/***********************************/
/*  Yet Another Fractal Generator  */
/*                                 */
/*        Juliaset for z+c        */
/*       (C) 1996 by MaCheFi       */
/*       szczerba@us.edu.pl        */
/*        zfjmgr@us.edu.pl         */
/***********************************/

#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>

#include <functions.h>
#include <graphics/modeid.h>
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 512
#define HEIGHT 512
#define DEPTH 8
#define COLORS 256

#define dx0 (x0_max-x0_min)/WIDTH
#define dy0 (y0_max-y0_min)/HEIGHT

struct Screen *scr;
struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;

ULONG modeid=DEFAULT_MONITOR_ID | HIRESLACE_KEY;

void stupid(void)
{
	if (scr) CloseScreen(scr);
	if (GfxBase) CloseLibrary((struct Library *)GfxBase);
	if (IntuitionBase) CloseLibrary((struct Library *)IntuitionBase);
	exit(0);
}

void OpenAllLibraries(void)
{
	IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",37);
	if (!IntuitionBase)
	{
		printf("You need intuition.library v.37+!!!\n");
		stupid();
	}
	GfxBase=(struct GfxBase *)OpenLibrary("graphics.library",37);
	if (!GfxBase)
	{
		printf("You need graphics.library v.37+!!!\n");
		stupid();
	}
}

void gimmecolors(void)
{
	ULONG i;
	for(i=0;i<COLORS;i++)
	{
		SetRGB32(&scr->ViewPort, i,(ULONG)(((float)i/0xff)*0xffffffff), (ULONG)(((float)i/0xff)*0xffffffff), (ULONG)(((float)i/0xff)*0xffffffff));
	}
}

void main(int argc,char *argv[])
{
	int color;
	long int i,j;
	float x0,y0;
	float x,y;
	float tempx;
	float a,b;
	float x0_min,x0_max,y0_min,y0_max;
	long int N;
	long int L;
	long int HOWMANY;

	if(argc!=8)
	{
		printf("Arguments: x_min x_max y_min y_max a b N\n");
		exit(0);
	}

	x0_min = atof(argv[1]);
	x0_max = atof(argv[2]);
	y0_min = atof(argv[3]);
	y0_max = atof(argv[4]);
	a      = atof(argv[5]);
	b      = atof(argv[6]);
	N      = atol(argv[7]);

	OpenAllLibraries();

	if(ModeNotAvailable(modeid))
		stupid();

	if(!(scr=OpenScreenTags(0,
	SA_Width, WIDTH,
	SA_Height, HEIGHT,
	SA_Depth, 8,
	SA_Type, PUBLICSCREEN,
	SA_DisplayID, modeid,
	TAG_DONE))) stupid();

	gimmecolors();

	SetRast(&scr->RastPort,255);

	y0=y0_max;
	for(j=0;j<HEIGHT;j++)
	{
		if(scr->MouseX<2 && scr->MouseY<2)
		{
			stupid();
			break;
		}
		x0=x0_min;
		for(i=0;i<WIDTH;i++)
		{
			x=x0;
			y=y0;

			if( (x0 * x0 + y0 * y0) >= 2)
			{
				HOWMANY=0;
				goto skip;
			}

			HOWMANY=0;
			for(L=1;L<=N;L++)
			{
				tempx = x * x * x - 3 * x * y * y + a;
				y = 3 * x * x * y - y * y * y + b;
				x=tempx;
			if( (x * x + y * y) < 2) HOWMANY++;
				else break;
			}
			skip:
			color = (int)( (COLORS-1)*(1.0 - (float)HOWMANY/N) );
			SetAPen(&scr->RastPort,color);
			WritePixel(&scr->RastPort,i,j);
			x0+=dx0;
		}
		y0-=dy0;
	}

	for(;;)
	{
		if(scr->MouseX<2 && scr->MouseY<2)
		{
			stupid();
			break;
		}
		Delay(50);
		printf("Where is top left screen corner...?\n");
	}
}
