//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "ff_main.h"
#include <math.h>
#include "ff_progress.h"
#include "skala.h"
#include "r_fun.h"
#include "ff_about.h"
#pragma link "TB97"

#define COLORS 256
#define crZoomCursor 100
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
Tf_main *f_main;
//---------------------------------------------------------------------------
__fastcall Tf_main::Tf_main(TComponent* Owner)
	: TForm(Owner)
{
		Screen->Cursors[crZoomCursor] = LoadCursor(HInstance, "CUR_ZOOM");
		img->Cursor = (Controls::TCursor)crZoomCursor;
	   bmp = new Graphics::TBitmap;
      greybmp = new Graphics::TBitmap;
      iscolor = false;
      bmp->Width=1;
      bmp->Height=1;
      greybmp->Width=1;
      greybmp->Height=1;
      cbx->ItemIndex=0;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::FormDestroy(TObject *Sender)
{
	delete greybmp;
   delete bmp;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::FormResize(TObject *Sender)
{
  Refresh();
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::btn_countClick(TObject *Sender)
{
 	if(count(atof(ed_re_min->Text.c_str()), atof(ed_re_max->Text.c_str()),
                  atof(ed_im_min->Text.c_str()), atof(ed_im_max->Text.c_str()),
                  atof(ed_re_c->Text.c_str()), atof(ed_im_c->Text.c_str()),
                  atol(ed_iter->Text.c_str()), img->Width, img->Height, cbx->ItemIndex))
   {
       TRect dest;
       dest.Left=0;
   	dest.Top=0;
   	dest.Right=img->Width;
   	dest.Bottom=img->Height;
       img->Picture->Bitmap=NULL;
   	img->Canvas->CopyRect(dest,greybmp->Canvas,greybmp->Canvas->ClipRect);
   }
   img->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::btn_colorClick(TObject *Sender)
{

  	if(color(atof(p2k(edr->Text).c_str()),atof(p2k(edg->Text).c_str()),atof(p2k(edb->Text).c_str())))
   	img->Canvas->Draw(0,0,bmp);
   img->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::imgMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
 	mouse=true;

	sel.Left=X;
   sel.Top=Y;
   sel.Right=X;
   sel.Bottom=Y;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::imgMouseMove(TObject *Sender, TShiftState Shift, int X,
	int Y)
{
   if(mouse)
	{
      img->Canvas->DrawFocusRect(sel);
   	sel.Right=X;
		sel.Bottom=Y;
       img->Canvas->DrawFocusRect(sel);
       img->Refresh();
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::imgMouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
	mouse=false;
   Cursor=crArrow;
   if((sel.Left<sel.Right)&&(sel.Bottom>sel.Top))
   {
   	img->Canvas->DrawFocusRect(sel);
		TSkalowanieSmall w(0,img->Width,atof(p2k(ed_re_min->Text).c_str()),atof(p2k(ed_re_max->Text).c_str()));
   	TSkalowanieSmall h(0,img->Height,atof(p2k(ed_im_min->Text).c_str()),atof(p2k(ed_im_max->Text).c_str()));
   	ed_re_min->Text=f2AnsiString(w.EkrToReal(sel.Left));
   	ed_re_max->Text=f2AnsiString(w.EkrToReal(sel.Right));
   	ed_im_min->Text=f2AnsiString(h.EkrToReal(sel.Bottom));
   	ed_im_max->Text=f2AnsiString(h.EkrToReal(sel.Top));
   	btn_countClick(Sender);
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::btn_zoomoutClick(TObject *Sender)
{
	ed_re_min->Text="-2";
	ed_re_max->Text="2";
	ed_im_min->Text="-2";
	ed_im_max->Text="2";
   btn_countClick(Sender);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
bool Tf_main::count(double x0_min, double x0_max, double y0_min, double y0_max,
                          double a, double b, long int N, int WIDTH, int HEIGHT, int type)
{
	bool result = true;
   Tf_progress* f_progress = new Tf_progress(this);
   f_progress->Show();
	f_progress->lab->Caption="Generating fractal...";

   break_op=false;

   greybmp->Width=WIDTH;
   greybmp->Height=HEIGHT;

	int color;
	long int i,j;
	double x0,y0;
	double x,y;
	double tempx;
	long int L;
	long int HOWMANY;

	y0=y0_max;

   double dx0=(x0_max-x0_min)/WIDTH;
   double dy0=(y0_max-y0_min)/HEIGHT;
   double inv_h = (double)100/HEIGHT;

   if(type==0) //julia
   {
 		for(j=0;j<HEIGHT;j++)
		{
			x0=x0_min;
			for(i=0;i<WIDTH;i++)
			{
				x=x0;
				y=y0;

				if( (x0 * x0 + y0 * y0) >= 2)
				{
					HOWMANY=0;
					goto skip;
				}

				HOWMANY=0;
				for(L=1;L<=N;L++)
				{
					tempx = x * x * x - 3 * x * y * y + a;
					y = 3 * x * x * y - y * y * y + b;
					x=tempx;
				if( (x * x + y * y) < 2) HOWMANY++;
					else break;
				}
				skip:
				color = (int)( (COLORS-1)*(1.0 - (double)HOWMANY/N) );
   			greybmp->Canvas->Pixels[i][j]=(TColor)RGB(color, color, color);
				x0+=dx0;
			}
			y0-=dy0;
       	f_progress->pb->Position=j*inv_h;
       	Application->ProcessMessages();
       	if(break_op)
       	{
				result=false;
       		break_op=false;
       		break;
       	}
       }
	}//end of julia's if
   else if (type==1)//mandelbrot^2
   {
       double a_min = x0_min;
		double a_max = x0_max;
		double b_min = y0_min;
		double b_max = y0_max;
		double da=(a_max-a_min)/WIDTH;
		double db=(b_max-b_min)/HEIGHT;
   	b=b_max;
		for(j=0;j<HEIGHT;j++)
		{
			a=a_min;
			for(i=0;i<WIDTH;i++)
			{
				x=0;
				y=0;
				HOWMANY=0;
				for(L=1;L<=N;L++)
				{
					tempx = x * x - y * y + a;
					y = 2 * x * y + b;
					x=tempx;
				if( (x * x + y * y) < 2) HOWMANY++;
					else break;
				}
				color = (int)( (COLORS-1)*(1.0 - (double)HOWMANY/N) );
				greybmp->Canvas->Pixels[i][j]=(TColor)RGB(color, color, color);
				a+=da;
			}
			b-=db;
           f_progress->pb->Position=j*inv_h;
       	Application->ProcessMessages();
       	if(break_op)
       	{
				result=false;
       		break_op=false;
       		break;
       	}
		}
   }
   else if (type==2)//madelbrot^3
   {
       double a_min = x0_min;
		double a_max = x0_max;
		double b_min = y0_min;
		double b_max = y0_max;
		double da=(a_max-a_min)/WIDTH;
		double db=(b_max-b_min)/HEIGHT;
   	b=b_max;
		for(j=0;j<HEIGHT;j++)
		{
			a=a_min;
			for(i=0;i<WIDTH;i++)
			{
				x=0;
				y=0;
				HOWMANY=0;
				for(L=1;L<=N;L++)
				{
					tempx = x * x * x - 3 * x * y * y + a;
					y = 3 * x * x * y - y * y * y + b;
					x=tempx;
					if( (x * x + y * y) < 2) HOWMANY++;
                   else break;
				}
				color = (int)( (COLORS-1)*(1.0 - (double)HOWMANY/N) );
				greybmp->Canvas->Pixels[i][j]=(TColor)RGB(color, color, color);
				a+=da;
			}
			b-=db;
           f_progress->pb->Position=j*inv_h;
       	Application->ProcessMessages();
       	if(break_op)
       	{
				result=false;
       		break_op=false;
       		break;
       	}
		}
   }   //end of mandelbrot^3
   else result=false;

	f_progress->Close();
   delete f_progress;
   return result;
}
//---------------------------------------------------------------------------
bool Tf_main::color(double R, double G, double B)
{
   Tf_progress* f_progress = new Tf_progress(this);
   f_progress->Show();
	f_progress->lab->Caption="Painting fractal...";
	bool result=true;
   break_op=false;
	int k,j,i=0;
   double inv_h = (double)100/greybmp->Height;
   bmp->Width=greybmp->Width;
   bmp->Height=greybmp->Height;
	for(;i<greybmp->Width;i++)
   {
   	for(j=0;j<greybmp->Height;j++)
       {
           k = GetRValue(greybmp->Canvas->Pixels[i][j]);
       	bmp->Canvas->Pixels[i][j]=(TColor)RGB(R*k,G*k,B*k);
       }
       f_progress->pb->Position=i*inv_h;
       Application->ProcessMessages();
       if(break_op)
       {
       	break_op=false;
           result=false;
       	break;
       }
   }
   delete f_progress;
   return result;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::cbxChange(TObject *Sender)
{
	if(cbx->ItemIndex==0)//Julia
   {
   	lab_im_c->Visible=true;
       lab_re_c->Visible=true;
       ed_im_c->Visible=true;
       ed_re_c->Visible=true;
   }
   else
   {
   	lab_im_c->Visible=false;
       lab_re_c->Visible=false;
       ed_im_c->Visible=false;
       ed_re_c->Visible=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::mnu_viewClick(TObject *Sender)
{
	if(mnu_view->Checked)
   {
   	mnu_view->Checked=false;
       tb_view->Visible=false;
   }
   else
   {
   	mnu_view->Checked=true;
   	tb_view->Visible=true;
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::tb_viewClose(TObject *Sender)
{
	mnu_view->Checked=false;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::mnu_paintClick(TObject *Sender)
{
	if(mnu_paint->Checked)
   {
   	mnu_paint->Checked=false;
       tb_paint->Visible=false;
   }
   else
   {
   	mnu_paint->Checked=true;
   	tb_paint->Visible=true;
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::mnu_countClick(TObject *Sender)
{
	if(mnu_count->Checked)
   {
   	mnu_count->Checked=false;
       tb_count->Visible=false;
   }
   else
   {
   	mnu_count->Checked=true;
   	tb_count->Visible=true;
   }
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::btn_saveClick(TObject *Sender)
{
	if(sd->Execute())
   {
   	save(sd->FileName);
   }
}
//---------------------------------------------------------------------------
void Tf_main::save(AnsiString fn)
{
	img->Picture->SaveToFile(fn);
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::tb_countClose(TObject *Sender)
{
	mnu_count->Checked=false;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::tb_paintClose(TObject *Sender)
{
	mnu_paint->Checked=false;
}
//---------------------------------------------------------------------------
void __fastcall Tf_main::mnu_aboutClick(TObject *Sender)
{
	Tf_about* f_about = new Tf_about(this);
   f_about->ShowModal();
   delete f_about;	
}
//---------------------------------------------------------------------------
