(* SmeftFR v2.00 package *)
(* Calculation of Feynman rules for 4-fermion and B+L violating vertices *)


Fierz4f = Function[{expr},
(* 4-fermion Fierzing routines *)
Block[{a,b,tmp,res,find,find1,find2,find3,find4,fierz,mu$1},

tmp = expr /. TensDot[___][Index[Spin, Ext[1]], Index[Spin, Ext[2]]] -> 0;
res = expr - tmp // Expand;

find1 = Unique[fierz];
find2 = Unique[fierz];
find3 = Unique[fierz];
find4 = Unique[fierz];

tmp = tmp /. TensDot[Ga[Index[Lorentz,a_]],b_][Index[Spin,Ext[1]],Index[Spin,Ext[4]]] *
             TensDot[Ga[Index[Lorentz,a_]],b_][Index[Spin,Ext[3]],Index[Spin,Ext[2]]] -> 
             TensDot[Ga[Index[Lorentz,a]],b][Index[Spin,find1],Index[Spin,find2]] *
             TensDot[Ga[Index[Lorentz,a]],b][Index[Spin,find3],Index[Spin,find4]];

tmp = tmp /. TensDot[Ga[Index[Lorentz,a_]],ProjM][Index[Spin,Ext[1]],Index[Spin,Ext[4]]] *
             TensDot[Ga[Index[Lorentz,a_]],ProjP][Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 2 ProjP[Index[Spin,find1],Index[Spin,find2]] ProjM[Index[Spin,find3],Index[Spin,find4]] );

tmp = tmp /. TensDot[Ga[Index[Lorentz,a_]],ProjP][Index[Spin,Ext[1]],Index[Spin,Ext[4]]] *
             TensDot[Ga[Index[Lorentz,a_]],ProjM][Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 2 ProjM[Index[Spin,find1],Index[Spin,find2]] ProjP[Index[Spin,find3],Index[Spin,find4]] );

tmp = tmp /. ProjM[Index[Spin,Ext[1]],Index[Spin,Ext[4]]] ProjP[Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 1/2 TensDot[Ga[Index[Lorentz,mu$1]],ProjP][Index[Spin,find1],Index[Spin,find2]] *
                   TensDot[Ga[Index[Lorentz,mu$1]],ProjM][Index[Spin,find3],Index[Spin,find4]] );

tmp = tmp /. ProjP[Index[Spin,Ext[1]],Index[Spin,Ext[4]]] ProjM[Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 1/2 TensDot[Ga[Index[Lorentz,\[Mu]]],ProjM][Index[Spin,find1],Index[Spin,find2]] *
                   TensDot[Ga[Index[Lorentz,\[Mu]]],ProjP][Index[Spin,find3],Index[Spin,find4]] );

tmp = tmp /. ProjP[Index[Spin,Ext[1]],Index[Spin,Ext[4]]] ProjP[Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 1/2 ProjP[Index[Spin,find1],Index[Spin,find2]] ProjP[Index[Spin,find3],Index[Spin,find4]] -
               1/8 SIG[\[Mu],\[Nu],ProjP,find1,find2] SIG[\[Mu],\[Nu],ProjP,find3,find4] ) ;

tmp = tmp /. ProjM[Index[Spin,Ext[1]],Index[Spin,Ext[4]]] ProjM[Index[Spin,Ext[3]],Index[Spin,Ext[2]]] ->
             ( - 1/2 ProjM[Index[Spin,find1],Index[Spin,find2]] ProjM[Index[Spin,find3],Index[Spin,find4]] -
               1/8 SIG[\[Mu],\[Nu],ProjM,find1,find2] SIG[\[Mu],\[Nu],ProjM,find3,find4] ) ;

find = Unique[fierz];

tmp = tmp /. Ext[4] -> find;
tmp = tmp /. Ext[2] -> Ext[4];             
tmp = tmp /. find   -> Ext[2];             

tmp = tmp /. find1 -> Ext[1] /. 
             find2 -> Ext[2] /. 
             find3 -> Ext[3] /. 
             find4 -> Ext[4];

tmp + res

]
(* end of Fierz4f *)
]




SymmetrizeNeutrino4Current = Function[{x},
(* symmetrize vertices with 4 fermions, 2 of them being Majorana neutrinos *)
Block[{a,swap,i,frule,symlist},

symlist = {};

For[i=1, i < Length[x]+1, i++,
  If[ SubsetQ[ Flatten[ Take[ x[[i]][[1]], All, 1] ], {vlbar,vl} ] && 
      (Flatten[ Take[ x[[i]][[1]], All, 1] ] =!= {vlbar,vl,vlbar,vl}),
    frule = x[[i]];
    Clear[swap];
    frule = frule /. Ext[3] -> swap;
    frule = frule /. Ext[4] -> Ext[3];
    frule = frule /. swap -> Ext[4];
    frule = frule /. TensDot[Ga[a_], ProjM][Index[Spin,Ext[4]],Index[Spin,Ext[3]]] ->  
                   - TensDot[Ga[a],  ProjP][Index[Spin,Ext[3]],Index[Spin,Ext[4]]];
    frule = frule /. TensDot[Ga[a_], ProjP][Index[Spin,Ext[4]],Index[Spin,Ext[3]]] ->  
                   - TensDot[Ga[a],  ProjM][Index[Spin,Ext[3]],Index[Spin,Ext[4]]];
    AppendTo[symlist,frule];  
  ];
];

MergeVertices[x,symlist]

]
(* end of SymmetrizeNeutrino4Current *)
]





FourFermionInteractions = Function[{}, 
(* 4-fermion couplings *) 
Block[{a, b, c, d, s1, s2, mu$2, mu$1, i4f, find, fierz, tmp, ia1, ia2, oplist, WC},

Print[Style["Calculating 4-fermion vertices...",Bold]];

oplist = Intersection[ SMEFTOperatorList, {"ll","ee","le"}];
FourLeptonLagrangian = 0;
For[i4f=1, i4f < Length[oplist] + 1, i4f++,
  FourLeptonLagrangian = FourLeptonLagrangian + Lam ToExpression["LQ"<>oplist[[i4f]]];
];
FourLeptonLagrangian = ReplaceFlavorRotations[FourLeptonLagrangian] // Expand;
FourLeptonLagrangian = FourLeptonLagrangian /. Lam^k_->If[k>1,0,Lam^k];
FourLeptonVertices = FeynmanRules[FourLeptonLagrangian];
If[ SMEFTMajoranaNeutrino, 
   FourLeptonVertices = SymmetrizeNeutrino4Current[FourLeptonVertices];
   For[i4f=1, i4f < Length[FourLeptonVertices] + 1, i4f++,      
    If[ FourLeptonVertices[[i4f,1]] === {{vlbar,1},{vl,2},{vlbar,3},{vl,4}},
        FourLeptonVertices[[i4f,2]] = Neutrino4Vertex[];
    ];
  ];
];

oplist = Intersection[ SMEFTOperatorList, {"lq1","lq3","eu","ed","lu","ld","qe","ledq","lequ1","lequ3"} ];
TwoQuarkTwoLeptonLagrangian = 0;
For[i4f=1, i4f < Length[oplist] + 1, i4f++,
  TwoQuarkTwoLeptonLagrangian = TwoQuarkTwoLeptonLagrangian + Lam ToExpression["LQ"<>oplist[[i4f]]];
];
TwoQuarkTwoLeptonLagrangian = Simplify2Tproduct[TwoQuarkTwoLeptonLagrangian];
TwoQuarkTwoLeptonLagrangian = ReplaceFlavorRotations[TwoQuarkTwoLeptonLagrangian] // Expand;
TwoQuarkTwoLeptonLagrangian = TwoQuarkTwoLeptonLagrangian /. Lam^k_->If[k>1,0,Lam^k];
TwoQuarkTwoLeptonVertices = FeynmanRules[TwoQuarkTwoLeptonLagrangian];
If[ SMEFTMajoranaNeutrino, TwoQuarkTwoLeptonVertices = SymmetrizeNeutrino4Current[TwoQuarkTwoLeptonVertices] ];

oplist = Intersection[ SMEFTOperatorList, {"qq1","qq3","uu","dd","ud1","ud8","qu1","qu8","qd1","qd8","quqd1","quqd8"} ];
FourQuarkLagrangian = 0;
For[i4f=1, i4f < Length[oplist] + 1, i4f++,
  FourQuarkLagrangian = FourQuarkLagrangian + Lam ToExpression["LQ"<>oplist[[i4f]]];
];
FourQuarkLagrangian = Simplify2Tproduct[FourQuarkLagrangian];
FourQuarkLagrangian = ReplaceFlavorRotations[FourQuarkLagrangian] // Expand;
FourQuarkLagrangian = FourQuarkLagrangian /. Lam^k_->If[k>1,0,Lam^k];
FourQuarkVertices = FeynmanRules[FourQuarkLagrangian];

(* store vertices in new variables for some simplifications *)
FourLeptonVerticesOrig = FourLeptonVertices;
FourQuarkVerticesOrig = FourQuarkVertices;
TwoQuarkTwoLeptonVerticesOrig = TwoQuarkTwoLeptonVertices;

TwoQuarkTwoLeptonVertices = TwoQuarkTwoLeptonVertices //. TensDot[Ga[a_],Ga[b_],c_][s1_,s2_] -> (ME[a,b] c[s1,s2] - I SIG[a,b,c,s1,s2]);
TwoQuarkTwoLeptonVertices = TwoQuarkTwoLeptonVertices /. SIG[Index[Lorentz,mu$2],Index[Lorentz,mu$1],c_,s1_,s2_] -> 
             (- SIG[Index[Lorentz,mu$1],Index[Lorentz,mu$2],c,s1,s2]) // Expand;
TwoQuarkTwoLeptonVertices = TwoQuarkTwoLeptonVertices /. ME[Index[Lorentz,a_],Index[Lorentz,b_]] SIG[Index[Lorentz,a_],Index[Lorentz,b_],c_,s1_,s2_] -> 0;
TwoQuarkTwoLeptonVertices = TwoQuarkTwoLeptonVertices /. IndexDelta[Index[Colour, Ext[a_]], Index[Colour, Ext[b_]]] -> 1;


(* fierzing and index rotation, whenewer possible. Currently commented
out, can affect evanescent operators! *)
      
(*
For[i4f=1, i4f < Length[FourLeptonVertices] + 1, i4f++,      
    If[ FourLeptonVertices[[i4f,1]] === {{lbar,1},{l,2},{lbar,3},{l,4}} ||
	FourLeptonVertices[[i4f,1]] === {{vlbar,1},{vl,2},{vlbar,3},{vl,4}},
	FourLeptonVertices[[i4f,2]] = Fierz4f[ FourLeptonVertices[[i4f,2]] ] ];
    FourLeptonVertices[[i4f,2]] = Fierz4f[ FourLeptonVertices[[i4f,2]] ];
];

For[i4f=1, i4f < Length[FourQuarkVertices] + 1, i4f++,      
    If[ FourQuarkVertices[[i4f,1]] === {{uqbar,1},{uq,2},{uqbar,3},{uq,4}} ||
	FourQuarkVertices[[i4f,1]] === {{dqbar,1},{dq,2},{dqbar,3},{dq,4}},
	FourQuarkVertices[[i4f,2]] = Fierz4f[ FourQuarkVertices[[i4f,2]] ] ];
];
*)

(* "manual" symmetrization of indices in Tll, Tee operators *)
      
If[ MemberQ[ SMEFTOperatorList, "ll" ],

WC = ToExpression[SMEFT$MB <> "ll"];
  
FourLeptonVertices = FourLeptonVertices /. 
    WC @@ {Index[Generation, Generation$1], Index[Generation, Generation$2], 
           Index[Generation, Ext[1]], Index[Generation, Ext[2]]} -> 
    WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]], 
           Index[Generation, Generation$1], Index[Generation, Generation$2]};
            
FourLeptonVertices = FourLeptonVertices /.            
    WC @@ {Index[Generation, Ext[3]], Index[Generation, Ext[2]], 
           Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
    WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
           Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourLeptonVertices = FourLeptonVertices /.
    WC @@ {Index[Generation, Ext[3]], Index[Generation, Ext[4]], 
           Index[Generation, Ext[1]], Index[Generation, Ext[2]]} -> 
    WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]], 
           Index[Generation, Ext[3]], Index[Generation, Ext[4]]};
];

If[ MemberQ[ SMEFTOperatorList, "ee" ],
 WC = ToExpression[SMEFT$MB <> "ee"];

FourLeptonVertices = FourLeptonVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
 Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourLeptonVertices = FourLeptonVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[4]], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
 Index[Generation, Ext[3]], Index[Generation, Ext[4]]};

]; 

      
(* "manual" symmetrization of indices in Tqq3, Tqq1, Tdd, Tuu operators *)

If[ MemberQ[ SMEFTOperatorList, "qq1" ],
 WC = ToExpression[SMEFT$MB <> "qq1"];

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$2], Index[Generation,
   Generation$1], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} -> 
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
   Index[Generation, Generation$2], Index[Generation, Generation$1]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$3], Index[Generation,
   Generation$2], Index[Generation, Generation$4], Index[Generation,
   Generation$1] } -> WC @@ {Index[Generation, Generation$4 ],
   Index[Generation, Generation$1], Index[Generation, Generation$3],
   Index[Generation, Generation$2] };

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$4], Index[Generation,
   Generation$2], Index[Generation, Generation$3], Index[Generation,
   Generation$1] } -> WC @@ {Index[Generation, Generation$3 ],
   Index[Generation, Generation$1], Index[Generation, Generation$4],
   Index[Generation, Generation$2] };

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
   Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
   Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
   Ext[4]], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} ->
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
   Index[Generation, Ext[3]], Index[Generation, Ext[4]]};
   
];

 
If[ MemberQ[ SMEFTOperatorList, "qq3" ],
 WC = ToExpression[SMEFT$MB <> "qq3"];

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$2], Index[Generation,
   Ext[2]], Index[Generation, Ext[1]], Index[Generation,
   Generation$1]} -> WC @@ {Index[Generation, Ext[1]], Index[Generation,
   Generation$1 ], Index[Generation, Generation$2], Index[Generation,
   Ext[2]]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$2], Index[Generation,
   Generation$1], Index[Generation, Ext[1]], Index[Generation, Ext[2]]}-> 
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
   Index[Generation, Generation$2], Index[Generation, Generation$1]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$3], Index[Generation,
   Generation$2], Index[Generation, Generation$4], Index[Generation,
   Generation$1]} -> WC @@ {Index[Generation, Generation$4 ],
   Index[Generation, Generation$1], Index[Generation, Generation$3],
   Index[Generation, Generation$2]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Generation$4], Index[Generation,
   Generation$2], Index[Generation, Generation$3], Index[Generation,
   Generation$1] } -> WC @@ {Index[Generation, Generation$3 ],
   Index[Generation, Generation$1], Index[Generation, Generation$4],
   Index[Generation, Generation$2]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
   Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
   Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
   Ext[4]], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} ->
   WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
   Index[Generation, Ext[3]], Index[Generation, Ext[4]]};
   
];   

If[ MemberQ[ SMEFTOperatorList, "uu" ],
 WC = ToExpression[SMEFT$MB <> "uu"];

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
 Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[4]], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
 Index[Generation, Ext[3]], Index[Generation, Ext[4]]};

]; 

If[ MemberQ[ SMEFTOperatorList, "dd" ],
 WC = ToExpression[SMEFT$MB <> "dd"];

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[4]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[4]],
 Index[Generation, Ext[3]], Index[Generation, Ext[2]]};

FourQuarkVertices = FourQuarkVertices /. WC @@ {Index[Generation, Ext[3]], Index[Generation,
 Ext[4]], Index[Generation, Ext[1]], Index[Generation, Ext[2]]} ->
 WC @@ {Index[Generation, Ext[1]], Index[Generation, Ext[2]],
 Index[Generation, Ext[3]], Index[Generation, Ext[4]]};

]; 
 
(* hack - manual correction of wrong sign generated by FeynRules for
vertices with 4 identical fermions and in uudd vertex *)

If [ SMEFTCorrect4FermionSign,

For[i4f=1, i4f < Length[FourLeptonVertices] + 1, i4f++,      
    If[ FourLeptonVertices[[i4f,1]] === {{lbar,1},{l,2},{lbar,3},{l,4}} ||
       (FourLeptonVertices[[i4f,1]] === {{vlbar,1},{vl,2},{vlbar,3},{vl,4}} && 
        ! SMEFTMajoranaNeutrino),
	
        FourLeptonVertices[[i4f,2]] = FourLeptonVertices[[i4f,2]] /. 
            TensDot[ia1_,ia2_][Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ->
          - TensDot[ia1, ia2][Index[Spin, Ext[1]], Index[Spin, Ext[4]]];
    ];
];

For[i4f=1, i4f < Length[FourQuarkVertices] + 1, i4f++,      
    If[ FourQuarkVertices[[i4f,1]] === {{uqbar,1},{uq,2},{uqbar,3},{uq,4}} ||
	FourQuarkVertices[[i4f,1]] === {{dqbar,1},{dq,2},{dqbar,3},{dq,4}} ||
	FourQuarkVertices[[i4f,1]] === {{dqbar,1},{dq,2},{uqbar,3},{uq,4}},
	FourQuarkVertices[[i4f,2]] = FourQuarkVertices[[i4f,2]] /.
	  TensDot[ia1_, ia2_][Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ->
	- TensDot[ia1, ia2][Index[Spin, Ext[1]], Index[Spin, Ext[4]]];
	FourQuarkVertices[[i4f,2]] = FourQuarkVertices[[i4f,2]] /.
	  ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ->
	- ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[4]]];
	FourQuarkVertices[[i4f,2]] = FourQuarkVertices[[i4f,2]] /.
	  ProjP[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ->
	- ProjP[Index[Spin, Ext[1]], Index[Spin, Ext[4]]];
    ];
  ];

,

(* if Correct4FermionSign = False and MajoranaNeutrino=True, revert
back manually evaluated proper sign to wrong one again ... *)

For[i4f=1, i4f < Length[FourLeptonVertices] + 1, i4f++,      
    If[ FourLeptonVertices[[i4f,1]] === {{vlbar,1},{vl,2},{vlbar,3},{vl,4}} && SMEFTMajoranaNeutrino,
	
        FourLeptonVertices[[i4f,2]] = FourLeptonVertices[[i4f,2]] /. 
            TensDot[ia1_,ia2_][Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ->
          - TensDot[ia1, ia2][Index[Spin, Ext[1]], Index[Spin, Ext[4]]];
    ];
];

    
];

find = Unique[fierz];

(* switch order of fields in Feynman rules for lvud *)      

For[i4f=1, i4f < Length[TwoQuarkTwoLeptonVertices] + 1, i4f++,      
    If[TwoQuarkTwoLeptonVertices[[i4f,1]] === {{dqbar,1},{l,2},{vlbar,3},{uq,4}},
       tmp = TwoQuarkTwoLeptonVertices[[i4f]][[2]] /. Ext[4] -> find;
       tmp = tmp /. Ext[2] -> Ext[4];             
       TwoQuarkTwoLeptonVertices[[i4f]][[2]] = tmp /. find   -> Ext[2];  
       TwoQuarkTwoLeptonVertices[[i4f]][[1]] = {{dqbar,1},{uq,2},{vlbar,3},{l,2}};
    ];

    If[TwoQuarkTwoLeptonVertices[[i4f,1]] === {{lbar,1},{dq,2},{uqbar,3},{vl,4}},
       tmp = TwoQuarkTwoLeptonVertices[[i4f]][[2]] /. Ext[4] -> find;
       tmp = tmp /. Ext[2] -> Ext[4];             
       TwoQuarkTwoLeptonVertices[[i4f]][[2]] = tmp /. find    -> Ext[2];  
       TwoQuarkTwoLeptonVertices[[i4f]][[1]] = {{lbar,1},{vl,2},{uqbar,3},{dq,2}};
    ];
];
       
            
];
(* end of FourFermionInteractions *)
];



(* sort out double defined vertices with psi^C-nu in 2-fermion currents *)
SortBLViolatingVertices = Function[{x},
Block[{i,vlist},

vlist = x;
For[i=1, i < Length[vlist] + 1, i++,
  If[ MemberQ[ {dqcbar,uqcbar}, vlist[[i]][[1,3,1]] ] && (vlist[[i]][[1,4,1]] == vl),
    vlist[[i]][[1,4,1]] = If[ vlist[[i]][[1,3,1]] === dqcbar, dq, uq ];
    vlist[[i]][[1,3,1]] = vlbar;
    vlist[[i]][[2]] = SwapExternalIndices[vlist[[i]][[2]],3,4];
  ];
  If[ (vlist[[i]][[1,3,1]] == vlbar) &&  MemberQ[ {dqc,uqc}, vlist[[i]][[1,4,1]] ],
    vlist[[i]][[1,3,1]] = If[ vlist[[i]][[1,4,1]] === dqc, dqbar, uqbar ];
    vlist[[i]][[1,4,1]] = vl;
    vlist[[i]][[2]] = SwapExternalIndices[vlist[[i]][[2]],3,4];
  ];
];
  
(*
vlist = vlist /. ProjP[ Index[Spin,Ext[4]], Index[Spin,Ext[2]] ] -> ProjP[ Index[Spin,Ext[2]], Index[Spin,Ext[4]] ]; 
vlist = vlist /. ProjP[ Index[Spin,Ext[4]], Index[Spin,Ext[3]] ] -> ProjP[ Index[Spin,Ext[3]], Index[Spin,Ext[4]] ]; 
vlist = vlist /. ProjM[ Index[Spin,Ext[4]], Index[Spin,Ext[2]] ] -> ProjM[ Index[Spin,Ext[2]], Index[Spin,Ext[4]] ]; 
vlist = vlist /. ProjM[ Index[Spin,Ext[4]], Index[Spin,Ext[3]] ] -> ProjM[ Index[Spin,Ext[3]], Index[Spin,Ext[4]] ]; 
*)

vlist

]
(* end of SortBLViolatingVertices *)
]




BLViolating4FermionInteractions = Function[{}, 
(*  BL violatingfermion couplings *) 
Block[{ i4f, oplist, temp },

Print[Style["Calculating B and L violating 4-fermion vertices...",Bold]];
      
oplist = Intersection[ SMEFTOperatorList, {"duq","qqu","qqq","duu"} ];
BLViolatingLagrangian = 0;
For[i4f=1, i4f < Length[oplist] + 1, i4f++,
  BLViolatingLagrangian = BLViolatingLagrangian + Lam ToExpression["LQ"<>oplist[[i4f]]];
];

BLViolatingLagrangian = ReplaceFlavorRotations[BLViolatingLagrangian] // Expand;
BLViolatingLagrangian = BLViolatingLagrangian /. Lam^k_->If[k>1,0,Lam];
(*

FeynRules are not calculating BL vertices properly - so the
calculation is commented out and replaced by the manually calculated
vertices

BLViolatingVertices = FeynmanRules[BLViolatingLagrangian];

*)
BLViolatingVertices = BL4Vertex[];
oplist = Complement[ {"duq","qqu","qqq","duu"}, oplist ];
For[i4f=1, i4f < Length[oplist] + 1, i4f++,
  BLViolatingVertices = BLViolatingVertices /. ToExpression[SMEFT$MB <> oplist[[i4f]] ][___] -> 0;
];
            
temp = {};
For[i4f=1, i4f < Length[BLViolatingVertices] + 1, i4f++, 
  If[ BLViolatingVertices[[i4f,2]] =!= 0, 
    AppendTo[ temp, BLViolatingVertices[[i4f]] ];
  ];
];
BLViolatingVertices = temp;

];
(* end of BLViolating4FermionInteractions *)
];


Neutrino4Vertex = Function[{},
(* if neutrinos are Majorana particles, 4-neutrino interaction must be
properly symmetrized, easier to do manually just for this one case *)

2 I Lam (ToExpression[SMEFT$MB<>"ll"][Index[Generation,
 Generation$1], Index[Generation, Generation$2], Index[Generation,
 Generation$3], Index[Generation, Generation$4]] ( Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[1]]] ]
 U[Index[Generation, Generation$2], Index[Generation, Ext[2]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[3]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin,
 Ext[1]], Index[Spin, Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[3]], Index[Spin, Ext[4]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[2]]] ]
 U[Index[Generation, Generation$2], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[3]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[3]], Index[Spin, Ext[4]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[1]]] ]
 U[Index[Generation, Generation$2], Index[Generation, Ext[2]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[4]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin,
 Ext[1]], Index[Spin, Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[3]], Index[Spin, Ext[4]]] + Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[2]]] ]
 U[Index[Generation, Generation$2], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[4]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[3]], Index[Spin, Ext[4]]] ) -
 ToExpression[SMEFT$MB<>"ll"][Index[Generation, Generation$1],
 Index[Generation, Generation$4], Index[Generation, Generation$3],
 Index[Generation, Generation$2]] ( Conjugate[ U[Index[Generation,
 Generation$1], Index[Generation, Ext[1]]] ] U[ Index[Generation,
 Generation$4], Index[Generation, Ext[4]]] Conjugate[
 U[Index[Generation, Generation$3], Index[Generation, Ext[3]]] ]
 U[Index[Generation, Generation$2], Index[Generation, Ext[2]]]
 TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin, Ext[1]],
 Index[Spin, Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[3]], Index[Spin, Ext[2]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[4]]] ] U[
 Index[Generation, Generation$4], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[3]]] ] U[Index[Generation, Generation$2], Index[Generation,
 Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[3]], Index[Spin, Ext[2]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[1]]] ] U[
 Index[Generation, Generation$4], Index[Generation, Ext[4]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[2]]] ] U[Index[Generation, Generation$2], Index[Generation,
 Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin,
 Ext[1]], Index[Spin, Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[3]], Index[Spin, Ext[2]]] + Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[4]]] ] U[
 Index[Generation, Generation$4], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$3], Index[Generation,
 Ext[2]]] ] U[Index[Generation, Generation$2], Index[Generation,
 Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[3]], Index[Spin, Ext[2]]] ) -
 ToExpression[SMEFT$MB<>"ll"][Index[Generation, Generation$1],
 Index[Generation, Generation$3], Index[Generation, Generation$2],
 Index[Generation, Generation$4]] ( Conjugate[ U[Index[Generation,
 Generation$1], Index[Generation, Ext[1]]] ] U[Index[Generation,
 Generation$3], Index[Generation, Ext[3]]] Conjugate[
 U[Index[Generation, Generation$2], Index[Generation, Ext[2]]] ] U[
 Index[Generation, Generation$4], Index[Generation, Ext[4]]]
 TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin, Ext[1]],
 Index[Spin, Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[2]], Index[Spin, Ext[4]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[3]]] ]
 U[Index[Generation, Generation$3], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$2], Index[Generation,
 Ext[2]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[4]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjM][Index[Spin, Ext[2]], Index[Spin, Ext[4]]] - Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[1]]] ]
 U[Index[Generation, Generation$3], Index[Generation, Ext[3]]]
 Conjugate[ U[Index[Generation, Generation$2], Index[Generation,
 Ext[4]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjM][Index[Spin,
 Ext[1]], Index[Spin, Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[2]], Index[Spin, Ext[4]]] + Conjugate[
 U[Index[Generation, Generation$1], Index[Generation, Ext[3]]] ]
 U[Index[Generation, Generation$3], Index[Generation, Ext[1]]]
 Conjugate[ U[Index[Generation, Generation$2], Index[Generation,
 Ext[4]]] ] U[ Index[Generation, Generation$4], Index[Generation,
 Ext[2]]] TensDot[Ga[Index[Lorentz, mu$1]], ProjP][Index[Spin,
 Ext[1]], Index[Spin, Ext[3]]] TensDot[Ga[Index[Lorentz, mu$1]],
 ProjP][Index[Spin, Ext[2]], Index[Spin, Ext[4]]] ) ) // Expand // Simplify

(* end of Neutrino4Vertex *)
]





BL4Vertex = Function[{},
(* FeynRules have problems with vertices containing explicit charge
conjugation fields, so overwrite it by Feynman rules calculated
analytically *)
Block[{ BL4Vert, i4f },

BL4Vert = {0,0,0,0};

(* Vertex dduv *) 

BL4Vert[[1]] = { { {dqcbar, 1}, {uq, 2}, {dqcbar, 3}, {vl, 4} }, -
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] U[ Index[Generation, Generation$4], Index[Generation, Ext[4]]
] ( ToExpression[ SMEFT$MB <> "duq" ][ Index[Generation, Ext[1]],
Index[Generation, Ext[2]], Index[Generation, Ext[3]],
Index[Generation, Generation$4] ] ProjP[Index[Spin, Ext[1]],
Index[Spin, Ext[2]]] ProjM[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] +
ToExpression[ SMEFT$MB <> "duq" ][ Index[Generation, Ext[3]],
Index[Generation, Ext[2]], Index[Generation, Ext[1]],
Index[Generation, Generation$4] ] ProjP[Index[Spin, Ext[3]],
Index[Spin, Ext[2]]] ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] )
- Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] Conjugate[ K[ Index[Generation, Ext[2]], Index[Generation,
Generation$2]] ] U[ Index[Generation, Generation$4], Index[Generation,
Ext[4]] ] ( ToExpression[ SMEFT$MB <> "qqq" ][ Index[Generation,
Ext[1]], Index[Generation, Generation$2], Index[Generation, Ext[3]],
Index[Generation, Generation$4] ] ProjM[Index[Spin, Ext[1]],
Index[Spin, Ext[2]]] ProjM[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] +
ToExpression[ SMEFT$MB <> "qqq" ][ Index[Generation, Ext[3]],
Index[Generation, Generation$2], Index[Generation, Ext[1]],
Index[Generation, Generation$4] ] ProjM[Index[Spin, Ext[3]],
Index[Spin, Ext[2]]] ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] )
};

(* Vertex dduv2 *)

BL4Vert[[2]] = { { {dqcbar, 1}, {dq, 2}, {uqcbar, 3}, {vl, 4} },
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] Conjugate[ K[ Index[Generation, Ext[3]], Index[Generation,
Generation$3]] ] U[ Index[Generation, Generation$4], Index[Generation,
Ext[4]] ] ( ToExpression[ SMEFT$MB <> "qqq" ][ Index[Generation,
Ext[1]], Index[Generation, Ext[2]], Index[Generation, Generation$3],
Index[Generation, Generation$4] ] - ToExpression[ SMEFT$MB <> "qqq" ][
Index[Generation, Ext[2]], Index[Generation, Ext[1]],
Index[Generation, Generation$3], Index[Generation, Generation$4] ] )
ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[2]]] ProjM[Index[Spin,
Ext[3]], Index[Spin, Ext[4]]]};

(* Vertex deuu *) 

BL4Vert[[3]] = { { {uqcbar, 1}, {dq, 2}, {uqcbar, 3}, {l, 4} }, 2
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] ( Conjugate[ K[Index[Generation, Ext[1]], Index[Generation,
Generation$1]] ] ToExpression[ SMEFT$MB <> "qqu" ][ Index[Generation,
Generation$1], Index[Generation, Ext[2]], Index[Generation, Ext[3]],
Index[Generation, Ext[4]]] ProjM[Index[Spin, Ext[1]], Index[Spin,
Ext[2]]] ProjP[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] + Conjugate[
K[Index[Generation, Ext[3]], Index[Generation, Generation$3]] ]
ToExpression[ SMEFT$MB <> "qqu" ][ Index[Generation, Generation$3],
Index[Generation, Ext[2]], Index[Generation, Ext[1]],
Index[Generation, Ext[4]]] ProjM[Index[Spin, Ext[3]], Index[Spin,
Ext[2]]] ProjP[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ) -
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] ( Conjugate[ K[Index[Generation, Ext[3]], Index[Generation,
Generation$3]] ] ToExpression[ SMEFT$MB <> "duq" ][ Index[Generation,
Ext[2]], Index[Generation, Ext[1]], Index[Generation, Generation$3],
Index[Generation, Ext[4]] ] ProjP[Index[Spin, Ext[1]], Index[Spin,
Ext[2]]] ProjM[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] + Conjugate[
K[Index[Generation, Ext[1]], Index[Generation, Generation$1]] ]
ToExpression[ SMEFT$MB <> "duq" ][ Index[Generation, Ext[2]],
Index[Generation, Ext[3]], Index[Generation, Generation$1],
Index[Generation, Ext[4]] ] ProjP[Index[Spin, Ext[3]], Index[Spin,
Ext[2]]] ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ) -
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] ( ToExpression[ SMEFT$MB <> "duu" ][ Index[Generation,
Ext[2]], Index[Generation, Ext[1]], Index[Generation, Ext[3]],
Index[Generation, Ext[4]] ] ProjP[Index[Spin, Ext[1]], Index[Spin,
Ext[2]]] ProjP[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] +
ToExpression[ SMEFT$MB <> "duu" ][ Index[Generation, Ext[2]],
Index[Generation, Ext[3]], Index[Generation, Ext[1]],
Index[Generation, Ext[4]] ] ProjP[Index[Spin, Ext[3]], Index[Spin,
Ext[2]]] ProjP[Index[Spin, Ext[1]], Index[Spin, Ext[4]]] ) -
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] Conjugate[ K[Index[Generation, Ext[1]], Index[Generation,
Generation$1]] ] Conjugate[ K[Index[Generation, Ext[3]],
Index[Generation, Generation$3]] ] ( ToExpression[ SMEFT$MB <> "qqq"
][ Index[Generation, Generation$1], Index[Generation, Ext[2]],
Index[Generation, Generation$3], Index[Generation, Ext[4]] ]
ProjM[Index[Spin, Ext[1]], Index[Spin, Ext[2]]] ProjM[Index[Spin,
Ext[3]], Index[Spin, Ext[4]]] + ToExpression[ SMEFT$MB <> "qqq" ][
Index[Generation, Generation$3], Index[Generation, Ext[2]],
Index[Generation, Generation$1], Index[Generation, Ext[4]] ]
ProjM[Index[Spin, Ext[3]], Index[Spin, Ext[2]]] ProjM[Index[Spin,
Ext[1]], Index[Spin, Ext[4]]] ) };

(* Vertex deuu2 *)

BL4Vert[[4]] = { { {uqcbar, 1}, {uq, 2}, {dqcbar, 3}, {l, 4} },
Eps[Index[Colour, Ext[1]], Index[Colour, Ext[2]], Index[Colour,
Ext[3]]] Conjugate[ K[Index[Generation, Ext[1]], Index[Generation,
Generation$1]] ] Conjugate[ K[Index[Generation, Ext[2]],
Index[Generation, Generation$2]] ] ( ToExpression[ SMEFT$MB <> "qqq"
][ Index[Generation, Generation$1], Index[Generation, Generation$2],
Index[Generation, Ext[3]], Index[Generation, Ext[4]] ] - ToExpression[
SMEFT$MB <> "qqq" ][ Index[Generation, Generation$2],
Index[Generation, Generation$1], Index[Generation, Ext[3]],
Index[Generation, Ext[4]] ] ) ProjM[Index[Spin, Ext[1]], Index[Spin,
Ext[2]]] ProjM[Index[Spin, Ext[3]], Index[Spin, Ext[4]]] };
 
For[i4f=1, i4f < Length[BL4Vert] + 1, i4f++, 
  BL4Vert[[i4f,2]] = I BL4Vert[[i4f,2]];
];

BL4Vert

]
(* end of BL4Vertex *)
]
