(* SmeftFR v2.00 package *)
(* gauge fixing and Feynman rules for ghost terms (R_xi gauge only) *)


SMEFT$LGfix = Function[{},
(* gauge fixing terms in terms of PHYSICAL (mass eigenstate) A,Z,W,G0,G+ *)
Block[{aux,f1,f2,F,ixi,i,k,ii,jj,mu,phfix,pzfix,pwfix,pzf1,pzf2,pzf3,xrot,xi,VEV,tmp},
	       
VEV = {0,vev/Sqrt[2]};

xrot = {{g1norm,0},{0,gwnorm}}.Table[ AZnorm[ Index[SU2W,ii], Index[SU2W,jj] ],{ii,1,2},{jj,1,2}] // Expand;
xrot = xrot /. Lam^k_ -> If[k > 1, 0, Lam] // Simplify;
xrot = {{xrot[[2,2]],xrot[[2,1]]},{xrot[[1,2]],xrot[[1,1]]}};

xi = Table[0,{ii,1,4},{jj,1,4}];
tmp = xrot.{{xiZ,0},{0,xiA}}.Transpose[xrot];
For[ii=1,ii<3,ii++,
  xi[[ii,ii]] = xiW;
  For[jj=1,jj<3,jj++, xi[[ii+2,jj+2]] = tmp[[ii,jj]];
  ];		   
];	
xi = Expand[xi] /. Lam^k_ -> If[k > 1, 0, Lam];
      
f2 = Table[0,{ii,1,4}];
ixi = Normal[Series[Inverse[xi],{Lam,0,1}]] // Simplify;

f1 = ExpandIndices[ {gwnorm del[Wi[mu,1],mu],
                     gwnorm del[Wi[mu,2],mu],
                     gwnorm del[Wi[mu,3],mu],
                     g1norm del[B[mu],mu]} ];
f1 = f1 /. Lam^k_ -> If[k > 1, 0, Lam];

For[i=1,i<4,i++,
    For[ii=1,ii<3,ii++,
	For[jj=1,jj<3,jj++,
	    f2[[i]] = f2[[i]] + GW Ta[i,ii,jj] (HC[PhiSM[ii]] VEV[[jj]] - VEV[[ii]] PhiSM[jj]);
	];
    ];
];
f2[[3]] = f2[[3]]/G0norm^2;

For[ii=1,ii<3,ii++, f2[[4]] = f2[[4]] + (HC[PhiSM[ii]] VEV[[ii]] - PhiSM[ii] VEV[[ii]]) ];
f2[[4]] = G1/2/G0norm^2 f2[[4]];

f2 = ExpandIndices[f2, FlavorExpand->SU2W] // Simplify;
      
F = f1 - I xi.f2;
F = Normal[Series[F,{Lam,0,1}]];
	       
aux = - F.ixi.F/2  // Expand;
aux = aux /. Lam^k_ -> If[k > 1, 0, Lam^k] // Simplify;

phfix = aux - (aux /. A[___]->0) // Simplify;
aux = aux - phfix // Simplify;
pzfix = aux - (aux /. Z[___]->0 /. G0->0) // Simplify;
pwfix = aux - pzfix // Simplify;
pwfix = pwfix /. vev GW -> MW // FullSimplify;
	       
pzf1 = pzfix /. G0->0 // Simplify;
pzf2 = pzfix /. Z[___]->0 // Simplify;
pzf3 = pzfix - pzf1 - pzf2 // Simplify;

pzf2 = pzf2 / SMEFT$MZ2 // Simplify;	       
pzf3 = Normal[Series[pzf3 /Sqrt[SMEFT$MZ2], {Lam, 0, 1}] ];    
pzf3 = Simplify[pzf3,Assumptions-> vev>0];

pzfix = pzf1 + MZ^2 pzf2 + MZ pzf3 // Simplify;	       
	       
phfix + pzfix + pwfix	       

]
(* end of LGfix *)     
];



SMEFT$LGhost = Function[{},
(* ghost Lagrangian in R_xi gauge *)
Block[{gvh,gvhbar,ghmat,ii,jj,k,aa,bb,cc,mu,xrot,xi,eta,aux},

xrot = {{g1norm,0},{0,gwnorm}}.Table[ AZnorm[ Index[SU2W,ii], Index[SU2W,jj] ],{ii,1,2},{jj,1,2}] // Expand;
xrot = xrot /. Lam^k_ -> If[k > 1, 0, Lam] // Simplify;
xrot = {{xrot[[2,2]],xrot[[2,1]]},{xrot[[1,2]],xrot[[1,1]]}};

xi = Table[0,{ii,1,4},{jj,1,4}];
tmp = xrot.{{xiZ,0},{0,xiA}}.Transpose[xrot];
For[ii=1,ii<3,ii++,
  xi[[ii,ii]] = xiW;
  For[jj=1,jj<3,jj++, xi[[ii+2,jj+2]] = tmp[[ii,jj]];
  ];		   
];	
xi = Expand[xi] /. Lam^k_ -> If[k > 1, 0, Lam];

eta = Table[KroneckerDelta[ii,jj],{ii,1,4},{jj,1,4}];
eta[[3,4]] = eta[[4,3]] = Lam vev^2 If[ MemberQ[ SMEFTOperatorList, "phiWB" ], ToExpression[SMEFT$MB <> "phiWB"], 0];
      
gvh = {ghWi[1],ghWi[2],ghWi[3],ghB};
gvhbar = {ghWibar[1],ghWibar[2],ghWibar[3],ghBbar};
		
aux = gvhbar.eta.del[del[gvh,mu],mu];

aux = aux + gwnorm GW del[gvhbar,mu].eta.{{0,         -Wi[mu,3], Wi[mu,2],  0}, 
					  {Wi[mu,3],  0,         -Wi[mu,1], 0},
					  {-Wi[mu,2], Wi[mu,1],  0,         0},
					  {0,         0,         0,         0}}.gvh // ExpandIndices;
aux = aux /. Lam^k_ -> If[k > 1, 0, Lam];

      
ghmat = {
	  {Hnorm H + vev,              G0norm G0,                    GPnorm/Sqrt[2] (GP + GPbar),   G1/GW GPnorm/Sqrt[2] (GP + GPbar)   },
	  {- G0norm G0,                Hnorm H + vev,                I GPnorm/Sqrt[2] (GP - GPbar), I G1/GW GPnorm/Sqrt[2] (GP - GPbar) },
          {- (GP + GPbar)/Sqrt[2],     - I (GP - GPbar)/Sqrt[2],     Hnorm H + vev,                 -G1/GW (Hnorm H + vev)              }/G0norm^2,
          {G1/GW (GP + GPbar)/Sqrt[2], I G1/GW (GP - GPbar)/Sqrt[2], - G1/GW (Hnorm H + vev),       G1^2/GW^2 (Hnorm H + vev)           }/G0norm^2
	};

ghmat = Expand[vev GW^2/4 xi.ghmat] /. Lam^k_ -> If[k > 1, 0, Lam];
		
aux = aux + ExpandIndices[gvhbar.eta.ghmat.gvh];

aux = aux /. ghB -> xrot[[2,1]] ghZ + xrot[[2,2]] ghA /.
             ghBbar -> xrot[[2,1]] ghZbar + xrot[[2,2]] ghAbar;

aux = aux /. ghWi[Index[SU2W, 3]] -> xrot[[1,1]] ghZ + xrot[[1,2]] ghA /.
             ghWibar[Index[SU2W, 3]] -> xrot[[1,1]] ghZbar + xrot[[1,2]] ghAbar;

aux = Normal[Series[aux, {Lam,0,1}]] // Expand;
		
(* QCD ghosts *)
aux = aux - ExpandIndices[del[ghGbar[aa],mu] del[ghG[aa],mu] +
			  GS f[aa,bb,cc] del[ghGbar[aa],mu] ghG[bb] G[mu,cc]];
      
aux

]
(* end of LGhost *)    
];



GhostInteractions = Function[{}, 
(* EW and QCD ghost couplings *)

Print[Style["Calculating ghost vertices...",Bold]];
(* run it to check the proper form of gauge-fixing terms
   test = SMEFT$LGfix[]; *)
      
GhostLagrangian = SMEFT$LGhost[];      
GhostVertices = FeynmanRules[GhostLagrangian];
   
];

