(* Generated by SMEFTParFile routine *)
(* 4.4.2019 21:34 *)

(* Active operators included in Feynman Rules: {dB, dd, dG, dphi, duq, duu, dW, eB, ed, ee, ephi, eu, eW, G, Gtilde, ld, le, ledq, lequ1, lequ3, ll, lq1, lq3, lu, phi, phiB, phiBox, phiBtilde, phid, phiD, phie, phiG, phiGtilde, phil1, phil3, phiq1, phiq3, phiu, phiud, phiW, phiWB, phiWtilde, phiWtildeB, qd1, qd8, qe, qq1, qq3, qqq, qqu, qu1, qu8, quqd1, quqd8, uB, ud1, ud8, uG, uphi, uu, uW, vv, W, Wtilde} *)

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* INTERNAL PARAMETERS *)

(* field and gauge normalization factors *)

(* Physical Higgs H *)
Hnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Physical Higgs normalization"
},

(* Neutral Goldstone G0 *)
G0norm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Neutral Goldstone normalization"
},

(* Charged Goldstone GP *)
GPnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Neutral Goldstone normalization"
},

(* Physical Z and photon *)
AZnorm == {
ParameterType -> Internal,
Indices -> {SU2W,SU2W},
ComplexParameter -> False,
Description -> "Physical Z and photon mixing matrix"
},

(* Physical W *)
Wnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "W normalization"
},

(* Physical gluon *)
Gnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Gluon normalization"
},

(* g1 normalization *)
g1norm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "g1 coupling normalization"
},

(* gw normalization *)
gwnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "gw coupling normalization"
},

(* gs normalization *)
gsnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "gs coupling normalization"
},

(* initial SM couplings before redefinitions *)
    
gw == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  Definitions      -> {gw :> gwnorm GW},
  TeX              -> Subscript[g,W], 
  Description      -> "Weak SU(2) coupling constant"
},

g1 == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  Definitions      -> {g1 :> g1norm G1},
  TeX              -> Subscript[g,1], 
  Description      -> "U(1)Y coupling constant"
},

gs == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QCD,1},  
  Definitions      -> {gs :> gsnorm GS},
  TeX              -> Subscript[g,s], 
  Description      -> "Strong sU(3) coupling constant"
},

(* effective gauge coupling constants *)

G1 == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  TeX              -> Subscript[G,1], 
  Description      -> "Effective U(1)Y coupling constant"
},

GW == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  TeX              -> Subscript[G,W], 
  Description      -> "Effective SU(2) coupling constant"
},

GS == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QCD,1},  
  TeX              -> Subscript[G,s], 
  Description      -> "Effective SU(3) coupling constant at the Z pole"
},

(* Higgs parameters *)
  
vev == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,-1},
  Description      -> "Higgs vacuum expectation value"
},

lam == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED, 1},
  TeX           -> \[Lambda],
  Description      -> "Higgs quartic coupling"
},

muH == {
  ParameterType -> Internal,
TeX           -> \[Mu],
Description   -> "Coefficient of the quadratic piece of the Higgs potential"
},

(* particle masses *)
    
MW == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,W], 
  Description   -> "W mass"
},

MZ == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,Z], 
  Description   -> "Z mass"
},

MH == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,H], 
  Description   -> "H mass"
},

(* fermion masses *)

fml == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fml[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, l],
  Description      -> "Lepton tree level pole masses"
},

fmu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, u],
  Description      -> "Up-type quark masses"
},

fmd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, d],
  Description      -> "Down-type quark masses"
},

mvdiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, \[Nu]],
    Description      -> "Neutrino masses"
},

mldiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, l],
    Description      -> "Lepton tree level pole masses"
},

mudiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, u],
    Description      -> "Up quark masses"
},

mddiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, d],
    Description      -> "Down quark masses"
},

(* Yukawa couplings *)  

yl == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, l],
  Description      -> "Lepton Yukawa coupling"
},

yu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, u],
  Description      -> "Up-type Yukawa coupling"
},

yd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, d],
  Description      -> "Down-type Yukawa coupling"
},

(* fermion fields rotations from Warsaw to mass basis *)

VVL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left neutrino mixing matrix"
},

VLL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left lepton mixing matrix"
},

VLR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right lepton mixing matrix"
},

VUL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left up quark mixing matrix"
},

VUR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right up quark mixing matrix"
},

VDL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left down quark mixing matrix"
},

VDR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right down quark mixing matrix"
},


(* physical flavor mixing *)

(* CKM matrix K =  VUL^+ VDL + corrections *)
K == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "CKM Matrix"
},

(* PMNS matrix U = VLL^+ VVL + corrections *)
U == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "PMNS Matrix"
},

(* gauge fixing parameters *)

xiW == { 
    ParameterType -> Internal, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],W], 
    Description   -> "W gauge fixing parameter"
  },

xiZ == { 
    ParameterType -> Internal, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],Z], 
    Description   -> "Z gauge fixing parameter"
  },

xiA == { 
    ParameterType -> Internal, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A], 
    Description   -> "A gauge fixing parameter"
  },

xiG == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G], 
    Description   -> "Gluon gauge fixing parameter"
  },


(* dim 6 couplings in Warsaw basis *)

(* flavor independent *)

cphi == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphi :> Cphi},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]],
  Description      -> "Qphi dim-6 coupling"
},


cphiBox == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiBox :> CphiBox},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]Box],
  Description      -> "QphiBox dim-6 coupling"
},


cphiD == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiD :> CphiD},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]D],
  Description      -> "QphiD dim-6 coupling"
},


cphiW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiW :> CphiW},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]W],
  Description      -> "QphiW dim-6 coupling"
},


cphiWtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiWtilde :> CphiWtilde},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]Wtilde],
  Description      -> "QphiWtilde dim-6 coupling"
},


cphiB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiB :> CphiB},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]B],
  Description      -> "QphiB dim-6 coupling"
},


cphiBtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiBtilde :> CphiBtilde},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]Btilde],
  Description      -> "QphiBtilde dim-6 coupling"
},


cphiWB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiWB :> CphiWB},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]WB],
  Description      -> "QphiWB dim-6 coupling"
},


cphiWtildeB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiWtildeB :> CphiWtildeB},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]WtildeB],
  Description      -> "QphiWtildeB dim-6 coupling"
},


cphiG == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiG :> CphiG},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]G],
  Description      -> "QphiG dim-6 coupling"
},


cphiGtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiGtilde :> CphiGtilde},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]Gtilde],
  Description      -> "QphiGtilde dim-6 coupling"
},


cG == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cG :> CG},
  ComplexParameter -> False,
  TeX              -> Superscript[c, G],
  Description      -> "QG dim-6 coupling"
},


cGtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cGtilde :> CGtilde},
  ComplexParameter -> False,
  TeX              -> Superscript[c, Gtilde],
  Description      -> "QGtilde dim-6 coupling"
},


cW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cW :> CW},
  ComplexParameter -> False,
  TeX              -> Superscript[c, W],
  Description      -> "QW dim-6 coupling"
},


cWtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cWtilde :> CWtilde},
  ComplexParameter -> False,
  TeX              -> Superscript[c, Wtilde],
  Description      -> "QWtilde dim-6 coupling"
},


(* flavor dependent *)

(* 2 fermion operators *)

cephi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cephi[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] Cephi[ind1,ind2] Conjugate[VLR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, e\[Phi]],
  Description      -> "Qephi coupling"
},


cdphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdphi[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] Cdphi[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, d\[Phi]],
  Description      -> "Qdphi coupling"
},


cuphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuphi[ff1_,ff2_] :> Module[{ind1,ind2}, VUL[ff1,ind1] Cuphi[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, u\[Phi]],
  Description      -> "Quphi coupling"
},


ceW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {ceW[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] CeW[ind1,ind2] Conjugate[VLR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, eW],
  Description      -> "QeW coupling"
},


ceB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {ceB[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] CeB[ind1,ind2] Conjugate[VLR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, eB],
  Description      -> "QeB coupling"
},


cuG == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuG[ff1_,ff2_] :> Module[{ind1,ind2}, VUL[ff1,ind1] CuG[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, uG],
  Description      -> "QuG coupling"
},


cuW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuW[ff1_,ff2_] :> Module[{ind1,ind2}, VUL[ff1,ind1] CuW[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, uW],
  Description      -> "QuW coupling"
},


cuB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuB[ff1_,ff2_] :> Module[{ind1,ind2}, VUL[ff1,ind1] CuB[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, uB],
  Description      -> "QuB coupling"
},


cdG == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdG[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] CdG[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, dG],
  Description      -> "QdG coupling"
},


cdW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdW[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] CdW[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, dW],
  Description      -> "QdW coupling"
},


cdB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdB[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] CdB[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, dB],
  Description      -> "QdB coupling"
},


cphil1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphil1[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] Cphil1[ind1,ind2] Conjugate[VLL[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]l1],
  Description      -> "Qphil1 coupling"
},


cphil3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphil3[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] Cphil3[ind1,ind2] Conjugate[VLL[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]l3],
  Description      -> "Qphil3 coupling"
},


cphie == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphie[ff1_,ff2_] :> Module[{ind1,ind2}, VLR[ff1,ind1] Cphie[ind1,ind2] Conjugate[VLR[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]e],
  Description      -> "Qphie coupling"
},


cphiq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiq1[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] Cphiq1[ind1,ind2] Conjugate[VDL[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]q1],
  Description      -> "Qphiq1 coupling"
},


cphiq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiq3[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] Cphiq3[ind1,ind2] Conjugate[VDL[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]q3],
  Description      -> "Qphiq3 coupling"
},


cphiu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiu[ff1_,ff2_] :> Module[{ind1,ind2}, VUR[ff1,ind1] Cphiu[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]u],
  Description      -> "Qphiu coupling"
},


cphid == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphid[ff1_,ff2_] :> Module[{ind1,ind2}, VDR[ff1,ind1] Cphid[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, \[Phi]d],
  Description      -> "Qphid coupling"
},


cphiud == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiud[ff1_,ff2_] :> Module[{ind1,ind2}, VUR[ff1,ind1] Cphiud[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, \[Phi]ud],
  Description      -> "Qphiud coupling"
},


(* 4 fermion operators *)

cll == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cll[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VLL[ff3,ind3] Cll[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VLL[ff4,ind4]] ]},
  TeX              -> Superscript[c, ll],
  Description      -> "Qll coupling"
},


cqq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqq1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDL[ff3,ind3] Cqq1[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VDL[ff4,ind4]] ]},
  TeX              -> Superscript[c, qq1],
  Description      -> "Qqq1 coupling"
},


cqq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqq3[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDL[ff3,ind3] Cqq3[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VDL[ff4,ind4]] ]},
  TeX              -> Superscript[c, qq3],
  Description      -> "Qqq3 coupling"
},


clq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {clq1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDL[ff3,ind3] Clq1[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VDL[ff4,ind4]] ]},
  TeX              -> Superscript[c, lq1],
  Description      -> "Qlq1 coupling"
},


clq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {clq3[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDL[ff3,ind3] Clq3[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VDL[ff4,ind4]] ]},
  TeX              -> Superscript[c, lq3],
  Description      -> "Qlq3 coupling"
},


cee == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cee[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLR[ff1,ind1] VLR[ff3,ind3] Cee[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VLR[ff4,ind4]] ]},
  TeX              -> Superscript[c, ee],
  Description      -> "Qee coupling"
},


cuu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuu[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VUR[ff1,ind1] VUR[ff3,ind3] Cuu[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, uu],
  Description      -> "Quu coupling"
},


cdd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdd[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDR[ff1,ind1] VDR[ff3,ind3] Cdd[ind1,ind2,ind3,ind4] Conjugate[VDR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, dd],
  Description      -> "Qdd coupling"
},


ceu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {ceu[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLR[ff1,ind1] VUR[ff3,ind3] Ceu[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, eu],
  Description      -> "Qeu coupling"
},


ced == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {ced[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLR[ff1,ind1] VDR[ff3,ind3] Ced[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, ed],
  Description      -> "Qed coupling"
},


cud1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cud1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VUR[ff1,ind1] VDR[ff3,ind3] Cud1[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, ud1],
  Description      -> "Qud1 coupling"
},


cud8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cud8[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VUR[ff1,ind1] VDR[ff3,ind3] Cud8[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, ud8],
  Description      -> "Qud8 coupling"
},


cle == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cle[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VLR[ff3,ind3] Cle[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VLR[ff4,ind4]] ]},
  TeX              -> Superscript[c, le],
  Description      -> "Qle coupling"
},


clu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {clu[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VUR[ff3,ind3] Clu[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, lu],
  Description      -> "Qlu coupling"
},


cld == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cld[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDR[ff3,ind3] Cld[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, ld],
  Description      -> "Qld coupling"
},


cqe == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqe[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VLR[ff3,ind3] Cqe[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VLR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qe],
  Description      -> "Qqe coupling"
},


cqu1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqu1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VUR[ff3,ind3] Cqu1[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qu1],
  Description      -> "Qqu1 coupling"
},


cqu8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqu8[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VUR[ff3,ind3] Cqu8[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qu8],
  Description      -> "Qqu8 coupling"
},


cqd1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqd1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDR[ff3,ind3] Cqd1[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qd1],
  Description      -> "Qqd1 coupling"
},


cqd8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqd8[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDR[ff3,ind3] Cqd8[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qd8],
  Description      -> "Qqd8 coupling"
},


cledq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cledq[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDR[ff3,ind3] Cledq[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VDL[ff4,ind4]] ]},
  TeX              -> Superscript[c, ledq],
  Description      -> "Qledq coupling"
},


cquqd1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cquqd1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDL[ff3,ind3] Cquqd1[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, quqd1],
  Description      -> "Qquqd1 coupling"
},


cquqd8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cquqd8[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VDL[ff1,ind1] VDL[ff3,ind3] Cquqd8[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VDR[ff4,ind4]] ]},
  TeX              -> Superscript[c, quqd8],
  Description      -> "Qquqd8 coupling"
},


clequ1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {clequ1[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDL[ff3,ind3] Clequ1[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, lequ1],
  Description      -> "Qlequ1 coupling"
},


clequ3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {clequ3[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VDL[ff3,ind3] Clequ3[ind1,ind2,ind3,ind4] Conjugate[VLR[ff2,ind2]] Conjugate[VUR[ff4,ind4]] ]},
  TeX              -> Superscript[c, lequ3],
  Description      -> "Qlequ3 coupling"
},


(* L or B violating operators *)

cvv == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cvv[ff1_,ff2_] :> Module[{ind1,ind2}, Conjugate[VVL[ff1,ind1]] Cvv[ind1,ind2] Conjugate[VVL[ff2,ind2]] ]},
  Hermitian        -> True,
  TeX              -> Superscript[c, vv],
  Description      -> "Qvv coupling"
},


cduq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cduq[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, Conjugate[VDR[ff1,ind1]] Conjugate[VDL[ff3,ind3]] Cduq[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VLL[ff4,ind4]] ]},
  TeX              -> Superscript[c, duq],
  Description      -> "Qduq coupling"
},


cqqu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqqu[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, Conjugate[VDL[ff1,ind1]] Conjugate[VUR[ff3,ind3]] Cqqu[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VLR[ff4,ind4]] ]},
  TeX              -> Superscript[c, qqu],
  Description      -> "Qqqu coupling"
},


cqqq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cqqq[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, Conjugate[VDL[ff1,ind1]] Conjugate[VDL[ff3,ind3]] Cqqq[ind1,ind2,ind3,ind4] Conjugate[VDL[ff2,ind2]] Conjugate[VLL[ff4,ind4]] ]},
  TeX              -> Superscript[c, qqq],
  Description      -> "Qqqq coupling"
},


cduu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cduu[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, Conjugate[VDR[ff1,ind1]] Conjugate[VUR[ff3,ind3]] Cduu[ind1,ind2,ind3,ind4] Conjugate[VUR[ff2,ind2]] Conjugate[VLR[ff4,ind4]] ]},
  TeX              -> Superscript[c, duu],
  Description      -> "Qduu coupling"
},


(* redefined (mass basis) dim-6 couplings *)

(* flavor independent *)

Cphi == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]],
  Description      -> "Qphi dim-6 coupling"
},


CphiBox == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]Box],
  Description      -> "QphiBox dim-6 coupling"
},


CphiD == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]D],
  Description      -> "QphiD dim-6 coupling"
},


CphiW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]W],
  Description      -> "QphiW dim-6 coupling"
},


CphiWtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]Wtilde],
  Description      -> "QphiWtilde dim-6 coupling"
},


CphiB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]B],
  Description      -> "QphiB dim-6 coupling"
},


CphiBtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]Btilde],
  Description      -> "QphiBtilde dim-6 coupling"
},


CphiWB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]WB],
  Description      -> "QphiWB dim-6 coupling"
},


CphiWtildeB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]WtildeB],
  Description      -> "QphiWtildeB dim-6 coupling"
},


CphiG == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]G],
  Description      -> "QphiG dim-6 coupling"
},


CphiGtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]Gtilde],
  Description      -> "QphiGtilde dim-6 coupling"
},


CG == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, G],
  Description      -> "QG dim-6 coupling"
},


CGtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, Gtilde],
  Description      -> "QGtilde dim-6 coupling"
},


CW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, W],
  Description      -> "QW dim-6 coupling"
},


CWtilde == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, Wtilde],
  Description      -> "QWtilde dim-6 coupling"
},


(* flavor dependent *)

(* 2 fermion operators *)

Cephi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, e\[Phi]],
  Description      -> "Qephi coupling"
},


Cdphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, d\[Phi]],
  Description      -> "Qdphi coupling"
},


Cuphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, u\[Phi]],
  Description      -> "Quphi coupling"
},


CeW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, eW],
  Description      -> "QeW coupling"
},


CeB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, eB],
  Description      -> "QeB coupling"
},


CuG == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, uG],
  Description      -> "QuG coupling"
},


CuW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, uW],
  Description      -> "QuW coupling"
},


CuB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, uB],
  Description      -> "QuB coupling"
},


CdG == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, dG],
  Description      -> "QdG coupling"
},


CdW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, dW],
  Description      -> "QdW coupling"
},


CdB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, dB],
  Description      -> "QdB coupling"
},


Cphil1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]l1],
  Description      -> "Qphil1 coupling"
},


Cphil3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]l3],
  Description      -> "Qphil3 coupling"
},


Cphie == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]e],
  Description      -> "Qphie coupling"
},


Cphiq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]q1],
  Description      -> "Qphiq1 coupling"
},


Cphiq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]q3],
  Description      -> "Qphiq3 coupling"
},


Cphiu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]u],
  Description      -> "Qphiu coupling"
},


Cphid == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, \[Phi]d],
  Description      -> "Qphid coupling"
},


Cphiud == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, \[Phi]ud],
  Description      -> "Qphiud coupling"
},


(* 4 fermion operators *)

Cll == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ll],
  Description      -> "Qll coupling"
},


Cqq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qq1],
  Description      -> "Qqq1 coupling"
},


Cqq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qq3],
  Description      -> "Qqq3 coupling"
},


Clq1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, lq1],
  Description      -> "Qlq1 coupling"
},


Clq3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, lq3],
  Description      -> "Qlq3 coupling"
},


Cee == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ee],
  Description      -> "Qee coupling"
},


Cuu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, uu],
  Description      -> "Quu coupling"
},


Cdd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, dd],
  Description      -> "Qdd coupling"
},


Ceu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, eu],
  Description      -> "Qeu coupling"
},


Ced == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ed],
  Description      -> "Qed coupling"
},


Cud1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ud1],
  Description      -> "Qud1 coupling"
},


Cud8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ud8],
  Description      -> "Qud8 coupling"
},


Cle == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, le],
  Description      -> "Qle coupling"
},


Clu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, lu],
  Description      -> "Qlu coupling"
},


Cld == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ld],
  Description      -> "Qld coupling"
},


Cqe == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qe],
  Description      -> "Qqe coupling"
},


Cqu1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qu1],
  Description      -> "Qqu1 coupling"
},


Cqu8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qu8],
  Description      -> "Qqu8 coupling"
},


Cqd1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qd1],
  Description      -> "Qqd1 coupling"
},


Cqd8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qd8],
  Description      -> "Qqd8 coupling"
},


Cledq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ledq],
  Description      -> "Qledq coupling"
},


Cquqd1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, quqd1],
  Description      -> "Qquqd1 coupling"
},


Cquqd8 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, quqd8],
  Description      -> "Qquqd8 coupling"
},


Clequ1 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, lequ1],
  Description      -> "Qlequ1 coupling"
},


Clequ3 == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, lequ3],
  Description      -> "Qlequ3 coupling"
},


(* L or B violating operators *)

Cvv == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> True,
  TeX              -> Superscript[C, vv],
  Description      -> "Qvv coupling"
},


Cduq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, duq],
  Description      -> "Qduq coupling"
},


Cqqu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qqu],
  Description      -> "Qqqu coupling"
},


Cqqq == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, qqq],
  Description      -> "Qqqq coupling"
},


Cduu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, duu],
  Description      -> "Qduu coupling"
},


(* NP scale *)

Lam == {
  ParameterType -> Internal,
  TeX           -> 1/\[CapitalLambda]^2,
  Description   -> "Effective NP scale squared"
}

};

