(* SmeftFR v2.00 package *)
(* rediagonalization of SMEFT Lagrangian, field and couplings redefinitions *)


SMEFTFindMassBasis = Function[{},
(* find transformations to mass basis, sector by sector *)

(* gauge coupling normalization  g -> gnorm G *)
g1norm = 1 - Lam vev^2 If[ MemberQ[ SMEFTOperatorList, "phiB" ], ToExpression[SMEFT$MB <> "phiB"], 0];
gwnorm = 1 - Lam vev^2 If[ MemberQ[ SMEFTOperatorList, "phiW" ], ToExpression[SMEFT$MB <> "phiW"], 0];
gsnorm = 1 - Lam vev^2 If[ MemberQ[ SMEFTOperatorList, "phiG" ], ToExpression[SMEFT$MB <> "phiG"], 0];

HiggsSectorDiagonalization[];
GaugeSectorDiagonalization[];
FermionSectorDiagonalization[];

(* end of SMEFTFindMassBasis *)
]


HiggsSectorDiagonalization = Function[{},
(* HIGGS SECTOR REDIAGONALIZATION *) 
Block[{ a, LHeff, KinH, tmp, VGHiggs, VHiggs, dV, dV0, dV1, vev, vev0,
delvev, dvev, MGH2, MG0, MGP },

(* effective pure Higgs Lagrangian, Lam is actually 1/Lambda^2! *)
LHeff = SMEFT$LGeff /. A[a_] -> 0 /. Z[a_] -> 0 /. W[a_] -> 0 /. Wbar[a_] -> 0 /. G[a_,b_] ->0 // Expand;

(* find kinetic terms *)
KinH = OptimizeIndex[ GetKineticTerms[ LHeff, FlavorExpand->False ] ];
(* change Hd^2H to -(dH)^2 *)
KinH = KinH /. F_ del[del[F_, Index[Lorentz,a_]], Index[Lorentz,a_]] -> 
               - del[F, Index[Lorentz, a]]^2;
KinH = KinH /. GP del[del[GPbar, Index[Lorentz,a_]], Index[Lorentz,a_]] -> 
               - del[GP, Index[Lorentz, a]] del[GPbar, Index[Lorentz, a]];
KinH = KinH /. GPbar del[del[GP, Index[Lorentz,a_]], Index[Lorentz,a_]] -> 
               - del[GP, Index[Lorentz, a]] del[GPbar, Index[Lorentz, a]];

(* find normalization of Higgs kinetic terms *)
tmp = 2 KinH /. G0->0 /. GP->0 /. del[H, a_] -> 1;
tmp = Solve[tmp == 1, Hnorm][[2]];
tmp = Normal[Series[Hnorm /. tmp, {Lam, 0, 1}]];
Hnorm = tmp // Simplify;
If [ SMEFTRxiGaugeStatus, 
  tmp = 2 KinH /. H->0 /. GP->0 /. del[G0, a_] -> 1;
  tmp = Solve[tmp == 1, G0norm][[2]];
  tmp = Normal[Series[G0norm /. tmp, {Lam, 0, 1}]];
  G0norm = tmp // Simplify;

  tmp = KinH /. H->0 /. G0->0 /. 
                del[GP, Index[Lorentz, a_]] del[GPbar, Index[Lorentz, a_]] -> 1;
  tmp = Solve[tmp == 1, GPnorm][[2]];
  tmp = Normal[Series[GPnorm /. tmp, {Lam, 0, 1}]];
  GPnorm = tmp // Simplify;
,
  G0norm = 1;     
  GPnorm = 1;     
];

tmp = Normal[Series[1/Hnorm, {Lam,0,1}]];     
Hnorm = 1/tmp;
tmp = Normal[Series[1/G0norm, {Lam,0,1}]];     
G0norm = 1/tmp;
tmp = Normal[Series[1/GPnorm, {Lam,0,1}]];     
GPnorm = 1/tmp;

(* Higgs Lagrangian in normalized fields H,G *)
LHeff = LHeff // Expand;
(* keep only terms 1/Lambda^2 *)
LHeff = LHeff /. Lam^k_ -> If[k > 1, 0, Lam^k];

(* effective Higgs potential and derivative *)
VGHiggs = - LHeff /. del[H_, ___]->0;
VHiggs = VGHiggs /. G0->0 /. GP->0 /. GPbar -> 0;
dV = D[VHiggs,H];

(* we want dV vanish for H=0, so H=0 is true vaccum; this gives
equation for vev *) 
dV0 = dV /. H->0 // Simplify;
(* solve for 0th order in Lambda, choose positive non-0 solution *)
tmp = vev /. Solve[ (dV0 /. Lam->0) == 0, vev ];
vev0 = tmp[[3]];

(* 1st order Lambda correction *)
dV1 = dV0 /. vev -> vev0 + delvev // Expand;
dV1 = dV1 /. delvev^k_ -> If[k > 1, 0, delvev^k];

tmp = Solve[ dV1 == 0, delvev];
dvev = delvev /. tmp[[1]][[1]];
dvev = Normal[ Series[ dvev, {Lam,0,1} ] ];

(* relation of vev and Lagrangian parameters (name it SMEFT$vev and keep vev
as variable) *)
SMEFT$vev = vev0 + dvev;

(* find physical Higgs mass^2 *)
VGHiggs = VGHiggs /. vev -> SMEFT$vev // Expand;
VGHiggs = VGHiggs /. Lam^k_ -> If[k > 1, 0, Lam^k];
MGH2 = GetMassTerms[VGHiggs]  // Expand // Simplify;

SMEFT$MH2 = 2 Coefficient[MGH2, H^2];
If [ SMEFTRxiGaugeStatus, 
  MG0 = 2 Coefficient[MGH2, G0^2];
  MGP = Coefficient[MGH2, GP GPbar];
  If[ MG0 != 0 || MGP != 0, Print["Error: non-vanishing Goldstone masses in unitary gauge!"]; Abort[];];
];

]
(* end of HiggsSectorDiagonalization *)
]



GaugeSectorDiagonalization = Function[{},
(* GAUGE SECTOR REDIAGONALIZATION *)
Block[{ a, b, c, k, mu$1, mu$2, tmp, z11, z12, z21, z22, LGeff, KinG,
KinG0, KinF, KinZ, KinZF, KinW, MassG, MassG0, MassW, MassF, MGKin,
MGMass, CKF, CKZ, CKZF, CMF, CMZ, CMZF, U0 },

(* Z and photon first *)

(* pure gauge Lagrangian, X Xtilde neglected -> full divergence in bilinears *)
LGeff = SMEFT$LGeff /. H -> 0 /. G0 -> 0 /. GP->0 /. GPbar->0 // Expand;
LGeff = LGeff /. Eps[a_,b_,c_,d_]-> 0 /. Lam^k_ -> If[k > 1, 0, Lam^k];

KinG = GetKineticTerms[ LGeff, FlavorExpand->False ];
MassG = GetMassTerms[ LGeff, FlavorExpand->False ];

(* kinetic and mass terms for B and W3 fields *)
KinG0 = KinG /. W[a_]-> 0 /. Wbar[a_]-> 0 /. G[a_,b_] -> 0;
MassG0 = MassG /. W[a_] -> 0 /. Wbar[a_]-> 0 /. G[a_,b_] -> 0;

KinG = KinG - KinG0;
MassG = MassG - MassG0;
(* optimize indices and antisymmetrize *)
KinG0 = OptimizeIndex[KinG0]; 
KinG0 = KinG0 /. del[c_[a_], b_] -> 1/2 (del[c[a], b] - del[c[b], a]);
MassG0 = OptimizeIndex[MassG0]; 

KinF = KinG0 /. Z[a_] -> 0 // Simplify;
KinZ = KinG0 /. A[a_] -> 0 // Simplify;
KinZF = KinG0 - KinZ - KinF // Expand // Simplify;

ttt = KinF;


(* coefficients of kinetic terms *)
CKF = -4 Coefficient[ KinF, (del[A[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] - 
                             del[A[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]])^2];
                             
CKZ = -4 Coefficient[ KinZ, (del[Z[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] - 
                             del[Z[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]])^2];

CKZF = -4 Coefficient[ KinZF, (del[A[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] - 
                               del[A[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]]) *
                              (del[Z[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] - 
                               del[Z[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]])];

(* kinetic mixing matrix, kinetic term is -1/4 (dB,dW3) MGKin (dB,dw3) *)
MGKin = {{CKF,CKZF/2},{CKZF/2,CKZ}};

(* coefficients of mass terms *)
CMF = 2 Coefficient[ MassG0, A[Index[Lorentz,mu$1]]^2 ] // Simplify;
CMZ = 2 Coefficient[ MassG0, Z[Index[Lorentz,mu$1]]^2 ] // Simplify;
CMZF = 2 Coefficient[ MassG0, Z[Index[Lorentz,mu$1]] A[Index[Lorentz,mu$1]] ] // Simplify;
      
(* kinetic mixing matrix, kinetic term is 1/2 (B,W3) MGMAss (B,W3) *)
MGMass = {{CMF,CMZF/2},{CMZF/2,CMZ}} // Expand;

(* AZnorm should be SM rotation times 1/Lambda^2 correction *)
U0 = 1/Sqrt[GW^2 + G1^2] {{GW, -G1},{G1, GW}}.{{1 + Lam z11, Lam z12},  {Lam z21, 1 + Lam z22}} // Expand;

For[a=1,a<3,a++,
  For[b=1,b<3,b++,
    MGKin = MGKin /. AZnorm[Index[SU2W, a], Index[SU2W, b]] -> U0[[a, b]] // Expand; 
    MGMass = MGMass /. AZnorm[Index[SU2W, a], Index[SU2W, b]] -> U0[[a, b]] // Expand;
  ];
];
Clear[a,b];

MGKin = MGKin /. Lam^k_ -> If[k > 1, 0, Lam^k];
MGMass = MGMass /. Lam^k_ -> If[k > 1, 0, Lam^k];

(* Require MGKin to be unit matrix and MGMass to be diagonal with vanishing photon mass *)
      
tmp = (z11 /. Solve[MGKin[[1, 1]] == 1, z11])[[1]];
z11 = tmp // Simplify;
tmp = (z22 /. Solve[MGKin[[2, 2]] == 1, z22])[[1]];
z22 = tmp // Simplify;

tmp = {z12, z21} /. Solve[{MGKin[[1, 2]] == 0, MGMass[[1, 2]] == 0}, {z12, z21}][[1]] // Simplify;
{z12, z21} = tmp;
      
(* Corrected Z mass *)
SMEFT$MZ2 = MGMass[[2,2]] // Simplify;
SMEFT$MZ2 = 4 SMEFT$MZ2 / vev^2 / (G1^2+GW^2) // Expand // FullSimplify;
SMEFT$MZ2 = (G1^2+GW^2) vev^2/4 SMEFT$MZ2;

(* full rotation matrix to Z and photon, (B,W3) = AZnorm (F,Z) *)
U0 = Simplify[U0 /. Lam -> 0] + FullSimplify[U0 - (U0 /. Lam -> 0)];
For[a=1,a<3,a++,
  For[b=1,b<3,b++,
    AZnorm[Index[SU2W, a], Index[SU2W, b]] = U0[[a, b]] // Simplify;
  ];
];
Clear[a,b];

(* W+/W- sector rediagonalization, this is the easy one... *)
(* kinetic and mass terms for W+/W- fields *)
KinW = KinG /. G[a_,b_] -> 0 // Simplify;
MassW = MassG /. G[a_,b_] -> 0 // Simplify;
KinG = KinG - KinW // Expand // Simplify;
MassG = MassG - MassW // Expand // Simplify;

KinW = OptimizeIndex[KinW]; 
KinW = KinW /. del[c_[a_], b_] -> 1/2 (del[c[a], b] - del[c[b], a]) // Simplify;
MassW = OptimizeIndex[MassW] // Simplify; 

KinG = OptimizeIndex[KinG]; 
KinG = KinG /. del[c_[a_,d_], b_] -> 1/2 (del[c[a,d], b] - del[c[b,d], a]) // Simplify;

tmp = -2 Coefficient[KinW, (del[W[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] -
                            del[W[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]])
                           (del[Wbar[Index[Lorentz,mu$1]],Index[Lorentz,mu$2]] -
                            del[Wbar[Index[Lorentz,mu$2]],Index[Lorentz,mu$1]])];
                            
(* normalization of W field *)
tmp = Solve[tmp == 1, Wnorm][[2]];
tmp = Normal[Series[Wnorm /. tmp, {Lam, 0, 1}]];
Wnorm = tmp // Simplify;

(* corrected W mass *)
SMEFT$MW2 = MassW / (W[Index[Lorentz, mu$1]] Wbar[Index[Lorentz, mu$1]]) // Expand;
SMEFT$MW2 = SMEFT$MW2 /. Lam^k_ -> If[k > 1, 0, Lam^k] // Simplify;

(* Gluon sector rediagonalization, again easy one... *)
(* normalization of gluon field *)
tmp = -4 Coefficient[KinG, (del[G[Index[Lorentz,mu$1],Index[Gluon,Gluon$1]],Index[Lorentz,mu$2]] -
                            del[G[Index[Lorentz,mu$2],Index[Gluon,Gluon$1]],Index[Lorentz,mu$1]] )^2];
tmp = Solve[tmp == 1, Gnorm][[2]];
tmp = Normal[Series[Gnorm /. tmp, {Lam, 0, 1}]];
Gnorm = tmp // Simplify;

]
(* end of GaugeSectorDiagonalization *)
];




FermionSectorDiagonalization = Function[{},
(* diagonalization of the fermion sector *)
Block[{a, b, c, k, LFeff, KinF, MassF, Flist, MLL, MUU, MDD, lhs, sol,
xl, xd, xu, f1, f2, g1, g2},

LFeff = SMEFT$LGFmass /. Z[a_] -> 0 /. A[a_] -> 0 /. W[a_] -> 0 // Expand;
LFeff = LFeff /. Lam^k_ -> If[k>1,0,Lam^k];

Clear[a,b,c];
(* apply unitarity of fermion rotations *)
LFeff = LFeff //. VVL[a_,b_] Conjugate[VVL[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VLL[a_,b_] Conjugate[VLL[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VLR[a_,b_] Conjugate[VLR[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VUL[a_,b_] Conjugate[VUL[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VUR[a_,b_] Conjugate[VUR[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VDL[a_,b_] Conjugate[VDL[a_,c_]] -> IndexDelta[b,c];
LFeff = LFeff //. VDR[a_,b_] Conjugate[VDR[a_,c_]] -> IndexDelta[b,c];

(* kinetic terms already in canonical form, no corrections *)
KinF = GetKineticTerms[ LFeff, FlavorExpand->False ];
(* find new mass terms *)
MassF = GetMassTerms[ LFeff, FlavorExpand->False ];
(* use FeynmanRules to simplify indices *)
Flist = FeynmanRules[ H MassF, ScreenOutput->False ];
(* keep only the right part *)
Flist = Flist /. ProjM[___] -> 0;
      
For[a=1,a<4,a++,
  If[ Flist[[a,1,2,1]] === l,  MLL =  - I Flist[[a,2]] // Expand ];
  If[ Flist[[a,1,2,1]] === uq, MUU =  - I Flist[[a,2]] // Expand ];
  If[ Flist[[a,1,2,1]] === dq, MDD =  - I Flist[[a,2]] // Expand ];
];
Clear[a];  

(* neglect Kronecker delta in color indices and chiral projectors *)

MDD = MDD /. ProjP[c_,d_] -> 1 /. IndexDelta[a_,b_] -> 1;
MUU = MUU /. ProjP[c_,d_] -> 1 /. IndexDelta[a_,b_] -> 1;
MLL = MLL /. ProjP[c_,d_] -> 1;

(* find relation of Yukawas to VL,VR from the condition of diagonal
tree level fermion masses *)

(* another trick - VL, VR are unitary, so 

VL[a,b] VL[a,c]^* = delta_ac
VL[b,a] VL[c,a]^* = delta_ac

Thus for invertions I take 

1/VLL[Generation$1, f1] -> Conjugate[VLL[Generation$1,f1]]

etc: seems to work...

*)

f1 = Index[ Generation, Ext[1] ];
f2 = Index[ Generation, Ext[2] ];

lhs = MLL /. yl[a_, b_] -> xl /. VLL[a_, b_] -> 1/Conjugate[VLL[a,b]] /.
                                 VLR[a_, b_] -> 1/Conjugate[VLR[a,b]];

sol = xl /. Solve[ lhs == - fml[f1,f2], xl ][[1]];
sol = Normal[ Series[ sol, {Lam,0,1} ] ];

SMEFT$YL[g1_,g2_] = sol /. Ext[1] -> Unique[YL] /. Ext[2] -> Unique[YL] /.
                   Index[Generation,Generation$1] -> g1 /. 
                   Index[Generation,Generation$2] -> g2 // Simplify;

lhs = MDD /. yd[a_, b_] -> xd /. VDL[a_, b_] -> 1/Conjugate[VDL[a,b]] /.
                                 VDR[a_, b_] -> 1/Conjugate[VDR[a,b]];

sol = xd /. Solve[ lhs == - fmd[f1,f2], xd ][[1]];
sol = Normal[ Series[ sol, {Lam,0,1} ] ];

SMEFT$YD[g1_,g2_] = sol /. Ext[1] -> Unique[YD] /. Ext[2] -> Unique[YD] /.
                   Index[Generation,Generation$1] -> g1 /. 
                   Index[Generation,Generation$2] -> g2 // Simplify;


lhs = MUU /. yu[a_, b_] -> xu /. VUL[a_, b_] -> 1/Conjugate[VUL[a,b]] /.
                                 VUR[a_, b_] -> 1/Conjugate[VUR[a,b]];

sol = xu /. Solve[ lhs == - fmu[f1,f2], xu ][[1]];
sol = Normal[ Series[ sol, {Lam,0,1} ] ];

SMEFT$YU[g1_,g2_] = sol /. Ext[1] -> Unique[YU] /. Ext[2] -> Unique[YU] /.
                   Index[Generation,Generation$1] -> g1 /. 
                   Index[Generation,Generation$2] -> g2 // Simplify;
           
]
(* end of FermionSectorDiagonalization *)
];

