(* SmeftFR v2.00 package *)
(* Auxiliary functions to simplify and transform SMEFT Lagrangian *)

(* sigma_munu Dirac matrix *)
Sigma[mu_,nu_,sp1_,sp2_] := I/2 Module[{spx},(Ga[mu,sp1,spx] Ga[nu,spx,sp2] - 
                                              Ga[nu,sp1,spx] Ga[mu,spx,sp2])];

                                           
Simplify2Tproduct = Function[{expr},
(*** SU(2) generators T^a_bc T^a_de reduction ***)
Module[{tmp,aa,y,z,y1,z1},

expr //. T[aa_,y_,z_] T[aa_,y1_,z1_] ->
      1/2 ( IndexDelta[y,z1] IndexDelta[z,y1] - 
      1/3 IndexDelta[y,z] IndexDelta[y1,z1] ) // Expand

]
(* end of Simplify2Tproduct *)     
];



(* make complex WC out of Re and Im in JSON file, scientific notation *)
SMEFTToComplex[x_] := If[NumberQ[x], x, ("Re" + I "Im") /. x ];




SwapExternalIndices = Function[{x,i1,i2},
(* swap external indeices excluding spin indices *)
Module[{swap,tmp},
 
tmp  = x /. Ext[i1] -> swap;
tmp = tmp /. Ext[i2] -> Ext[i1];
tmp = tmp /. swap -> Ext[i2];
 
tmp = tmp /. Index[Spin,Ext[i1]] -> Index[Spin,swap];
tmp = tmp /. Index[Spin,Ext[i2]] -> Index[Spin,Ext[i1]];
tmp = tmp /. Index[Spin,swap]    -> Index[Spin,Ext[i2]];

tmp

]
(* end of SwapExternalIndices *)
]




ReplaceFlavorRotations = Function[x,
(* replace flavor rotation matrices with CKM and PMNS *)
Block[{tmp,ind1,ind2,ff,ff1,ff2,ff3,ff4,a,b,c},

tmp = x;
	  
(* apply unitarity of fermion rotations *)
tmp = tmp //. VVL[a_,b_] Conjugate[VVL[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VLL[a_,b_] Conjugate[VLL[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VLR[a_,b_] Conjugate[VLR[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VUL[a_,b_] Conjugate[VUL[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VUR[a_,b_] Conjugate[VUR[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VDL[a_,b_] Conjugate[VDL[a_,c_]] -> IndexDelta[b,c];
tmp = tmp //. VDR[a_,b_] Conjugate[VDR[a_,c_]] -> IndexDelta[b,c];

tmp = tmp //. VVL[b_,a_] Conjugate[VVL[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VLL[b_,a_] Conjugate[VLL[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VLR[b_,a_] Conjugate[VLR[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VUL[b_,a_] Conjugate[VUL[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VUR[b_,a_] Conjugate[VUR[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VDL[b_,a_] Conjugate[VDL[c_,a_]] -> IndexDelta[b,c];
tmp = tmp //. VDR[b_,a_] Conjugate[VDR[c_,a_]] -> IndexDelta[b,c];

(* K=VUL^+ VDL, U = VLL^+ VVL + dim-6 corrections *)
ind1 = Index[Generation,Unique[ff]];
tmp = tmp //. Conjugate[VLL[a_,b_]] VVL[a_,c_] -> U[b,c] - 
              SMEFT$Unitary Lam vev^2 U[ind1,c] If[ MemberQ[SMEFTOperatorList,"phil3"], 
              ToExpression[SMEFT$MB <> "phil3"][b,ind1], 0];
ind1 = Index[Generation,Unique[ff]];
tmp = tmp //. Conjugate[VVL[a_,b_]] VLL[a_,c_] -> Conjugate[U[c,b]] -
              SMEFT$Unitary Lam vev^2 Conjugate[U[ind1,b]] Conjugate[If[ MemberQ[SMEFTOperatorList,"phil3"], 
              ToExpression[SMEFT$MB <> "phil3"][c,ind1], 0]]; 
ind1 = Index[Generation,Unique[ff]];
tmp = tmp //. Conjugate[VUL[a_,b_]] VDL[a_,c_] -> K[b,c] - 
              SMEFT$Unitary Lam vev^2 K[b,ind1] If[ MemberQ[SMEFTOperatorList,"phiq3"], 
              ToExpression[SMEFT$MB <> "phiq3"][ind1,c], 0];
ind1 = Index[Generation,Unique[ff]];
tmp = tmp //. Conjugate[VDL[a_,b_]] VUL[a_,c_] -> Conjugate[K[c,b]] -
              SMEFT$Unitary Lam vev^2 Conjugate[K[c,ind1]] Conjugate[If[ MemberQ[SMEFTOperatorList,"phiq3"], 
              ToExpression[SMEFT$MB <> "phiq3"][ind1,b], 0]];
    
tmp

]
(* End of ReplaceFlavorRotations *) 
];


 
ApplyFlavorRotations = Function[x,
(* express 2-fermion WCs in rotated (mass) basis *)
Block[{tmp,i,wcw,wcm,ind1,ind2,ff,ff1,ff2,ff3,ff4},

tmp = x // Expand // FunctionExpand;

For[i=1, i < Length[Tensor2WC] + 1, i++, 
  If[ ! Tensor2WC[[i,5]],
    ind1 = Index[Generation,Unique[ff]];
    ind2 = Index[Generation,Unique[ff]];
    wcw = ToExpression[ SMEFT$WB <> ToString[ Tensor2WC[[i,1]] ] ];
    wcm = ToExpression[ SMEFT$MB <> ToString[ Tensor2WC[[i,1]] ] ];
    tmp = tmp /. wcw[ff1_,ff2_] -> Tensor2WC[[i,2]][ff1,ind1] wcm[ind1,ind2] Conjugate[ Tensor2WC[[i,3]][ff2,ind2] ];
  ];
];
    
tmp // FunctionExpand

]
(* End of ApplyFlavorRotations *) 
];

 

Apply4fermionRotations = Function[x,
(* express 4-fermion WCs in rotated (mass) basis *)
Block[{tmp,i,wcw,wcm,ind1,ind2,ind3,ind4,ff,ff1,ff2,ff3,ff4},

tmp = x // Expand // FunctionExpand;

For[i=1, i < Length[Tensor4WC] + 1, i++, 
  If[ ! Tensor4WC[[i,6]],
    ind1 = Index[Generation,Unique[ff]];
    ind2 = Index[Generation,Unique[ff]];
    ind3 = Index[Generation,Unique[ff]];
    ind4 = Index[Generation,Unique[ff]];
    wcw = ToExpression[ SMEFT$WB <> ToString[ Tensor4WC[[i,1]] ] ];
    wcm = ToExpression[ SMEFT$MB <> ToString[ Tensor4WC[[i,1]] ] ];
    tmp = tmp /. wcw[ff1_,ff2_,ff3_,ff4_] -> Tensor4WC[[i,2]][ff1,ind1]  Tensor4WC[[i,3]][ff3,ind3] wcm[ind1,ind2,ind3,ind4] Conjugate[ Tensor4WC[[i,4]][ff2,ind2] ] Conjugate[ Tensor4WC[[i,5]][ff4,ind4] ];
  ];
];
  
tmp = tmp // FunctionExpand // Expand;
    
tmp

]
(* End of Apply4fermionRotations *) 
];



ApplyBLFlavorRotations = Function[x,
(* express BL-violating WCs in rotated basis *)
Block[{tmp,i,wcw,wcm,ind1,ind2,ind3,ind4,ff,ff1,ff2,ff3,ff4},

tmp = x // Expand // FunctionExpand;

For[i=1, i < Length[Tensor2WC] + 1, i++, 
  If[Tensor2WC[[i,5]],
    ind1 = Index[Generation,Unique[ff]];
    ind2 = Index[Generation,Unique[ff]];
    wcw = ToExpression[ SMEFT$WB <> ToString[ Tensor2WC[[i,1]] ] ];
    wcm = ToExpression[ SMEFT$MB <> ToString[ Tensor2WC[[i,1]] ] ];
    tmp = tmp /. wcw[ff1_,ff2_] -> Conjugate[ Tensor2WC[[i,2]][ff1,ind1] ] wcm[ind1,ind2] Conjugate[ Tensor2WC[[i,3]][ff2,ind2] ];
  ];
];
    
For[i=1, i < Length[Tensor4WC] + 1, i++, 
  If[Tensor4WC[[i,6]],
    ind1 = Index[Generation,Unique[ff]];
    ind2 = Index[Generation,Unique[ff]];
    ind3 = Index[Generation,Unique[ff]];
    ind4 = Index[Generation,Unique[ff]];
    wcw = ToExpression[ SMEFT$WB <> ToString[ Tensor4WC[[i,1]] ] ];
    wcm = ToExpression[ SMEFT$MB <> ToString[ Tensor4WC[[i,1]] ] ];
    tmp = tmp /. wcw[ff1_,ff2_,ff3_,ff4_] -> Conjugate[ Tensor4WC[[i,2]][ff1,ind1] ] Conjugate[ Tensor4WC[[i,3]][ff3,ind3] ] wcm[ind1,ind2,ind3,ind4] Conjugate[ Tensor4WC[[i,4]][ff2,ind2] ] Conjugate[ Tensor4WC[[i,5]][ff4,ind4] ];
  ];
];

tmp = tmp // FunctionExpand // Expand;

tmp

]
(* End of ApplyBLfermionRotations *) 
];



Tensor2WCSymmetrize = Function[{WC,cat},
(* symmetrization of 3x3 WC matrices *)
Block[{tmp},

tmp = WC;
      
If[cat == 2,(* hermitian 3x3 matrix *)
  tmp[[2,1]] = Conjugate[tmp[[1,2]]];
  tmp[[3,1]] = Conjugate[tmp[[1,3]]];
  tmp[[3,2]] = Conjugate[tmp[[2,3]]];
];

If[cat == 3,(* symmetric 3x3 matrix *)
  tmp[[2,1]] = tmp[[1,2]];
  tmp[[3,1]] = tmp[[1,3]];
  tmp[[3,2]] = tmp[[2,3]];
];

tmp
      
]
(* end of Tensor2WCSymmetrize *)
]



Tensor4WCSymmetrize = Function[{WC,cat},
(* symmetrization of 3x3x3x3 WC matrices, according to their classes
defined by cat argument, see smeft_variables.m *)
Block[{WCR,WCI,tmp},

tmp = WC;
      
If[ cat == 4 || cat == 5 || cat == 6,
      
WCR = Re[WC];
WCI = Im[WC];

If[cat == 4,(* two identical XX currents *)
(* Real part *)
  WCR[[1,1,2,1]] = WCR[[1,1,1,2]];
  WCR[[1,1,3,1]] = WCR[[1,1,1,3]];
  WCR[[1,1,3,2]] = WCR[[1,1,2,3]];
  WCR[[1,2,1,1]] = WCR[[1,1,1,2]];
  WCR[[1,3,1,1]] = WCR[[1,1,1,3]];
  WCR[[1,3,1,2]] = WCR[[1,2,1,3]];
  WCR[[1,3,2,1]] = WCR[[1,2,3,1]];
  WCR[[2,1,1,1]] = WCR[[1,1,1,2]];
  WCR[[2,1,1,2]] = WCR[[1,2,2,1]];
  WCR[[2,1,1,3]] = WCR[[1,2,3,1]];
  WCR[[2,1,2,1]] = WCR[[1,2,1,2]];
  WCR[[2,1,2,2]] = WCR[[1,2,2,2]];
  WCR[[2,1,2,3]] = WCR[[1,2,3,2]];
  WCR[[2,1,3,1]] = WCR[[1,2,1,3]];
  WCR[[2,1,3,2]] = WCR[[1,2,2,3]];
  WCR[[2,1,3,3]] = WCR[[1,2,3,3]];
  WCR[[2,2,1,1]] = WCR[[1,1,2,2]];
  WCR[[2,2,1,2]] = WCR[[1,2,2,2]];
  WCR[[2,2,1,3]] = WCR[[1,3,2,2]];
  WCR[[2,2,2,1]] = WCR[[1,2,2,2]];
  WCR[[2,2,3,1]] = WCR[[1,3,2,2]];
  WCR[[2,2,3,2]] = WCR[[2,2,2,3]];
  WCR[[2,3,1,1]] = WCR[[1,1,2,3]];
  WCR[[2,3,1,2]] = WCR[[1,2,2,3]];
  WCR[[2,3,1,3]] = WCR[[1,3,2,3]];
  WCR[[2,3,2,1]] = WCR[[1,2,3,2]];
  WCR[[2,3,2,2]] = WCR[[2,2,2,3]];
  WCR[[2,3,3,1]] = WCR[[1,3,3,2]];
  WCR[[3,1,1,1]] = WCR[[1,1,1,3]];
  WCR[[3,1,1,2]] = WCR[[1,2,3,1]];
  WCR[[3,1,1,3]] = WCR[[1,3,3,1]];
  WCR[[3,1,2,1]] = WCR[[1,2,1,3]];
  WCR[[3,1,2,2]] = WCR[[1,3,2,2]];
  WCR[[3,1,2,3]] = WCR[[1,3,3,2]];
  WCR[[3,1,3,1]] = WCR[[1,3,1,3]];
  WCR[[3,1,3,2]] = WCR[[1,3,2,3]];
  WCR[[3,1,3,3]] = WCR[[1,3,3,3]];
  WCR[[3,2,1,1]] = WCR[[1,1,2,3]];
  WCR[[3,2,1,2]] = WCR[[1,2,3,2]];
  WCR[[3,2,1,3]] = WCR[[1,3,3,2]];
  WCR[[3,2,2,1]] = WCR[[1,2,2,3]];
  WCR[[3,2,2,2]] = WCR[[2,2,2,3]];
  WCR[[3,2,2,3]] = WCR[[2,3,3,2]];
  WCR[[3,2,3,1]] = WCR[[1,3,2,3]];
  WCR[[3,2,3,2]] = WCR[[2,3,2,3]];
  WCR[[3,2,3,3]] = WCR[[2,3,3,3]];
  WCR[[3,3,1,1]] = WCR[[1,1,3,3]];
  WCR[[3,3,1,2]] = WCR[[1,2,3,3]];
  WCR[[3,3,1,3]] = WCR[[1,3,3,3]];
  WCR[[3,3,2,1]] = WCR[[1,2,3,3]];
  WCR[[3,3,2,2]] = WCR[[2,2,3,3]];
  WCR[[3,3,2,3]] = WCR[[2,3,3,3]];
  WCR[[3,3,3,1]] = WCR[[1,3,3,3]];
  WCR[[3,3,3,2]] = WCR[[2,3,3,3]];
(* Imaginary part *)
  WCI[[1,1,1,1]] = 0;
  WCI[[1,1,2,1]] = - WCI[[1,1,1,2]];
  WCI[[1,1,2,2]] = 0;
  WCI[[1,1,3,1]] = - WCI[[1,1,1,3]];
  WCI[[1,1,3,2]] = - WCI[[1,1,2,3]];
  WCI[[1,1,3,3]] = 0;
  WCI[[1,2,1,1]] = WCI[[1,1,1,2]];
  WCI[[1,2,2,1]] = 0;
  WCI[[1,3,1,1]] = WCI[[1,1,1,3]];
  WCI[[1,3,1,2]] = WCI[[1,2,1,3]];
  WCI[[1,3,2,1]] = - WCI[[1,2,3,1]];
  WCI[[1,3,3,1]] = 0;
  WCI[[2,1,1,1]] = - WCI[[1,1,1,2]];
  WCI[[2,1,1,2]] = 0;
  WCI[[2,1,1,3]] = - WCI[[1,2,3,1]];
  WCI[[2,1,2,1]] = - WCI[[1,2,1,2]];
  WCI[[2,1,2,2]] = - WCI[[1,2,2,2]];
  WCI[[2,1,2,3]] = - WCI[[1,2,3,2]];
  WCI[[2,1,3,1]] = - WCI[[1,2,1,3]];
  WCI[[2,1,3,2]] = - WCI[[1,2,2,3]];
  WCI[[2,1,3,3]] = - WCI[[1,2,3,3]];
  WCI[[2,2,1,1]] = 0;
  WCI[[2,2,1,2]] = WCI[[1,2,2,2]];
  WCI[[2,2,1,3]] = WCI[[1,3,2,2]];
  WCI[[2,2,2,1]] = - WCI[[1,2,2,2]];
  WCI[[2,2,2,2]] = 0;
  WCI[[2,2,3,1]] = - WCI[[1,3,2,2]];
  WCI[[2,2,3,2]] = - WCI[[2,2,2,3]];
  WCI[[2,2,3,3]] = 0;
  WCI[[2,3,1,1]] = WCI[[1,1,2,3]];
  WCI[[2,3,1,2]] = WCI[[1,2,2,3]];
  WCI[[2,3,1,3]] = WCI[[1,3,2,3]];
  WCI[[2,3,2,1]] = - WCI[[1,2,3,2]];
  WCI[[2,3,2,2]] = WCI[[2,2,2,3]];
  WCI[[2,3,3,1]] = - WCI[[1,3,3,2]];
  WCI[[2,3,3,2]] = 0;
  WCI[[3,1,1,1]] = - WCI[[1,1,1,3]];
  WCI[[3,1,1,2]] = WCI[[1,2,3,1]];
  WCI[[3,1,1,3]] = 0;
  WCI[[3,1,2,1]] = - WCI[[1,2,1,3]];
  WCI[[3,1,2,2]] = - WCI[[1,3,2,2]];
  WCI[[3,1,2,3]] = - WCI[[1,3,3,2]];
  WCI[[3,1,3,1]] = - WCI[[1,3,1,3]];
  WCI[[3,1,3,2]] = - WCI[[1,3,2,3]];
  WCI[[3,1,3,3]] = - WCI[[1,3,3,3]];
  WCI[[3,2,1,1]] = - WCI[[1,1,2,3]];
  WCI[[3,2,1,2]] = WCI[[1,2,3,2]];
  WCI[[3,2,1,3]] = WCI[[1,3,3,2]];
  WCI[[3,2,2,1]] = - WCI[[1,2,2,3]];
  WCI[[3,2,2,2]] = - WCI[[2,2,2,3]];
  WCI[[3,2,2,3]] = 0;
  WCI[[3,2,3,1]] = - WCI[[1,3,2,3]];
  WCI[[3,2,3,2]] = - WCI[[2,3,2,3]];
  WCI[[3,2,3,3]] = - WCI[[2,3,3,3]];
  WCI[[3,3,1,1]] = 0;
  WCI[[3,3,1,2]] = WCI[[1,2,3,3]];
  WCI[[3,3,1,3]] = WCI[[1,3,3,3]];
  WCI[[3,3,2,1]] = - WCI[[1,2,3,3]];
  WCI[[3,3,2,2]] = 0;
  WCI[[3,3,2,3]] = WCI[[2,3,3,3]];
  WCI[[3,3,3,1]] = - WCI[[1,3,3,3]];
  WCI[[3,3,3,2]] = - WCI[[2,3,3,3]];
  WCI[[3,3,3,3]] = 0;
];

If[cat == 5,(* two independent XX currents *)
(* Real part *)
  WCR[[1,1,2,1]] = WCR[[1,1,1,2]];
  WCR[[1,1,3,1]] = WCR[[1,1,1,3]];
  WCR[[1,1,3,2]] = WCR[[1,1,2,3]];
  WCR[[2,1,1,1]] = WCR[[1,2,1,1]];
  WCR[[2,1,1,2]] = WCR[[1,2,2,1]];
  WCR[[2,1,1,3]] = WCR[[1,2,3,1]];
  WCR[[2,1,2,1]] = WCR[[1,2,1,2]];
  WCR[[2,1,2,2]] = WCR[[1,2,2,2]];
  WCR[[2,1,2,3]] = WCR[[1,2,3,2]];
  WCR[[2,1,3,1]] = WCR[[1,2,1,3]];
  WCR[[2,1,3,2]] = WCR[[1,2,2,3]];
  WCR[[2,1,3,3]] = WCR[[1,2,3,3]];
  WCR[[2,2,2,1]] = WCR[[2,2,1,2]];
  WCR[[2,2,3,1]] = WCR[[2,2,1,3]];
  WCR[[2,2,3,2]] = WCR[[2,2,2,3]];
  WCR[[3,1,1,1]] = WCR[[1,3,1,1]];
  WCR[[3,1,1,2]] = WCR[[1,3,2,1]];
  WCR[[3,1,1,3]] = WCR[[1,3,3,1]];
  WCR[[3,1,2,1]] = WCR[[1,3,1,2]];
  WCR[[3,1,2,2]] = WCR[[1,3,2,2]];
  WCR[[3,1,2,3]] = WCR[[1,3,3,2]];
  WCR[[3,1,3,1]] = WCR[[1,3,1,3]];
  WCR[[3,1,3,2]] = WCR[[1,3,2,3]];
  WCR[[3,1,3,3]] = WCR[[1,3,3,3]];
  WCR[[3,2,1,1]] = WCR[[2,3,1,1]];
  WCR[[3,2,1,2]] = WCR[[2,3,2,1]];
  WCR[[3,2,1,3]] = WCR[[2,3,3,1]];
  WCR[[3,2,2,1]] = WCR[[2,3,1,2]];
  WCR[[3,2,2,2]] = WCR[[2,3,2,2]];
  WCR[[3,2,2,3]] = WCR[[2,3,3,2]];
  WCR[[3,2,3,1]] = WCR[[2,3,1,3]];
  WCR[[3,2,3,2]] = WCR[[2,3,2,3]];
  WCR[[3,2,3,3]] = WCR[[2,3,3,3]];
  WCR[[3,3,2,1]] = WCR[[3,3,1,2]];
  WCR[[3,3,3,1]] = WCR[[3,3,1,3]];
  WCR[[3,3,3,2]] = WCR[[3,3,2,3]];
(* Imaginary part *)
  WCI[[1,1,1,1]] = 0;
  WCI[[1,1,2,1]] = - WCI[[1,1,1,2]];
  WCI[[1,1,2,2]] = 0;
  WCI[[1,1,3,1]] = - WCI[[1,1,1,3]];
  WCI[[1,1,3,2]] = - WCI[[1,1,2,3]];
  WCI[[1,1,3,3]] = 0;
  WCI[[2,1,1,1]] = - WCI[[1,2,1,1]];
  WCI[[2,1,1,2]] = - WCI[[1,2,2,1]];
  WCI[[2,1,1,3]] = - WCI[[1,2,3,1]];
  WCI[[2,1,2,1]] = - WCI[[1,2,1,2]];
  WCI[[2,1,2,2]] = - WCI[[1,2,2,2]];
  WCI[[2,1,2,3]] = - WCI[[1,2,3,2]];
  WCI[[2,1,3,1]] = - WCI[[1,2,1,3]];
  WCI[[2,1,3,2]] = - WCI[[1,2,2,3]];
  WCI[[2,1,3,3]] = - WCI[[1,2,3,3]];
  WCI[[2,2,1,1]] = 0;
  WCI[[2,2,2,1]] = - WCI[[2,2,1,2]];
  WCI[[2,2,2,2]] = 0;
  WCI[[2,2,3,1]] = - WCI[[2,2,1,3]];
  WCI[[2,2,3,2]] = - WCI[[2,2,2,3]];
  WCI[[2,2,3,3]] = 0;
  WCI[[3,1,1,1]] = - WCI[[1,3,1,1]];
  WCI[[3,1,1,2]] = - WCI[[1,3,2,1]];
  WCI[[3,1,1,3]] = - WCI[[1,3,3,1]];
  WCI[[3,1,2,1]] = - WCI[[1,3,1,2]];
  WCI[[3,1,2,2]] = - WCI[[1,3,2,2]];
  WCI[[3,1,2,3]] = - WCI[[1,3,3,2]];
  WCI[[3,1,3,1]] = - WCI[[1,3,1,3]];
  WCI[[3,1,3,2]] = - WCI[[1,3,2,3]];
  WCI[[3,1,3,3]] = - WCI[[1,3,3,3]];
  WCI[[3,2,1,1]] = - WCI[[2,3,1,1]];
  WCI[[3,2,1,2]] = - WCI[[2,3,2,1]];
  WCI[[3,2,1,3]] = - WCI[[2,3,3,1]];
  WCI[[3,2,2,1]] = - WCI[[2,3,1,2]];
  WCI[[3,2,2,2]] = - WCI[[2,3,2,2]];
  WCI[[3,2,2,3]] = - WCI[[2,3,3,2]];
  WCI[[3,2,3,1]] = - WCI[[2,3,1,3]];
  WCI[[3,2,3,2]] = - WCI[[2,3,2,3]];
  WCI[[3,2,3,3]] = - WCI[[2,3,3,3]];
  WCI[[3,3,1,1]] = 0;
  WCI[[3,3,2,1]] = - WCI[[3,3,1,2]];
  WCI[[3,3,2,2]] = 0;
  WCI[[3,3,3,1]] = - WCI[[3,3,1,3]];
  WCI[[3,3,3,2]] = - WCI[[3,3,2,3]];
  WCI[[3,3,3,3]] = 0;
];

If[cat == 6,(* two identical XX currents special case Cee *)
(* Real part *)
  WCR[[1,1,2,1]] = WCR[[1,1,1,2]];
  WCR[[1,1,3,1]] = WCR[[1,1,1,3]];
  WCR[[1,1,3,2]] = WCR[[1,1,2,3]];
  WCR[[1,2,1,1]] = WCR[[1,1,1,2]];
  WCR[[1,2,2,1]] = WCR[[1,1,2,2]];
  WCR[[1,2,3,1]] = WCR[[1,1,2,3]];
  WCR[[1,3,1,1]] = WCR[[1,1,1,3]];
  WCR[[1,3,1,2]] = WCR[[1,2,1,3]];
  WCR[[1,3,2,1]] = WCR[[1,1,2,3]];
  WCR[[1,3,2,2]] = WCR[[1,2,2,3]];
  WCR[[1,3,3,1]] = WCR[[1,1,3,3]];
  WCR[[1,3,3,2]] = WCR[[1,2,3,3]];
  WCR[[2,1,1,1]] = WCR[[1,1,1,2]];
  WCR[[2,1,1,2]] = WCR[[1,1,2,2]];
  WCR[[2,1,1,3]] = WCR[[1,1,2,3]];
  WCR[[2,1,2,1]] = WCR[[1,2,1,2]];
  WCR[[2,1,2,2]] = WCR[[1,2,2,2]];
  WCR[[2,1,2,3]] = WCR[[1,2,3,2]];
  WCR[[2,1,3,1]] = WCR[[1,2,1,3]];
  WCR[[2,1,3,2]] = WCR[[1,2,2,3]];
  WCR[[2,1,3,3]] = WCR[[1,2,3,3]];
  WCR[[2,2,1,1]] = WCR[[1,1,2,2]];
  WCR[[2,2,1,2]] = WCR[[1,2,2,2]];
  WCR[[2,2,1,3]] = WCR[[1,2,2,3]];
  WCR[[2,2,2,1]] = WCR[[1,2,2,2]];
  WCR[[2,2,3,1]] = WCR[[1,2,2,3]];
  WCR[[2,2,3,2]] = WCR[[2,2,2,3]];
  WCR[[2,3,1,1]] = WCR[[1,1,2,3]];
  WCR[[2,3,1,2]] = WCR[[1,2,2,3]];
  WCR[[2,3,1,3]] = WCR[[1,3,2,3]];
  WCR[[2,3,2,1]] = WCR[[1,2,3,2]];
  WCR[[2,3,2,2]] = WCR[[2,2,2,3]];
  WCR[[2,3,3,1]] = WCR[[1,2,3,3]];
  WCR[[2,3,3,2]] = WCR[[2,2,3,3]];
  WCR[[3,1,1,1]] = WCR[[1,1,1,3]];
  WCR[[3,1,1,2]] = WCR[[1,1,2,3]];
  WCR[[3,1,1,3]] = WCR[[1,1,3,3]];
  WCR[[3,1,2,1]] = WCR[[1,2,1,3]];
  WCR[[3,1,2,2]] = WCR[[1,2,2,3]];
  WCR[[3,1,2,3]] = WCR[[1,2,3,3]];
  WCR[[3,1,3,1]] = WCR[[1,3,1,3]];
  WCR[[3,1,3,2]] = WCR[[1,3,2,3]];
  WCR[[3,1,3,3]] = WCR[[1,3,3,3]];
  WCR[[3,2,1,1]] = WCR[[1,1,2,3]];
  WCR[[3,2,1,2]] = WCR[[1,2,3,2]];
  WCR[[3,2,1,3]] = WCR[[1,2,3,3]];
  WCR[[3,2,2,1]] = WCR[[1,2,2,3]];
  WCR[[3,2,2,2]] = WCR[[2,2,2,3]];
  WCR[[3,2,2,3]] = WCR[[2,2,3,3]];
  WCR[[3,2,3,1]] = WCR[[1,3,2,3]];
  WCR[[3,2,3,2]] = WCR[[2,3,2,3]];
  WCR[[3,2,3,3]] = WCR[[2,3,3,3]];
  WCR[[3,3,1,1]] = WCR[[1,1,3,3]];
  WCR[[3,3,1,2]] = WCR[[1,2,3,3]];
  WCR[[3,3,1,3]] = WCR[[1,3,3,3]];
  WCR[[3,3,2,1]] = WCR[[1,2,3,3]];
  WCR[[3,3,2,2]] = WCR[[2,2,3,3]];
  WCR[[3,3,2,3]] = WCR[[2,3,3,3]];
  WCR[[3,3,3,1]] = WCR[[1,3,3,3]];
  WCR[[3,3,3,2]] = WCR[[2,3,3,3]];
(* Imaginary part *)
  WCI[[1,1,1,1]] = 0;
  WCI[[1,1,2,1]] = - WCI[[1,1,1,2]];
  WCI[[1,1,2,2]] = 0;
  WCI[[1,1,3,1]] = - WCI[[1,1,1,3]];
  WCI[[1,1,3,2]] = - WCI[[1,1,2,3]];
  WCI[[1,1,3,3]] = 0;
  WCI[[1,2,1,1]] = WCI[[1,1,1,2]];
  WCI[[1,2,2,1]] = 0;
  WCI[[1,2,3,1]] = - WCI[[1,1,2,3]];
  WCI[[1,3,1,1]] = WCI[[1,1,1,3]];
  WCI[[1,3,1,2]] = WCI[[1,2,1,3]];
  WCI[[1,3,2,1]] = WCI[[1,1,2,3]];
  WCI[[1,3,2,2]] = WCI[[1,2,2,3]];
  WCI[[1,3,3,1]] = 0;
  WCI[[1,3,3,2]] = WCI[[1,2,3,3]];
  WCI[[2,1,1,1]] = - WCI[[1,1,1,2]];
  WCI[[2,1,1,2]] = 0;
  WCI[[2,1,1,3]] = WCI[[1,1,2,3]];
  WCI[[2,1,2,1]] = - WCI[[1,2,1,2]];
  WCI[[2,1,2,2]] = - WCI[[1,2,2,2]];
  WCI[[2,1,2,3]] = - WCI[[1,2,3,2]];
  WCI[[2,1,3,1]] = - WCI[[1,2,1,3]];
  WCI[[2,1,3,2]] = - WCI[[1,2,2,3]];
  WCI[[2,1,3,3]] = - WCI[[1,2,3,3]];
  WCI[[2,2,1,1]] = 0;
  WCI[[2,2,1,2]] = WCI[[1,2,2,2]];
  WCI[[2,2,1,3]] = WCI[[1,2,2,3]];
  WCI[[2,2,2,1]] = - WCI[[1,2,2,2]];
  WCI[[2,2,2,2]] = 0;
  WCI[[2,2,3,1]] = - WCI[[1,2,2,3]];
  WCI[[2,2,3,2]] = - WCI[[2,2,2,3]];
  WCI[[2,2,3,3]] = 0;
  WCI[[2,3,1,1]] = WCI[[1,1,2,3]];
  WCI[[2,3,1,2]] = WCI[[1,2,2,3]];
  WCI[[2,3,1,3]] = WCI[[1,3,2,3]];
  WCI[[2,3,2,1]] = - WCI[[1,2,3,2]];
  WCI[[2,3,2,2]] = WCI[[2,2,2,3]];
  WCI[[2,3,3,1]] = - WCI[[1,2,3,3]];
  WCI[[2,3,3,2]] = 0;
  WCI[[3,1,1,1]] = - WCI[[1,1,1,3]];
  WCI[[3,1,1,2]] = - WCI[[1,1,2,3]];
  WCI[[3,1,1,3]] = 0;
  WCI[[3,1,2,1]] = - WCI[[1,2,1,3]];
  WCI[[3,1,2,2]] = - WCI[[1,2,2,3]];
  WCI[[3,1,2,3]] = - WCI[[1,2,3,3]];
  WCI[[3,1,3,1]] = - WCI[[1,3,1,3]];
  WCI[[3,1,3,2]] = - WCI[[1,3,2,3]];
  WCI[[3,1,3,3]] = - WCI[[1,3,3,3]];
  WCI[[3,2,1,1]] = - WCI[[1,1,2,3]];
  WCI[[3,2,1,2]] = WCI[[1,2,3,2]];
  WCI[[3,2,1,3]] = WCI[[1,2,3,3]];
  WCI[[3,2,2,1]] = - WCI[[1,2,2,3]];
  WCI[[3,2,2,2]] = - WCI[[2,2,2,3]];
  WCI[[3,2,2,3]] = 0;
  WCI[[3,2,3,1]] = - WCI[[1,3,2,3]];
  WCI[[3,2,3,2]] = - WCI[[2,3,2,3]];
  WCI[[3,2,3,3]] = - WCI[[2,3,3,3]];
  WCI[[3,3,1,1]] = 0;
  WCI[[3,3,1,2]] = WCI[[1,2,3,3]];
  WCI[[3,3,1,3]] = WCI[[1,3,3,3]];
  WCI[[3,3,2,1]] = - WCI[[1,2,3,3]];
  WCI[[3,3,2,2]] = 0;
  WCI[[3,3,2,3]] = WCI[[2,3,3,3]];
  WCI[[3,3,3,1]] = - WCI[[1,3,3,3]];
  WCI[[3,3,3,2]] = - WCI[[2,3,3,3]];
  WCI[[3,3,3,3]] = 0;
];

tmp = WCR + I WCI;
    
];
    
If[cat == 7,(* B- violating special case qque *)
  tmp[[2,1,1,1]] = tmp[[1,2,1,1]];
  tmp[[2,1,1,2]] = tmp[[1,2,1,2]];
  tmp[[2,1,1,3]] = tmp[[1,2,1,3]];
  tmp[[2,1,2,1]] = tmp[[1,2,2,1]];
  tmp[[2,1,2,2]] = tmp[[1,2,2,2]];
  tmp[[2,1,2,3]] = tmp[[1,2,2,3]];
  tmp[[2,1,3,1]] = tmp[[1,2,3,1]];
  tmp[[2,1,3,2]] = tmp[[1,2,3,2]];
  tmp[[2,1,3,3]] = tmp[[1,2,3,3]];
  tmp[[3,1,1,1]] = tmp[[1,3,1,1]];
  tmp[[3,1,1,2]] = tmp[[1,3,1,2]];
  tmp[[3,1,1,3]] = tmp[[1,3,1,3]];
  tmp[[3,1,2,1]] = tmp[[1,3,2,1]];
  tmp[[3,1,2,2]] = tmp[[1,3,2,2]];
  tmp[[3,1,2,3]] = tmp[[1,3,2,3]];
  tmp[[3,1,3,1]] = tmp[[1,3,3,1]];
  tmp[[3,1,3,2]] = tmp[[1,3,3,2]];
  tmp[[3,1,3,3]] = tmp[[1,3,3,3]];
  tmp[[3,2,1,1]] = tmp[[2,3,1,1]];
  tmp[[3,2,1,2]] = tmp[[2,3,1,2]];
  tmp[[3,2,1,3]] = tmp[[2,3,1,3]];
  tmp[[3,2,2,1]] = tmp[[2,3,2,1]];
  tmp[[3,2,2,2]] = tmp[[2,3,2,2]];
  tmp[[3,2,2,3]] = tmp[[2,3,2,3]];
  tmp[[3,2,3,1]] = tmp[[2,3,3,1]];
  tmp[[3,2,3,2]] = tmp[[2,3,3,2]];
  tmp[[3,2,3,3]] = tmp[[2,3,3,3]];
];

If[cat == 8,(* B- violating special case qqql *)
  tmp[[2,1,1,1]] = tmp[[1,1,2,1]];
  tmp[[2,1,1,2]] = tmp[[1,1,2,2]];
  tmp[[2,1,1,3]] = tmp[[1,1,2,3]];
  tmp[[2,2,1,1]] = tmp[[1,2,2,1]];
  tmp[[2,2,1,2]] = tmp[[1,2,2,2]];
  tmp[[2,2,1,3]] = tmp[[1,2,2,3]];
  tmp[[3,1,1,1]] = tmp[[1,1,3,1]];
  tmp[[3,1,1,2]] = tmp[[1,1,3,2]];
  tmp[[3,1,1,3]] = tmp[[1,1,3,3]];
  tmp[[3,1,2,1]] = tmp[[2,3,1,1]] + tmp[[2,1,3,1]] - tmp[[1,3,2,1]];
  tmp[[3,1,2,2]] = tmp[[2,3,1,2]] + tmp[[2,1,3,2]] - tmp[[1,3,2,2]];
  tmp[[3,1,2,3]] = tmp[[2,3,1,3]] + tmp[[2,1,3,3]] - tmp[[1,3,2,3]];
  tmp[[3,2,1,1]] = tmp[[1,3,2,1]] + tmp[[1,2,3,1]] - tmp[[2,3,1,1]];
  tmp[[3,2,1,2]] = tmp[[1,3,2,2]] + tmp[[1,2,3,2]] - tmp[[2,3,1,2]];
  tmp[[3,2,1,3]] = tmp[[1,3,2,3]] + tmp[[1,2,3,3]] - tmp[[2,3,1,3]];
  tmp[[3,2,2,1]] = tmp[[2,2,3,1]];
  tmp[[3,2,2,2]] = tmp[[2,2,3,2]];
  tmp[[3,2,2,3]] = tmp[[2,2,3,3]];
  tmp[[3,3,1,1]] = tmp[[1,3,3,1]];
  tmp[[3,3,1,2]] = tmp[[1,3,3,2]];
  tmp[[3,3,1,3]] = tmp[[1,3,3,3]];
  tmp[[3,3,2,1]] = tmp[[2,3,3,1]];
  tmp[[3,3,2,2]] = tmp[[2,3,3,2]];
  tmp[[3,3,2,3]] = tmp[[2,3,3,3]];
];

tmp

]
(* end of Tensor4WCSymmetrize *)
] 




SMEFTLoadModel = Function[{},
(* calculate SMEFT Lagrangian parts - can be time-consuming *)
Block[{i},

SMEFTLoadModelFiles[ "smeft_par_WB.fr" ];
SMEFTLoadLagrangian[];

SMEFT$LGeff = LGauge + LHiggs;
For[i=1, i < Length[GaugeBilinearOperators] + 1, i++,
  If[ MemberQ[ SMEFTOperatorList, GaugeBilinearOperators[[i]] ],
    SMEFT$LGeff = SMEFT$LGeff + Lam ToExpression["LQ"<>GaugeBilinearOperators[[i]]];
  ];
];

SMEFT$LGeff6 = 0;
For[i=1, i < Length[GaugeTripleOperators] + 1, i++,
  If[ MemberQ[ SMEFTOperatorList, GaugeTripleOperators[[i]] ],
    SMEFT$LGeff6 = SMEFT$LGeff6 + Lam ToExpression["LQ"<>GaugeTripleOperators[[i]]];
  ];
];

SMEFT$LGFmass = LFermions + LYukawa // FunctionExpand;
For[i=1, i < Length[TwoFermionMassOperators] + 1, i++,
  If[ MemberQ[ SMEFTOperatorList, TwoFermionMassOperators[[i]] ],
    SMEFT$LGFmass = SMEFT$LGFmass + Lam FunctionExpand[ ToExpression["LQ"<>TwoFermionMassOperators[[i]]] ];
  ];
];

SMEFT$LGferm = SMEFT$LGFmass;
For[i=1, i < Length[TwoFermionOperators] + 1, i++,
  If[ MemberQ[ SMEFTOperatorList, TwoFermionOperators[[i]] ],
    SMEFT$LGferm = SMEFT$LGferm + Lam FunctionExpand[ ToExpression["LQ"<>TwoFermionOperators[[i]]] ];
  ];
];

];
(* end of SMEFTGenerateInteractions *)
]


SMEFTFeynmanRules = Function[{},
(* calculate SMEFT Feynman rules, sector by sector *)

LeptonEWInteractions[];
If[ SMEFTMajoranaNeutrino,
  DeltaLTwoInteractions[];
  LeptonGaugeVertices = SymmetrizeNeutrino2Current[LeptonGaugeVertices];
  LeptonHiggsGaugeVertices = MergeVertices[DeltaLTwoVertices, LeptonHiggsGaugeVertices];
  LeptonHiggsGaugeVertices = SymmetrizeNeutrino2Current[LeptonHiggsGaugeVertices];
,
  DeltaLTwoInteractions = 0;  
];
  
QuarkEWInteractions[];
QuarkQCDInteractions[];

HiggsEWInteractions[];
HiggsQCDInteractions[];

FourFermionInteractions[];
BLViolating4FermionInteractions[];

If[SMEFTRxiGaugeStatus, GhostInteractions[] ];
(* store Feynman rules and Lagrangian in mass basis in disk file *)

SMEFTOutput[ FileNameJoin[{ SMEFT$Path, "output", "smeft_feynman_rules.m" }] ];

(* end of SMEFTFeynmanRules *)
]

