(* SmeftFR v2.00 package *)
(* latex output generator *)

(* latex output auxiliary variables *)

FieldType = {H,G0,GP,GPbar,G,Z,A,W,Wbar,l,vl,dq,uq,lbar,vlbar,dqbar,uqbar,
             ghWp,ghWm,ghZ,ghA,ghG,ghWpbar,ghWmbar,ghZbar,ghAbar,ghGbar,
             lc,dqc,uqc,lcbar,dqcbar,uqcbar};

FieldName = {"h","G0","GP","GP","g","Z","A","W","W","e","v","d","u","e","v","d","u",
             "etaP","etaM","etaZ","etaA","etaG","etabarP","etabarM","etabarZ","etabarA","etabarG",
             "ec","dqc","uqc","ec","dqc","uqc"};

FieldTex = {"h","G^0","G^+","G^-","g","Z^0","A^0","W^+","W^-",
            "e","\\nu","d","u"," e","\\nu"," d"," u",
           "\\eta^+","\\eta^-","\\eta_Z","\\eta_A","\\eta_G",
	   "\\bar\\eta^+","\\bar\\eta^-","\\bar\\eta_Z","\\bar\\eta_A","\\bar\\eta_G",
           "(e^c)","(d^c)","(u^c)","(e^c)","(d^c)","(u^c)"};

LineType =  {1,1, 2, 2,    3,4,4,7,7,   6,6,6, 6, 5,   5,   5,    5,
             8,8,8,8,8,9,9,9,9,9,
             6,6,6,5,5,5};

FieldFlavor = {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,
               0,0,0,0,0,0,0,0,0,0
               1,1,1,1,1,1};

(* auxiliary functions for generation of diagrams with latex version
of Feynman rules *)

Dim6VertexName = Function[{plist}, 
Block[{i,pos,name,res},

name = {};
For[i=1,i<Length[plist]+1,i++,
    pos = Position[ FieldType, plist[[i]][[1]] ][[1]][[1]];
    name = AppendTo[name, FieldName[[pos]]];
];
name = Sort[name];
res = "";
For[i=1,i<Length[plist]+1,i++, res = res <> ToString[ name[[i]] ]; ];

res
      
]
(* end of Dim6VertexName *)
]



FieldNameAndIndex = Function[{pos,i,DiagType},
Block[{flav,ind,is},

flav  = {0,0,0,0,3,4,4,4,4,1,1,2,2,1,1,2,2,0,0,0,0,5,0,0,0,0,5,1,2,2,1,2,2};
is = ToString[i];
      
ind = Switch[flav[[pos]],
	     0, "",
	     1, "^{f_" ~~ is ~~ "}" ~~ If[DiagType == 2, "_{s_" ~~ is ~~ "}",""],
	     2, "^{f_" ~~ is ~~ "}" ~~ Switch[ DiagType,
					       1, "_{m_" ~~ is ~~ "}",
					       2, "_{m_" ~~ is ~~ " s_" ~~ is ~~ "}",
					       _, "" ],
	     3, "^{a_" ~~ is ~~ "}_{\\mu_" ~~ is ~~ "}",
	     4, "_{\\mu_" ~~ is ~~ "}",
	     5, "^{a_" ~~ is ~~ "}"
];

"$" ~~ FieldTex[[pos]] ~~ ind ~~ "$"
        
]
(*end of FieldNameAndIndex *)
]



IsolateFactors = Function[{expr},
Block[{flist,f1,f2,i,h},

f1 = f2 = 1;
flist = FactorList[expr];
For[i=1, i < Length[flist] + 1, i++,
    If[ ! MemberQ[ Dim6NoFlavorOperators, flist[[i,1]] ] &&
	(MemberQ[ {Power, Complex, Symbol, Integer}, Head[ flist[[i,1]] ] ] ||
	 flist[[i,1]] === G1 - GW  || flist[[i,1]] === GW - G1 ||
	 flist[[i,1]] === G1 + GW), 
	f1 = f1 flist[[i,1]]^flist[[i,2]];
	,
	f2 = f2 flist[[i,1]]^flist[[i,2]];
    ];
];

{f1,f2}

]
(* end of IsolateFactors *)
]



ToLaTeXForm = Function[{expr},
Block[{sm,nsm,op,res,l1,l2,num1,num2,i,j,aaafact,AAA,BBB,a},

l1 = Length[Dim6NoFlavorOperators];
l2 = Length[Dim6FlavorOperators];

sm = expr;
For[j=1, j < l1+1, j++, sm = sm /. Dim6NoFlavorOperators[[j]] -> 0 ]; 
For[j=1, j < l2+1, j++, sm = sm /. Dim6FlavorOperators[[j]][___] -> 0 ]; 
nsm = expr - sm // Expand;
sm = Together[sm // Simplify];

res = {};
If[ sm =!= 0, 
    {num1, num2} = IsolateFactors[Numerator[sm]];
    num2 = aaafact Simplify[num2, TimeConstraint->10];
    num1 = num1/Denominator[sm] /. G1 - GW -> (G1^2 - GW^2)/(G1 + GW) /.
    GW - G1 -> - (G1^2 - GW^2)/(G1 + GW);
    res = AppendTo[ res, num1 ];
    res = AppendTo[ res, num2 ];
];

For[i=1, i < l1+1, i++,
  op = nsm;
  For[j=1, j < l1+1, j++, If[j != i, op = op /. Dim6NoFlavorOperators[[j]] -> 0] ]; 
  For[j=1, j < l2+1, j++, op = op /. Dim6FlavorOperators[[j]][___] -> 0 ]; 
  op = Together[ Simplify[op, TimeConstraint->3] ];
  If[ op =!= 0, 
      {num1, num2} = IsolateFactors[Numerator[op]];
      num2 = aaafact Simplify[num2, TimeConstraint->10];
      num1 = num1/Denominator[op] /. G1 - GW -> (G1^2 - GW^2)/(G1 + GW) /.
      GW - G1 -> - (G1^2 - GW^2)/(G1 + GW);
      res = AppendTo[ res, num1 ];
      res = AppendTo[ res, num2 ];
  ];
];

For[i=1, i < l2+1, i++,
  op = nsm;
  For[j=1, j < l1+1, j++, op = op /. Dim6NoFlavorOperators[[j]] -> 0 ]; 
  For[j=1, j < l2+1, j++, If[j != i, op = op /. Dim6FlavorOperators[[j]][___] -> 0 ] ]; 
  op = Together[ Simplify[op, TimeConstraint->3] ];
    If[ op =!= 0,
	{num1, num2} = IsolateFactors[Numerator[op]];
	num2 = aaafact Simplify[num2, TimeConstraint->10];
	num1 = num1/Denominator[op] /. G1 - GW -> (G1^2 - GW^2)/(G1 + GW) /.
	GW - G1 -> - (G1^2 - GW^2)/(G1 + GW);
	res = AppendTo[ res, num1 ];
	res = AppendTo[ res, num2 ];
    ];
];

res = res /. G1 -> BBB /. GW -> AAA /. mvdiag[a_] -> vmass[a];
For[i=1, i<Length[res]+1, i++,
    res[[i]] = ToString[ TeXForm[ res[[i]] ] ];
];

If[ sm =!= 0 && res[[2]] == "aaafact", res[[2]] = ""];
      
res

]
(* end of ToLaTexForm *)
]


ToLaTeX = Function[{expr,DiagType,verbose},
Block[{tmp,res,x,y,v,z,i,s1,s2,s3,s4,SIG,sprod,AAA,BBB},

tmp = expr /. Lam -> 1; 
tmp = tmp  /. TensDot[Ga[x_], SlashedP[y_], z_][s1_, s2_] -> 
              FV[y, x] z[s1,s2] - I SIG[x, \[Nu], z, s1, s2] FV[y, \[Nu]]  /. 
              TensDot[SlashedP[y_], Ga[x_], z_][s1_, s2_] -> 
              FV[y, x] z[s1,s2] + I SIG[x, \[Nu], z, s1, s2] FV[y, \[Nu]]  // Expand;

tmp = tmp /. TensDot[Ga[x_], Ga[y_], z_][s1_, s2_] -> ME[x, y] z[s1,s2] - I SIG[x, y, z, s1, s2] // Expand;

tmp = tmp /. SIG[Index[Lorentz, Ext[4]], Index[Lorentz, Ext[3]], x_, y_, z_] ->         
          (- SIG[Index[Lorentz, Ext[3]], Index[Lorentz, Ext[4]], x, y, z]); 
tmp = tmp /. SIG[Index[Lorentz, Ext[5]], Index[Lorentz, Ext[3]], x_, y_, z_] ->          
          (- SIG[Index[Lorentz, Ext[3]], Index[Lorentz, Ext[5]], x, y, z]); 
tmp = tmp /. SIG[Index[Lorentz, Ext[5]], Index[Lorentz, Ext[4]], x_, y_, z_] ->         
          (- SIG[Index[Lorentz, Ext[4]], Index[Lorentz, Ext[5]], x, y, z]); 

tmp = tmp /. Eps[x_, y_, v_, z_] FV[a_, y_] FV[b_, v_] FV[c_, z_] -> 
    Eps[x, y, v, z] Switch[{a > b, a > c, b > c},
	   {False, False, False} ,  FV[a, y] FV[b, v] FV[c, z],
	   {False, False, True}, -  FV[a, y] FV[b, z] FV[c, v],
	   {True, False, False}, -  FV[a, v] FV[b, y] FV[c, z],
	   {True, True, True},   -  FV[a, z] FV[b, v] FV[c, y],
	   {True, True, False},     FV[a, z] FV[b, y] FV[c, v],
	   {False, True, True},     FV[a, v] FV[b, z] FV[c, y]];

tmp = tmp /. Eps[x_, y_, v_, z_] FV[s1_, v_] FV[s2_, z_] -> 
    Eps[x, y, v, z] If[s2 > s1,  FV[s1, v] FV[s2, z], - FV[s1, z] FV[s2, v] ];

tmp = tmp /. SP[x_,y_] -> sprod[x,y];
tmp = ToLaTeXForm[tmp];

tmp = StringReplace[tmp,"Generation$\$$"->"g_"];
tmp = StringReplace[tmp,"Gluon$\$$"->"b_"];
If[DiagType == 2,
   tmp = StringReplace[tmp,"mu$\$$1"->"\\mu"];
   tmp = StringReplace[tmp,"mu$\$$2"->"\\nu"]
];
tmp = StringReplace[tmp, " ^" -> "^"];

tmp = StringReplace[tmp,"{}"->""];
tmp = StringReplace[tmp,"$"->" "];
tmp = StringReplace[tmp,"\\text"->""];
tmp = StringReplace[tmp,"{lam}"->"\\lambda"];
tmp = StringReplace[tmp,"{vev}"->"v"];
tmp = StringReplace[tmp,"{SIG}"->"SIG"];
tmp = StringReplace[tmp,"{SlashedP}"->"SlashedP"];
tmp = StringReplace[tmp,"G_1"->"{\\bar g}_1"];
tmp = StringReplace[tmp,"G_W"->"{\\bar g}_W"];
tmp = StringReplace[tmp,"G_s"->"{\\bar g}_s"];
tmp = StringReplace[tmp,"BBB"->"{\\bar g'}{}"];
tmp = StringReplace[tmp,"AAA"->"{\\bar g}"];

tmp = StringReplace[tmp,"{aaafact}"->""];
tmp = StringReplace[tmp,"{sprod}"->"sprod"];

tmp = StringReplace[tmp,"{Lambda}"->" "];
(* tmp = StringReplace[tmp,"{Lambda}"->"\\frac{1}{\\Lambda^2}"]; *)

tmp = StringReplace[tmp,"  "->" "];
tmp = StringReplace[tmp," _"->"_"];
tmp = StringReplace[tmp,"_ "->"_"];
tmp = StringReplace[tmp,"{p}"->"p"];
tmp = StringReplace[tmp,"{s}"->"s"];
tmp = StringReplace[tmp,"{m}"->"m"];
tmp = StringReplace[tmp,"{f}"->"f"];

tmp = StringReplace[tmp,"P_-" -> "P_L"];
tmp = StringReplace[tmp,"P_+" -> "P_R"];

tmp = StringReplace[tmp,"+"->" + "];
tmp = StringReplace[tmp,"-"->" - "];

tmp = StringReplace[tmp, "alpha " ~~ x_ -> "alpha_" ~~ x];
tmp = StringReplace[tmp, "beta " ~~ x_ -> "beta_" ~~ x];
tmp = StringReplace[tmp, "gamma " ~~ x_ -> "gamma_" ~~ x];

tmp = StringReplace[tmp, "{vmass}\\left(" ~~ Shortest[x__] ~~ "\\right)" -> "m_{\\nu_{" ~~ x ~~ "}}"]; 
tmp = StringReplace[tmp, "{vmass}(" ~~ Shortest[x__] ~~ ")" -> "m_{\\nu_{" ~~ x ~~ "}}"];

tmp = StringReplace[tmp, "{mldiag}\\left(" ~~ Shortest[x__] ~~ "\\right)" -> "m_{l_{" ~~ x ~~ "}}"];  
tmp = StringReplace[tmp, "{mldiag}(" ~~ Shortest[x__] ~~ ")" -> "m_{l_{" ~~ x ~~ "}}"];

tmp = StringReplace[tmp, "{mddiag}\\left(" ~~ Shortest[x__] ~~ "\\right)" -> "m_{d_{" ~~ x ~~ "}}"]; 
tmp = StringReplace[tmp, "{mddiag}(" ~~ Shortest[x__] ~~ ")" -> "m_{d_{" ~~ x ~~ "}}"];

tmp = StringReplace[tmp, "{mudiag}\\left(" ~~ Shortest[x__] ~~ "\\right)" -> "m_{u_{" ~~ x ~~ "}}"];
tmp = StringReplace[tmp, "{mudiag}(" ~~ Shortest[x__] ~~ ")" -> "m_{u_{" ~~ x ~~ "}}"];

tmp = StringReplace[tmp, "{Subsuperscript}[p," ~~ x_ ~~ "," ~~ Shortest[y__] ~~ "]" -> 
                         "p_{" ~~ x ~~ "}^{" ~~ y ~~ "}"];
tmp = StringReplace[tmp, "{Subsuperscript}\\left[p," ~~ x_ ~~ "," ~~ Shortest[y__] ~~ "\\right]" -> 
                         "p_{" ~~ x ~~ "}^{" ~~ y ~~ "}"];

tmp = StringReplace[tmp, "sprod(" ~~ Shortest[x__] ~~ "," ~~ Shortest[y__] ~~ ")" -> 
                         "p_{" ~~ x ~~ "}\\nobreak\\cdot\\nobreak{}p_{" ~~ y ~~ "}"];

tmp = StringReplace[tmp, "m_" ~~ x_ ~~ "_{" ~~ Shortest[y__] ~~ "}" -> 
                         "m_{" ~~ x ~~ "_{" ~~ y ~~ "}}"];

tmp = StringReplace[tmp, "SlashedP(" ~~ Shortest[x__] ~~ ")" -> 
                         "\\slashed{p}_{" ~~ x ~~ "}"];

If[DiagType == 2,
   tmp = StringReplace[tmp, "\\gamma^{{\\mu}}.P_" ~~ Shortest[x_] ~~ "_{s_" ~~ Shortest[s1_] ~~
		       ",s_" ~~ Shortest[s2_] ~~ "} \\gamma^{{\\mu}}.P_" ~~ Shortest[y_] ~~
		       "_{s_" ~~ Shortest[s3_] ~~ ",s_" ~~ Shortest[s4_] ~~ "}" ->
		       "(\\gamma^{{\\mu}}.P_" ~~ x ~~ ")_{s_" ~~ s1 ~~ " s_" ~~ s2 ~~
		       "} (\\gamma_{{\\mu}}.P_" ~~ y ~~ ")_{s_" ~~ s3 ~~ " s_" ~~ s4 ~~ "}"];
(* with the replacement in line below all Lorentz indices are always up... *)                       
   tmp = StringReplace[tmp, "\\gamma^{{\\mu}}.P_" ~~ Shortest[x_] ~~ "_{s_" ~~ Shortest[s1_] ~~
		       ",s_" ~~ Shortest[s2_] ~~ "}" ->
		       "(\\gamma^{{\\mu}}.P_" ~~ x ~~ ")_{s_" ~~ s1 ~~ " s_" ~~ s2 ~~ "}"];
   tmp = StringReplace[tmp, "SIG\\left({\\mu},{\\nu},P_" ~~ Shortest[x_] ~~ ",s_" ~~ Shortest[s1_] ~~
		       ",s_" ~~ Shortest[s2_] ~~ "\\right) SIG\\left({\\mu},{\\nu},P_" ~~ Shortest[y_] ~~
		       ",s_" ~~ Shortest[s3_] ~~ ",s_" ~~ Shortest[s4_] ~~ "\\right)" ->
		       "(\\sigma^{\\mu\\nu} P_" ~~ x ~~ ")_{s_" ~~ s1 ~~ " s_" ~~ s2 ~~
		       "} (\\sigma_{\\mu\\nu} P_" ~~ y ~~ ")_{s_" ~~ s3 ~~ " s_" ~~ s4 ~~ "}" ];
];

tmp = StringReplace[tmp, "{Superscript}[C," ~~ Shortest[x__] ~~ "]" ~~
                                               Shortest[y__] ~~ "^*" -> 
                                       "C^{" ~~ x ~~  "*}" ~~ y];
                         
tmp = StringReplace[tmp, "SIG\\left(" ~~ Shortest[x__] ~~ "," ~~ Shortest[y__] ~~ "," ~~
                                           Shortest[z__] ~~ "," ~~ Shortest[v__] ~~ "\\right)" ->
                         "\\sigma^{" ~~ x ~~ " " ~~ y ~~ "} " ~~ z ~~ " "];

tmp = StringReplace[tmp,"Gtilde" -> "{\\widetilde G}"];
tmp = StringReplace[tmp,"Wtilde" -> "{\\widetilde W}"];
tmp = StringReplace[tmp,"Btilde" -> "{\\widetilde B}"];

tmp = StringReplace[tmp,"{a}" -> "a"];
tmp = StringReplace[tmp,"{1}" -> "1"];
tmp = StringReplace[tmp,"{2}" -> "2"];
tmp = StringReplace[tmp,"{3}" -> "3"];
tmp = StringReplace[tmp,"{4}" -> "4"];
tmp = StringReplace[tmp,"{5}" -> "5"];
tmp = StringReplace[tmp,"{6}" -> "6"];

If [DiagType == 0,
  tmp = StringReplace[tmp,"\\delta_{m_1,m_2}" -> ""];
];
If [DiagType == 0 || DiagType == 1,
  tmp = StringReplace[tmp,"\\delta_{s_1,s_2}" -> ""];
  tmp = StringReplace[tmp,"_{s_1,s_2}" -> ""];
];

tmp = StringReplace[tmp, "P_"~~ Shortest[x_] ~~ "_{s_" ~~ Shortest[s1_] ~~ ",s_" ~~ Shortest[s2_] ~~ "}" ->
                        "(P_"~~ x ~~ ")_{s_" ~~ s1 ~~ " s_" ~~ s2 ~~ "}"];

  
tmp = StringReplace[tmp,"^{{ \\phi Box}}" -> "^{{ \\phi \\Box}}"];

tmp = StringReplace[tmp,"\\phi" -> "\\varphi"];

tmp = StringReplace[tmp,"T_{" -> "{\\cal T}_{"];

tmp = StringReplace[tmp,"."->" "];
tmp = StringReplace[tmp,","->" "];

(* set nicely formatted first sign in the line *)
res = "";
For[ i=1, i<Length[tmp], i = i+2,
     While[ StringLength[ tmp[[i]] ] > 0 && StringTake[tmp[[i]],1] == " ", tmp[[i]] = StringDrop[tmp[[i]],1] ];
     If[ StringLength[tmp[[i]]] > 0 && StringTake[tmp[[i]],1] == "-",
	 sgn = " - ";
	 tmp[[i]] = StringDrop[ tmp[[i]], 1 ];
	 ,
	 sgn = " + ";
     ];
     While[ StringLength[ tmp[[i]] ] > 0 && StringTake[tmp[[i]],1] == " ", tmp[[i]] = StringDrop[tmp[[i]],1] ];
     res = res <> sgn <> If[ tmp[[i]] != "1", tmp[[i]], "" ] <> tmp[[i+1]];     
];

If[verbose,
   Print[res];
   Print[ ];
];

res <> "\n"

]
(* end of ToLaTex *)
]




SelectFieldLine = Function[{n,x1,y1,x2,y2},
Block[{s,f,line,xs,ys,s1,c1,x3,x4,y3,y4,a1,a2,l},

s = StringJoin["(",ToString[x1],",",ToString[y1],")"];
f = StringJoin["(",ToString[x2],",",ToString[y2],")"];

xs = (x1 + x2)/2;
ys = (y1 + y2)/2;

s1 =   (x2 - x1 - y2 + y1)/Sqrt[2]/Sqrt[(x2-x1)^2 + (y2-y1)^2];
c1 = - (x2 - x1 + y2 - y1)/Sqrt[2]/Sqrt[(x2-x1)^2 + (y2-y1)^2];

x3 = N[xs + 8 c1, {Infinity, 1}];
y3 = N[ys + 8 s1, {Infinity, 1}];
x4 = N[xs - 8 s1, {Infinity, 1}];
y4 = N[ys + 8 c1, {Infinity, 1}];
xs = N[xs, {Infinity, 1}];
ys = N[ys, {Infinity, 1}];

If[Abs[x3]<0.5, x3=0];
If[Abs[y3]<0.5, y3=0];
If[Abs[x4]<0.5, x4=0];
If[Abs[y4]<0.5, y4=0];
If[Abs[xs]<0.5, xs=0];
If[Abs[ys]<0.5, ys=0];

a1 = StringJoin["(",ToString[xs],",",ToString[ys],")(",ToString[x3],",",ToString[y3],")"];
a2 = StringJoin["(",ToString[xs],",",ToString[ys],")(",ToString[x4],",",ToString[y4],")"];

Switch[n,
  1, StringJoin["\\DashLine",s,f,"{3}\n"],
  2, StringJoin["\\DashArrowLine",s,f,"{3}\n"],
  3, StringJoin["\\Gluon",s,f,"{3}{4}\n"],
  4, StringJoin["\\Photon",s,f,"{3}{4}\n"],
  5, StringJoin["\\ArrowLine",f,s,"\n"],
  6, StringJoin["\\ArrowLine",s,f,"\n"],
  7, StringJoin["\\Photon",s,f,"{3}{4}\n\\Line",a1,"\n\\Line",a2,"\n"],
  8, StringJoin["\\ZigZag",s,f,"{3}{4}\n"],
  9, StringJoin["\\ZigZag",s,f,"{3}{4}\n"]
]

]
(* end of SelectFieldLine *)
]



DrawDiagram = Function[{cfile,np,frule,DiagType,verbose,vname},
Block[{i,x1,x2,y1,y2,tp,pos,vpos,ysize,yshift,vfile},

x1 = {{5, 40, 75},
      {5, 40, 75, 40},
      {5, 20, 60, 75, 40},
      {5, 20, 60, 75, 20, 60}};

y1 = {{0,  50,  0},
      {50, 100, 50, 0},
      {50, 95,  95, 50, 0},
      {50, 95,  95, 50, 5, 5}};

x2 = {{40, 40, 40},
      {40, 40, 40, 40},
      {40, 40, 40, 40, 40},
      {40, 40, 40, 40, 40, 40}};

y2 = {{0, 0, 0},
      {50, 50, 50, 50},
      {50, 50, 50, 50, 50},
      {50, 50, 50, 50, 50, 50}};

tp = {{"(0,0)[r]", "(45,45)[l]","(80,0)[l]"},
      {"(0,50)[r]","(45,95)[l]","(80,50)[l]","(45,5)[l]"},
      {"(0,50)[r]","(15,90)[r]","(65,90)[l]","(80,50)[l]","(45,5)[l]"},
      {"(0,50)[r]","(15,90)[r]","(65,90)[l]","(80,50)[l]","(15,10)[r]","(65,10)[l]"}};

ysize = {"55)","100)","100)","100)"};
yshift = {"(0,15)\n","(0,50)\n","(0,50)\n","(0,50)\n"};
vpos =  {0,50,50,50};

WriteString[cfile, "\\noindent \\begin{tabular}{cp{1mm}l}\n"];
WriteString[cfile, "\\begin{picture}(90,"~~ysize[[np-2]]~~yshift[[np-2]] ];

For[i=1,i<np+1,i++,
    pos = Position[ FieldType, frule[[1]][[i]][[1]] ][[1]][[1]];
    WriteString[cfile, SelectFieldLine[LineType[[pos]],x1[[np-2,i]],y1[[np-2,i]],x2[[np-2,i]],y2[[np-2,i]]] ];
    WriteString[cfile, "\\Text"~~tp[[np-2,i]]~~"{"~~FieldNameAndIndex[pos,i,DiagType]~~"}\n"];
];  

WriteString[cfile, "\\Vertex(40,"~~ToString[ vpos[[np-2]] ]~~"){2}\n"];
WriteString[cfile, "\\end{picture}\n"];
WriteString[cfile, "&&\n"];
WriteString[cfile, "\\begin{minipage}[c]{0.8\\linewidth}\n"];
WriteString[cfile, "\\input vertices/"~~vname[[1]]~~"/"~~vname[[2]]~~".tex\n" ];
WriteString[cfile, "\\end{minipage}\n"];
WriteString[cfile, "\\end{tabular}\n\n"];
WriteString[cfile, "\\bigskip\n\n"];

vfile = OpenWrite[ FileNameJoin[{SMEFT$Path, "output", "latex",
"vertices", vname[[1]], vname[[2]]<>".tex"}] ];

WriteString[vfile, "%\n\\begin{dmath*}\n%\n"];
WriteString[vfile, ToLaTeX[frule[[2]], DiagType, verbose ] ];
WriteString[vfile, "%\n\\end{dmath*}\n%\n"];
Close[vfile];
      

];
(* end of DrawDiagram *)
];



DrawSector = Function[{frset,verbose,DiagType,DiagClass},
(* draws diagrams for chosen sector of Lagrangian *)		      
Block[{i,j,vlist,vtype,vcount,vname},

vlist = {};
vcount = 0;
      
For[j=3,j<7,j++,
    For[i=1,i < Length[frset]+1,i++,
	vtype = Dim6VertexName[ frset[[i]][[1]] ];
	If[ ! MemberQ[vlist, vtype] && Length[frset[[i]][[1]]] == j,
	    If[ verbose, Print[vtype] ];
            vname = FileNameJoin[{SMEFT$Path, "output", "latex", "vertices", DiagClass}];
            If [ ! DirectoryQ[vname],  CreateDirectory[vname] ];
            vname = {DiagClass, vtype};
	    WriteString[cfile, "%Vertex " <> vtype <> "\n"];
	    DrawDiagram[cfile,j,frset[[i]], DiagType, verbose, vname ];
	    vlist = AppendTo[vlist, vtype];
	    vcount = vcount + 1;
	];
    ];
];

vcount    
      
]
(* end of DrawSector *)
]




SMEFTToLatex[ OptionsPattern[{ FullDocument -> True, ScreenOutput -> False }] ] :=
(* master routine of latex generation code *)
Block[{i, j, frules, Dim6NoFlavorOperators, Dim6FlavorOperators,
cfile, VertCount, vlist, nlist, olist},

vlist = {"LeptonGaugeVertices", "LeptonHiggsGaugeVertices",
"QuarkGaugeVertices", "QuarkHiggsGaugeVertices", "QuarkGluonVertices",
"GaugeSelfVertices", "GaugeHiggsVertices", "GluonSelfVertices",
"GluonHiggsVertices", "FourLeptonVertices",
"TwoQuarkTwoLeptonVertices", "FourQuarkVertices",
"BLViolatingVertices"};

nlist = {"Lepton--gauge", "Lepton--Higgs--gauge", 
"Quark--gauge", "Quark--Higgs--gauge", "Quark-gluon", 
"Gauge self interaction", "Higgs--gauge", "Gluon self interaction", 
"Higgs--gluon", "Four lepton", 
"Two quark--two lepton", "Four quark", 
"Baryon and lepton number violating four fermion"};

olist = {0,0,0,0,1,0,0,1,1,2,2,2,2};

Dim6NoFlavorOperators = Intersection[ Join[ GaugeBilinearOperators,
    GaugeTripleOperators ], SMEFTOperatorList ];
For[i = 1, i < Length[Dim6NoFlavorOperators] + 1, i++, 
  Dim6NoFlavorOperators[[i]] = ToExpression[ SMEFT$MB <> Dim6NoFlavorOperators[[i]] ];
];

Dim6FlavorOperators = Intersection[ Join[ TwoFermionMassOperators,
    TwoFermionOperators, FourFermionOperators, BLViolatingOperators ],
    SMEFTOperatorList ];
For[i = 1, i < Length[Dim6FlavorOperators] + 1, i++, 
  Dim6FlavorOperators[[i]] = ToExpression[ SMEFT$MB <> Dim6FlavorOperators[[i]] ];
];
  
Print[ Style["Generating Latex file with Feynman rules...", Bold] ];
VertCount = 0;

(* open file and create header *)
cfile = OpenWrite[ FileNameJoin[{SMEFT$Path, "output", "latex", "smeft_feynman_rules.tex"}] ];

Print["Latex form of Feynman rules will be stored in file ", 
  Style[ FileNameJoin[{SMEFT$Path, "output", "latex", "smeft_feynman_rules.tex"}], Bold]];
Print["Compilation requires breqn.sty and axodraw.sty styles (included)."];
Print["Automatic line breaking of math formulae may not be perfect!"];

WriteString[cfile, "%Automatically generated Feynman rules file for SMEFT\n\n"];
If[OptionValue[FullDocument],
   WriteString[cfile, "\\documentclass[11pt]{article}\n"];
   WriteString[cfile, "\\usepackage{axodraw}\n"];
   WriteString[cfile, "\\usepackage{amsmath, amssymb}\n"];
   WriteString[cfile, "\\usepackage{slashed}\n"];
   WriteString[cfile, "\\usepackage{breqn}\n"];
   WriteString[cfile, "\\setkeys{breqn}{breakdepth={3}}\n"];
   
   WriteString[cfile, "\\textwidth = 16cm\n\n"];
   WriteString[cfile, "\\textheight = 24cm\n\n"];
   WriteString[cfile, "\\topmargin=-2cm\n"];
   WriteString[cfile, "\\oddsidemargin=0cm\n"];
   WriteString[cfile, "\\evensidemargin=\\oddsidemargin\n"];

   WriteString[cfile, "\\def\\text#1{#1}\n\n"];
   WriteString[cfile, "\\begin{document}\n\n"];

   WriteString[cfile, "\\appendix\n\n"];

   WriteString[cfile, "\\bigskip\n\\bigskip\n\\bigskip\n"];
   WriteString[cfile, "\\section{SMEFT interaction vertices}\n\n"];
];

For[i=1, i < Length[vlist] + 1, i++, 
  WriteString[cfile, "\\bigskip\n\\bigskip\n\\bigskip\n"];
  WriteString[cfile, "\\subsection{" <> nlist[[i]] <> " vertices}\n\n"];
  frules = ToExpression[ vlist[[i]] ];
  If[ vlist[[i]] == "GluonSelfVertices",  (* skip 5- and 6-gluon vertex *)
    For[j=1, j < Length[frules] + 1, j++,
      If[ Length[ frules[[j,1]] ] > 4 , frules[[j,2]] = LongExpressionNotDisplayed ];
    ];
  ];
  VertCount = VertCount + DrawSector[frules,OptionValue[ScreenOutput],olist[[i]],vlist[[i]]];
];
  
If[SMEFTRxiGaugeStatus,
   WriteString[cfile, "\\bigskip\n\\bigskip\n\\bigskip\n"];
   WriteString[cfile, "\\subsection{Ghost vertices}\n\n"];
   VertCount = VertCount + DrawSector[GhostVertices,OptionValue[ScreenOutput],0,"GhostVertices"];
];
   
If[OptionValue[FullDocument],
   WriteString[cfile, "\\end{document}\n"];
];

Close[ FileNameJoin[{SMEFT$Path, "output", "latex", "smeft_feynman_rules.tex"}] ];

Print["Latex output ready, total number of vertices drawn = ", VertCount];

]
(* end of SMEFTLatexGenerator *)
