(* SmeftFR v2.00 package *)
(* Contains definitions of SMEFT parameters in mass basis *)

(* ********************************** *)
(* ***** Parameters (SM + dim6) ***** *)
(* ********************************** *)
 
M$Parameters = {
  
(* parametrization of EW numerical input; if necessary update values
of SMEFT$... variables in the file smeft_variables.m *)

  aEWM1 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aeWM1,
    InteractionOrder -> {QED,-2},  
    TeX              -> Superscript[Subscript[\[Alpha],em],-1],
    Description      -> "1/alpha_em at MZ scale"
  },
  aEW == { 
    ParameterType    -> Internal, 
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},  
    TeX              -> Subscript[\[Alpha],em],
    Description      -> "alpha_em at MZ scale"
  },
  ee == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi/SMEFT$aeWM1],
    InteractionOrder -> {QED,1},  
    TeX              -> e, 
    Description      -> "Electric charge e at MZ scale"
  },
  Gf == { 
    ParameterType    -> External, 
    Value            -> SMEFT$Gf,
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,f], 
    Description      -> "Fermi constant"
  },
  sw2 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$sw2, 
    TeX              -> Superscript[Subscript[s,W],2], 
    Description      -> "s_W^2"
  },
  sw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[SMEFT$sw2], 
    TeX              -> Subscript[s,W], 
    Description      -> "s_W"
  },
  cw2 == { 
    ParameterType    -> External, 
    Value            -> 1 - SMEFT$sw2, 
    TeX              -> Superscript[Subscript[c,W],2], 
    Description      -> "c_W^2"
  },
  cw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[1 - SMEFT$sw2], 
    TeX              -> Subscript[c,W], 
    Description      -> "c_W"
  },
  aS == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aS,
    InteractionOrder -> {QCD,2},  
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "alpha_s at MZ scale"
  },

(* effective gauge coupling constants *)
  G1 == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf SMEFT$sw2/(1 - SMEFT$sw2)], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,1], 
    Description      -> "Effective U(1)Y coupling constant"
  },
  GW == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,W], 
    Description      -> "Effective SU(2) coupling constant"
  },
  GS == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi SMEFT$aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[G,s], 
    Description      -> "Effective SU(3) coupling constant at the Z pole"
  },

(* Higgs vev and quartic coupling *)
  vev == {
    ParameterType    -> External,
    Value            -> 1/Sqrt[Sqrt[2] SMEFT$Gf], 
    TeX              -> v,
    Description      -> "Higgs vacuum expectation value"
  },
  lam == {
    ParameterType    -> External,
    Value            -> Sqrt[2] SMEFT$MH^2 SMEFT$Gf, 
    InteractionOrder -> {QED, 1},
    TeX              -> \[Lambda],
    Description      -> "Higgs quartic coupling"
  },

  
(* auxiliary parameter giving QED Interaction Order = 1 for Yukawa couplings *)
  YO == { 
    ParameterType    -> External, 
    Value            -> 1, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[Y,O], 
    Description      -> "Interaction order for Yukawa/fermion masses"
  },

(* gauge fixing parameters *)

xiW == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],W], 
    Description   -> "W gauge fixing parameter"
  },

xiZ == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],Z], 
    Description   -> "Z gauge fixing parameter"
  },

xiA == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A], 
    Description   -> "Photon gauge fixing parameter"
  },

xiG == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G], 
    Description   -> "Gluon gauge fixing parameter"
  },

  (* unphysical field mass *)
  
  MgZ == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]Z],
    Description      -> "Z ghost mass"
  },

  MgW == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]W],
    Description      -> "W ghost mass"
  },

  MG0 == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,G0],
    Description      -> "G0 mass"
  },

  MGP == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,GP],
    Description      -> "G+ and G- mass"
  },
  
(* physical flavor mixing *)

(* CKM matrix K = VUL^+ VDL + dim 6 corrections. Here we use pure
Wolfenstein, no dim-6 additions. Parameters are defined at the top of
smeft_variables.m, edit them there if necessary *)

K == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {K[1,1] -> CKM$mat[[1,1]],
            K[1,2] -> CKM$mat[[1,2]], 
            K[1,3] -> CKM$mat[[1,3]],
            K[2,1] -> CKM$mat[[2,1]],
            K[2,2] -> CKM$mat[[2,2]],
            K[2,3] -> CKM$mat[[2,3]],
            K[3,1] -> CKM$mat[[3,1]],
            K[3,2] -> CKM$mat[[3,2]],
            K[3,3] -> CKM$mat[[3,3]]},
Unitary -> False,
ComplexParameter -> True,
Description -> "CKM Matrix"
},

(* PMNS matrix U = VLL^+ VVL + dim 6 corrections.  Here no dim-6
additions. Angles and phases are defined at the top of
smeft_variables.m, edit them there if necessary *)

U == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {U[1,1] -> PMNS$mat[[1,1]],
            U[1,2] -> PMNS$mat[[1,2]], 
            U[1,3] -> PMNS$mat[[1,3]], 
            U[2,1] -> PMNS$mat[[2,1]], 
            U[2,2] -> PMNS$mat[[2,2]], 
            U[2,3] -> PMNS$mat[[2,3]], 
            U[3,1] -> PMNS$mat[[3,1]], 
            U[3,2] -> PMNS$mat[[3,2]], 
            U[3,3] -> PMNS$mat[[3,3]]},
Unitary -> False,
ComplexParameter -> True,
Description -> "PMNS Matrix"
},
