(* SmeftFR v2.00 package *)
(* Contains definitions of SMEFT parameters in Warsaw basis *)

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* INTERNAL PARAMETERS *)

(* field and gauge normalization factors *)

(* Physical Higgs H *)
Hnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Physical Higgs normalization"
},

(* Neutral Goldstone G0 *)
G0norm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Neutral Goldstone normalization"
},

(* Charged Goldstone GP *)
GPnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Neutral Goldstone normalization"
},

(* Physical Z and photon *)
AZnorm == {
ParameterType -> Internal,
Indices -> {SU2W,SU2W},
ComplexParameter -> False,
Description -> "Physical Z and photon mixing matrix"
},

(* Physical W *)
Wnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "W normalization"
},

(* Physical gluon *)
Gnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "Gluon normalization"
},

(* g1 normalization *)
g1norm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "g1 coupling normalization"
},

(* gw normalization *)
gwnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "gw coupling normalization"
},

(* gs normalization *)
gsnorm == {
ParameterType -> Internal,
Indices -> {},
ComplexParameter -> False,
Description -> "gs coupling normalization"
},

(* initial SM couplings before redefinitions *)
    
gw == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  Definitions      -> {gw :> gwnorm GW},
  TeX              -> Subscript[g,W], 
  Description      -> "Weak SU(2) coupling constant"
},

g1 == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  Definitions      -> {g1 :> g1norm G1},
  TeX              -> Subscript[g,1], 
  Description      -> "U(1)Y coupling constant"
},

gs == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QCD,1},  
  Definitions      -> {gs :> gsnorm GS},
  TeX              -> Subscript[g,s], 
  Description      -> "Strong sU(3) coupling constant"
},

(* effective gauge coupling constants *)

G1 == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  TeX              -> Subscript[G,1], 
  Description      -> "Effective U(1)Y coupling constant"
},

GW == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QED,1},  
  TeX              -> Subscript[G,W], 
  Description      -> "Effective SU(2) coupling constant"
},

GS == { 
  ParameterType    -> Internal, 
  InteractionOrder -> {QCD,1},  
  TeX              -> Subscript[G,s], 
  Description      -> "Effective SU(3) coupling constant at the Z pole"
},

(* Higgs parameters *)
  
vev == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,-1},
  Description      -> "Higgs vacuum expectation value"
},

lam == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED, 1},
  TeX           -> \[Lambda],
  Description      -> "Higgs quartic coupling"
},

muH == {
  ParameterType -> Internal,
TeX           -> \[Mu],
Description   -> "Coefficient of the quadratic piece of the Higgs potential"
},

(* particle masses *)
    
MW == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,W], 
  Description   -> "W mass"
},

MZ == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,Z], 
  Description   -> "Z mass"
},

MH == { 
  ParameterType -> Internal, 
  TeX           -> Subscript[M,H], 
  Description   -> "H mass"
},

(* fermion masses *)

fml == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fml[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, l],
  Description      -> "Lepton tree level pole masses"
},

fmu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, u],
  Description      -> "Up-type quark masses"
},

fmd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, d],
  Description      -> "Down-type quark masses"
},

mvdiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, \[Nu]],
    Description      -> "Neutrino masses"
},

mldiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, l],
    Description      -> "Lepton tree level pole masses"
},

mudiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, u],
    Description      -> "Up quark masses"
},

mddiag == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation]},
    ComplexParameter -> False,
    AllowSummation -> True,
    TeX              -> Subscript[m, d],
    Description      -> "Down quark masses"
},

(* Yukawa couplings *)  

yl == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, l],
  Description      -> "Lepton Yukawa coupling"
},

yu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, u],
  Description      -> "Up-type Yukawa coupling"
},

yd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, d],
  Description      -> "Down-type Yukawa coupling"
},

(* fermion fields rotations from Warsaw to mass basis *)

VVL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left neutrino mixing matrix"
},

VLL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left lepton mixing matrix"
},

VLR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right lepton mixing matrix"
},

VUL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left up quark mixing matrix"
},

VUR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right up quark mixing matrix"
},

VDL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left down quark mixing matrix"
},

VDR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right down quark mixing matrix"
},


(* physical flavor mixing *)

(* CKM matrix K =  VUL^+ VDL + corrections *)
K == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "CKM Matrix"
},

(* PMNS matrix U = VLL^+ VVL + corrections *)
U == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "PMNS Matrix"
},

(* gauge fixing parameters *)

xiW == { 
    ParameterType -> Internal, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],W], 
    Description   -> "W gauge fixing parameter"
  },

xiZ == { 
    ParameterType -> Internal, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],Z], 
    Description   -> "Z gauge fixing parameter"
  },

xiA == { 
    ParameterType -> Internal, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A], 
    Description   -> "A gauge fixing parameter"
  },

xiG == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G], 
    Description   -> "Gluon gauge fixing parameter"
  },
