(* SMEFT Feynman rules package *)
(* exporting interfaces - run smeft_fr_init.m prior to this code! *)

Remove["Global`*"];
(* Off[General::stop]; *)

(* FeynRules and SmeftFR package installation paths - edit if necessary *)
$FeynRulesPath = FileNameJoin[{"/home","rosiek","FeynRules"}];
SMEFT$MajorVersion      = "2";
SMEFT$MinorVersion      = "00";
SMEFT$Path              = FileNameJoin[{$FeynRulesPath, "Models", "SMEFT_" <> 
                          SMEFT$MajorVersion <> "_" <> SMEFT$MinorVersion}];
If[ ! DirectoryQ[SMEFT$Path], 
  Print["Directory " <> SMEFT$Path <> "does not exist, please check package setup"];
  Abort[];
];

(* Load FeynRules and SMEFT packages *)
Get[ FileNameJoin[{$FeynRulesPath,"FeynRules.m"}] ];
Get[ FileNameJoin[{ SMEFT$Path, "code", "smeft_package.m"}] ];

(* initialize time counter *)     
CPUTime = TimeUsed[];

(* initialize mass basis model files and Lagrangian *)
SMEFTInitializeMB[ RealParameters->True, Include4Fermion->True ];
Print["\nMass basis Lagrangian loaded, time = ", TimeUsed[] - CPUTime,"\n"];

SMEFTToWCXF[ FileNameJoin[ { SMEFT$Path, "output", "smeft_par_MB.fr" } ],
             FileNameJoin[ { SMEFT$Path, "output", "smeft_wcxf_MB.json" } ] ];
Print["\nParameters dumped to WCXF file, time = ", TimeUsed[] - CPUTime];

SMEFTToLatex[];
Print["\nLatex output generated, time = ", TimeUsed[] - CPUTime];

WriteUFO[ SMEFTMBLagrangian, Output -> FileNameJoin[{SMEFT$Path,
  "output", "UFO"}], AddDecays -> False ];
Print["\nVertices stored in UFO format in directory", 
       Style[FileNameJoin[{SMEFT$Path, "output", "UFO"}] ,Bold] ];
Print["\nUFO output generated, time = ", TimeUsed[] - CPUTime,"\n"];

WriteFeynArtsOutput[ SMEFTMBLagrangian, Output -> FileNameJoin[{SMEFT$Path,
  "output", "FeynArts", "FeynArts"}] ];
Print["\nVertices stored in FeynArts format in directory", 
       Style[FileNameJoin[{SMEFT$Path, "output", "FeynArts"}] ,Bold] ];

Print["\nTotal CPU time = ", TimeUsed[] - CPUTime];



