(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13602,        348]
NotebookOptionsPosition[     11286,        302]
NotebookOutlinePosition[     11700,        318]
CellTagsIndexPosition[     11657,        315]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "SmeftFR  v2.01\n ",
 StyleBox["Feynman rule generator in SMEFT",
  FontSize->36],
 " \n",
 StyleBox["Interfaces - Latex, UFO, FeynArts and WCxf formats\n", "Section",
  FontColor->GrayLevel[0]],
 StyleBox["SmeftFR-init.nb should be executed prior to this code!", 
  "Subsection",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}], "Title",
 CellChangeTimes->{{3.4126590568924417`*^9, 3.412659075768538*^9}, {
  3.423416384793591*^9, 3.423416395796236*^9}, {3.4234174151520243`*^9, 
  3.423417420076274*^9}, {3.760600931373452*^9, 3.760600938564866*^9}, {
  3.760600980116218*^9, 3.7606010342731333`*^9}, {3.760601110546075*^9, 
  3.7606011157457647`*^9}, {3.760965916750543*^9, 3.7609659226892*^9}, {
  3.760969333036388*^9, 3.760969456832159*^9}, {3.76096949468789*^9, 
  3.760969497616509*^9}, {3.760969597787758*^9, 3.7609696028087606`*^9}, {
  3.762706903793747*^9, 3.762706914691828*^9}, {3.7627070983484364`*^9, 
  3.7627071199679213`*^9}, {3.762707162573914*^9, 3.762707184384281*^9}, {
  3.776590046742124*^9, 3.776590046861511*^9}},
 TextAlignment->Center,ExpressionUUID->"68b8f4ae-1b50-45fc-8fb7-0768ce1acaea"],

Cell[CellGroupData[{

Cell["Set proper paths and load package", "Section",
 CellChangeTimes->{{3.760969789646365*^9, 3.760969816962785*^9}, {
   3.760969884414713*^9, 3.760969885436679*^9}, 3.760969946661951*^9, {
   3.762707261100027*^9, 
   3.762707270825543*^9}},ExpressionUUID->"d8e28858-48c3-45e1-85e5-\
ba933fc1c3a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "FeynRules", " ", "and", " ", "SmeftFR", " ", "package", " ", 
     "installation", " ", "paths"}], "-", 
    RowBox[{"edit", " ", "if", " ", "necessary"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\</home\>\"", ",", "\"\<rosiek\>\"", ",", "\"\<FeynRules\>\""}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SMEFT$MajorVersion", "=", "\"\<2\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SMEFT$MinorVersion", "=", "\"\<01\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SMEFT$Path", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"$FeynRulesPath", ",", "\"\<Models\>\"", ",", 
      RowBox[{
      "\"\<SMEFT_\>\"", "<>", "SMEFT$MajorVersion", "<>", "\"\<_\>\"", "<>", 
       "SMEFT$MinorVersion"}]}], "}"}], "]"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.4126590568924417`*^9, 3.412659075768538*^9}, {
   3.423416384793591*^9, 3.423416395796236*^9}, {3.4234174151520243`*^9, 
   3.423417420076274*^9}, {3.760600931373452*^9, 3.760600938564866*^9}, {
   3.760600980116218*^9, 3.7606010342731333`*^9}, {3.760601110546075*^9, 
   3.7606011157457647`*^9}, {3.760965916750543*^9, 3.7609659226892*^9}, {
   3.760969333036388*^9, 3.760969352713992*^9}, {3.762707281334773*^9, 
   3.7627073105310173`*^9}, 3.762708923188611*^9, {3.762709180307948*^9, 
   3.762709190912554*^9}, {3.7765900540806026`*^9, 
   3.7765900542027483`*^9}},ExpressionUUID->"eec34924-11ca-48a1-b401-\
77b9b8b2dc0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Load", " ", "FeynRules", " ", "and", " ", "SMEFT", " ", "packages"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"$FeynRulesPath", ",", "\"\<FeynRules.m\>\""}], "}"}], "]"}], 
     "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "SMEFT$Path", ",", "\"\<code\>\"", ",", "\"\<smeft_package.m\>\""}], 
       "}"}], "]"}], "]"}], ";"}], "\n"}]}]], "Input",
 CellChangeTimes->{{3.760601085197588*^9, 3.760601106029333*^9}, 
   3.762707299234066*^9},ExpressionUUID->"665e8197-75cc-4cc9-9080-\
ac98cfaa0526"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reload mass basis Lagrangian, initialize model", "Section",
 CellChangeTimes->{{3.412621711134922*^9, 3.412621715160161*^9}, {
   3.760972321445037*^9, 3.760972327069193*^9}, 3.762707249295392*^9, {
   3.762707389702379*^9, 
   3.762707422269435*^9}},ExpressionUUID->"f9cfb12d-ae19-49de-8c08-\
984ac8e4a487"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTInitializeMB", "[", 
   RowBox[{
    RowBox[{"RealParameters", "\[Rule]", "True"}], ",", 
    RowBox[{"Include4Fermion", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760972627004978*^9, 3.760972634631793*^9}, {
   3.760972666176269*^9, 3.760972727824284*^9}, 3.760972844423047*^9, 
   3.7627074309709663`*^9},ExpressionUUID->"bafc84c2-d2f0-4308-8f4f-\
a78bf81b00f5"],

Cell[TextData[{
 "After call to ",
 StyleBox["SMEFTInitializeMB",
  FontColor->RGBColor[0, 0, 1]],
 ", the mass basis model files are read in and the mass basis Lagrangian is \
stored in a global variable  ",
 StyleBox["SMEFTMBLagrangian",
  FontColor->RGBColor[1, 0.5, 0]],
 " for further use by interface routines. "
}], "Text",
 CellChangeTimes->{{3.760972759432354*^9, 3.760972790877749*^9}, {
   3.760972821941867*^9, 3.7609728408537483`*^9}, {3.760973081141934*^9, 
   3.760973112813623*^9}, {3.762707442313759*^9, 3.7627074593100023`*^9}, 
   3.762707505483914*^9},ExpressionUUID->"6a88774d-237d-4448-89fa-\
73adbaf090af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WCxf input and output", "Section",
 CellChangeTimes->{{3.760979059207157*^9, 3.760979078821291*^9}, {
  3.762708393646049*^9, 
  3.7627084038739653`*^9}},ExpressionUUID->"d80012ba-c011-43d3-be49-\
5239e1f4a423"],

Cell["\<\
Exporting numerical values of Wilson coefficients in the WCxf format is \
performed by the function:\
\>", "Text",
 CellChangeTimes->{{3.760973239573413*^9, 
  3.760973286174428*^9}},ExpressionUUID->"85a281df-0478-4203-81e0-\
a27c0da6a0f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTToWCXF", "[", 
   RowBox[{
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "SMEFT$Path", ",", "\"\<output\>\"", ",", "\"\<smeft_par_MB.fr\>\""}], 
      "}"}], "]"}], ",", " ", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "SMEFT$Path", ",", "\"\<output\>\"", ",", 
       "\"\<smeft_wcxf_MB.json\>\""}], "}"}], "]"}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.760973000950308*^9, 3.7609730693592367`*^9}, {
  3.7632021140746317`*^9, 3.763202123963759*^9}, {3.763399179175972*^9, 
  3.7633991821287537`*^9}},ExpressionUUID->"6fe2c640-23be-42c2-acad-\
b47fa501c2a1"],

Cell["\<\
The created file can be used to transfer numerical values of Wilson \
coefficients to other codes supporting WCxf format. Conversely,  files in \
WCxf format can be translated to FeynRules parameter files using routine \
WCXFToSMEFT[\[OpenCurlyDoubleQuote]wcxf_file.json\[CloseCurlyDoubleQuote],\
\[CloseCurlyDoubleQuote]smeft_file.fr\[CloseCurlyDoubleQuote]] - see manual \
for more details and available options. \
\>", "Text",
 CellChangeTimes->{{3.7609733274470987`*^9, 3.760973331789826*^9}, {
  3.760973489597457*^9, 3.760973536923071*^9}, {3.760973664852585*^9, 
  3.760973692226741*^9}, {3.762707536842198*^9, 3.762707536919984*^9}, {
  3.7627076272896833`*^9, 3.76270767420958*^9}, {3.762707756283785*^9, 
  3.76270776087564*^9}},ExpressionUUID->"7788d64f-fa91-40b0-a5bf-\
705e767276d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Latex  output", "Section",
 CellChangeTimes->{{3.7609737527084103`*^9, 3.760973780074239*^9}, {
  3.760973816435884*^9, 
  3.760973818585753*^9}},ExpressionUUID->"dfbd88f0-2a19-48e8-989c-\
8bf42c78e17b"],

Cell[TextData[{
 "SmeftFR can create a Latex file with the Feynman rules drawn with \
\[OpenCurlyDoubleQuote]axodraw.sty\[CloseCurlyDoubleQuote]. They are divided \
in sections  according to the pieces of the Lagrangian we displayed above. \
The tex file is output/smeft_feynman_rules.tex. To compile it, one needs to \
produce intermediate Postsciprt file:\n",
 StyleBox["latex     smeft_feunman_rules.tex\ndvips    \
smeft_feunman_rules.dvi\nps2pdf smeft_feunman_rules.ps ",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.760975593991325*^9, 3.760975706267427*^9}, {
  3.7609757472042847`*^9, 3.760975773450438*^9}, {3.760975980310062*^9, 
  3.760976049451584*^9}, {3.7609761550393543`*^9, 3.760976218347515*^9}, {
  3.762708016521484*^9, 
  3.762708088553321*^9}},ExpressionUUID->"1fc1a5f9-bcd0-474b-bc09-\
2c0fda3fa36f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTToLatex", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760973834196251*^9, 
  3.760973868172414*^9}},ExpressionUUID->"3d92c3f0-e64e-45b1-bebd-\
b9d4c9e1d6c6"],

Cell["\<\
Long formulae with 5- and 6-tuple gluon vertices are not included in the \
Latex output (and only here).\
\>", "Text",
 CellChangeTimes->{{3.7609762669586973`*^9, 3.7609763227351313`*^9}, {
  3.762707905508999*^9, 3.7627079432949457`*^9}, {3.7627081008827868`*^9, 
  3.76270811335684*^9}},ExpressionUUID->"1ae5f0aa-71dc-49e1-9f6e-\
6e417b5b2448"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Section",
 CellChangeTimes->{{3.760978737165659*^9, 
  3.760978747875888*^9}},ExpressionUUID->"9816b728-95c0-47a7-84b8-\
025adb1cf3e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"SMEFTMBLagrangian", ",", " ", 
    RowBox[{"Output", "\[Rule]", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "SMEFT$Path", ",", " ", "\"\<output\>\"", ",", " ", "\"\<UFO\>\""}], 
       "}"}], "]"}]}], ",", " ", 
    RowBox[{"AddDecays", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760978760044993*^9, 3.760978873333323*^9}, {
  3.760978958155004*^9, 3.7609789616293793`*^9}, {3.762708124696856*^9, 
  3.762708126907357*^9}},ExpressionUUID->"f5d0c8bf-cc2e-4102-b67a-\
a962c7781f09"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts output", "Section",
 CellChangeTimes->{{3.760979059207157*^9, 
  3.760979078821291*^9}},ExpressionUUID->"8626feec-09ca-4ecd-8988-\
76ca0c800939"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"SMEFTMBLagrangian", ",", " ", 
    RowBox[{"Output", "\[Rule]", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "SMEFT$Path", ",", " ", "\"\<output\>\"", ",", " ", "\"\<FeynArts\>\"",
         ",", "\"\<FeynArts\>\""}], "}"}], "]"}]}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760979082452731*^9, 3.760979125856543*^9}, {
   3.760979167833156*^9, 3.760979197980172*^9}, 3.760980246010791*^9, {
   3.7609813247143173`*^9, 3.7609813326193132`*^9}, {3.7627081324967203`*^9, 
   3.762708135287344*^9}},ExpressionUUID->"c20c91ae-fdbc-4338-bee8-\
0946c3c1951e"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 681},
WindowMargins->{{50, Automatic}, {Automatic, 195}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1141, 22, 456, "Title",ExpressionUUID->"68b8f4ae-1b50-45fc-8fb7-0768ce1acaea"],
Cell[CellGroupData[{
Cell[1733, 48, 301, 5, 135, "Section",ExpressionUUID->"d8e28858-48c3-45e1-85e5-ba933fc1c3a2"],
Cell[2037, 55, 1739, 40, 458, "Input",ExpressionUUID->"eec34924-11ca-48a1-b401-77b9b8b2dc0f"],
Cell[3779, 97, 758, 22, 194, "Input",ExpressionUUID->"665e8197-75cc-4cc9-9080-ac98cfaa0526"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4574, 124, 314, 5, 135, "Section",ExpressionUUID->"f9cfb12d-ae19-49de-8c08-984ac8e4a487"],
Cell[4891, 131, 430, 9, 61, "Input",ExpressionUUID->"bafc84c2-d2f0-4308-8f4f-a78bf81b00f5"],
Cell[5324, 142, 629, 14, 162, "Text",ExpressionUUID->"6a88774d-237d-4448-89fa-73adbaf090af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5990, 161, 217, 4, 135, "Section",ExpressionUUID->"d80012ba-c011-43d3-be49-5239e1f4a423"],
Cell[6210, 167, 250, 6, 116, "Text",ExpressionUUID->"85a281df-0478-4203-81e0-a27c0da6a0f4"],
Cell[6463, 175, 668, 18, 150, "Input",ExpressionUUID->"6fe2c640-23be-42c2-acad-b47fa501c2a1"],
Cell[7134, 195, 806, 13, 254, "Text",ExpressionUUID->"7788d64f-fa91-40b0-a5bf-705e767276d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7977, 213, 209, 4, 135, "Section",ExpressionUUID->"dfbd88f0-2a19-48e8-989c-8bf42c78e17b"],
Cell[8189, 219, 834, 15, 346, "Text",ExpressionUUID->"1fc1a5f9-bcd0-474b-bc09-2c0fda3fa36f"],
Cell[9026, 236, 204, 5, 61, "Input",ExpressionUUID->"3d92c3f0-e64e-45b1-bebd-b9d4c9e1d6c6"],
Cell[9233, 243, 356, 7, 116, "Text",ExpressionUUID->"1ae5f0aa-71dc-49e1-9f6e-6e417b5b2448"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9626, 255, 155, 3, 135, "Section",ExpressionUUID->"9816b728-95c0-47a7-84b8-025adb1cf3e3"],
Cell[9784, 260, 606, 14, 150, "Input",ExpressionUUID->"f5d0c8bf-cc2e-4102-b67a-a962c7781f09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10427, 279, 160, 3, 135, "Section",ExpressionUUID->"8626feec-09ca-4ecd-8988-76ca0c800939"],
Cell[10590, 284, 668, 14, 150, "Input",ExpressionUUID->"c20c91ae-fdbc-4338-bee8-0946c3c1951e"]
}, Open  ]]
}, Open  ]]
}
]
*)

