(* SmeftFR v2.0 package *)
(* Contains definitions of SM fields and quantum numbers *)

(* ************* ************ *)
(* Information *)
(* ************************** *)
M$ModelName = SMEFT$ModelName;

M$Information = {
  Authors      -> SMEFT$Authors,
  Version      -> SMEFT$Version,
  Date         -> SMEFT$Date(*,
  Institutions -> SMEFT$Institutions,
  Emails       -> SMEFT$Emails,
  URLs         -> SMEFT$URLs*)
};


(* ************************** *)
(* vevs *)
(* ************************** *)

(* M$vevs={ {Phi[2],vev} }; *)


(* ************************** *)
(* Gauge groups *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> Gl,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  }
};


(* ************************** *)
(* Indices *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* Interaction orders (as used by mg5) *)
(* ************************** *)

M$InteractionOrderHierarchy = {
{QCD,1},
{NP,1},
{QED,1}
}

M$InteractionOrderLimit = {
{QCD,99},
{NP,1},
{QED,99}
} 


(* ************************** *)
(* Particle classes *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, Internal},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW,Internal},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "g",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields  *)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    Mass          -> 0,
    SelfConjugate -> True, 
    Definitions   -> { B[si_] -> AZnorm[1,1] A[si] + AZnorm[1,2] Z[si] } 
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    Mass          -> 0,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[si_,1] -> Wnorm/Sqrt[2] (Wbar[si] + W[si]),
		       Wi[si_,2] -> - I Wnorm/Sqrt[2] (Wbar[si] - W[si]),
		       Wi[si_,3] -> AZnorm[2,1] A[si] + AZnorm[2,2] Z[si]
		     }
  },
  V[14] == {
    ClassName        -> Gl,
    Unphysical       -> True,
    Mass             -> 0,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Definitions      -> { Gl[si_,a_] -> Gnorm G[si,a] } 
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2])}
  },

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    Mass             -> Mn,
    Width            -> 0,
    SelfConjugate    -> False,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mldiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mudiag,
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mldiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Charge conjugated physical fermions *)
  F[22] == {
    ClassName        -> lc,
    ClassMembers     -> {ec, muc, tac},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mldiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> 1, LeptonNumber -> -1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Backward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e^C+", "mu^C+", "ta^C+"},
    AntiParticleName -> {"e^C-", "mu^C-", "ta^C-"},
    FullName         -> {"Electron^C", "Muon^C", "Tau^C"} 
  },
  F[23] == {
    ClassName        -> uqc,
    ClassMembers     -> {uc, cc, tc},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mudiag,
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> -2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Backward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u^C",  "c^C",  "t^C" },
    AntiParticleName -> {"u^C~", "c^C~", "t^C~"},
    FullName         -> {"u^C-quark", "c^C-quark", "t^C-quark"}
  },
  F[24] == {
    ClassName        -> dqc,
    ClassMembers     -> {dc, sc, bc},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mldiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> 1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Backward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d^C",  "s^C",  "b^C" },
    AntiParticleName -> {"d^C~", "s^C~", "b^C~"},
    FullName         -> {"d^C-quark", "s^C-quark", "b^C-quark"}
  },

  
(* Fermions: unphysical fields *)
  F[11] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> { 
      LL[sp1_,1,ff_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VVL[ff,ff1] vl[sp2,ff1]], 
      LL[sp1_,2,ff_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VLL[ff,ff1]  l[sp2,ff1]] }
  },
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1},
    Definitions    -> { 
      lR[sp1_,ff_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VLR[ff,ff1] l[sp2,ff1]] }
  },
  F[13] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VUL[ff,ff1] uq[sp2,ff1,cc]], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VDL[ff,ff1] dq[sp2,ff1,cc]] }
  },
  F[14] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { 
      uR[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VUR[ff,ff1] uq[sp2,ff1,cc]] }
  },
  F[15] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3},
    Definitions    -> { 
      dR[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VDR[ff,ff1] dq[sp2,ff1,cc]] }
  },

(* Fermions: charge conjugated unphysical fields *)
  F[31] == { 
    ClassName      -> LLc, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { 
      LLc[sp1_,1,ff_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] Conjugate[VVL[ff,ff1]] vl[sp2,ff1]], 
      LLc[sp1_,2,ff_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] Conjugate[VLL[ff,ff1]] lc[sp2,ff1]] }
  },
  F[32] == { 
    ClassName      -> lRc, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1},
    Definitions    -> { 
      lRc[sp1_,ff_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] Conjugate[VLR[ff,ff1]] lc[sp2,ff1]] }
  },
  F[33] == { 
    ClassName      -> QLc, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/6},
    Definitions    -> { 
      QLc[sp1_,1,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] Conjugate[VUL[ff,ff1]] uqc[sp2,ff1,cc]], 
      QLc[sp1_,2,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] Conjugate[VDL[ff,ff1]] dqc[sp2,ff1,cc]] }
  },
  F[44] == { 
    ClassName      -> uRc, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> - 2/3},
    Definitions    -> { 
      uRc[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] Conjugate[VUR[ff,ff1]] uqc[sp2,ff1,cc]] }
  },
  F[55] == { 
    ClassName      -> dRc, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/3},
    Definitions    -> { 
      dRc[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] Conjugate[VDR[ff,ff1]] dqc[sp2,ff1,cc]] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H,
    SelfConjugate   -> True,
    Mass            -> {MH,Internal},
    Width           -> {WH,0.00575308848},
    PropagatorLabel -> "H",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "H",
    FullName        -> "H"
  },

(* Goldstone fields  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ,Internal},
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW,Internal},
    QuantumNumbers   -> {Q -> 1},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },

(* Higgs: unphysical scalars in dim-4 lagrangian *)
  S[11] == { 
    ClassName      -> PhiSM, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { PhiSM[1] -> GP/GPnorm, PhiSM[2] -> (vev + H/Hnorm + I G0/G0norm)/Sqrt[2]  }
  },

(* Higgs: unphysical scalars in dim-6 lagrangian *)
  S[12] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi[1] -> GP, Phi[2] -> (vev + H + I G0)/Sqrt[2]  }
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];
