(* Generated by WCXFToSMEFT routine from the file /home/rosiek/FeynRules/Models/SMEFT_2_01/definitions/wcxf_default.json *)
(* 6.9.2019 12:24 *)


(* Active operators included in Feynman Rules: {dB, dd, dG, dphi, duq, duu, dW, eB, ed, ee, ephi, eu, eW, G, Gtilde, ld, le, ledq, lequ1, lequ3, ll, lq1, lq3, lu, phi, phiB, phiBox, phiBtilde, phid, phiD, phie, phiG, phiGtilde, phil1, phil3, phiq1, phiq3, phiu, phiud, phiW, phiWB, phiWtilde, phiWtildeB, qd1, qd8, qe, qq1, qq3, qqq, qqu, qu1, qu8, quqd1, quqd8, uB, ud1, ud8, uG, uphi, uu, uW, vv, W, Wtilde} *)

(* SmeftFR v2.0 package *)
(* Contains definitions of SMEFT parameters in mass basis *)

(* ********************************** *)
(* ***** Parameters (SM + dim6) ***** *)
(* ********************************** *)
 
M$Parameters = {
  
(* parametrization of EW numerical input; if necessary update values
of SMEFT$... variables in the file smeft_variables.m *)

  aEWM1 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aeWM1,
    InteractionOrder -> {QED,-2},  
    TeX              -> Superscript[Subscript[\[Alpha],em],-1],
    Description      -> "1/alpha_em at MZ scale"
  },
  aEW == { 
    ParameterType    -> Internal, 
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},  
    TeX              -> Subscript[\[Alpha],em],
    Description      -> "alpha_em at MZ scale"
  },
  ee == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi/SMEFT$aeWM1],
    InteractionOrder -> {QED,1},  
    TeX              -> e, 
    Description      -> "Electric charge e at MZ scale"
  },
  Gf == { 
    ParameterType    -> External, 
    Value            -> SMEFT$Gf,
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,f], 
    Description      -> "Fermi constant"
  },
  sw2 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$sw2, 
    TeX              -> Superscript[Subscript[s,W],2], 
    Description      -> "s_W^2"
  },
  sw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[SMEFT$sw2], 
    TeX              -> Subscript[s,W], 
    Description      -> "s_W"
  },
  cw2 == { 
    ParameterType    -> External, 
    Value            -> 1 - SMEFT$sw2, 
    TeX              -> Superscript[Subscript[c,W],2], 
    Description      -> "c_W^2"
  },
  cw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[1 - SMEFT$sw2], 
    TeX              -> Subscript[c,W], 
    Description      -> "c_W"
  },
  aS == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aS,
    InteractionOrder -> {QCD,2},  
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "alpha_s at MZ scale"
  },

(* effective gauge coupling constants *)
  G1 == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf SMEFT$sw2/(1 - SMEFT$sw2)], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,1], 
    Description      -> "Effective U(1)Y coupling constant"
  },
  GW == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,W], 
    Description      -> "Effective SU(2) coupling constant"
  },
  GS == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi SMEFT$aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[G,s], 
    Description      -> "Effective SU(3) coupling constant at the Z pole"
  },

(* Higgs vev and quartic coupling *)
  vev == {
    ParameterType    -> External,
    Value            -> 1/Sqrt[Sqrt[2] SMEFT$Gf], 
    TeX              -> v,
    Description      -> "Higgs vacuum expectation value"
  },
  hlambda == {
    ParameterType    -> External,
    Value            -> Sqrt[2] SMEFT$MH^2 SMEFT$Gf, 
    InteractionOrder -> {QED, 1},
    TeX              -> \[Lambda],
    Description      -> "Higgs quartic coupling"
  },

  
(* auxiliary parameter giving QED Interaction Order = 1 for Yukawa couplings *)
  YO == { 
    ParameterType    -> External, 
    Value            -> 1, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[Y,O], 
    Description      -> "Interaction order for Yukawa/fermion masses"
  },

(* gauge fixing parameters *)

xiW == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],W], 
    Description   -> "W gauge fixing parameter"
  },

xiZ == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],Z], 
    Description   -> "Z gauge fixing parameter"
  },

xiA == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A], 
    Description   -> "Photon gauge fixing parameter"
  },

xiG == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G], 
    Description   -> "Gluon gauge fixing parameter"
  },

  (* unphysical field mass *)
  
  MgZ == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]Z],
    Description      -> "Z ghost mass"
  },

  MgW == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]W],
    Description      -> "W ghost mass"
  },

  MG0 == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,G0],
    Description      -> "G0 mass"
  },

  MGP == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,GP],
    Description      -> "G+ and G- mass"
  },
  
(* physical flavor mixing *)

(* CKM matrix K = VUL^+ VDL + dim 6 corrections. Here we use pure
Wolfenstein, no dim-6 additions. Parameters are defined at the top of
smeft_variables.m, edit them there if necessary *)

Kq == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {Kq[1,1] -> CKM$mat[[1,1]],
            Kq[1,2] -> CKM$mat[[1,2]], 
            Kq[1,3] -> CKM$mat[[1,3]],
            Kq[2,1] -> CKM$mat[[2,1]],
            Kq[2,2] -> CKM$mat[[2,2]],
            Kq[2,3] -> CKM$mat[[2,3]],
            Kq[3,1] -> CKM$mat[[3,1]],
            Kq[3,2] -> CKM$mat[[3,2]],
            Kq[3,3] -> CKM$mat[[3,3]]},
Unitary -> False,
ComplexParameter -> True,
TeX           -> K,
Description -> "CKM Matrix"
},

(* PMNS matrix U = VLL^+ VVL + dim 6 corrections.  Here no dim-6
additions. Angles and phases are defined at the top of
smeft_variables.m, edit them there if necessary *)

Ul == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {Ul[1,1] -> PMNS$mat[[1,1]],
            Ul[1,2] -> PMNS$mat[[1,2]], 
            Ul[1,3] -> PMNS$mat[[1,3]], 
            Ul[2,1] -> PMNS$mat[[2,1]], 
            Ul[2,2] -> PMNS$mat[[2,2]], 
            Ul[2,3] -> PMNS$mat[[2,3]], 
            Ul[3,1] -> PMNS$mat[[3,1]], 
            Ul[3,2] -> PMNS$mat[[3,2]], 
            Ul[3,3] -> PMNS$mat[[3,3]]},
Unitary -> False,
TeX           -> U,
ComplexParameter -> True,
Description -> "PMNS Matrix"
},


(* neutrino masses *)

  v1mass == {
    ParameterType    -> External,
    Value            -> 0.*^-323,
    Description      -> "v1 mass"
  },
  v2mass == {
    ParameterType    -> External,
    Value            -> 0.*^-323,
    Description      -> "v2 mass"
  },
  v3mass == {
    ParameterType    -> External,
    Value            -> 0.*^-323,
    Description      -> "v3 mass"
  },

(* redefined (mass basis) dim-6 couplings *)

(* flavor independent *)

 CG == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, G],
    Description      -> "QG coupling"
    },


 CGtilde == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, Gtilde],
    Description      -> "QGtilde coupling"
    },


 Cphi == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]],
    Description      -> "Qphi coupling"
    },


 CphiB == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]B],
    Description      -> "QphiB coupling"
    },


 CphiBox == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]Box],
    Description      -> "QphiBox coupling"
    },


 CphiBtilde == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]Btilde],
    Description      -> "QphiBtilde coupling"
    },


 CphiD == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]D],
    Description      -> "QphiD coupling"
    },


 CphiG == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]G],
    Description      -> "QphiG coupling"
    },


 CphiGtilde == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]Gtilde],
    Description      -> "QphiGtilde coupling"
    },


 CphiW == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]W],
    Description      -> "QphiW coupling"
    },


 CphiWB == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]WB],
    Description      -> "QphiWB coupling"
    },


 CphiWtilde == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]Wtilde],
    Description      -> "QphiWtilde coupling"
    },


 CphiWtildeB == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]WtildeB],
    Description      -> "QphiWtildeB coupling"
    },


 CW == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, W],
    Description      -> "QW coupling"
    },


 CWtilde == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0*^0,
    ComplexParameter -> False,
    TeX              -> Superscript[C, Wtilde],
    Description      -> "QWtilde coupling"
    },


(* flavor dependent *)

(* 2 fermion operators *)

 CdB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CdB[1, 1] -> 0*^0,
                         CdB[1, 2] -> 0*^0,
                         CdB[1, 3] -> 0*^0,
                         CdB[2, 1] -> 0*^0,
                         CdB[2, 2] -> 0*^0,
                         CdB[2, 3] -> 0*^0,
                         CdB[3, 1] -> 0*^0,
                         CdB[3, 2] -> 0*^0,
                         CdB[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, dB],
    Description      -> "QdB coupling"
    },


 CdG == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CdG[1, 1] -> 0*^0,
                         CdG[1, 2] -> 0*^0,
                         CdG[1, 3] -> 0*^0,
                         CdG[2, 1] -> 0*^0,
                         CdG[2, 2] -> 0*^0,
                         CdG[2, 3] -> 0*^0,
                         CdG[3, 1] -> 0*^0,
                         CdG[3, 2] -> 0*^0,
                         CdG[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, dG],
    Description      -> "QdG coupling"
    },


 Cdphi == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cdphi[1, 1] -> 0*^0,
                         Cdphi[1, 2] -> 0*^0,
                         Cdphi[1, 3] -> 0*^0,
                         Cdphi[2, 1] -> 0*^0,
                         Cdphi[2, 2] -> 0*^0,
                         Cdphi[2, 3] -> 0*^0,
                         Cdphi[3, 1] -> 0*^0,
                         Cdphi[3, 2] -> 0*^0,
                         Cdphi[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, d\[Phi]],
    Description      -> "Qdphi coupling"
    },


 CdW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CdW[1, 1] -> 0*^0,
                         CdW[1, 2] -> 0*^0,
                         CdW[1, 3] -> 0*^0,
                         CdW[2, 1] -> 0*^0,
                         CdW[2, 2] -> 0*^0,
                         CdW[2, 3] -> 0*^0,
                         CdW[3, 1] -> 0*^0,
                         CdW[3, 2] -> 0*^0,
                         CdW[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, dW],
    Description      -> "QdW coupling"
    },


 CeB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CeB[1, 1] -> 0*^0,
                         CeB[1, 2] -> 0*^0,
                         CeB[1, 3] -> 0*^0,
                         CeB[2, 1] -> 0*^0,
                         CeB[2, 2] -> 0*^0,
                         CeB[2, 3] -> 0*^0,
                         CeB[3, 1] -> 0*^0,
                         CeB[3, 2] -> 0*^0,
                         CeB[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, eB],
    Description      -> "QeB coupling"
    },


 Cephi == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cephi[1, 1] -> 0*^0,
                         Cephi[1, 2] -> 0*^0,
                         Cephi[1, 3] -> 0*^0,
                         Cephi[2, 1] -> 0*^0,
                         Cephi[2, 2] -> 0*^0,
                         Cephi[2, 3] -> 0*^0,
                         Cephi[3, 1] -> 0*^0,
                         Cephi[3, 2] -> 0*^0,
                         Cephi[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, e\[Phi]],
    Description      -> "Qephi coupling"
    },


 CeW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CeW[1, 1] -> 0*^0,
                         CeW[1, 2] -> 0*^0,
                         CeW[1, 3] -> 0*^0,
                         CeW[2, 1] -> 0*^0,
                         CeW[2, 2] -> 0*^0,
                         CeW[2, 3] -> 0*^0,
                         CeW[3, 1] -> 0*^0,
                         CeW[3, 2] -> 0*^0,
                         CeW[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, eW],
    Description      -> "QeW coupling"
    },


 Cphid == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphid[1, 1] -> 0*^0,
                         Cphid[1, 2] -> 0*^0,
                         Cphid[1, 3] -> 0*^0,
                         Cphid[2, 1] -> 0*^0,
                         Cphid[2, 2] -> 0*^0,
                         Cphid[2, 3] -> 0*^0,
                         Cphid[3, 1] -> 0*^0,
                         Cphid[3, 2] -> 0*^0,
                         Cphid[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]d],
    Description      -> "Qphid coupling"
    },


 Cphie == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphie[1, 1] -> 0*^0,
                         Cphie[1, 2] -> 0*^0,
                         Cphie[1, 3] -> 0*^0,
                         Cphie[2, 1] -> 0*^0,
                         Cphie[2, 2] -> 0*^0,
                         Cphie[2, 3] -> 0*^0,
                         Cphie[3, 1] -> 0*^0,
                         Cphie[3, 2] -> 0*^0,
                         Cphie[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]e],
    Description      -> "Qphie coupling"
    },


 Cphil1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphil1[1, 1] -> 0*^0,
                         Cphil1[1, 2] -> 0*^0,
                         Cphil1[1, 3] -> 0*^0,
                         Cphil1[2, 1] -> 0*^0,
                         Cphil1[2, 2] -> 0*^0,
                         Cphil1[2, 3] -> 0*^0,
                         Cphil1[3, 1] -> 0*^0,
                         Cphil1[3, 2] -> 0*^0,
                         Cphil1[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]l1],
    Description      -> "Qphil1 coupling"
    },


 Cphil3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphil3[1, 1] -> 0*^0,
                         Cphil3[1, 2] -> 0*^0,
                         Cphil3[1, 3] -> 0*^0,
                         Cphil3[2, 1] -> 0*^0,
                         Cphil3[2, 2] -> 0*^0,
                         Cphil3[2, 3] -> 0*^0,
                         Cphil3[3, 1] -> 0*^0,
                         Cphil3[3, 2] -> 0*^0,
                         Cphil3[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]l3],
    Description      -> "Qphil3 coupling"
    },


 Cphiq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphiq1[1, 1] -> 0*^0,
                         Cphiq1[1, 2] -> 0*^0,
                         Cphiq1[1, 3] -> 0*^0,
                         Cphiq1[2, 1] -> 0*^0,
                         Cphiq1[2, 2] -> 0*^0,
                         Cphiq1[2, 3] -> 0*^0,
                         Cphiq1[3, 1] -> 0*^0,
                         Cphiq1[3, 2] -> 0*^0,
                         Cphiq1[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]q1],
    Description      -> "Qphiq1 coupling"
    },


 Cphiq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphiq3[1, 1] -> 0*^0,
                         Cphiq3[1, 2] -> 0*^0,
                         Cphiq3[1, 3] -> 0*^0,
                         Cphiq3[2, 1] -> 0*^0,
                         Cphiq3[2, 2] -> 0*^0,
                         Cphiq3[2, 3] -> 0*^0,
                         Cphiq3[3, 1] -> 0*^0,
                         Cphiq3[3, 2] -> 0*^0,
                         Cphiq3[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]q3],
    Description      -> "Qphiq3 coupling"
    },


 Cphiu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphiu[1, 1] -> 0*^0,
                         Cphiu[1, 2] -> 0*^0,
                         Cphiu[1, 3] -> 0*^0,
                         Cphiu[2, 1] -> 0*^0,
                         Cphiu[2, 2] -> 0*^0,
                         Cphiu[2, 3] -> 0*^0,
                         Cphiu[3, 1] -> 0*^0,
                         Cphiu[3, 2] -> 0*^0,
                         Cphiu[3, 3] -> 0*^0},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]u],
    Description      -> "Qphiu coupling"
    },


 Cphiud == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphiud[1, 1] -> 0*^0,
                         Cphiud[1, 2] -> 0*^0,
                         Cphiud[1, 3] -> 0*^0,
                         Cphiud[2, 1] -> 0*^0,
                         Cphiud[2, 2] -> 0*^0,
                         Cphiud[2, 3] -> 0*^0,
                         Cphiud[3, 1] -> 0*^0,
                         Cphiud[3, 2] -> 0*^0,
                         Cphiud[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, \[Phi]ud],
    Description      -> "Qphiud coupling"
    },


 CuB == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CuB[1, 1] -> 0*^0,
                         CuB[1, 2] -> 0*^0,
                         CuB[1, 3] -> 0*^0,
                         CuB[2, 1] -> 0*^0,
                         CuB[2, 2] -> 0*^0,
                         CuB[2, 3] -> 0*^0,
                         CuB[3, 1] -> 0*^0,
                         CuB[3, 2] -> 0*^0,
                         CuB[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, uB],
    Description      -> "QuB coupling"
    },


 CuG == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CuG[1, 1] -> 0*^0,
                         CuG[1, 2] -> 0*^0,
                         CuG[1, 3] -> 0*^0,
                         CuG[2, 1] -> 0*^0,
                         CuG[2, 2] -> 0*^0,
                         CuG[2, 3] -> 0*^0,
                         CuG[3, 1] -> 0*^0,
                         CuG[3, 2] -> 0*^0,
                         CuG[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, uG],
    Description      -> "QuG coupling"
    },


 Cuphi == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cuphi[1, 1] -> 0*^0,
                         Cuphi[1, 2] -> 0*^0,
                         Cuphi[1, 3] -> 0*^0,
                         Cuphi[2, 1] -> 0*^0,
                         Cuphi[2, 2] -> 0*^0,
                         Cuphi[2, 3] -> 0*^0,
                         Cuphi[3, 1] -> 0*^0,
                         Cuphi[3, 2] -> 0*^0,
                         Cuphi[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, u\[Phi]],
    Description      -> "Quphi coupling"
    },


 CuW == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {CuW[1, 1] -> 0*^0,
                         CuW[1, 2] -> 0*^0,
                         CuW[1, 3] -> 0*^0,
                         CuW[2, 1] -> 0*^0,
                         CuW[2, 2] -> 0*^0,
                         CuW[2, 3] -> 0*^0,
                         CuW[3, 1] -> 0*^0,
                         CuW[3, 2] -> 0*^0,
                         CuW[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, uW],
    Description      -> "QuW coupling"
    },


 Cvv == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cvv[1, 1] -> 0*^0,
                         Cvv[1, 2] -> 0*^0,
                         Cvv[1, 3] -> 0*^0,
                         Cvv[2, 1] -> 0*^0,
                         Cvv[2, 2] -> 0*^0,
                         Cvv[2, 3] -> 0*^0,
                         Cvv[3, 1] -> 0*^0,
                         Cvv[3, 2] -> 0*^0,
                         Cvv[3, 3] -> 0*^0},
    Hermitian        -> False,
    TeX              -> Superscript[C, vv],
    Description      -> "Qvv coupling"
    },


(* 4 fermion operators *)

 Cdd == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cdd[1, 1, 1, 1] -> 0*^0,
                         Cdd[1, 1, 1, 2] -> 0*^0,
                         Cdd[1, 1, 1, 3] -> 0*^0,
                         Cdd[1, 1, 2, 1] -> 0*^0,
                         Cdd[1, 1, 2, 2] -> 0*^0,
                         Cdd[1, 1, 2, 3] -> 0*^0,
                         Cdd[1, 1, 3, 1] -> 0*^0,
                         Cdd[1, 1, 3, 2] -> 0*^0,
                         Cdd[1, 1, 3, 3] -> 0*^0,
                         Cdd[1, 2, 1, 1] -> 0*^0,
                         Cdd[1, 2, 1, 2] -> 0*^0,
                         Cdd[1, 2, 1, 3] -> 0*^0,
                         Cdd[1, 2, 2, 1] -> 0*^0,
                         Cdd[1, 2, 2, 2] -> 0*^0,
                         Cdd[1, 2, 2, 3] -> 0*^0,
                         Cdd[1, 2, 3, 1] -> 0*^0,
                         Cdd[1, 2, 3, 2] -> 0*^0,
                         Cdd[1, 2, 3, 3] -> 0*^0,
                         Cdd[1, 3, 1, 1] -> 0*^0,
                         Cdd[1, 3, 1, 2] -> 0*^0,
                         Cdd[1, 3, 1, 3] -> 0*^0,
                         Cdd[1, 3, 2, 1] -> 0*^0,
                         Cdd[1, 3, 2, 2] -> 0*^0,
                         Cdd[1, 3, 2, 3] -> 0*^0,
                         Cdd[1, 3, 3, 1] -> 0*^0,
                         Cdd[1, 3, 3, 2] -> 0*^0,
                         Cdd[1, 3, 3, 3] -> 0*^0,
                         Cdd[2, 1, 1, 1] -> 0*^0,
                         Cdd[2, 1, 1, 2] -> 0*^0,
                         Cdd[2, 1, 1, 3] -> 0*^0,
                         Cdd[2, 1, 2, 1] -> 0*^0,
                         Cdd[2, 1, 2, 2] -> 0*^0,
                         Cdd[2, 1, 2, 3] -> 0*^0,
                         Cdd[2, 1, 3, 1] -> 0*^0,
                         Cdd[2, 1, 3, 2] -> 0*^0,
                         Cdd[2, 1, 3, 3] -> 0*^0,
                         Cdd[2, 2, 1, 1] -> 0*^0,
                         Cdd[2, 2, 1, 2] -> 0*^0,
                         Cdd[2, 2, 1, 3] -> 0*^0,
                         Cdd[2, 2, 2, 1] -> 0*^0,
                         Cdd[2, 2, 2, 2] -> 0*^0,
                         Cdd[2, 2, 2, 3] -> 0*^0,
                         Cdd[2, 2, 3, 1] -> 0*^0,
                         Cdd[2, 2, 3, 2] -> 0*^0,
                         Cdd[2, 2, 3, 3] -> 0*^0,
                         Cdd[2, 3, 1, 1] -> 0*^0,
                         Cdd[2, 3, 1, 2] -> 0*^0,
                         Cdd[2, 3, 1, 3] -> 0*^0,
                         Cdd[2, 3, 2, 1] -> 0*^0,
                         Cdd[2, 3, 2, 2] -> 0*^0,
                         Cdd[2, 3, 2, 3] -> 0*^0,
                         Cdd[2, 3, 3, 1] -> 0*^0,
                         Cdd[2, 3, 3, 2] -> 0*^0,
                         Cdd[2, 3, 3, 3] -> 0*^0,
                         Cdd[3, 1, 1, 1] -> 0*^0,
                         Cdd[3, 1, 1, 2] -> 0*^0,
                         Cdd[3, 1, 1, 3] -> 0*^0,
                         Cdd[3, 1, 2, 1] -> 0*^0,
                         Cdd[3, 1, 2, 2] -> 0*^0,
                         Cdd[3, 1, 2, 3] -> 0*^0,
                         Cdd[3, 1, 3, 1] -> 0*^0,
                         Cdd[3, 1, 3, 2] -> 0*^0,
                         Cdd[3, 1, 3, 3] -> 0*^0,
                         Cdd[3, 2, 1, 1] -> 0*^0,
                         Cdd[3, 2, 1, 2] -> 0*^0,
                         Cdd[3, 2, 1, 3] -> 0*^0,
                         Cdd[3, 2, 2, 1] -> 0*^0,
                         Cdd[3, 2, 2, 2] -> 0*^0,
                         Cdd[3, 2, 2, 3] -> 0*^0,
                         Cdd[3, 2, 3, 1] -> 0*^0,
                         Cdd[3, 2, 3, 2] -> 0*^0,
                         Cdd[3, 2, 3, 3] -> 0*^0,
                         Cdd[3, 3, 1, 1] -> 0*^0,
                         Cdd[3, 3, 1, 2] -> 0*^0,
                         Cdd[3, 3, 1, 3] -> 0*^0,
                         Cdd[3, 3, 2, 1] -> 0*^0,
                         Cdd[3, 3, 2, 2] -> 0*^0,
                         Cdd[3, 3, 2, 3] -> 0*^0,
                         Cdd[3, 3, 3, 1] -> 0*^0,
                         Cdd[3, 3, 3, 2] -> 0*^0,
                         Cdd[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, dd],
    Description      -> "Qdd coupling"
    },


 Cduq == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cduq[1, 1, 1, 1] -> 0*^0,
                         Cduq[1, 1, 1, 2] -> 0*^0,
                         Cduq[1, 1, 1, 3] -> 0*^0,
                         Cduq[1, 1, 2, 1] -> 0*^0,
                         Cduq[1, 1, 2, 2] -> 0*^0,
                         Cduq[1, 1, 2, 3] -> 0*^0,
                         Cduq[1, 1, 3, 1] -> 0*^0,
                         Cduq[1, 1, 3, 2] -> 0*^0,
                         Cduq[1, 1, 3, 3] -> 0*^0,
                         Cduq[1, 2, 1, 1] -> 0*^0,
                         Cduq[1, 2, 1, 2] -> 0*^0,
                         Cduq[1, 2, 1, 3] -> 0*^0,
                         Cduq[1, 2, 2, 1] -> 0*^0,
                         Cduq[1, 2, 2, 2] -> 0*^0,
                         Cduq[1, 2, 2, 3] -> 0*^0,
                         Cduq[1, 2, 3, 1] -> 0*^0,
                         Cduq[1, 2, 3, 2] -> 0*^0,
                         Cduq[1, 2, 3, 3] -> 0*^0,
                         Cduq[1, 3, 1, 1] -> 0*^0,
                         Cduq[1, 3, 1, 2] -> 0*^0,
                         Cduq[1, 3, 1, 3] -> 0*^0,
                         Cduq[1, 3, 2, 1] -> 0*^0,
                         Cduq[1, 3, 2, 2] -> 0*^0,
                         Cduq[1, 3, 2, 3] -> 0*^0,
                         Cduq[1, 3, 3, 1] -> 0*^0,
                         Cduq[1, 3, 3, 2] -> 0*^0,
                         Cduq[1, 3, 3, 3] -> 0*^0,
                         Cduq[2, 1, 1, 1] -> 0*^0,
                         Cduq[2, 1, 1, 2] -> 0*^0,
                         Cduq[2, 1, 1, 3] -> 0*^0,
                         Cduq[2, 1, 2, 1] -> 0*^0,
                         Cduq[2, 1, 2, 2] -> 0*^0,
                         Cduq[2, 1, 2, 3] -> 0*^0,
                         Cduq[2, 1, 3, 1] -> 0*^0,
                         Cduq[2, 1, 3, 2] -> 0*^0,
                         Cduq[2, 1, 3, 3] -> 0*^0,
                         Cduq[2, 2, 1, 1] -> 0*^0,
                         Cduq[2, 2, 1, 2] -> 0*^0,
                         Cduq[2, 2, 1, 3] -> 0*^0,
                         Cduq[2, 2, 2, 1] -> 0*^0,
                         Cduq[2, 2, 2, 2] -> 0*^0,
                         Cduq[2, 2, 2, 3] -> 0*^0,
                         Cduq[2, 2, 3, 1] -> 0*^0,
                         Cduq[2, 2, 3, 2] -> 0*^0,
                         Cduq[2, 2, 3, 3] -> 0*^0,
                         Cduq[2, 3, 1, 1] -> 0*^0,
                         Cduq[2, 3, 1, 2] -> 0*^0,
                         Cduq[2, 3, 1, 3] -> 0*^0,
                         Cduq[2, 3, 2, 1] -> 0*^0,
                         Cduq[2, 3, 2, 2] -> 0*^0,
                         Cduq[2, 3, 2, 3] -> 0*^0,
                         Cduq[2, 3, 3, 1] -> 0*^0,
                         Cduq[2, 3, 3, 2] -> 0*^0,
                         Cduq[2, 3, 3, 3] -> 0*^0,
                         Cduq[3, 1, 1, 1] -> 0*^0,
                         Cduq[3, 1, 1, 2] -> 0*^0,
                         Cduq[3, 1, 1, 3] -> 0*^0,
                         Cduq[3, 1, 2, 1] -> 0*^0,
                         Cduq[3, 1, 2, 2] -> 0*^0,
                         Cduq[3, 1, 2, 3] -> 0*^0,
                         Cduq[3, 1, 3, 1] -> 0*^0,
                         Cduq[3, 1, 3, 2] -> 0*^0,
                         Cduq[3, 1, 3, 3] -> 0*^0,
                         Cduq[3, 2, 1, 1] -> 0*^0,
                         Cduq[3, 2, 1, 2] -> 0*^0,
                         Cduq[3, 2, 1, 3] -> 0*^0,
                         Cduq[3, 2, 2, 1] -> 0*^0,
                         Cduq[3, 2, 2, 2] -> 0*^0,
                         Cduq[3, 2, 2, 3] -> 0*^0,
                         Cduq[3, 2, 3, 1] -> 0*^0,
                         Cduq[3, 2, 3, 2] -> 0*^0,
                         Cduq[3, 2, 3, 3] -> 0*^0,
                         Cduq[3, 3, 1, 1] -> 0*^0,
                         Cduq[3, 3, 1, 2] -> 0*^0,
                         Cduq[3, 3, 1, 3] -> 0*^0,
                         Cduq[3, 3, 2, 1] -> 0*^0,
                         Cduq[3, 3, 2, 2] -> 0*^0,
                         Cduq[3, 3, 2, 3] -> 0*^0,
                         Cduq[3, 3, 3, 1] -> 0*^0,
                         Cduq[3, 3, 3, 2] -> 0*^0,
                         Cduq[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, duq],
    Description      -> "Qduq coupling"
    },


 Cduu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cduu[1, 1, 1, 1] -> 0*^0,
                         Cduu[1, 1, 1, 2] -> 0*^0,
                         Cduu[1, 1, 1, 3] -> 0*^0,
                         Cduu[1, 1, 2, 1] -> 0*^0,
                         Cduu[1, 1, 2, 2] -> 0*^0,
                         Cduu[1, 1, 2, 3] -> 0*^0,
                         Cduu[1, 1, 3, 1] -> 0*^0,
                         Cduu[1, 1, 3, 2] -> 0*^0,
                         Cduu[1, 1, 3, 3] -> 0*^0,
                         Cduu[1, 2, 1, 1] -> 0*^0,
                         Cduu[1, 2, 1, 2] -> 0*^0,
                         Cduu[1, 2, 1, 3] -> 0*^0,
                         Cduu[1, 2, 2, 1] -> 0*^0,
                         Cduu[1, 2, 2, 2] -> 0*^0,
                         Cduu[1, 2, 2, 3] -> 0*^0,
                         Cduu[1, 2, 3, 1] -> 0*^0,
                         Cduu[1, 2, 3, 2] -> 0*^0,
                         Cduu[1, 2, 3, 3] -> 0*^0,
                         Cduu[1, 3, 1, 1] -> 0*^0,
                         Cduu[1, 3, 1, 2] -> 0*^0,
                         Cduu[1, 3, 1, 3] -> 0*^0,
                         Cduu[1, 3, 2, 1] -> 0*^0,
                         Cduu[1, 3, 2, 2] -> 0*^0,
                         Cduu[1, 3, 2, 3] -> 0*^0,
                         Cduu[1, 3, 3, 1] -> 0*^0,
                         Cduu[1, 3, 3, 2] -> 0*^0,
                         Cduu[1, 3, 3, 3] -> 0*^0,
                         Cduu[2, 1, 1, 1] -> 0*^0,
                         Cduu[2, 1, 1, 2] -> 0*^0,
                         Cduu[2, 1, 1, 3] -> 0*^0,
                         Cduu[2, 1, 2, 1] -> 0*^0,
                         Cduu[2, 1, 2, 2] -> 0*^0,
                         Cduu[2, 1, 2, 3] -> 0*^0,
                         Cduu[2, 1, 3, 1] -> 0*^0,
                         Cduu[2, 1, 3, 2] -> 0*^0,
                         Cduu[2, 1, 3, 3] -> 0*^0,
                         Cduu[2, 2, 1, 1] -> 0*^0,
                         Cduu[2, 2, 1, 2] -> 0*^0,
                         Cduu[2, 2, 1, 3] -> 0*^0,
                         Cduu[2, 2, 2, 1] -> 0*^0,
                         Cduu[2, 2, 2, 2] -> 0*^0,
                         Cduu[2, 2, 2, 3] -> 0*^0,
                         Cduu[2, 2, 3, 1] -> 0*^0,
                         Cduu[2, 2, 3, 2] -> 0*^0,
                         Cduu[2, 2, 3, 3] -> 0*^0,
                         Cduu[2, 3, 1, 1] -> 0*^0,
                         Cduu[2, 3, 1, 2] -> 0*^0,
                         Cduu[2, 3, 1, 3] -> 0*^0,
                         Cduu[2, 3, 2, 1] -> 0*^0,
                         Cduu[2, 3, 2, 2] -> 0*^0,
                         Cduu[2, 3, 2, 3] -> 0*^0,
                         Cduu[2, 3, 3, 1] -> 0*^0,
                         Cduu[2, 3, 3, 2] -> 0*^0,
                         Cduu[2, 3, 3, 3] -> 0*^0,
                         Cduu[3, 1, 1, 1] -> 0*^0,
                         Cduu[3, 1, 1, 2] -> 0*^0,
                         Cduu[3, 1, 1, 3] -> 0*^0,
                         Cduu[3, 1, 2, 1] -> 0*^0,
                         Cduu[3, 1, 2, 2] -> 0*^0,
                         Cduu[3, 1, 2, 3] -> 0*^0,
                         Cduu[3, 1, 3, 1] -> 0*^0,
                         Cduu[3, 1, 3, 2] -> 0*^0,
                         Cduu[3, 1, 3, 3] -> 0*^0,
                         Cduu[3, 2, 1, 1] -> 0*^0,
                         Cduu[3, 2, 1, 2] -> 0*^0,
                         Cduu[3, 2, 1, 3] -> 0*^0,
                         Cduu[3, 2, 2, 1] -> 0*^0,
                         Cduu[3, 2, 2, 2] -> 0*^0,
                         Cduu[3, 2, 2, 3] -> 0*^0,
                         Cduu[3, 2, 3, 1] -> 0*^0,
                         Cduu[3, 2, 3, 2] -> 0*^0,
                         Cduu[3, 2, 3, 3] -> 0*^0,
                         Cduu[3, 3, 1, 1] -> 0*^0,
                         Cduu[3, 3, 1, 2] -> 0*^0,
                         Cduu[3, 3, 1, 3] -> 0*^0,
                         Cduu[3, 3, 2, 1] -> 0*^0,
                         Cduu[3, 3, 2, 2] -> 0*^0,
                         Cduu[3, 3, 2, 3] -> 0*^0,
                         Cduu[3, 3, 3, 1] -> 0*^0,
                         Cduu[3, 3, 3, 2] -> 0*^0,
                         Cduu[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, duu],
    Description      -> "Qduu coupling"
    },


 Ced == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Ced[1, 1, 1, 1] -> 0*^0,
                         Ced[1, 1, 1, 2] -> 0*^0,
                         Ced[1, 1, 1, 3] -> 0*^0,
                         Ced[1, 1, 2, 1] -> 0*^0,
                         Ced[1, 1, 2, 2] -> 0*^0,
                         Ced[1, 1, 2, 3] -> 0*^0,
                         Ced[1, 1, 3, 1] -> 0*^0,
                         Ced[1, 1, 3, 2] -> 0*^0,
                         Ced[1, 1, 3, 3] -> 0*^0,
                         Ced[1, 2, 1, 1] -> 0*^0,
                         Ced[1, 2, 1, 2] -> 0*^0,
                         Ced[1, 2, 1, 3] -> 0*^0,
                         Ced[1, 2, 2, 1] -> 0*^0,
                         Ced[1, 2, 2, 2] -> 0*^0,
                         Ced[1, 2, 2, 3] -> 0*^0,
                         Ced[1, 2, 3, 1] -> 0*^0,
                         Ced[1, 2, 3, 2] -> 0*^0,
                         Ced[1, 2, 3, 3] -> 0*^0,
                         Ced[1, 3, 1, 1] -> 0*^0,
                         Ced[1, 3, 1, 2] -> 0*^0,
                         Ced[1, 3, 1, 3] -> 0*^0,
                         Ced[1, 3, 2, 1] -> 0*^0,
                         Ced[1, 3, 2, 2] -> 0*^0,
                         Ced[1, 3, 2, 3] -> 0*^0,
                         Ced[1, 3, 3, 1] -> 0*^0,
                         Ced[1, 3, 3, 2] -> 0*^0,
                         Ced[1, 3, 3, 3] -> 0*^0,
                         Ced[2, 1, 1, 1] -> 0*^0,
                         Ced[2, 1, 1, 2] -> 0*^0,
                         Ced[2, 1, 1, 3] -> 0*^0,
                         Ced[2, 1, 2, 1] -> 0*^0,
                         Ced[2, 1, 2, 2] -> 0*^0,
                         Ced[2, 1, 2, 3] -> 0*^0,
                         Ced[2, 1, 3, 1] -> 0*^0,
                         Ced[2, 1, 3, 2] -> 0*^0,
                         Ced[2, 1, 3, 3] -> 0*^0,
                         Ced[2, 2, 1, 1] -> 0*^0,
                         Ced[2, 2, 1, 2] -> 0*^0,
                         Ced[2, 2, 1, 3] -> 0*^0,
                         Ced[2, 2, 2, 1] -> 0*^0,
                         Ced[2, 2, 2, 2] -> 0*^0,
                         Ced[2, 2, 2, 3] -> 0*^0,
                         Ced[2, 2, 3, 1] -> 0*^0,
                         Ced[2, 2, 3, 2] -> 0*^0,
                         Ced[2, 2, 3, 3] -> 0*^0,
                         Ced[2, 3, 1, 1] -> 0*^0,
                         Ced[2, 3, 1, 2] -> 0*^0,
                         Ced[2, 3, 1, 3] -> 0*^0,
                         Ced[2, 3, 2, 1] -> 0*^0,
                         Ced[2, 3, 2, 2] -> 0*^0,
                         Ced[2, 3, 2, 3] -> 0*^0,
                         Ced[2, 3, 3, 1] -> 0*^0,
                         Ced[2, 3, 3, 2] -> 0*^0,
                         Ced[2, 3, 3, 3] -> 0*^0,
                         Ced[3, 1, 1, 1] -> 0*^0,
                         Ced[3, 1, 1, 2] -> 0*^0,
                         Ced[3, 1, 1, 3] -> 0*^0,
                         Ced[3, 1, 2, 1] -> 0*^0,
                         Ced[3, 1, 2, 2] -> 0*^0,
                         Ced[3, 1, 2, 3] -> 0*^0,
                         Ced[3, 1, 3, 1] -> 0*^0,
                         Ced[3, 1, 3, 2] -> 0*^0,
                         Ced[3, 1, 3, 3] -> 0*^0,
                         Ced[3, 2, 1, 1] -> 0*^0,
                         Ced[3, 2, 1, 2] -> 0*^0,
                         Ced[3, 2, 1, 3] -> 0*^0,
                         Ced[3, 2, 2, 1] -> 0*^0,
                         Ced[3, 2, 2, 2] -> 0*^0,
                         Ced[3, 2, 2, 3] -> 0*^0,
                         Ced[3, 2, 3, 1] -> 0*^0,
                         Ced[3, 2, 3, 2] -> 0*^0,
                         Ced[3, 2, 3, 3] -> 0*^0,
                         Ced[3, 3, 1, 1] -> 0*^0,
                         Ced[3, 3, 1, 2] -> 0*^0,
                         Ced[3, 3, 1, 3] -> 0*^0,
                         Ced[3, 3, 2, 1] -> 0*^0,
                         Ced[3, 3, 2, 2] -> 0*^0,
                         Ced[3, 3, 2, 3] -> 0*^0,
                         Ced[3, 3, 3, 1] -> 0*^0,
                         Ced[3, 3, 3, 2] -> 0*^0,
                         Ced[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ed],
    Description      -> "Qed coupling"
    },


 Cee == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cee[1, 1, 1, 1] -> 0*^0,
                         Cee[1, 1, 1, 2] -> 0*^0,
                         Cee[1, 1, 1, 3] -> 0*^0,
                         Cee[1, 1, 2, 1] -> 0*^0,
                         Cee[1, 1, 2, 2] -> 0*^0,
                         Cee[1, 1, 2, 3] -> 0*^0,
                         Cee[1, 1, 3, 1] -> 0*^0,
                         Cee[1, 1, 3, 2] -> 0*^0,
                         Cee[1, 1, 3, 3] -> 0*^0,
                         Cee[1, 2, 1, 1] -> 0*^0,
                         Cee[1, 2, 1, 2] -> 0*^0,
                         Cee[1, 2, 1, 3] -> 0*^0,
                         Cee[1, 2, 2, 1] -> 0*^0,
                         Cee[1, 2, 2, 2] -> 0*^0,
                         Cee[1, 2, 2, 3] -> 0*^0,
                         Cee[1, 2, 3, 1] -> 0*^0,
                         Cee[1, 2, 3, 2] -> 0*^0,
                         Cee[1, 2, 3, 3] -> 0*^0,
                         Cee[1, 3, 1, 1] -> 0*^0,
                         Cee[1, 3, 1, 2] -> 0*^0,
                         Cee[1, 3, 1, 3] -> 0*^0,
                         Cee[1, 3, 2, 1] -> 0*^0,
                         Cee[1, 3, 2, 2] -> 0*^0,
                         Cee[1, 3, 2, 3] -> 0*^0,
                         Cee[1, 3, 3, 1] -> 0*^0,
                         Cee[1, 3, 3, 2] -> 0*^0,
                         Cee[1, 3, 3, 3] -> 0*^0,
                         Cee[2, 1, 1, 1] -> 0*^0,
                         Cee[2, 1, 1, 2] -> 0*^0,
                         Cee[2, 1, 1, 3] -> 0*^0,
                         Cee[2, 1, 2, 1] -> 0*^0,
                         Cee[2, 1, 2, 2] -> 0*^0,
                         Cee[2, 1, 2, 3] -> 0*^0,
                         Cee[2, 1, 3, 1] -> 0*^0,
                         Cee[2, 1, 3, 2] -> 0*^0,
                         Cee[2, 1, 3, 3] -> 0*^0,
                         Cee[2, 2, 1, 1] -> 0*^0,
                         Cee[2, 2, 1, 2] -> 0*^0,
                         Cee[2, 2, 1, 3] -> 0*^0,
                         Cee[2, 2, 2, 1] -> 0*^0,
                         Cee[2, 2, 2, 2] -> 0*^0,
                         Cee[2, 2, 2, 3] -> 0*^0,
                         Cee[2, 2, 3, 1] -> 0*^0,
                         Cee[2, 2, 3, 2] -> 0*^0,
                         Cee[2, 2, 3, 3] -> 0*^0,
                         Cee[2, 3, 1, 1] -> 0*^0,
                         Cee[2, 3, 1, 2] -> 0*^0,
                         Cee[2, 3, 1, 3] -> 0*^0,
                         Cee[2, 3, 2, 1] -> 0*^0,
                         Cee[2, 3, 2, 2] -> 0*^0,
                         Cee[2, 3, 2, 3] -> 0*^0,
                         Cee[2, 3, 3, 1] -> 0*^0,
                         Cee[2, 3, 3, 2] -> 0*^0,
                         Cee[2, 3, 3, 3] -> 0*^0,
                         Cee[3, 1, 1, 1] -> 0*^0,
                         Cee[3, 1, 1, 2] -> 0*^0,
                         Cee[3, 1, 1, 3] -> 0*^0,
                         Cee[3, 1, 2, 1] -> 0*^0,
                         Cee[3, 1, 2, 2] -> 0*^0,
                         Cee[3, 1, 2, 3] -> 0*^0,
                         Cee[3, 1, 3, 1] -> 0*^0,
                         Cee[3, 1, 3, 2] -> 0*^0,
                         Cee[3, 1, 3, 3] -> 0*^0,
                         Cee[3, 2, 1, 1] -> 0*^0,
                         Cee[3, 2, 1, 2] -> 0*^0,
                         Cee[3, 2, 1, 3] -> 0*^0,
                         Cee[3, 2, 2, 1] -> 0*^0,
                         Cee[3, 2, 2, 2] -> 0*^0,
                         Cee[3, 2, 2, 3] -> 0*^0,
                         Cee[3, 2, 3, 1] -> 0*^0,
                         Cee[3, 2, 3, 2] -> 0*^0,
                         Cee[3, 2, 3, 3] -> 0*^0,
                         Cee[3, 3, 1, 1] -> 0*^0,
                         Cee[3, 3, 1, 2] -> 0*^0,
                         Cee[3, 3, 1, 3] -> 0*^0,
                         Cee[3, 3, 2, 1] -> 0*^0,
                         Cee[3, 3, 2, 2] -> 0*^0,
                         Cee[3, 3, 2, 3] -> 0*^0,
                         Cee[3, 3, 3, 1] -> 0*^0,
                         Cee[3, 3, 3, 2] -> 0*^0,
                         Cee[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ee],
    Description      -> "Qee coupling"
    },


 Ceu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Ceu[1, 1, 1, 1] -> 0*^0,
                         Ceu[1, 1, 1, 2] -> 0*^0,
                         Ceu[1, 1, 1, 3] -> 0*^0,
                         Ceu[1, 1, 2, 1] -> 0*^0,
                         Ceu[1, 1, 2, 2] -> 0*^0,
                         Ceu[1, 1, 2, 3] -> 0*^0,
                         Ceu[1, 1, 3, 1] -> 0*^0,
                         Ceu[1, 1, 3, 2] -> 0*^0,
                         Ceu[1, 1, 3, 3] -> 0*^0,
                         Ceu[1, 2, 1, 1] -> 0*^0,
                         Ceu[1, 2, 1, 2] -> 0*^0,
                         Ceu[1, 2, 1, 3] -> 0*^0,
                         Ceu[1, 2, 2, 1] -> 0*^0,
                         Ceu[1, 2, 2, 2] -> 0*^0,
                         Ceu[1, 2, 2, 3] -> 0*^0,
                         Ceu[1, 2, 3, 1] -> 0*^0,
                         Ceu[1, 2, 3, 2] -> 0*^0,
                         Ceu[1, 2, 3, 3] -> 0*^0,
                         Ceu[1, 3, 1, 1] -> 0*^0,
                         Ceu[1, 3, 1, 2] -> 0*^0,
                         Ceu[1, 3, 1, 3] -> 0*^0,
                         Ceu[1, 3, 2, 1] -> 0*^0,
                         Ceu[1, 3, 2, 2] -> 0*^0,
                         Ceu[1, 3, 2, 3] -> 0*^0,
                         Ceu[1, 3, 3, 1] -> 0*^0,
                         Ceu[1, 3, 3, 2] -> 0*^0,
                         Ceu[1, 3, 3, 3] -> 0*^0,
                         Ceu[2, 1, 1, 1] -> 0*^0,
                         Ceu[2, 1, 1, 2] -> 0*^0,
                         Ceu[2, 1, 1, 3] -> 0*^0,
                         Ceu[2, 1, 2, 1] -> 0*^0,
                         Ceu[2, 1, 2, 2] -> 0*^0,
                         Ceu[2, 1, 2, 3] -> 0*^0,
                         Ceu[2, 1, 3, 1] -> 0*^0,
                         Ceu[2, 1, 3, 2] -> 0*^0,
                         Ceu[2, 1, 3, 3] -> 0*^0,
                         Ceu[2, 2, 1, 1] -> 0*^0,
                         Ceu[2, 2, 1, 2] -> 0*^0,
                         Ceu[2, 2, 1, 3] -> 0*^0,
                         Ceu[2, 2, 2, 1] -> 0*^0,
                         Ceu[2, 2, 2, 2] -> 0*^0,
                         Ceu[2, 2, 2, 3] -> 0*^0,
                         Ceu[2, 2, 3, 1] -> 0*^0,
                         Ceu[2, 2, 3, 2] -> 0*^0,
                         Ceu[2, 2, 3, 3] -> 0*^0,
                         Ceu[2, 3, 1, 1] -> 0*^0,
                         Ceu[2, 3, 1, 2] -> 0*^0,
                         Ceu[2, 3, 1, 3] -> 0*^0,
                         Ceu[2, 3, 2, 1] -> 0*^0,
                         Ceu[2, 3, 2, 2] -> 0*^0,
                         Ceu[2, 3, 2, 3] -> 0*^0,
                         Ceu[2, 3, 3, 1] -> 0*^0,
                         Ceu[2, 3, 3, 2] -> 0*^0,
                         Ceu[2, 3, 3, 3] -> 0*^0,
                         Ceu[3, 1, 1, 1] -> 0*^0,
                         Ceu[3, 1, 1, 2] -> 0*^0,
                         Ceu[3, 1, 1, 3] -> 0*^0,
                         Ceu[3, 1, 2, 1] -> 0*^0,
                         Ceu[3, 1, 2, 2] -> 0*^0,
                         Ceu[3, 1, 2, 3] -> 0*^0,
                         Ceu[3, 1, 3, 1] -> 0*^0,
                         Ceu[3, 1, 3, 2] -> 0*^0,
                         Ceu[3, 1, 3, 3] -> 0*^0,
                         Ceu[3, 2, 1, 1] -> 0*^0,
                         Ceu[3, 2, 1, 2] -> 0*^0,
                         Ceu[3, 2, 1, 3] -> 0*^0,
                         Ceu[3, 2, 2, 1] -> 0*^0,
                         Ceu[3, 2, 2, 2] -> 0*^0,
                         Ceu[3, 2, 2, 3] -> 0*^0,
                         Ceu[3, 2, 3, 1] -> 0*^0,
                         Ceu[3, 2, 3, 2] -> 0*^0,
                         Ceu[3, 2, 3, 3] -> 0*^0,
                         Ceu[3, 3, 1, 1] -> 0*^0,
                         Ceu[3, 3, 1, 2] -> 0*^0,
                         Ceu[3, 3, 1, 3] -> 0*^0,
                         Ceu[3, 3, 2, 1] -> 0*^0,
                         Ceu[3, 3, 2, 2] -> 0*^0,
                         Ceu[3, 3, 2, 3] -> 0*^0,
                         Ceu[3, 3, 3, 1] -> 0*^0,
                         Ceu[3, 3, 3, 2] -> 0*^0,
                         Ceu[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, eu],
    Description      -> "Qeu coupling"
    },


 Cld == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cld[1, 1, 1, 1] -> 0*^0,
                         Cld[1, 1, 1, 2] -> 0*^0,
                         Cld[1, 1, 1, 3] -> 0*^0,
                         Cld[1, 1, 2, 1] -> 0*^0,
                         Cld[1, 1, 2, 2] -> 0*^0,
                         Cld[1, 1, 2, 3] -> 0*^0,
                         Cld[1, 1, 3, 1] -> 0*^0,
                         Cld[1, 1, 3, 2] -> 0*^0,
                         Cld[1, 1, 3, 3] -> 0*^0,
                         Cld[1, 2, 1, 1] -> 0*^0,
                         Cld[1, 2, 1, 2] -> 0*^0,
                         Cld[1, 2, 1, 3] -> 0*^0,
                         Cld[1, 2, 2, 1] -> 0*^0,
                         Cld[1, 2, 2, 2] -> 0*^0,
                         Cld[1, 2, 2, 3] -> 0*^0,
                         Cld[1, 2, 3, 1] -> 0*^0,
                         Cld[1, 2, 3, 2] -> 0*^0,
                         Cld[1, 2, 3, 3] -> 0*^0,
                         Cld[1, 3, 1, 1] -> 0*^0,
                         Cld[1, 3, 1, 2] -> 0*^0,
                         Cld[1, 3, 1, 3] -> 0*^0,
                         Cld[1, 3, 2, 1] -> 0*^0,
                         Cld[1, 3, 2, 2] -> 0*^0,
                         Cld[1, 3, 2, 3] -> 0*^0,
                         Cld[1, 3, 3, 1] -> 0*^0,
                         Cld[1, 3, 3, 2] -> 0*^0,
                         Cld[1, 3, 3, 3] -> 0*^0,
                         Cld[2, 1, 1, 1] -> 0*^0,
                         Cld[2, 1, 1, 2] -> 0*^0,
                         Cld[2, 1, 1, 3] -> 0*^0,
                         Cld[2, 1, 2, 1] -> 0*^0,
                         Cld[2, 1, 2, 2] -> 0*^0,
                         Cld[2, 1, 2, 3] -> 0*^0,
                         Cld[2, 1, 3, 1] -> 0*^0,
                         Cld[2, 1, 3, 2] -> 0*^0,
                         Cld[2, 1, 3, 3] -> 0*^0,
                         Cld[2, 2, 1, 1] -> 0*^0,
                         Cld[2, 2, 1, 2] -> 0*^0,
                         Cld[2, 2, 1, 3] -> 0*^0,
                         Cld[2, 2, 2, 1] -> 0*^0,
                         Cld[2, 2, 2, 2] -> 0*^0,
                         Cld[2, 2, 2, 3] -> 0*^0,
                         Cld[2, 2, 3, 1] -> 0*^0,
                         Cld[2, 2, 3, 2] -> 0*^0,
                         Cld[2, 2, 3, 3] -> 0*^0,
                         Cld[2, 3, 1, 1] -> 0*^0,
                         Cld[2, 3, 1, 2] -> 0*^0,
                         Cld[2, 3, 1, 3] -> 0*^0,
                         Cld[2, 3, 2, 1] -> 0*^0,
                         Cld[2, 3, 2, 2] -> 0*^0,
                         Cld[2, 3, 2, 3] -> 0*^0,
                         Cld[2, 3, 3, 1] -> 0*^0,
                         Cld[2, 3, 3, 2] -> 0*^0,
                         Cld[2, 3, 3, 3] -> 0*^0,
                         Cld[3, 1, 1, 1] -> 0*^0,
                         Cld[3, 1, 1, 2] -> 0*^0,
                         Cld[3, 1, 1, 3] -> 0*^0,
                         Cld[3, 1, 2, 1] -> 0*^0,
                         Cld[3, 1, 2, 2] -> 0*^0,
                         Cld[3, 1, 2, 3] -> 0*^0,
                         Cld[3, 1, 3, 1] -> 0*^0,
                         Cld[3, 1, 3, 2] -> 0*^0,
                         Cld[3, 1, 3, 3] -> 0*^0,
                         Cld[3, 2, 1, 1] -> 0*^0,
                         Cld[3, 2, 1, 2] -> 0*^0,
                         Cld[3, 2, 1, 3] -> 0*^0,
                         Cld[3, 2, 2, 1] -> 0*^0,
                         Cld[3, 2, 2, 2] -> 0*^0,
                         Cld[3, 2, 2, 3] -> 0*^0,
                         Cld[3, 2, 3, 1] -> 0*^0,
                         Cld[3, 2, 3, 2] -> 0*^0,
                         Cld[3, 2, 3, 3] -> 0*^0,
                         Cld[3, 3, 1, 1] -> 0*^0,
                         Cld[3, 3, 1, 2] -> 0*^0,
                         Cld[3, 3, 1, 3] -> 0*^0,
                         Cld[3, 3, 2, 1] -> 0*^0,
                         Cld[3, 3, 2, 2] -> 0*^0,
                         Cld[3, 3, 2, 3] -> 0*^0,
                         Cld[3, 3, 3, 1] -> 0*^0,
                         Cld[3, 3, 3, 2] -> 0*^0,
                         Cld[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ld],
    Description      -> "Qld coupling"
    },


 Cle == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cle[1, 1, 1, 1] -> 0*^0,
                         Cle[1, 1, 1, 2] -> 0*^0,
                         Cle[1, 1, 1, 3] -> 0*^0,
                         Cle[1, 1, 2, 1] -> 0*^0,
                         Cle[1, 1, 2, 2] -> 0*^0,
                         Cle[1, 1, 2, 3] -> 0*^0,
                         Cle[1, 1, 3, 1] -> 0*^0,
                         Cle[1, 1, 3, 2] -> 0*^0,
                         Cle[1, 1, 3, 3] -> 0*^0,
                         Cle[1, 2, 1, 1] -> 0*^0,
                         Cle[1, 2, 1, 2] -> 0*^0,
                         Cle[1, 2, 1, 3] -> 0*^0,
                         Cle[1, 2, 2, 1] -> 0*^0,
                         Cle[1, 2, 2, 2] -> 0*^0,
                         Cle[1, 2, 2, 3] -> 0*^0,
                         Cle[1, 2, 3, 1] -> 0*^0,
                         Cle[1, 2, 3, 2] -> 0*^0,
                         Cle[1, 2, 3, 3] -> 0*^0,
                         Cle[1, 3, 1, 1] -> 0*^0,
                         Cle[1, 3, 1, 2] -> 0*^0,
                         Cle[1, 3, 1, 3] -> 0*^0,
                         Cle[1, 3, 2, 1] -> 0*^0,
                         Cle[1, 3, 2, 2] -> 0*^0,
                         Cle[1, 3, 2, 3] -> 0*^0,
                         Cle[1, 3, 3, 1] -> 0*^0,
                         Cle[1, 3, 3, 2] -> 0*^0,
                         Cle[1, 3, 3, 3] -> 0*^0,
                         Cle[2, 1, 1, 1] -> 0*^0,
                         Cle[2, 1, 1, 2] -> 0*^0,
                         Cle[2, 1, 1, 3] -> 0*^0,
                         Cle[2, 1, 2, 1] -> 0*^0,
                         Cle[2, 1, 2, 2] -> 0*^0,
                         Cle[2, 1, 2, 3] -> 0*^0,
                         Cle[2, 1, 3, 1] -> 0*^0,
                         Cle[2, 1, 3, 2] -> 0*^0,
                         Cle[2, 1, 3, 3] -> 0*^0,
                         Cle[2, 2, 1, 1] -> 0*^0,
                         Cle[2, 2, 1, 2] -> 0*^0,
                         Cle[2, 2, 1, 3] -> 0*^0,
                         Cle[2, 2, 2, 1] -> 0*^0,
                         Cle[2, 2, 2, 2] -> 0*^0,
                         Cle[2, 2, 2, 3] -> 0*^0,
                         Cle[2, 2, 3, 1] -> 0*^0,
                         Cle[2, 2, 3, 2] -> 0*^0,
                         Cle[2, 2, 3, 3] -> 0*^0,
                         Cle[2, 3, 1, 1] -> 0*^0,
                         Cle[2, 3, 1, 2] -> 0*^0,
                         Cle[2, 3, 1, 3] -> 0*^0,
                         Cle[2, 3, 2, 1] -> 0*^0,
                         Cle[2, 3, 2, 2] -> 0*^0,
                         Cle[2, 3, 2, 3] -> 0*^0,
                         Cle[2, 3, 3, 1] -> 0*^0,
                         Cle[2, 3, 3, 2] -> 0*^0,
                         Cle[2, 3, 3, 3] -> 0*^0,
                         Cle[3, 1, 1, 1] -> 0*^0,
                         Cle[3, 1, 1, 2] -> 0*^0,
                         Cle[3, 1, 1, 3] -> 0*^0,
                         Cle[3, 1, 2, 1] -> 0*^0,
                         Cle[3, 1, 2, 2] -> 0*^0,
                         Cle[3, 1, 2, 3] -> 0*^0,
                         Cle[3, 1, 3, 1] -> 0*^0,
                         Cle[3, 1, 3, 2] -> 0*^0,
                         Cle[3, 1, 3, 3] -> 0*^0,
                         Cle[3, 2, 1, 1] -> 0*^0,
                         Cle[3, 2, 1, 2] -> 0*^0,
                         Cle[3, 2, 1, 3] -> 0*^0,
                         Cle[3, 2, 2, 1] -> 0*^0,
                         Cle[3, 2, 2, 2] -> 0*^0,
                         Cle[3, 2, 2, 3] -> 0*^0,
                         Cle[3, 2, 3, 1] -> 0*^0,
                         Cle[3, 2, 3, 2] -> 0*^0,
                         Cle[3, 2, 3, 3] -> 0*^0,
                         Cle[3, 3, 1, 1] -> 0*^0,
                         Cle[3, 3, 1, 2] -> 0*^0,
                         Cle[3, 3, 1, 3] -> 0*^0,
                         Cle[3, 3, 2, 1] -> 0*^0,
                         Cle[3, 3, 2, 2] -> 0*^0,
                         Cle[3, 3, 2, 3] -> 0*^0,
                         Cle[3, 3, 3, 1] -> 0*^0,
                         Cle[3, 3, 3, 2] -> 0*^0,
                         Cle[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, le],
    Description      -> "Qle coupling"
    },


 Cledq == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cledq[1, 1, 1, 1] -> 0*^0,
                         Cledq[1, 1, 1, 2] -> 0*^0,
                         Cledq[1, 1, 1, 3] -> 0*^0,
                         Cledq[1, 1, 2, 1] -> 0*^0,
                         Cledq[1, 1, 2, 2] -> 0*^0,
                         Cledq[1, 1, 2, 3] -> 0*^0,
                         Cledq[1, 1, 3, 1] -> 0*^0,
                         Cledq[1, 1, 3, 2] -> 0*^0,
                         Cledq[1, 1, 3, 3] -> 0*^0,
                         Cledq[1, 2, 1, 1] -> 0*^0,
                         Cledq[1, 2, 1, 2] -> 0*^0,
                         Cledq[1, 2, 1, 3] -> 0*^0,
                         Cledq[1, 2, 2, 1] -> 0*^0,
                         Cledq[1, 2, 2, 2] -> 0*^0,
                         Cledq[1, 2, 2, 3] -> 0*^0,
                         Cledq[1, 2, 3, 1] -> 0*^0,
                         Cledq[1, 2, 3, 2] -> 0*^0,
                         Cledq[1, 2, 3, 3] -> 0*^0,
                         Cledq[1, 3, 1, 1] -> 0*^0,
                         Cledq[1, 3, 1, 2] -> 0*^0,
                         Cledq[1, 3, 1, 3] -> 0*^0,
                         Cledq[1, 3, 2, 1] -> 0*^0,
                         Cledq[1, 3, 2, 2] -> 0*^0,
                         Cledq[1, 3, 2, 3] -> 0*^0,
                         Cledq[1, 3, 3, 1] -> 0*^0,
                         Cledq[1, 3, 3, 2] -> 0*^0,
                         Cledq[1, 3, 3, 3] -> 0*^0,
                         Cledq[2, 1, 1, 1] -> 0*^0,
                         Cledq[2, 1, 1, 2] -> 0*^0,
                         Cledq[2, 1, 1, 3] -> 0*^0,
                         Cledq[2, 1, 2, 1] -> 0*^0,
                         Cledq[2, 1, 2, 2] -> 0*^0,
                         Cledq[2, 1, 2, 3] -> 0*^0,
                         Cledq[2, 1, 3, 1] -> 0*^0,
                         Cledq[2, 1, 3, 2] -> 0*^0,
                         Cledq[2, 1, 3, 3] -> 0*^0,
                         Cledq[2, 2, 1, 1] -> 0*^0,
                         Cledq[2, 2, 1, 2] -> 0*^0,
                         Cledq[2, 2, 1, 3] -> 0*^0,
                         Cledq[2, 2, 2, 1] -> 0*^0,
                         Cledq[2, 2, 2, 2] -> 0*^0,
                         Cledq[2, 2, 2, 3] -> 0*^0,
                         Cledq[2, 2, 3, 1] -> 0*^0,
                         Cledq[2, 2, 3, 2] -> 0*^0,
                         Cledq[2, 2, 3, 3] -> 0*^0,
                         Cledq[2, 3, 1, 1] -> 0*^0,
                         Cledq[2, 3, 1, 2] -> 0*^0,
                         Cledq[2, 3, 1, 3] -> 0*^0,
                         Cledq[2, 3, 2, 1] -> 0*^0,
                         Cledq[2, 3, 2, 2] -> 0*^0,
                         Cledq[2, 3, 2, 3] -> 0*^0,
                         Cledq[2, 3, 3, 1] -> 0*^0,
                         Cledq[2, 3, 3, 2] -> 0*^0,
                         Cledq[2, 3, 3, 3] -> 0*^0,
                         Cledq[3, 1, 1, 1] -> 0*^0,
                         Cledq[3, 1, 1, 2] -> 0*^0,
                         Cledq[3, 1, 1, 3] -> 0*^0,
                         Cledq[3, 1, 2, 1] -> 0*^0,
                         Cledq[3, 1, 2, 2] -> 0*^0,
                         Cledq[3, 1, 2, 3] -> 0*^0,
                         Cledq[3, 1, 3, 1] -> 0*^0,
                         Cledq[3, 1, 3, 2] -> 0*^0,
                         Cledq[3, 1, 3, 3] -> 0*^0,
                         Cledq[3, 2, 1, 1] -> 0*^0,
                         Cledq[3, 2, 1, 2] -> 0*^0,
                         Cledq[3, 2, 1, 3] -> 0*^0,
                         Cledq[3, 2, 2, 1] -> 0*^0,
                         Cledq[3, 2, 2, 2] -> 0*^0,
                         Cledq[3, 2, 2, 3] -> 0*^0,
                         Cledq[3, 2, 3, 1] -> 0*^0,
                         Cledq[3, 2, 3, 2] -> 0*^0,
                         Cledq[3, 2, 3, 3] -> 0*^0,
                         Cledq[3, 3, 1, 1] -> 0*^0,
                         Cledq[3, 3, 1, 2] -> 0*^0,
                         Cledq[3, 3, 1, 3] -> 0*^0,
                         Cledq[3, 3, 2, 1] -> 0*^0,
                         Cledq[3, 3, 2, 2] -> 0*^0,
                         Cledq[3, 3, 2, 3] -> 0*^0,
                         Cledq[3, 3, 3, 1] -> 0*^0,
                         Cledq[3, 3, 3, 2] -> 0*^0,
                         Cledq[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ledq],
    Description      -> "Qledq coupling"
    },


 Clequ1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Clequ1[1, 1, 1, 1] -> 0*^0,
                         Clequ1[1, 1, 1, 2] -> 0*^0,
                         Clequ1[1, 1, 1, 3] -> 0*^0,
                         Clequ1[1, 1, 2, 1] -> 0*^0,
                         Clequ1[1, 1, 2, 2] -> 0*^0,
                         Clequ1[1, 1, 2, 3] -> 0*^0,
                         Clequ1[1, 1, 3, 1] -> 0*^0,
                         Clequ1[1, 1, 3, 2] -> 0*^0,
                         Clequ1[1, 1, 3, 3] -> 0*^0,
                         Clequ1[1, 2, 1, 1] -> 0*^0,
                         Clequ1[1, 2, 1, 2] -> 0*^0,
                         Clequ1[1, 2, 1, 3] -> 0*^0,
                         Clequ1[1, 2, 2, 1] -> 0*^0,
                         Clequ1[1, 2, 2, 2] -> 0*^0,
                         Clequ1[1, 2, 2, 3] -> 0*^0,
                         Clequ1[1, 2, 3, 1] -> 0*^0,
                         Clequ1[1, 2, 3, 2] -> 0*^0,
                         Clequ1[1, 2, 3, 3] -> 0*^0,
                         Clequ1[1, 3, 1, 1] -> 0*^0,
                         Clequ1[1, 3, 1, 2] -> 0*^0,
                         Clequ1[1, 3, 1, 3] -> 0*^0,
                         Clequ1[1, 3, 2, 1] -> 0*^0,
                         Clequ1[1, 3, 2, 2] -> 0*^0,
                         Clequ1[1, 3, 2, 3] -> 0*^0,
                         Clequ1[1, 3, 3, 1] -> 0*^0,
                         Clequ1[1, 3, 3, 2] -> 0*^0,
                         Clequ1[1, 3, 3, 3] -> 0*^0,
                         Clequ1[2, 1, 1, 1] -> 0*^0,
                         Clequ1[2, 1, 1, 2] -> 0*^0,
                         Clequ1[2, 1, 1, 3] -> 0*^0,
                         Clequ1[2, 1, 2, 1] -> 0*^0,
                         Clequ1[2, 1, 2, 2] -> 0*^0,
                         Clequ1[2, 1, 2, 3] -> 0*^0,
                         Clequ1[2, 1, 3, 1] -> 0*^0,
                         Clequ1[2, 1, 3, 2] -> 0*^0,
                         Clequ1[2, 1, 3, 3] -> 0*^0,
                         Clequ1[2, 2, 1, 1] -> 0*^0,
                         Clequ1[2, 2, 1, 2] -> 0*^0,
                         Clequ1[2, 2, 1, 3] -> 0*^0,
                         Clequ1[2, 2, 2, 1] -> 0*^0,
                         Clequ1[2, 2, 2, 2] -> 0*^0,
                         Clequ1[2, 2, 2, 3] -> 0*^0,
                         Clequ1[2, 2, 3, 1] -> 0*^0,
                         Clequ1[2, 2, 3, 2] -> 0*^0,
                         Clequ1[2, 2, 3, 3] -> 0*^0,
                         Clequ1[2, 3, 1, 1] -> 0*^0,
                         Clequ1[2, 3, 1, 2] -> 0*^0,
                         Clequ1[2, 3, 1, 3] -> 0*^0,
                         Clequ1[2, 3, 2, 1] -> 0*^0,
                         Clequ1[2, 3, 2, 2] -> 0*^0,
                         Clequ1[2, 3, 2, 3] -> 0*^0,
                         Clequ1[2, 3, 3, 1] -> 0*^0,
                         Clequ1[2, 3, 3, 2] -> 0*^0,
                         Clequ1[2, 3, 3, 3] -> 0*^0,
                         Clequ1[3, 1, 1, 1] -> 0*^0,
                         Clequ1[3, 1, 1, 2] -> 0*^0,
                         Clequ1[3, 1, 1, 3] -> 0*^0,
                         Clequ1[3, 1, 2, 1] -> 0*^0,
                         Clequ1[3, 1, 2, 2] -> 0*^0,
                         Clequ1[3, 1, 2, 3] -> 0*^0,
                         Clequ1[3, 1, 3, 1] -> 0*^0,
                         Clequ1[3, 1, 3, 2] -> 0*^0,
                         Clequ1[3, 1, 3, 3] -> 0*^0,
                         Clequ1[3, 2, 1, 1] -> 0*^0,
                         Clequ1[3, 2, 1, 2] -> 0*^0,
                         Clequ1[3, 2, 1, 3] -> 0*^0,
                         Clequ1[3, 2, 2, 1] -> 0*^0,
                         Clequ1[3, 2, 2, 2] -> 0*^0,
                         Clequ1[3, 2, 2, 3] -> 0*^0,
                         Clequ1[3, 2, 3, 1] -> 0*^0,
                         Clequ1[3, 2, 3, 2] -> 0*^0,
                         Clequ1[3, 2, 3, 3] -> 0*^0,
                         Clequ1[3, 3, 1, 1] -> 0*^0,
                         Clequ1[3, 3, 1, 2] -> 0*^0,
                         Clequ1[3, 3, 1, 3] -> 0*^0,
                         Clequ1[3, 3, 2, 1] -> 0*^0,
                         Clequ1[3, 3, 2, 2] -> 0*^0,
                         Clequ1[3, 3, 2, 3] -> 0*^0,
                         Clequ1[3, 3, 3, 1] -> 0*^0,
                         Clequ1[3, 3, 3, 2] -> 0*^0,
                         Clequ1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, lequ1],
    Description      -> "Qlequ1 coupling"
    },


 Clequ3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Clequ3[1, 1, 1, 1] -> 0*^0,
                         Clequ3[1, 1, 1, 2] -> 0*^0,
                         Clequ3[1, 1, 1, 3] -> 0*^0,
                         Clequ3[1, 1, 2, 1] -> 0*^0,
                         Clequ3[1, 1, 2, 2] -> 0*^0,
                         Clequ3[1, 1, 2, 3] -> 0*^0,
                         Clequ3[1, 1, 3, 1] -> 0*^0,
                         Clequ3[1, 1, 3, 2] -> 0*^0,
                         Clequ3[1, 1, 3, 3] -> 0*^0,
                         Clequ3[1, 2, 1, 1] -> 0*^0,
                         Clequ3[1, 2, 1, 2] -> 0*^0,
                         Clequ3[1, 2, 1, 3] -> 0*^0,
                         Clequ3[1, 2, 2, 1] -> 0*^0,
                         Clequ3[1, 2, 2, 2] -> 0*^0,
                         Clequ3[1, 2, 2, 3] -> 0*^0,
                         Clequ3[1, 2, 3, 1] -> 0*^0,
                         Clequ3[1, 2, 3, 2] -> 0*^0,
                         Clequ3[1, 2, 3, 3] -> 0*^0,
                         Clequ3[1, 3, 1, 1] -> 0*^0,
                         Clequ3[1, 3, 1, 2] -> 0*^0,
                         Clequ3[1, 3, 1, 3] -> 0*^0,
                         Clequ3[1, 3, 2, 1] -> 0*^0,
                         Clequ3[1, 3, 2, 2] -> 0*^0,
                         Clequ3[1, 3, 2, 3] -> 0*^0,
                         Clequ3[1, 3, 3, 1] -> 0*^0,
                         Clequ3[1, 3, 3, 2] -> 0*^0,
                         Clequ3[1, 3, 3, 3] -> 0*^0,
                         Clequ3[2, 1, 1, 1] -> 0*^0,
                         Clequ3[2, 1, 1, 2] -> 0*^0,
                         Clequ3[2, 1, 1, 3] -> 0*^0,
                         Clequ3[2, 1, 2, 1] -> 0*^0,
                         Clequ3[2, 1, 2, 2] -> 0*^0,
                         Clequ3[2, 1, 2, 3] -> 0*^0,
                         Clequ3[2, 1, 3, 1] -> 0*^0,
                         Clequ3[2, 1, 3, 2] -> 0*^0,
                         Clequ3[2, 1, 3, 3] -> 0*^0,
                         Clequ3[2, 2, 1, 1] -> 0*^0,
                         Clequ3[2, 2, 1, 2] -> 0*^0,
                         Clequ3[2, 2, 1, 3] -> 0*^0,
                         Clequ3[2, 2, 2, 1] -> 0*^0,
                         Clequ3[2, 2, 2, 2] -> 0*^0,
                         Clequ3[2, 2, 2, 3] -> 0*^0,
                         Clequ3[2, 2, 3, 1] -> 0*^0,
                         Clequ3[2, 2, 3, 2] -> 0*^0,
                         Clequ3[2, 2, 3, 3] -> 0*^0,
                         Clequ3[2, 3, 1, 1] -> 0*^0,
                         Clequ3[2, 3, 1, 2] -> 0*^0,
                         Clequ3[2, 3, 1, 3] -> 0*^0,
                         Clequ3[2, 3, 2, 1] -> 0*^0,
                         Clequ3[2, 3, 2, 2] -> 0*^0,
                         Clequ3[2, 3, 2, 3] -> 0*^0,
                         Clequ3[2, 3, 3, 1] -> 0*^0,
                         Clequ3[2, 3, 3, 2] -> 0*^0,
                         Clequ3[2, 3, 3, 3] -> 0*^0,
                         Clequ3[3, 1, 1, 1] -> 0*^0,
                         Clequ3[3, 1, 1, 2] -> 0*^0,
                         Clequ3[3, 1, 1, 3] -> 0*^0,
                         Clequ3[3, 1, 2, 1] -> 0*^0,
                         Clequ3[3, 1, 2, 2] -> 0*^0,
                         Clequ3[3, 1, 2, 3] -> 0*^0,
                         Clequ3[3, 1, 3, 1] -> 0*^0,
                         Clequ3[3, 1, 3, 2] -> 0*^0,
                         Clequ3[3, 1, 3, 3] -> 0*^0,
                         Clequ3[3, 2, 1, 1] -> 0*^0,
                         Clequ3[3, 2, 1, 2] -> 0*^0,
                         Clequ3[3, 2, 1, 3] -> 0*^0,
                         Clequ3[3, 2, 2, 1] -> 0*^0,
                         Clequ3[3, 2, 2, 2] -> 0*^0,
                         Clequ3[3, 2, 2, 3] -> 0*^0,
                         Clequ3[3, 2, 3, 1] -> 0*^0,
                         Clequ3[3, 2, 3, 2] -> 0*^0,
                         Clequ3[3, 2, 3, 3] -> 0*^0,
                         Clequ3[3, 3, 1, 1] -> 0*^0,
                         Clequ3[3, 3, 1, 2] -> 0*^0,
                         Clequ3[3, 3, 1, 3] -> 0*^0,
                         Clequ3[3, 3, 2, 1] -> 0*^0,
                         Clequ3[3, 3, 2, 2] -> 0*^0,
                         Clequ3[3, 3, 2, 3] -> 0*^0,
                         Clequ3[3, 3, 3, 1] -> 0*^0,
                         Clequ3[3, 3, 3, 2] -> 0*^0,
                         Clequ3[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, lequ3],
    Description      -> "Qlequ3 coupling"
    },


 Cll == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cll[1, 1, 1, 1] -> 0*^0,
                         Cll[1, 1, 1, 2] -> 0*^0,
                         Cll[1, 1, 1, 3] -> 0*^0,
                         Cll[1, 1, 2, 1] -> 0*^0,
                         Cll[1, 1, 2, 2] -> 0*^0,
                         Cll[1, 1, 2, 3] -> 0*^0,
                         Cll[1, 1, 3, 1] -> 0*^0,
                         Cll[1, 1, 3, 2] -> 0*^0,
                         Cll[1, 1, 3, 3] -> 0*^0,
                         Cll[1, 2, 1, 1] -> 0*^0,
                         Cll[1, 2, 1, 2] -> 0*^0,
                         Cll[1, 2, 1, 3] -> 0*^0,
                         Cll[1, 2, 2, 1] -> 0*^0,
                         Cll[1, 2, 2, 2] -> 0*^0,
                         Cll[1, 2, 2, 3] -> 0*^0,
                         Cll[1, 2, 3, 1] -> 0*^0,
                         Cll[1, 2, 3, 2] -> 0*^0,
                         Cll[1, 2, 3, 3] -> 0*^0,
                         Cll[1, 3, 1, 1] -> 0*^0,
                         Cll[1, 3, 1, 2] -> 0*^0,
                         Cll[1, 3, 1, 3] -> 0*^0,
                         Cll[1, 3, 2, 1] -> 0*^0,
                         Cll[1, 3, 2, 2] -> 0*^0,
                         Cll[1, 3, 2, 3] -> 0*^0,
                         Cll[1, 3, 3, 1] -> 0*^0,
                         Cll[1, 3, 3, 2] -> 0*^0,
                         Cll[1, 3, 3, 3] -> 0*^0,
                         Cll[2, 1, 1, 1] -> 0*^0,
                         Cll[2, 1, 1, 2] -> 0*^0,
                         Cll[2, 1, 1, 3] -> 0*^0,
                         Cll[2, 1, 2, 1] -> 0*^0,
                         Cll[2, 1, 2, 2] -> 0*^0,
                         Cll[2, 1, 2, 3] -> 0*^0,
                         Cll[2, 1, 3, 1] -> 0*^0,
                         Cll[2, 1, 3, 2] -> 0*^0,
                         Cll[2, 1, 3, 3] -> 0*^0,
                         Cll[2, 2, 1, 1] -> 0*^0,
                         Cll[2, 2, 1, 2] -> 0*^0,
                         Cll[2, 2, 1, 3] -> 0*^0,
                         Cll[2, 2, 2, 1] -> 0*^0,
                         Cll[2, 2, 2, 2] -> 0*^0,
                         Cll[2, 2, 2, 3] -> 0*^0,
                         Cll[2, 2, 3, 1] -> 0*^0,
                         Cll[2, 2, 3, 2] -> 0*^0,
                         Cll[2, 2, 3, 3] -> 0*^0,
                         Cll[2, 3, 1, 1] -> 0*^0,
                         Cll[2, 3, 1, 2] -> 0*^0,
                         Cll[2, 3, 1, 3] -> 0*^0,
                         Cll[2, 3, 2, 1] -> 0*^0,
                         Cll[2, 3, 2, 2] -> 0*^0,
                         Cll[2, 3, 2, 3] -> 0*^0,
                         Cll[2, 3, 3, 1] -> 0*^0,
                         Cll[2, 3, 3, 2] -> 0*^0,
                         Cll[2, 3, 3, 3] -> 0*^0,
                         Cll[3, 1, 1, 1] -> 0*^0,
                         Cll[3, 1, 1, 2] -> 0*^0,
                         Cll[3, 1, 1, 3] -> 0*^0,
                         Cll[3, 1, 2, 1] -> 0*^0,
                         Cll[3, 1, 2, 2] -> 0*^0,
                         Cll[3, 1, 2, 3] -> 0*^0,
                         Cll[3, 1, 3, 1] -> 0*^0,
                         Cll[3, 1, 3, 2] -> 0*^0,
                         Cll[3, 1, 3, 3] -> 0*^0,
                         Cll[3, 2, 1, 1] -> 0*^0,
                         Cll[3, 2, 1, 2] -> 0*^0,
                         Cll[3, 2, 1, 3] -> 0*^0,
                         Cll[3, 2, 2, 1] -> 0*^0,
                         Cll[3, 2, 2, 2] -> 0*^0,
                         Cll[3, 2, 2, 3] -> 0*^0,
                         Cll[3, 2, 3, 1] -> 0*^0,
                         Cll[3, 2, 3, 2] -> 0*^0,
                         Cll[3, 2, 3, 3] -> 0*^0,
                         Cll[3, 3, 1, 1] -> 0*^0,
                         Cll[3, 3, 1, 2] -> 0*^0,
                         Cll[3, 3, 1, 3] -> 0*^0,
                         Cll[3, 3, 2, 1] -> 0*^0,
                         Cll[3, 3, 2, 2] -> 0*^0,
                         Cll[3, 3, 2, 3] -> 0*^0,
                         Cll[3, 3, 3, 1] -> 0*^0,
                         Cll[3, 3, 3, 2] -> 0*^0,
                         Cll[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ll],
    Description      -> "Qll coupling"
    },


 Clq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Clq1[1, 1, 1, 1] -> 0*^0,
                         Clq1[1, 1, 1, 2] -> 0*^0,
                         Clq1[1, 1, 1, 3] -> 0*^0,
                         Clq1[1, 1, 2, 1] -> 0*^0,
                         Clq1[1, 1, 2, 2] -> 0*^0,
                         Clq1[1, 1, 2, 3] -> 0*^0,
                         Clq1[1, 1, 3, 1] -> 0*^0,
                         Clq1[1, 1, 3, 2] -> 0*^0,
                         Clq1[1, 1, 3, 3] -> 0*^0,
                         Clq1[1, 2, 1, 1] -> 0*^0,
                         Clq1[1, 2, 1, 2] -> 0*^0,
                         Clq1[1, 2, 1, 3] -> 0*^0,
                         Clq1[1, 2, 2, 1] -> 0*^0,
                         Clq1[1, 2, 2, 2] -> 0*^0,
                         Clq1[1, 2, 2, 3] -> 0*^0,
                         Clq1[1, 2, 3, 1] -> 0*^0,
                         Clq1[1, 2, 3, 2] -> 0*^0,
                         Clq1[1, 2, 3, 3] -> 0*^0,
                         Clq1[1, 3, 1, 1] -> 0*^0,
                         Clq1[1, 3, 1, 2] -> 0*^0,
                         Clq1[1, 3, 1, 3] -> 0*^0,
                         Clq1[1, 3, 2, 1] -> 0*^0,
                         Clq1[1, 3, 2, 2] -> 0*^0,
                         Clq1[1, 3, 2, 3] -> 0*^0,
                         Clq1[1, 3, 3, 1] -> 0*^0,
                         Clq1[1, 3, 3, 2] -> 0*^0,
                         Clq1[1, 3, 3, 3] -> 0*^0,
                         Clq1[2, 1, 1, 1] -> 0*^0,
                         Clq1[2, 1, 1, 2] -> 0*^0,
                         Clq1[2, 1, 1, 3] -> 0*^0,
                         Clq1[2, 1, 2, 1] -> 0*^0,
                         Clq1[2, 1, 2, 2] -> 0*^0,
                         Clq1[2, 1, 2, 3] -> 0*^0,
                         Clq1[2, 1, 3, 1] -> 0*^0,
                         Clq1[2, 1, 3, 2] -> 0*^0,
                         Clq1[2, 1, 3, 3] -> 0*^0,
                         Clq1[2, 2, 1, 1] -> 0*^0,
                         Clq1[2, 2, 1, 2] -> 0*^0,
                         Clq1[2, 2, 1, 3] -> 0*^0,
                         Clq1[2, 2, 2, 1] -> 0*^0,
                         Clq1[2, 2, 2, 2] -> 0*^0,
                         Clq1[2, 2, 2, 3] -> 0*^0,
                         Clq1[2, 2, 3, 1] -> 0*^0,
                         Clq1[2, 2, 3, 2] -> 0*^0,
                         Clq1[2, 2, 3, 3] -> 0*^0,
                         Clq1[2, 3, 1, 1] -> 0*^0,
                         Clq1[2, 3, 1, 2] -> 0*^0,
                         Clq1[2, 3, 1, 3] -> 0*^0,
                         Clq1[2, 3, 2, 1] -> 0*^0,
                         Clq1[2, 3, 2, 2] -> 0*^0,
                         Clq1[2, 3, 2, 3] -> 0*^0,
                         Clq1[2, 3, 3, 1] -> 0*^0,
                         Clq1[2, 3, 3, 2] -> 0*^0,
                         Clq1[2, 3, 3, 3] -> 0*^0,
                         Clq1[3, 1, 1, 1] -> 0*^0,
                         Clq1[3, 1, 1, 2] -> 0*^0,
                         Clq1[3, 1, 1, 3] -> 0*^0,
                         Clq1[3, 1, 2, 1] -> 0*^0,
                         Clq1[3, 1, 2, 2] -> 0*^0,
                         Clq1[3, 1, 2, 3] -> 0*^0,
                         Clq1[3, 1, 3, 1] -> 0*^0,
                         Clq1[3, 1, 3, 2] -> 0*^0,
                         Clq1[3, 1, 3, 3] -> 0*^0,
                         Clq1[3, 2, 1, 1] -> 0*^0,
                         Clq1[3, 2, 1, 2] -> 0*^0,
                         Clq1[3, 2, 1, 3] -> 0*^0,
                         Clq1[3, 2, 2, 1] -> 0*^0,
                         Clq1[3, 2, 2, 2] -> 0*^0,
                         Clq1[3, 2, 2, 3] -> 0*^0,
                         Clq1[3, 2, 3, 1] -> 0*^0,
                         Clq1[3, 2, 3, 2] -> 0*^0,
                         Clq1[3, 2, 3, 3] -> 0*^0,
                         Clq1[3, 3, 1, 1] -> 0*^0,
                         Clq1[3, 3, 1, 2] -> 0*^0,
                         Clq1[3, 3, 1, 3] -> 0*^0,
                         Clq1[3, 3, 2, 1] -> 0*^0,
                         Clq1[3, 3, 2, 2] -> 0*^0,
                         Clq1[3, 3, 2, 3] -> 0*^0,
                         Clq1[3, 3, 3, 1] -> 0*^0,
                         Clq1[3, 3, 3, 2] -> 0*^0,
                         Clq1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, lq1],
    Description      -> "Qlq1 coupling"
    },


 Clq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Clq3[1, 1, 1, 1] -> 0*^0,
                         Clq3[1, 1, 1, 2] -> 0*^0,
                         Clq3[1, 1, 1, 3] -> 0*^0,
                         Clq3[1, 1, 2, 1] -> 0*^0,
                         Clq3[1, 1, 2, 2] -> 0*^0,
                         Clq3[1, 1, 2, 3] -> 0*^0,
                         Clq3[1, 1, 3, 1] -> 0*^0,
                         Clq3[1, 1, 3, 2] -> 0*^0,
                         Clq3[1, 1, 3, 3] -> 0*^0,
                         Clq3[1, 2, 1, 1] -> 0*^0,
                         Clq3[1, 2, 1, 2] -> 0*^0,
                         Clq3[1, 2, 1, 3] -> 0*^0,
                         Clq3[1, 2, 2, 1] -> 0*^0,
                         Clq3[1, 2, 2, 2] -> 0*^0,
                         Clq3[1, 2, 2, 3] -> 0*^0,
                         Clq3[1, 2, 3, 1] -> 0*^0,
                         Clq3[1, 2, 3, 2] -> 0*^0,
                         Clq3[1, 2, 3, 3] -> 0*^0,
                         Clq3[1, 3, 1, 1] -> 0*^0,
                         Clq3[1, 3, 1, 2] -> 0*^0,
                         Clq3[1, 3, 1, 3] -> 0*^0,
                         Clq3[1, 3, 2, 1] -> 0*^0,
                         Clq3[1, 3, 2, 2] -> 0*^0,
                         Clq3[1, 3, 2, 3] -> 0*^0,
                         Clq3[1, 3, 3, 1] -> 0*^0,
                         Clq3[1, 3, 3, 2] -> 0*^0,
                         Clq3[1, 3, 3, 3] -> 0*^0,
                         Clq3[2, 1, 1, 1] -> 0*^0,
                         Clq3[2, 1, 1, 2] -> 0*^0,
                         Clq3[2, 1, 1, 3] -> 0*^0,
                         Clq3[2, 1, 2, 1] -> 0*^0,
                         Clq3[2, 1, 2, 2] -> 0*^0,
                         Clq3[2, 1, 2, 3] -> 0*^0,
                         Clq3[2, 1, 3, 1] -> 0*^0,
                         Clq3[2, 1, 3, 2] -> 0*^0,
                         Clq3[2, 1, 3, 3] -> 0*^0,
                         Clq3[2, 2, 1, 1] -> 0*^0,
                         Clq3[2, 2, 1, 2] -> 0*^0,
                         Clq3[2, 2, 1, 3] -> 0*^0,
                         Clq3[2, 2, 2, 1] -> 0*^0,
                         Clq3[2, 2, 2, 2] -> 0*^0,
                         Clq3[2, 2, 2, 3] -> 0*^0,
                         Clq3[2, 2, 3, 1] -> 0*^0,
                         Clq3[2, 2, 3, 2] -> 0*^0,
                         Clq3[2, 2, 3, 3] -> 0*^0,
                         Clq3[2, 3, 1, 1] -> 0*^0,
                         Clq3[2, 3, 1, 2] -> 0*^0,
                         Clq3[2, 3, 1, 3] -> 0*^0,
                         Clq3[2, 3, 2, 1] -> 0*^0,
                         Clq3[2, 3, 2, 2] -> 0*^0,
                         Clq3[2, 3, 2, 3] -> 0*^0,
                         Clq3[2, 3, 3, 1] -> 0*^0,
                         Clq3[2, 3, 3, 2] -> 0*^0,
                         Clq3[2, 3, 3, 3] -> 0*^0,
                         Clq3[3, 1, 1, 1] -> 0*^0,
                         Clq3[3, 1, 1, 2] -> 0*^0,
                         Clq3[3, 1, 1, 3] -> 0*^0,
                         Clq3[3, 1, 2, 1] -> 0*^0,
                         Clq3[3, 1, 2, 2] -> 0*^0,
                         Clq3[3, 1, 2, 3] -> 0*^0,
                         Clq3[3, 1, 3, 1] -> 0*^0,
                         Clq3[3, 1, 3, 2] -> 0*^0,
                         Clq3[3, 1, 3, 3] -> 0*^0,
                         Clq3[3, 2, 1, 1] -> 0*^0,
                         Clq3[3, 2, 1, 2] -> 0*^0,
                         Clq3[3, 2, 1, 3] -> 0*^0,
                         Clq3[3, 2, 2, 1] -> 0*^0,
                         Clq3[3, 2, 2, 2] -> 0*^0,
                         Clq3[3, 2, 2, 3] -> 0*^0,
                         Clq3[3, 2, 3, 1] -> 0*^0,
                         Clq3[3, 2, 3, 2] -> 0*^0,
                         Clq3[3, 2, 3, 3] -> 0*^0,
                         Clq3[3, 3, 1, 1] -> 0*^0,
                         Clq3[3, 3, 1, 2] -> 0*^0,
                         Clq3[3, 3, 1, 3] -> 0*^0,
                         Clq3[3, 3, 2, 1] -> 0*^0,
                         Clq3[3, 3, 2, 2] -> 0*^0,
                         Clq3[3, 3, 2, 3] -> 0*^0,
                         Clq3[3, 3, 3, 1] -> 0*^0,
                         Clq3[3, 3, 3, 2] -> 0*^0,
                         Clq3[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, lq3],
    Description      -> "Qlq3 coupling"
    },


 Clu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Clu[1, 1, 1, 1] -> 0*^0,
                         Clu[1, 1, 1, 2] -> 0*^0,
                         Clu[1, 1, 1, 3] -> 0*^0,
                         Clu[1, 1, 2, 1] -> 0*^0,
                         Clu[1, 1, 2, 2] -> 0*^0,
                         Clu[1, 1, 2, 3] -> 0*^0,
                         Clu[1, 1, 3, 1] -> 0*^0,
                         Clu[1, 1, 3, 2] -> 0*^0,
                         Clu[1, 1, 3, 3] -> 0*^0,
                         Clu[1, 2, 1, 1] -> 0*^0,
                         Clu[1, 2, 1, 2] -> 0*^0,
                         Clu[1, 2, 1, 3] -> 0*^0,
                         Clu[1, 2, 2, 1] -> 0*^0,
                         Clu[1, 2, 2, 2] -> 0*^0,
                         Clu[1, 2, 2, 3] -> 0*^0,
                         Clu[1, 2, 3, 1] -> 0*^0,
                         Clu[1, 2, 3, 2] -> 0*^0,
                         Clu[1, 2, 3, 3] -> 0*^0,
                         Clu[1, 3, 1, 1] -> 0*^0,
                         Clu[1, 3, 1, 2] -> 0*^0,
                         Clu[1, 3, 1, 3] -> 0*^0,
                         Clu[1, 3, 2, 1] -> 0*^0,
                         Clu[1, 3, 2, 2] -> 0*^0,
                         Clu[1, 3, 2, 3] -> 0*^0,
                         Clu[1, 3, 3, 1] -> 0*^0,
                         Clu[1, 3, 3, 2] -> 0*^0,
                         Clu[1, 3, 3, 3] -> 0*^0,
                         Clu[2, 1, 1, 1] -> 0*^0,
                         Clu[2, 1, 1, 2] -> 0*^0,
                         Clu[2, 1, 1, 3] -> 0*^0,
                         Clu[2, 1, 2, 1] -> 0*^0,
                         Clu[2, 1, 2, 2] -> 0*^0,
                         Clu[2, 1, 2, 3] -> 0*^0,
                         Clu[2, 1, 3, 1] -> 0*^0,
                         Clu[2, 1, 3, 2] -> 0*^0,
                         Clu[2, 1, 3, 3] -> 0*^0,
                         Clu[2, 2, 1, 1] -> 0*^0,
                         Clu[2, 2, 1, 2] -> 0*^0,
                         Clu[2, 2, 1, 3] -> 0*^0,
                         Clu[2, 2, 2, 1] -> 0*^0,
                         Clu[2, 2, 2, 2] -> 0*^0,
                         Clu[2, 2, 2, 3] -> 0*^0,
                         Clu[2, 2, 3, 1] -> 0*^0,
                         Clu[2, 2, 3, 2] -> 0*^0,
                         Clu[2, 2, 3, 3] -> 0*^0,
                         Clu[2, 3, 1, 1] -> 0*^0,
                         Clu[2, 3, 1, 2] -> 0*^0,
                         Clu[2, 3, 1, 3] -> 0*^0,
                         Clu[2, 3, 2, 1] -> 0*^0,
                         Clu[2, 3, 2, 2] -> 0*^0,
                         Clu[2, 3, 2, 3] -> 0*^0,
                         Clu[2, 3, 3, 1] -> 0*^0,
                         Clu[2, 3, 3, 2] -> 0*^0,
                         Clu[2, 3, 3, 3] -> 0*^0,
                         Clu[3, 1, 1, 1] -> 0*^0,
                         Clu[3, 1, 1, 2] -> 0*^0,
                         Clu[3, 1, 1, 3] -> 0*^0,
                         Clu[3, 1, 2, 1] -> 0*^0,
                         Clu[3, 1, 2, 2] -> 0*^0,
                         Clu[3, 1, 2, 3] -> 0*^0,
                         Clu[3, 1, 3, 1] -> 0*^0,
                         Clu[3, 1, 3, 2] -> 0*^0,
                         Clu[3, 1, 3, 3] -> 0*^0,
                         Clu[3, 2, 1, 1] -> 0*^0,
                         Clu[3, 2, 1, 2] -> 0*^0,
                         Clu[3, 2, 1, 3] -> 0*^0,
                         Clu[3, 2, 2, 1] -> 0*^0,
                         Clu[3, 2, 2, 2] -> 0*^0,
                         Clu[3, 2, 2, 3] -> 0*^0,
                         Clu[3, 2, 3, 1] -> 0*^0,
                         Clu[3, 2, 3, 2] -> 0*^0,
                         Clu[3, 2, 3, 3] -> 0*^0,
                         Clu[3, 3, 1, 1] -> 0*^0,
                         Clu[3, 3, 1, 2] -> 0*^0,
                         Clu[3, 3, 1, 3] -> 0*^0,
                         Clu[3, 3, 2, 1] -> 0*^0,
                         Clu[3, 3, 2, 2] -> 0*^0,
                         Clu[3, 3, 2, 3] -> 0*^0,
                         Clu[3, 3, 3, 1] -> 0*^0,
                         Clu[3, 3, 3, 2] -> 0*^0,
                         Clu[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, lu],
    Description      -> "Qlu coupling"
    },


 Cqd1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqd1[1, 1, 1, 1] -> 0*^0,
                         Cqd1[1, 1, 1, 2] -> 0*^0,
                         Cqd1[1, 1, 1, 3] -> 0*^0,
                         Cqd1[1, 1, 2, 1] -> 0*^0,
                         Cqd1[1, 1, 2, 2] -> 0*^0,
                         Cqd1[1, 1, 2, 3] -> 0*^0,
                         Cqd1[1, 1, 3, 1] -> 0*^0,
                         Cqd1[1, 1, 3, 2] -> 0*^0,
                         Cqd1[1, 1, 3, 3] -> 0*^0,
                         Cqd1[1, 2, 1, 1] -> 0*^0,
                         Cqd1[1, 2, 1, 2] -> 0*^0,
                         Cqd1[1, 2, 1, 3] -> 0*^0,
                         Cqd1[1, 2, 2, 1] -> 0*^0,
                         Cqd1[1, 2, 2, 2] -> 0*^0,
                         Cqd1[1, 2, 2, 3] -> 0*^0,
                         Cqd1[1, 2, 3, 1] -> 0*^0,
                         Cqd1[1, 2, 3, 2] -> 0*^0,
                         Cqd1[1, 2, 3, 3] -> 0*^0,
                         Cqd1[1, 3, 1, 1] -> 0*^0,
                         Cqd1[1, 3, 1, 2] -> 0*^0,
                         Cqd1[1, 3, 1, 3] -> 0*^0,
                         Cqd1[1, 3, 2, 1] -> 0*^0,
                         Cqd1[1, 3, 2, 2] -> 0*^0,
                         Cqd1[1, 3, 2, 3] -> 0*^0,
                         Cqd1[1, 3, 3, 1] -> 0*^0,
                         Cqd1[1, 3, 3, 2] -> 0*^0,
                         Cqd1[1, 3, 3, 3] -> 0*^0,
                         Cqd1[2, 1, 1, 1] -> 0*^0,
                         Cqd1[2, 1, 1, 2] -> 0*^0,
                         Cqd1[2, 1, 1, 3] -> 0*^0,
                         Cqd1[2, 1, 2, 1] -> 0*^0,
                         Cqd1[2, 1, 2, 2] -> 0*^0,
                         Cqd1[2, 1, 2, 3] -> 0*^0,
                         Cqd1[2, 1, 3, 1] -> 0*^0,
                         Cqd1[2, 1, 3, 2] -> 0*^0,
                         Cqd1[2, 1, 3, 3] -> 0*^0,
                         Cqd1[2, 2, 1, 1] -> 0*^0,
                         Cqd1[2, 2, 1, 2] -> 0*^0,
                         Cqd1[2, 2, 1, 3] -> 0*^0,
                         Cqd1[2, 2, 2, 1] -> 0*^0,
                         Cqd1[2, 2, 2, 2] -> 0*^0,
                         Cqd1[2, 2, 2, 3] -> 0*^0,
                         Cqd1[2, 2, 3, 1] -> 0*^0,
                         Cqd1[2, 2, 3, 2] -> 0*^0,
                         Cqd1[2, 2, 3, 3] -> 0*^0,
                         Cqd1[2, 3, 1, 1] -> 0*^0,
                         Cqd1[2, 3, 1, 2] -> 0*^0,
                         Cqd1[2, 3, 1, 3] -> 0*^0,
                         Cqd1[2, 3, 2, 1] -> 0*^0,
                         Cqd1[2, 3, 2, 2] -> 0*^0,
                         Cqd1[2, 3, 2, 3] -> 0*^0,
                         Cqd1[2, 3, 3, 1] -> 0*^0,
                         Cqd1[2, 3, 3, 2] -> 0*^0,
                         Cqd1[2, 3, 3, 3] -> 0*^0,
                         Cqd1[3, 1, 1, 1] -> 0*^0,
                         Cqd1[3, 1, 1, 2] -> 0*^0,
                         Cqd1[3, 1, 1, 3] -> 0*^0,
                         Cqd1[3, 1, 2, 1] -> 0*^0,
                         Cqd1[3, 1, 2, 2] -> 0*^0,
                         Cqd1[3, 1, 2, 3] -> 0*^0,
                         Cqd1[3, 1, 3, 1] -> 0*^0,
                         Cqd1[3, 1, 3, 2] -> 0*^0,
                         Cqd1[3, 1, 3, 3] -> 0*^0,
                         Cqd1[3, 2, 1, 1] -> 0*^0,
                         Cqd1[3, 2, 1, 2] -> 0*^0,
                         Cqd1[3, 2, 1, 3] -> 0*^0,
                         Cqd1[3, 2, 2, 1] -> 0*^0,
                         Cqd1[3, 2, 2, 2] -> 0*^0,
                         Cqd1[3, 2, 2, 3] -> 0*^0,
                         Cqd1[3, 2, 3, 1] -> 0*^0,
                         Cqd1[3, 2, 3, 2] -> 0*^0,
                         Cqd1[3, 2, 3, 3] -> 0*^0,
                         Cqd1[3, 3, 1, 1] -> 0*^0,
                         Cqd1[3, 3, 1, 2] -> 0*^0,
                         Cqd1[3, 3, 1, 3] -> 0*^0,
                         Cqd1[3, 3, 2, 1] -> 0*^0,
                         Cqd1[3, 3, 2, 2] -> 0*^0,
                         Cqd1[3, 3, 2, 3] -> 0*^0,
                         Cqd1[3, 3, 3, 1] -> 0*^0,
                         Cqd1[3, 3, 3, 2] -> 0*^0,
                         Cqd1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qd1],
    Description      -> "Qqd1 coupling"
    },


 Cqd8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqd8[1, 1, 1, 1] -> 0*^0,
                         Cqd8[1, 1, 1, 2] -> 0*^0,
                         Cqd8[1, 1, 1, 3] -> 0*^0,
                         Cqd8[1, 1, 2, 1] -> 0*^0,
                         Cqd8[1, 1, 2, 2] -> 0*^0,
                         Cqd8[1, 1, 2, 3] -> 0*^0,
                         Cqd8[1, 1, 3, 1] -> 0*^0,
                         Cqd8[1, 1, 3, 2] -> 0*^0,
                         Cqd8[1, 1, 3, 3] -> 0*^0,
                         Cqd8[1, 2, 1, 1] -> 0*^0,
                         Cqd8[1, 2, 1, 2] -> 0*^0,
                         Cqd8[1, 2, 1, 3] -> 0*^0,
                         Cqd8[1, 2, 2, 1] -> 0*^0,
                         Cqd8[1, 2, 2, 2] -> 0*^0,
                         Cqd8[1, 2, 2, 3] -> 0*^0,
                         Cqd8[1, 2, 3, 1] -> 0*^0,
                         Cqd8[1, 2, 3, 2] -> 0*^0,
                         Cqd8[1, 2, 3, 3] -> 0*^0,
                         Cqd8[1, 3, 1, 1] -> 0*^0,
                         Cqd8[1, 3, 1, 2] -> 0*^0,
                         Cqd8[1, 3, 1, 3] -> 0*^0,
                         Cqd8[1, 3, 2, 1] -> 0*^0,
                         Cqd8[1, 3, 2, 2] -> 0*^0,
                         Cqd8[1, 3, 2, 3] -> 0*^0,
                         Cqd8[1, 3, 3, 1] -> 0*^0,
                         Cqd8[1, 3, 3, 2] -> 0*^0,
                         Cqd8[1, 3, 3, 3] -> 0*^0,
                         Cqd8[2, 1, 1, 1] -> 0*^0,
                         Cqd8[2, 1, 1, 2] -> 0*^0,
                         Cqd8[2, 1, 1, 3] -> 0*^0,
                         Cqd8[2, 1, 2, 1] -> 0*^0,
                         Cqd8[2, 1, 2, 2] -> 0*^0,
                         Cqd8[2, 1, 2, 3] -> 0*^0,
                         Cqd8[2, 1, 3, 1] -> 0*^0,
                         Cqd8[2, 1, 3, 2] -> 0*^0,
                         Cqd8[2, 1, 3, 3] -> 0*^0,
                         Cqd8[2, 2, 1, 1] -> 0*^0,
                         Cqd8[2, 2, 1, 2] -> 0*^0,
                         Cqd8[2, 2, 1, 3] -> 0*^0,
                         Cqd8[2, 2, 2, 1] -> 0*^0,
                         Cqd8[2, 2, 2, 2] -> 0*^0,
                         Cqd8[2, 2, 2, 3] -> 0*^0,
                         Cqd8[2, 2, 3, 1] -> 0*^0,
                         Cqd8[2, 2, 3, 2] -> 0*^0,
                         Cqd8[2, 2, 3, 3] -> 0*^0,
                         Cqd8[2, 3, 1, 1] -> 0*^0,
                         Cqd8[2, 3, 1, 2] -> 0*^0,
                         Cqd8[2, 3, 1, 3] -> 0*^0,
                         Cqd8[2, 3, 2, 1] -> 0*^0,
                         Cqd8[2, 3, 2, 2] -> 0*^0,
                         Cqd8[2, 3, 2, 3] -> 0*^0,
                         Cqd8[2, 3, 3, 1] -> 0*^0,
                         Cqd8[2, 3, 3, 2] -> 0*^0,
                         Cqd8[2, 3, 3, 3] -> 0*^0,
                         Cqd8[3, 1, 1, 1] -> 0*^0,
                         Cqd8[3, 1, 1, 2] -> 0*^0,
                         Cqd8[3, 1, 1, 3] -> 0*^0,
                         Cqd8[3, 1, 2, 1] -> 0*^0,
                         Cqd8[3, 1, 2, 2] -> 0*^0,
                         Cqd8[3, 1, 2, 3] -> 0*^0,
                         Cqd8[3, 1, 3, 1] -> 0*^0,
                         Cqd8[3, 1, 3, 2] -> 0*^0,
                         Cqd8[3, 1, 3, 3] -> 0*^0,
                         Cqd8[3, 2, 1, 1] -> 0*^0,
                         Cqd8[3, 2, 1, 2] -> 0*^0,
                         Cqd8[3, 2, 1, 3] -> 0*^0,
                         Cqd8[3, 2, 2, 1] -> 0*^0,
                         Cqd8[3, 2, 2, 2] -> 0*^0,
                         Cqd8[3, 2, 2, 3] -> 0*^0,
                         Cqd8[3, 2, 3, 1] -> 0*^0,
                         Cqd8[3, 2, 3, 2] -> 0*^0,
                         Cqd8[3, 2, 3, 3] -> 0*^0,
                         Cqd8[3, 3, 1, 1] -> 0*^0,
                         Cqd8[3, 3, 1, 2] -> 0*^0,
                         Cqd8[3, 3, 1, 3] -> 0*^0,
                         Cqd8[3, 3, 2, 1] -> 0*^0,
                         Cqd8[3, 3, 2, 2] -> 0*^0,
                         Cqd8[3, 3, 2, 3] -> 0*^0,
                         Cqd8[3, 3, 3, 1] -> 0*^0,
                         Cqd8[3, 3, 3, 2] -> 0*^0,
                         Cqd8[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qd8],
    Description      -> "Qqd8 coupling"
    },


 Cqe == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqe[1, 1, 1, 1] -> 0*^0,
                         Cqe[1, 1, 1, 2] -> 0*^0,
                         Cqe[1, 1, 1, 3] -> 0*^0,
                         Cqe[1, 1, 2, 1] -> 0*^0,
                         Cqe[1, 1, 2, 2] -> 0*^0,
                         Cqe[1, 1, 2, 3] -> 0*^0,
                         Cqe[1, 1, 3, 1] -> 0*^0,
                         Cqe[1, 1, 3, 2] -> 0*^0,
                         Cqe[1, 1, 3, 3] -> 0*^0,
                         Cqe[1, 2, 1, 1] -> 0*^0,
                         Cqe[1, 2, 1, 2] -> 0*^0,
                         Cqe[1, 2, 1, 3] -> 0*^0,
                         Cqe[1, 2, 2, 1] -> 0*^0,
                         Cqe[1, 2, 2, 2] -> 0*^0,
                         Cqe[1, 2, 2, 3] -> 0*^0,
                         Cqe[1, 2, 3, 1] -> 0*^0,
                         Cqe[1, 2, 3, 2] -> 0*^0,
                         Cqe[1, 2, 3, 3] -> 0*^0,
                         Cqe[1, 3, 1, 1] -> 0*^0,
                         Cqe[1, 3, 1, 2] -> 0*^0,
                         Cqe[1, 3, 1, 3] -> 0*^0,
                         Cqe[1, 3, 2, 1] -> 0*^0,
                         Cqe[1, 3, 2, 2] -> 0*^0,
                         Cqe[1, 3, 2, 3] -> 0*^0,
                         Cqe[1, 3, 3, 1] -> 0*^0,
                         Cqe[1, 3, 3, 2] -> 0*^0,
                         Cqe[1, 3, 3, 3] -> 0*^0,
                         Cqe[2, 1, 1, 1] -> 0*^0,
                         Cqe[2, 1, 1, 2] -> 0*^0,
                         Cqe[2, 1, 1, 3] -> 0*^0,
                         Cqe[2, 1, 2, 1] -> 0*^0,
                         Cqe[2, 1, 2, 2] -> 0*^0,
                         Cqe[2, 1, 2, 3] -> 0*^0,
                         Cqe[2, 1, 3, 1] -> 0*^0,
                         Cqe[2, 1, 3, 2] -> 0*^0,
                         Cqe[2, 1, 3, 3] -> 0*^0,
                         Cqe[2, 2, 1, 1] -> 0*^0,
                         Cqe[2, 2, 1, 2] -> 0*^0,
                         Cqe[2, 2, 1, 3] -> 0*^0,
                         Cqe[2, 2, 2, 1] -> 0*^0,
                         Cqe[2, 2, 2, 2] -> 0*^0,
                         Cqe[2, 2, 2, 3] -> 0*^0,
                         Cqe[2, 2, 3, 1] -> 0*^0,
                         Cqe[2, 2, 3, 2] -> 0*^0,
                         Cqe[2, 2, 3, 3] -> 0*^0,
                         Cqe[2, 3, 1, 1] -> 0*^0,
                         Cqe[2, 3, 1, 2] -> 0*^0,
                         Cqe[2, 3, 1, 3] -> 0*^0,
                         Cqe[2, 3, 2, 1] -> 0*^0,
                         Cqe[2, 3, 2, 2] -> 0*^0,
                         Cqe[2, 3, 2, 3] -> 0*^0,
                         Cqe[2, 3, 3, 1] -> 0*^0,
                         Cqe[2, 3, 3, 2] -> 0*^0,
                         Cqe[2, 3, 3, 3] -> 0*^0,
                         Cqe[3, 1, 1, 1] -> 0*^0,
                         Cqe[3, 1, 1, 2] -> 0*^0,
                         Cqe[3, 1, 1, 3] -> 0*^0,
                         Cqe[3, 1, 2, 1] -> 0*^0,
                         Cqe[3, 1, 2, 2] -> 0*^0,
                         Cqe[3, 1, 2, 3] -> 0*^0,
                         Cqe[3, 1, 3, 1] -> 0*^0,
                         Cqe[3, 1, 3, 2] -> 0*^0,
                         Cqe[3, 1, 3, 3] -> 0*^0,
                         Cqe[3, 2, 1, 1] -> 0*^0,
                         Cqe[3, 2, 1, 2] -> 0*^0,
                         Cqe[3, 2, 1, 3] -> 0*^0,
                         Cqe[3, 2, 2, 1] -> 0*^0,
                         Cqe[3, 2, 2, 2] -> 0*^0,
                         Cqe[3, 2, 2, 3] -> 0*^0,
                         Cqe[3, 2, 3, 1] -> 0*^0,
                         Cqe[3, 2, 3, 2] -> 0*^0,
                         Cqe[3, 2, 3, 3] -> 0*^0,
                         Cqe[3, 3, 1, 1] -> 0*^0,
                         Cqe[3, 3, 1, 2] -> 0*^0,
                         Cqe[3, 3, 1, 3] -> 0*^0,
                         Cqe[3, 3, 2, 1] -> 0*^0,
                         Cqe[3, 3, 2, 2] -> 0*^0,
                         Cqe[3, 3, 2, 3] -> 0*^0,
                         Cqe[3, 3, 3, 1] -> 0*^0,
                         Cqe[3, 3, 3, 2] -> 0*^0,
                         Cqe[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qe],
    Description      -> "Qqe coupling"
    },


 Cqq1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqq1[1, 1, 1, 1] -> 0*^0,
                         Cqq1[1, 1, 1, 2] -> 0*^0,
                         Cqq1[1, 1, 1, 3] -> 0*^0,
                         Cqq1[1, 1, 2, 1] -> 0*^0,
                         Cqq1[1, 1, 2, 2] -> 0*^0,
                         Cqq1[1, 1, 2, 3] -> 0*^0,
                         Cqq1[1, 1, 3, 1] -> 0*^0,
                         Cqq1[1, 1, 3, 2] -> 0*^0,
                         Cqq1[1, 1, 3, 3] -> 0*^0,
                         Cqq1[1, 2, 1, 1] -> 0*^0,
                         Cqq1[1, 2, 1, 2] -> 0*^0,
                         Cqq1[1, 2, 1, 3] -> 0*^0,
                         Cqq1[1, 2, 2, 1] -> 0*^0,
                         Cqq1[1, 2, 2, 2] -> 0*^0,
                         Cqq1[1, 2, 2, 3] -> 0*^0,
                         Cqq1[1, 2, 3, 1] -> 0*^0,
                         Cqq1[1, 2, 3, 2] -> 0*^0,
                         Cqq1[1, 2, 3, 3] -> 0*^0,
                         Cqq1[1, 3, 1, 1] -> 0*^0,
                         Cqq1[1, 3, 1, 2] -> 0*^0,
                         Cqq1[1, 3, 1, 3] -> 0*^0,
                         Cqq1[1, 3, 2, 1] -> 0*^0,
                         Cqq1[1, 3, 2, 2] -> 0*^0,
                         Cqq1[1, 3, 2, 3] -> 0*^0,
                         Cqq1[1, 3, 3, 1] -> 0*^0,
                         Cqq1[1, 3, 3, 2] -> 0*^0,
                         Cqq1[1, 3, 3, 3] -> 0*^0,
                         Cqq1[2, 1, 1, 1] -> 0*^0,
                         Cqq1[2, 1, 1, 2] -> 0*^0,
                         Cqq1[2, 1, 1, 3] -> 0*^0,
                         Cqq1[2, 1, 2, 1] -> 0*^0,
                         Cqq1[2, 1, 2, 2] -> 0*^0,
                         Cqq1[2, 1, 2, 3] -> 0*^0,
                         Cqq1[2, 1, 3, 1] -> 0*^0,
                         Cqq1[2, 1, 3, 2] -> 0*^0,
                         Cqq1[2, 1, 3, 3] -> 0*^0,
                         Cqq1[2, 2, 1, 1] -> 0*^0,
                         Cqq1[2, 2, 1, 2] -> 0*^0,
                         Cqq1[2, 2, 1, 3] -> 0*^0,
                         Cqq1[2, 2, 2, 1] -> 0*^0,
                         Cqq1[2, 2, 2, 2] -> 0*^0,
                         Cqq1[2, 2, 2, 3] -> 0*^0,
                         Cqq1[2, 2, 3, 1] -> 0*^0,
                         Cqq1[2, 2, 3, 2] -> 0*^0,
                         Cqq1[2, 2, 3, 3] -> 0*^0,
                         Cqq1[2, 3, 1, 1] -> 0*^0,
                         Cqq1[2, 3, 1, 2] -> 0*^0,
                         Cqq1[2, 3, 1, 3] -> 0*^0,
                         Cqq1[2, 3, 2, 1] -> 0*^0,
                         Cqq1[2, 3, 2, 2] -> 0*^0,
                         Cqq1[2, 3, 2, 3] -> 0*^0,
                         Cqq1[2, 3, 3, 1] -> 0*^0,
                         Cqq1[2, 3, 3, 2] -> 0*^0,
                         Cqq1[2, 3, 3, 3] -> 0*^0,
                         Cqq1[3, 1, 1, 1] -> 0*^0,
                         Cqq1[3, 1, 1, 2] -> 0*^0,
                         Cqq1[3, 1, 1, 3] -> 0*^0,
                         Cqq1[3, 1, 2, 1] -> 0*^0,
                         Cqq1[3, 1, 2, 2] -> 0*^0,
                         Cqq1[3, 1, 2, 3] -> 0*^0,
                         Cqq1[3, 1, 3, 1] -> 0*^0,
                         Cqq1[3, 1, 3, 2] -> 0*^0,
                         Cqq1[3, 1, 3, 3] -> 0*^0,
                         Cqq1[3, 2, 1, 1] -> 0*^0,
                         Cqq1[3, 2, 1, 2] -> 0*^0,
                         Cqq1[3, 2, 1, 3] -> 0*^0,
                         Cqq1[3, 2, 2, 1] -> 0*^0,
                         Cqq1[3, 2, 2, 2] -> 0*^0,
                         Cqq1[3, 2, 2, 3] -> 0*^0,
                         Cqq1[3, 2, 3, 1] -> 0*^0,
                         Cqq1[3, 2, 3, 2] -> 0*^0,
                         Cqq1[3, 2, 3, 3] -> 0*^0,
                         Cqq1[3, 3, 1, 1] -> 0*^0,
                         Cqq1[3, 3, 1, 2] -> 0*^0,
                         Cqq1[3, 3, 1, 3] -> 0*^0,
                         Cqq1[3, 3, 2, 1] -> 0*^0,
                         Cqq1[3, 3, 2, 2] -> 0*^0,
                         Cqq1[3, 3, 2, 3] -> 0*^0,
                         Cqq1[3, 3, 3, 1] -> 0*^0,
                         Cqq1[3, 3, 3, 2] -> 0*^0,
                         Cqq1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qq1],
    Description      -> "Qqq1 coupling"
    },


 Cqq3 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqq3[1, 1, 1, 1] -> 0*^0,
                         Cqq3[1, 1, 1, 2] -> 0*^0,
                         Cqq3[1, 1, 1, 3] -> 0*^0,
                         Cqq3[1, 1, 2, 1] -> 0*^0,
                         Cqq3[1, 1, 2, 2] -> 0*^0,
                         Cqq3[1, 1, 2, 3] -> 0*^0,
                         Cqq3[1, 1, 3, 1] -> 0*^0,
                         Cqq3[1, 1, 3, 2] -> 0*^0,
                         Cqq3[1, 1, 3, 3] -> 0*^0,
                         Cqq3[1, 2, 1, 1] -> 0*^0,
                         Cqq3[1, 2, 1, 2] -> 0*^0,
                         Cqq3[1, 2, 1, 3] -> 0*^0,
                         Cqq3[1, 2, 2, 1] -> 0*^0,
                         Cqq3[1, 2, 2, 2] -> 0*^0,
                         Cqq3[1, 2, 2, 3] -> 0*^0,
                         Cqq3[1, 2, 3, 1] -> 0*^0,
                         Cqq3[1, 2, 3, 2] -> 0*^0,
                         Cqq3[1, 2, 3, 3] -> 0*^0,
                         Cqq3[1, 3, 1, 1] -> 0*^0,
                         Cqq3[1, 3, 1, 2] -> 0*^0,
                         Cqq3[1, 3, 1, 3] -> 0*^0,
                         Cqq3[1, 3, 2, 1] -> 0*^0,
                         Cqq3[1, 3, 2, 2] -> 0*^0,
                         Cqq3[1, 3, 2, 3] -> 0*^0,
                         Cqq3[1, 3, 3, 1] -> 0*^0,
                         Cqq3[1, 3, 3, 2] -> 0*^0,
                         Cqq3[1, 3, 3, 3] -> 0*^0,
                         Cqq3[2, 1, 1, 1] -> 0*^0,
                         Cqq3[2, 1, 1, 2] -> 0*^0,
                         Cqq3[2, 1, 1, 3] -> 0*^0,
                         Cqq3[2, 1, 2, 1] -> 0*^0,
                         Cqq3[2, 1, 2, 2] -> 0*^0,
                         Cqq3[2, 1, 2, 3] -> 0*^0,
                         Cqq3[2, 1, 3, 1] -> 0*^0,
                         Cqq3[2, 1, 3, 2] -> 0*^0,
                         Cqq3[2, 1, 3, 3] -> 0*^0,
                         Cqq3[2, 2, 1, 1] -> 0*^0,
                         Cqq3[2, 2, 1, 2] -> 0*^0,
                         Cqq3[2, 2, 1, 3] -> 0*^0,
                         Cqq3[2, 2, 2, 1] -> 0*^0,
                         Cqq3[2, 2, 2, 2] -> 0*^0,
                         Cqq3[2, 2, 2, 3] -> 0*^0,
                         Cqq3[2, 2, 3, 1] -> 0*^0,
                         Cqq3[2, 2, 3, 2] -> 0*^0,
                         Cqq3[2, 2, 3, 3] -> 0*^0,
                         Cqq3[2, 3, 1, 1] -> 0*^0,
                         Cqq3[2, 3, 1, 2] -> 0*^0,
                         Cqq3[2, 3, 1, 3] -> 0*^0,
                         Cqq3[2, 3, 2, 1] -> 0*^0,
                         Cqq3[2, 3, 2, 2] -> 0*^0,
                         Cqq3[2, 3, 2, 3] -> 0*^0,
                         Cqq3[2, 3, 3, 1] -> 0*^0,
                         Cqq3[2, 3, 3, 2] -> 0*^0,
                         Cqq3[2, 3, 3, 3] -> 0*^0,
                         Cqq3[3, 1, 1, 1] -> 0*^0,
                         Cqq3[3, 1, 1, 2] -> 0*^0,
                         Cqq3[3, 1, 1, 3] -> 0*^0,
                         Cqq3[3, 1, 2, 1] -> 0*^0,
                         Cqq3[3, 1, 2, 2] -> 0*^0,
                         Cqq3[3, 1, 2, 3] -> 0*^0,
                         Cqq3[3, 1, 3, 1] -> 0*^0,
                         Cqq3[3, 1, 3, 2] -> 0*^0,
                         Cqq3[3, 1, 3, 3] -> 0*^0,
                         Cqq3[3, 2, 1, 1] -> 0*^0,
                         Cqq3[3, 2, 1, 2] -> 0*^0,
                         Cqq3[3, 2, 1, 3] -> 0*^0,
                         Cqq3[3, 2, 2, 1] -> 0*^0,
                         Cqq3[3, 2, 2, 2] -> 0*^0,
                         Cqq3[3, 2, 2, 3] -> 0*^0,
                         Cqq3[3, 2, 3, 1] -> 0*^0,
                         Cqq3[3, 2, 3, 2] -> 0*^0,
                         Cqq3[3, 2, 3, 3] -> 0*^0,
                         Cqq3[3, 3, 1, 1] -> 0*^0,
                         Cqq3[3, 3, 1, 2] -> 0*^0,
                         Cqq3[3, 3, 1, 3] -> 0*^0,
                         Cqq3[3, 3, 2, 1] -> 0*^0,
                         Cqq3[3, 3, 2, 2] -> 0*^0,
                         Cqq3[3, 3, 2, 3] -> 0*^0,
                         Cqq3[3, 3, 3, 1] -> 0*^0,
                         Cqq3[3, 3, 3, 2] -> 0*^0,
                         Cqq3[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qq3],
    Description      -> "Qqq3 coupling"
    },


 Cqqq == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqqq[1, 1, 1, 1] -> 0*^0,
                         Cqqq[1, 1, 1, 2] -> 0*^0,
                         Cqqq[1, 1, 1, 3] -> 0*^0,
                         Cqqq[1, 1, 2, 1] -> 0*^0,
                         Cqqq[1, 1, 2, 2] -> 0*^0,
                         Cqqq[1, 1, 2, 3] -> 0*^0,
                         Cqqq[1, 1, 3, 1] -> 0*^0,
                         Cqqq[1, 1, 3, 2] -> 0*^0,
                         Cqqq[1, 1, 3, 3] -> 0*^0,
                         Cqqq[1, 2, 1, 1] -> 0*^0,
                         Cqqq[1, 2, 1, 2] -> 0*^0,
                         Cqqq[1, 2, 1, 3] -> 0*^0,
                         Cqqq[1, 2, 2, 1] -> 0*^0,
                         Cqqq[1, 2, 2, 2] -> 0*^0,
                         Cqqq[1, 2, 2, 3] -> 0*^0,
                         Cqqq[1, 2, 3, 1] -> 0*^0,
                         Cqqq[1, 2, 3, 2] -> 0*^0,
                         Cqqq[1, 2, 3, 3] -> 0*^0,
                         Cqqq[1, 3, 1, 1] -> 0*^0,
                         Cqqq[1, 3, 1, 2] -> 0*^0,
                         Cqqq[1, 3, 1, 3] -> 0*^0,
                         Cqqq[1, 3, 2, 1] -> 0*^0,
                         Cqqq[1, 3, 2, 2] -> 0*^0,
                         Cqqq[1, 3, 2, 3] -> 0*^0,
                         Cqqq[1, 3, 3, 1] -> 0*^0,
                         Cqqq[1, 3, 3, 2] -> 0*^0,
                         Cqqq[1, 3, 3, 3] -> 0*^0,
                         Cqqq[2, 1, 1, 1] -> 0*^0,
                         Cqqq[2, 1, 1, 2] -> 0*^0,
                         Cqqq[2, 1, 1, 3] -> 0*^0,
                         Cqqq[2, 1, 2, 1] -> 0*^0,
                         Cqqq[2, 1, 2, 2] -> 0*^0,
                         Cqqq[2, 1, 2, 3] -> 0*^0,
                         Cqqq[2, 1, 3, 1] -> 0*^0,
                         Cqqq[2, 1, 3, 2] -> 0*^0,
                         Cqqq[2, 1, 3, 3] -> 0*^0,
                         Cqqq[2, 2, 1, 1] -> 0*^0,
                         Cqqq[2, 2, 1, 2] -> 0*^0,
                         Cqqq[2, 2, 1, 3] -> 0*^0,
                         Cqqq[2, 2, 2, 1] -> 0*^0,
                         Cqqq[2, 2, 2, 2] -> 0*^0,
                         Cqqq[2, 2, 2, 3] -> 0*^0,
                         Cqqq[2, 2, 3, 1] -> 0*^0,
                         Cqqq[2, 2, 3, 2] -> 0*^0,
                         Cqqq[2, 2, 3, 3] -> 0*^0,
                         Cqqq[2, 3, 1, 1] -> 0*^0,
                         Cqqq[2, 3, 1, 2] -> 0*^0,
                         Cqqq[2, 3, 1, 3] -> 0*^0,
                         Cqqq[2, 3, 2, 1] -> 0*^0,
                         Cqqq[2, 3, 2, 2] -> 0*^0,
                         Cqqq[2, 3, 2, 3] -> 0*^0,
                         Cqqq[2, 3, 3, 1] -> 0*^0,
                         Cqqq[2, 3, 3, 2] -> 0*^0,
                         Cqqq[2, 3, 3, 3] -> 0*^0,
                         Cqqq[3, 1, 1, 1] -> 0*^0,
                         Cqqq[3, 1, 1, 2] -> 0*^0,
                         Cqqq[3, 1, 1, 3] -> 0*^0,
                         Cqqq[3, 1, 2, 1] -> 0*^0,
                         Cqqq[3, 1, 2, 2] -> 0*^0,
                         Cqqq[3, 1, 2, 3] -> 0*^0,
                         Cqqq[3, 1, 3, 1] -> 0*^0,
                         Cqqq[3, 1, 3, 2] -> 0*^0,
                         Cqqq[3, 1, 3, 3] -> 0*^0,
                         Cqqq[3, 2, 1, 1] -> 0*^0,
                         Cqqq[3, 2, 1, 2] -> 0*^0,
                         Cqqq[3, 2, 1, 3] -> 0*^0,
                         Cqqq[3, 2, 2, 1] -> 0*^0,
                         Cqqq[3, 2, 2, 2] -> 0*^0,
                         Cqqq[3, 2, 2, 3] -> 0*^0,
                         Cqqq[3, 2, 3, 1] -> 0*^0,
                         Cqqq[3, 2, 3, 2] -> 0*^0,
                         Cqqq[3, 2, 3, 3] -> 0*^0,
                         Cqqq[3, 3, 1, 1] -> 0*^0,
                         Cqqq[3, 3, 1, 2] -> 0*^0,
                         Cqqq[3, 3, 1, 3] -> 0*^0,
                         Cqqq[3, 3, 2, 1] -> 0*^0,
                         Cqqq[3, 3, 2, 2] -> 0*^0,
                         Cqqq[3, 3, 2, 3] -> 0*^0,
                         Cqqq[3, 3, 3, 1] -> 0*^0,
                         Cqqq[3, 3, 3, 2] -> 0*^0,
                         Cqqq[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qqq],
    Description      -> "Qqqq coupling"
    },


 Cqqu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqqu[1, 1, 1, 1] -> 0*^0,
                         Cqqu[1, 1, 1, 2] -> 0*^0,
                         Cqqu[1, 1, 1, 3] -> 0*^0,
                         Cqqu[1, 1, 2, 1] -> 0*^0,
                         Cqqu[1, 1, 2, 2] -> 0*^0,
                         Cqqu[1, 1, 2, 3] -> 0*^0,
                         Cqqu[1, 1, 3, 1] -> 0*^0,
                         Cqqu[1, 1, 3, 2] -> 0*^0,
                         Cqqu[1, 1, 3, 3] -> 0*^0,
                         Cqqu[1, 2, 1, 1] -> 0*^0,
                         Cqqu[1, 2, 1, 2] -> 0*^0,
                         Cqqu[1, 2, 1, 3] -> 0*^0,
                         Cqqu[1, 2, 2, 1] -> 0*^0,
                         Cqqu[1, 2, 2, 2] -> 0*^0,
                         Cqqu[1, 2, 2, 3] -> 0*^0,
                         Cqqu[1, 2, 3, 1] -> 0*^0,
                         Cqqu[1, 2, 3, 2] -> 0*^0,
                         Cqqu[1, 2, 3, 3] -> 0*^0,
                         Cqqu[1, 3, 1, 1] -> 0*^0,
                         Cqqu[1, 3, 1, 2] -> 0*^0,
                         Cqqu[1, 3, 1, 3] -> 0*^0,
                         Cqqu[1, 3, 2, 1] -> 0*^0,
                         Cqqu[1, 3, 2, 2] -> 0*^0,
                         Cqqu[1, 3, 2, 3] -> 0*^0,
                         Cqqu[1, 3, 3, 1] -> 0*^0,
                         Cqqu[1, 3, 3, 2] -> 0*^0,
                         Cqqu[1, 3, 3, 3] -> 0*^0,
                         Cqqu[2, 1, 1, 1] -> 0*^0,
                         Cqqu[2, 1, 1, 2] -> 0*^0,
                         Cqqu[2, 1, 1, 3] -> 0*^0,
                         Cqqu[2, 1, 2, 1] -> 0*^0,
                         Cqqu[2, 1, 2, 2] -> 0*^0,
                         Cqqu[2, 1, 2, 3] -> 0*^0,
                         Cqqu[2, 1, 3, 1] -> 0*^0,
                         Cqqu[2, 1, 3, 2] -> 0*^0,
                         Cqqu[2, 1, 3, 3] -> 0*^0,
                         Cqqu[2, 2, 1, 1] -> 0*^0,
                         Cqqu[2, 2, 1, 2] -> 0*^0,
                         Cqqu[2, 2, 1, 3] -> 0*^0,
                         Cqqu[2, 2, 2, 1] -> 0*^0,
                         Cqqu[2, 2, 2, 2] -> 0*^0,
                         Cqqu[2, 2, 2, 3] -> 0*^0,
                         Cqqu[2, 2, 3, 1] -> 0*^0,
                         Cqqu[2, 2, 3, 2] -> 0*^0,
                         Cqqu[2, 2, 3, 3] -> 0*^0,
                         Cqqu[2, 3, 1, 1] -> 0*^0,
                         Cqqu[2, 3, 1, 2] -> 0*^0,
                         Cqqu[2, 3, 1, 3] -> 0*^0,
                         Cqqu[2, 3, 2, 1] -> 0*^0,
                         Cqqu[2, 3, 2, 2] -> 0*^0,
                         Cqqu[2, 3, 2, 3] -> 0*^0,
                         Cqqu[2, 3, 3, 1] -> 0*^0,
                         Cqqu[2, 3, 3, 2] -> 0*^0,
                         Cqqu[2, 3, 3, 3] -> 0*^0,
                         Cqqu[3, 1, 1, 1] -> 0*^0,
                         Cqqu[3, 1, 1, 2] -> 0*^0,
                         Cqqu[3, 1, 1, 3] -> 0*^0,
                         Cqqu[3, 1, 2, 1] -> 0*^0,
                         Cqqu[3, 1, 2, 2] -> 0*^0,
                         Cqqu[3, 1, 2, 3] -> 0*^0,
                         Cqqu[3, 1, 3, 1] -> 0*^0,
                         Cqqu[3, 1, 3, 2] -> 0*^0,
                         Cqqu[3, 1, 3, 3] -> 0*^0,
                         Cqqu[3, 2, 1, 1] -> 0*^0,
                         Cqqu[3, 2, 1, 2] -> 0*^0,
                         Cqqu[3, 2, 1, 3] -> 0*^0,
                         Cqqu[3, 2, 2, 1] -> 0*^0,
                         Cqqu[3, 2, 2, 2] -> 0*^0,
                         Cqqu[3, 2, 2, 3] -> 0*^0,
                         Cqqu[3, 2, 3, 1] -> 0*^0,
                         Cqqu[3, 2, 3, 2] -> 0*^0,
                         Cqqu[3, 2, 3, 3] -> 0*^0,
                         Cqqu[3, 3, 1, 1] -> 0*^0,
                         Cqqu[3, 3, 1, 2] -> 0*^0,
                         Cqqu[3, 3, 1, 3] -> 0*^0,
                         Cqqu[3, 3, 2, 1] -> 0*^0,
                         Cqqu[3, 3, 2, 2] -> 0*^0,
                         Cqqu[3, 3, 2, 3] -> 0*^0,
                         Cqqu[3, 3, 3, 1] -> 0*^0,
                         Cqqu[3, 3, 3, 2] -> 0*^0,
                         Cqqu[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qqu],
    Description      -> "Qqqu coupling"
    },


 Cqu1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqu1[1, 1, 1, 1] -> 0*^0,
                         Cqu1[1, 1, 1, 2] -> 0*^0,
                         Cqu1[1, 1, 1, 3] -> 0*^0,
                         Cqu1[1, 1, 2, 1] -> 0*^0,
                         Cqu1[1, 1, 2, 2] -> 0*^0,
                         Cqu1[1, 1, 2, 3] -> 0*^0,
                         Cqu1[1, 1, 3, 1] -> 0*^0,
                         Cqu1[1, 1, 3, 2] -> 0*^0,
                         Cqu1[1, 1, 3, 3] -> 0*^0,
                         Cqu1[1, 2, 1, 1] -> 0*^0,
                         Cqu1[1, 2, 1, 2] -> 0*^0,
                         Cqu1[1, 2, 1, 3] -> 0*^0,
                         Cqu1[1, 2, 2, 1] -> 0*^0,
                         Cqu1[1, 2, 2, 2] -> 0*^0,
                         Cqu1[1, 2, 2, 3] -> 0*^0,
                         Cqu1[1, 2, 3, 1] -> 0*^0,
                         Cqu1[1, 2, 3, 2] -> 0*^0,
                         Cqu1[1, 2, 3, 3] -> 0*^0,
                         Cqu1[1, 3, 1, 1] -> 0*^0,
                         Cqu1[1, 3, 1, 2] -> 0*^0,
                         Cqu1[1, 3, 1, 3] -> 0*^0,
                         Cqu1[1, 3, 2, 1] -> 0*^0,
                         Cqu1[1, 3, 2, 2] -> 0*^0,
                         Cqu1[1, 3, 2, 3] -> 0*^0,
                         Cqu1[1, 3, 3, 1] -> 0*^0,
                         Cqu1[1, 3, 3, 2] -> 0*^0,
                         Cqu1[1, 3, 3, 3] -> 0*^0,
                         Cqu1[2, 1, 1, 1] -> 0*^0,
                         Cqu1[2, 1, 1, 2] -> 0*^0,
                         Cqu1[2, 1, 1, 3] -> 0*^0,
                         Cqu1[2, 1, 2, 1] -> 0*^0,
                         Cqu1[2, 1, 2, 2] -> 0*^0,
                         Cqu1[2, 1, 2, 3] -> 0*^0,
                         Cqu1[2, 1, 3, 1] -> 0*^0,
                         Cqu1[2, 1, 3, 2] -> 0*^0,
                         Cqu1[2, 1, 3, 3] -> 0*^0,
                         Cqu1[2, 2, 1, 1] -> 0*^0,
                         Cqu1[2, 2, 1, 2] -> 0*^0,
                         Cqu1[2, 2, 1, 3] -> 0*^0,
                         Cqu1[2, 2, 2, 1] -> 0*^0,
                         Cqu1[2, 2, 2, 2] -> 0*^0,
                         Cqu1[2, 2, 2, 3] -> 0*^0,
                         Cqu1[2, 2, 3, 1] -> 0*^0,
                         Cqu1[2, 2, 3, 2] -> 0*^0,
                         Cqu1[2, 2, 3, 3] -> 0*^0,
                         Cqu1[2, 3, 1, 1] -> 0*^0,
                         Cqu1[2, 3, 1, 2] -> 0*^0,
                         Cqu1[2, 3, 1, 3] -> 0*^0,
                         Cqu1[2, 3, 2, 1] -> 0*^0,
                         Cqu1[2, 3, 2, 2] -> 0*^0,
                         Cqu1[2, 3, 2, 3] -> 0*^0,
                         Cqu1[2, 3, 3, 1] -> 0*^0,
                         Cqu1[2, 3, 3, 2] -> 0*^0,
                         Cqu1[2, 3, 3, 3] -> 0*^0,
                         Cqu1[3, 1, 1, 1] -> 0*^0,
                         Cqu1[3, 1, 1, 2] -> 0*^0,
                         Cqu1[3, 1, 1, 3] -> 0*^0,
                         Cqu1[3, 1, 2, 1] -> 0*^0,
                         Cqu1[3, 1, 2, 2] -> 0*^0,
                         Cqu1[3, 1, 2, 3] -> 0*^0,
                         Cqu1[3, 1, 3, 1] -> 0*^0,
                         Cqu1[3, 1, 3, 2] -> 0*^0,
                         Cqu1[3, 1, 3, 3] -> 0*^0,
                         Cqu1[3, 2, 1, 1] -> 0*^0,
                         Cqu1[3, 2, 1, 2] -> 0*^0,
                         Cqu1[3, 2, 1, 3] -> 0*^0,
                         Cqu1[3, 2, 2, 1] -> 0*^0,
                         Cqu1[3, 2, 2, 2] -> 0*^0,
                         Cqu1[3, 2, 2, 3] -> 0*^0,
                         Cqu1[3, 2, 3, 1] -> 0*^0,
                         Cqu1[3, 2, 3, 2] -> 0*^0,
                         Cqu1[3, 2, 3, 3] -> 0*^0,
                         Cqu1[3, 3, 1, 1] -> 0*^0,
                         Cqu1[3, 3, 1, 2] -> 0*^0,
                         Cqu1[3, 3, 1, 3] -> 0*^0,
                         Cqu1[3, 3, 2, 1] -> 0*^0,
                         Cqu1[3, 3, 2, 2] -> 0*^0,
                         Cqu1[3, 3, 2, 3] -> 0*^0,
                         Cqu1[3, 3, 3, 1] -> 0*^0,
                         Cqu1[3, 3, 3, 2] -> 0*^0,
                         Cqu1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qu1],
    Description      -> "Qqu1 coupling"
    },


 Cqu8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cqu8[1, 1, 1, 1] -> 0*^0,
                         Cqu8[1, 1, 1, 2] -> 0*^0,
                         Cqu8[1, 1, 1, 3] -> 0*^0,
                         Cqu8[1, 1, 2, 1] -> 0*^0,
                         Cqu8[1, 1, 2, 2] -> 0*^0,
                         Cqu8[1, 1, 2, 3] -> 0*^0,
                         Cqu8[1, 1, 3, 1] -> 0*^0,
                         Cqu8[1, 1, 3, 2] -> 0*^0,
                         Cqu8[1, 1, 3, 3] -> 0*^0,
                         Cqu8[1, 2, 1, 1] -> 0*^0,
                         Cqu8[1, 2, 1, 2] -> 0*^0,
                         Cqu8[1, 2, 1, 3] -> 0*^0,
                         Cqu8[1, 2, 2, 1] -> 0*^0,
                         Cqu8[1, 2, 2, 2] -> 0*^0,
                         Cqu8[1, 2, 2, 3] -> 0*^0,
                         Cqu8[1, 2, 3, 1] -> 0*^0,
                         Cqu8[1, 2, 3, 2] -> 0*^0,
                         Cqu8[1, 2, 3, 3] -> 0*^0,
                         Cqu8[1, 3, 1, 1] -> 0*^0,
                         Cqu8[1, 3, 1, 2] -> 0*^0,
                         Cqu8[1, 3, 1, 3] -> 0*^0,
                         Cqu8[1, 3, 2, 1] -> 0*^0,
                         Cqu8[1, 3, 2, 2] -> 0*^0,
                         Cqu8[1, 3, 2, 3] -> 0*^0,
                         Cqu8[1, 3, 3, 1] -> 0*^0,
                         Cqu8[1, 3, 3, 2] -> 0*^0,
                         Cqu8[1, 3, 3, 3] -> 0*^0,
                         Cqu8[2, 1, 1, 1] -> 0*^0,
                         Cqu8[2, 1, 1, 2] -> 0*^0,
                         Cqu8[2, 1, 1, 3] -> 0*^0,
                         Cqu8[2, 1, 2, 1] -> 0*^0,
                         Cqu8[2, 1, 2, 2] -> 0*^0,
                         Cqu8[2, 1, 2, 3] -> 0*^0,
                         Cqu8[2, 1, 3, 1] -> 0*^0,
                         Cqu8[2, 1, 3, 2] -> 0*^0,
                         Cqu8[2, 1, 3, 3] -> 0*^0,
                         Cqu8[2, 2, 1, 1] -> 0*^0,
                         Cqu8[2, 2, 1, 2] -> 0*^0,
                         Cqu8[2, 2, 1, 3] -> 0*^0,
                         Cqu8[2, 2, 2, 1] -> 0*^0,
                         Cqu8[2, 2, 2, 2] -> 0*^0,
                         Cqu8[2, 2, 2, 3] -> 0*^0,
                         Cqu8[2, 2, 3, 1] -> 0*^0,
                         Cqu8[2, 2, 3, 2] -> 0*^0,
                         Cqu8[2, 2, 3, 3] -> 0*^0,
                         Cqu8[2, 3, 1, 1] -> 0*^0,
                         Cqu8[2, 3, 1, 2] -> 0*^0,
                         Cqu8[2, 3, 1, 3] -> 0*^0,
                         Cqu8[2, 3, 2, 1] -> 0*^0,
                         Cqu8[2, 3, 2, 2] -> 0*^0,
                         Cqu8[2, 3, 2, 3] -> 0*^0,
                         Cqu8[2, 3, 3, 1] -> 0*^0,
                         Cqu8[2, 3, 3, 2] -> 0*^0,
                         Cqu8[2, 3, 3, 3] -> 0*^0,
                         Cqu8[3, 1, 1, 1] -> 0*^0,
                         Cqu8[3, 1, 1, 2] -> 0*^0,
                         Cqu8[3, 1, 1, 3] -> 0*^0,
                         Cqu8[3, 1, 2, 1] -> 0*^0,
                         Cqu8[3, 1, 2, 2] -> 0*^0,
                         Cqu8[3, 1, 2, 3] -> 0*^0,
                         Cqu8[3, 1, 3, 1] -> 0*^0,
                         Cqu8[3, 1, 3, 2] -> 0*^0,
                         Cqu8[3, 1, 3, 3] -> 0*^0,
                         Cqu8[3, 2, 1, 1] -> 0*^0,
                         Cqu8[3, 2, 1, 2] -> 0*^0,
                         Cqu8[3, 2, 1, 3] -> 0*^0,
                         Cqu8[3, 2, 2, 1] -> 0*^0,
                         Cqu8[3, 2, 2, 2] -> 0*^0,
                         Cqu8[3, 2, 2, 3] -> 0*^0,
                         Cqu8[3, 2, 3, 1] -> 0*^0,
                         Cqu8[3, 2, 3, 2] -> 0*^0,
                         Cqu8[3, 2, 3, 3] -> 0*^0,
                         Cqu8[3, 3, 1, 1] -> 0*^0,
                         Cqu8[3, 3, 1, 2] -> 0*^0,
                         Cqu8[3, 3, 1, 3] -> 0*^0,
                         Cqu8[3, 3, 2, 1] -> 0*^0,
                         Cqu8[3, 3, 2, 2] -> 0*^0,
                         Cqu8[3, 3, 2, 3] -> 0*^0,
                         Cqu8[3, 3, 3, 1] -> 0*^0,
                         Cqu8[3, 3, 3, 2] -> 0*^0,
                         Cqu8[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, qu8],
    Description      -> "Qqu8 coupling"
    },


 Cquqd1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cquqd1[1, 1, 1, 1] -> 0*^0,
                         Cquqd1[1, 1, 1, 2] -> 0*^0,
                         Cquqd1[1, 1, 1, 3] -> 0*^0,
                         Cquqd1[1, 1, 2, 1] -> 0*^0,
                         Cquqd1[1, 1, 2, 2] -> 0*^0,
                         Cquqd1[1, 1, 2, 3] -> 0*^0,
                         Cquqd1[1, 1, 3, 1] -> 0*^0,
                         Cquqd1[1, 1, 3, 2] -> 0*^0,
                         Cquqd1[1, 1, 3, 3] -> 0*^0,
                         Cquqd1[1, 2, 1, 1] -> 0*^0,
                         Cquqd1[1, 2, 1, 2] -> 0*^0,
                         Cquqd1[1, 2, 1, 3] -> 0*^0,
                         Cquqd1[1, 2, 2, 1] -> 0*^0,
                         Cquqd1[1, 2, 2, 2] -> 0*^0,
                         Cquqd1[1, 2, 2, 3] -> 0*^0,
                         Cquqd1[1, 2, 3, 1] -> 0*^0,
                         Cquqd1[1, 2, 3, 2] -> 0*^0,
                         Cquqd1[1, 2, 3, 3] -> 0*^0,
                         Cquqd1[1, 3, 1, 1] -> 0*^0,
                         Cquqd1[1, 3, 1, 2] -> 0*^0,
                         Cquqd1[1, 3, 1, 3] -> 0*^0,
                         Cquqd1[1, 3, 2, 1] -> 0*^0,
                         Cquqd1[1, 3, 2, 2] -> 0*^0,
                         Cquqd1[1, 3, 2, 3] -> 0*^0,
                         Cquqd1[1, 3, 3, 1] -> 0*^0,
                         Cquqd1[1, 3, 3, 2] -> 0*^0,
                         Cquqd1[1, 3, 3, 3] -> 0*^0,
                         Cquqd1[2, 1, 1, 1] -> 0*^0,
                         Cquqd1[2, 1, 1, 2] -> 0*^0,
                         Cquqd1[2, 1, 1, 3] -> 0*^0,
                         Cquqd1[2, 1, 2, 1] -> 0*^0,
                         Cquqd1[2, 1, 2, 2] -> 0*^0,
                         Cquqd1[2, 1, 2, 3] -> 0*^0,
                         Cquqd1[2, 1, 3, 1] -> 0*^0,
                         Cquqd1[2, 1, 3, 2] -> 0*^0,
                         Cquqd1[2, 1, 3, 3] -> 0*^0,
                         Cquqd1[2, 2, 1, 1] -> 0*^0,
                         Cquqd1[2, 2, 1, 2] -> 0*^0,
                         Cquqd1[2, 2, 1, 3] -> 0*^0,
                         Cquqd1[2, 2, 2, 1] -> 0*^0,
                         Cquqd1[2, 2, 2, 2] -> 0*^0,
                         Cquqd1[2, 2, 2, 3] -> 0*^0,
                         Cquqd1[2, 2, 3, 1] -> 0*^0,
                         Cquqd1[2, 2, 3, 2] -> 0*^0,
                         Cquqd1[2, 2, 3, 3] -> 0*^0,
                         Cquqd1[2, 3, 1, 1] -> 0*^0,
                         Cquqd1[2, 3, 1, 2] -> 0*^0,
                         Cquqd1[2, 3, 1, 3] -> 0*^0,
                         Cquqd1[2, 3, 2, 1] -> 0*^0,
                         Cquqd1[2, 3, 2, 2] -> 0*^0,
                         Cquqd1[2, 3, 2, 3] -> 0*^0,
                         Cquqd1[2, 3, 3, 1] -> 0*^0,
                         Cquqd1[2, 3, 3, 2] -> 0*^0,
                         Cquqd1[2, 3, 3, 3] -> 0*^0,
                         Cquqd1[3, 1, 1, 1] -> 0*^0,
                         Cquqd1[3, 1, 1, 2] -> 0*^0,
                         Cquqd1[3, 1, 1, 3] -> 0*^0,
                         Cquqd1[3, 1, 2, 1] -> 0*^0,
                         Cquqd1[3, 1, 2, 2] -> 0*^0,
                         Cquqd1[3, 1, 2, 3] -> 0*^0,
                         Cquqd1[3, 1, 3, 1] -> 0*^0,
                         Cquqd1[3, 1, 3, 2] -> 0*^0,
                         Cquqd1[3, 1, 3, 3] -> 0*^0,
                         Cquqd1[3, 2, 1, 1] -> 0*^0,
                         Cquqd1[3, 2, 1, 2] -> 0*^0,
                         Cquqd1[3, 2, 1, 3] -> 0*^0,
                         Cquqd1[3, 2, 2, 1] -> 0*^0,
                         Cquqd1[3, 2, 2, 2] -> 0*^0,
                         Cquqd1[3, 2, 2, 3] -> 0*^0,
                         Cquqd1[3, 2, 3, 1] -> 0*^0,
                         Cquqd1[3, 2, 3, 2] -> 0*^0,
                         Cquqd1[3, 2, 3, 3] -> 0*^0,
                         Cquqd1[3, 3, 1, 1] -> 0*^0,
                         Cquqd1[3, 3, 1, 2] -> 0*^0,
                         Cquqd1[3, 3, 1, 3] -> 0*^0,
                         Cquqd1[3, 3, 2, 1] -> 0*^0,
                         Cquqd1[3, 3, 2, 2] -> 0*^0,
                         Cquqd1[3, 3, 2, 3] -> 0*^0,
                         Cquqd1[3, 3, 3, 1] -> 0*^0,
                         Cquqd1[3, 3, 3, 2] -> 0*^0,
                         Cquqd1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, quqd1],
    Description      -> "Qquqd1 coupling"
    },


 Cquqd8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cquqd8[1, 1, 1, 1] -> 0*^0,
                         Cquqd8[1, 1, 1, 2] -> 0*^0,
                         Cquqd8[1, 1, 1, 3] -> 0*^0,
                         Cquqd8[1, 1, 2, 1] -> 0*^0,
                         Cquqd8[1, 1, 2, 2] -> 0*^0,
                         Cquqd8[1, 1, 2, 3] -> 0*^0,
                         Cquqd8[1, 1, 3, 1] -> 0*^0,
                         Cquqd8[1, 1, 3, 2] -> 0*^0,
                         Cquqd8[1, 1, 3, 3] -> 0*^0,
                         Cquqd8[1, 2, 1, 1] -> 0*^0,
                         Cquqd8[1, 2, 1, 2] -> 0*^0,
                         Cquqd8[1, 2, 1, 3] -> 0*^0,
                         Cquqd8[1, 2, 2, 1] -> 0*^0,
                         Cquqd8[1, 2, 2, 2] -> 0*^0,
                         Cquqd8[1, 2, 2, 3] -> 0*^0,
                         Cquqd8[1, 2, 3, 1] -> 0*^0,
                         Cquqd8[1, 2, 3, 2] -> 0*^0,
                         Cquqd8[1, 2, 3, 3] -> 0*^0,
                         Cquqd8[1, 3, 1, 1] -> 0*^0,
                         Cquqd8[1, 3, 1, 2] -> 0*^0,
                         Cquqd8[1, 3, 1, 3] -> 0*^0,
                         Cquqd8[1, 3, 2, 1] -> 0*^0,
                         Cquqd8[1, 3, 2, 2] -> 0*^0,
                         Cquqd8[1, 3, 2, 3] -> 0*^0,
                         Cquqd8[1, 3, 3, 1] -> 0*^0,
                         Cquqd8[1, 3, 3, 2] -> 0*^0,
                         Cquqd8[1, 3, 3, 3] -> 0*^0,
                         Cquqd8[2, 1, 1, 1] -> 0*^0,
                         Cquqd8[2, 1, 1, 2] -> 0*^0,
                         Cquqd8[2, 1, 1, 3] -> 0*^0,
                         Cquqd8[2, 1, 2, 1] -> 0*^0,
                         Cquqd8[2, 1, 2, 2] -> 0*^0,
                         Cquqd8[2, 1, 2, 3] -> 0*^0,
                         Cquqd8[2, 1, 3, 1] -> 0*^0,
                         Cquqd8[2, 1, 3, 2] -> 0*^0,
                         Cquqd8[2, 1, 3, 3] -> 0*^0,
                         Cquqd8[2, 2, 1, 1] -> 0*^0,
                         Cquqd8[2, 2, 1, 2] -> 0*^0,
                         Cquqd8[2, 2, 1, 3] -> 0*^0,
                         Cquqd8[2, 2, 2, 1] -> 0*^0,
                         Cquqd8[2, 2, 2, 2] -> 0*^0,
                         Cquqd8[2, 2, 2, 3] -> 0*^0,
                         Cquqd8[2, 2, 3, 1] -> 0*^0,
                         Cquqd8[2, 2, 3, 2] -> 0*^0,
                         Cquqd8[2, 2, 3, 3] -> 0*^0,
                         Cquqd8[2, 3, 1, 1] -> 0*^0,
                         Cquqd8[2, 3, 1, 2] -> 0*^0,
                         Cquqd8[2, 3, 1, 3] -> 0*^0,
                         Cquqd8[2, 3, 2, 1] -> 0*^0,
                         Cquqd8[2, 3, 2, 2] -> 0*^0,
                         Cquqd8[2, 3, 2, 3] -> 0*^0,
                         Cquqd8[2, 3, 3, 1] -> 0*^0,
                         Cquqd8[2, 3, 3, 2] -> 0*^0,
                         Cquqd8[2, 3, 3, 3] -> 0*^0,
                         Cquqd8[3, 1, 1, 1] -> 0*^0,
                         Cquqd8[3, 1, 1, 2] -> 0*^0,
                         Cquqd8[3, 1, 1, 3] -> 0*^0,
                         Cquqd8[3, 1, 2, 1] -> 0*^0,
                         Cquqd8[3, 1, 2, 2] -> 0*^0,
                         Cquqd8[3, 1, 2, 3] -> 0*^0,
                         Cquqd8[3, 1, 3, 1] -> 0*^0,
                         Cquqd8[3, 1, 3, 2] -> 0*^0,
                         Cquqd8[3, 1, 3, 3] -> 0*^0,
                         Cquqd8[3, 2, 1, 1] -> 0*^0,
                         Cquqd8[3, 2, 1, 2] -> 0*^0,
                         Cquqd8[3, 2, 1, 3] -> 0*^0,
                         Cquqd8[3, 2, 2, 1] -> 0*^0,
                         Cquqd8[3, 2, 2, 2] -> 0*^0,
                         Cquqd8[3, 2, 2, 3] -> 0*^0,
                         Cquqd8[3, 2, 3, 1] -> 0*^0,
                         Cquqd8[3, 2, 3, 2] -> 0*^0,
                         Cquqd8[3, 2, 3, 3] -> 0*^0,
                         Cquqd8[3, 3, 1, 1] -> 0*^0,
                         Cquqd8[3, 3, 1, 2] -> 0*^0,
                         Cquqd8[3, 3, 1, 3] -> 0*^0,
                         Cquqd8[3, 3, 2, 1] -> 0*^0,
                         Cquqd8[3, 3, 2, 2] -> 0*^0,
                         Cquqd8[3, 3, 2, 3] -> 0*^0,
                         Cquqd8[3, 3, 3, 1] -> 0*^0,
                         Cquqd8[3, 3, 3, 2] -> 0*^0,
                         Cquqd8[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, quqd8],
    Description      -> "Qquqd8 coupling"
    },


 Cud1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cud1[1, 1, 1, 1] -> 0*^0,
                         Cud1[1, 1, 1, 2] -> 0*^0,
                         Cud1[1, 1, 1, 3] -> 0*^0,
                         Cud1[1, 1, 2, 1] -> 0*^0,
                         Cud1[1, 1, 2, 2] -> 0*^0,
                         Cud1[1, 1, 2, 3] -> 0*^0,
                         Cud1[1, 1, 3, 1] -> 0*^0,
                         Cud1[1, 1, 3, 2] -> 0*^0,
                         Cud1[1, 1, 3, 3] -> 0*^0,
                         Cud1[1, 2, 1, 1] -> 0*^0,
                         Cud1[1, 2, 1, 2] -> 0*^0,
                         Cud1[1, 2, 1, 3] -> 0*^0,
                         Cud1[1, 2, 2, 1] -> 0*^0,
                         Cud1[1, 2, 2, 2] -> 0*^0,
                         Cud1[1, 2, 2, 3] -> 0*^0,
                         Cud1[1, 2, 3, 1] -> 0*^0,
                         Cud1[1, 2, 3, 2] -> 0*^0,
                         Cud1[1, 2, 3, 3] -> 0*^0,
                         Cud1[1, 3, 1, 1] -> 0*^0,
                         Cud1[1, 3, 1, 2] -> 0*^0,
                         Cud1[1, 3, 1, 3] -> 0*^0,
                         Cud1[1, 3, 2, 1] -> 0*^0,
                         Cud1[1, 3, 2, 2] -> 0*^0,
                         Cud1[1, 3, 2, 3] -> 0*^0,
                         Cud1[1, 3, 3, 1] -> 0*^0,
                         Cud1[1, 3, 3, 2] -> 0*^0,
                         Cud1[1, 3, 3, 3] -> 0*^0,
                         Cud1[2, 1, 1, 1] -> 0*^0,
                         Cud1[2, 1, 1, 2] -> 0*^0,
                         Cud1[2, 1, 1, 3] -> 0*^0,
                         Cud1[2, 1, 2, 1] -> 0*^0,
                         Cud1[2, 1, 2, 2] -> 0*^0,
                         Cud1[2, 1, 2, 3] -> 0*^0,
                         Cud1[2, 1, 3, 1] -> 0*^0,
                         Cud1[2, 1, 3, 2] -> 0*^0,
                         Cud1[2, 1, 3, 3] -> 0*^0,
                         Cud1[2, 2, 1, 1] -> 0*^0,
                         Cud1[2, 2, 1, 2] -> 0*^0,
                         Cud1[2, 2, 1, 3] -> 0*^0,
                         Cud1[2, 2, 2, 1] -> 0*^0,
                         Cud1[2, 2, 2, 2] -> 0*^0,
                         Cud1[2, 2, 2, 3] -> 0*^0,
                         Cud1[2, 2, 3, 1] -> 0*^0,
                         Cud1[2, 2, 3, 2] -> 0*^0,
                         Cud1[2, 2, 3, 3] -> 0*^0,
                         Cud1[2, 3, 1, 1] -> 0*^0,
                         Cud1[2, 3, 1, 2] -> 0*^0,
                         Cud1[2, 3, 1, 3] -> 0*^0,
                         Cud1[2, 3, 2, 1] -> 0*^0,
                         Cud1[2, 3, 2, 2] -> 0*^0,
                         Cud1[2, 3, 2, 3] -> 0*^0,
                         Cud1[2, 3, 3, 1] -> 0*^0,
                         Cud1[2, 3, 3, 2] -> 0*^0,
                         Cud1[2, 3, 3, 3] -> 0*^0,
                         Cud1[3, 1, 1, 1] -> 0*^0,
                         Cud1[3, 1, 1, 2] -> 0*^0,
                         Cud1[3, 1, 1, 3] -> 0*^0,
                         Cud1[3, 1, 2, 1] -> 0*^0,
                         Cud1[3, 1, 2, 2] -> 0*^0,
                         Cud1[3, 1, 2, 3] -> 0*^0,
                         Cud1[3, 1, 3, 1] -> 0*^0,
                         Cud1[3, 1, 3, 2] -> 0*^0,
                         Cud1[3, 1, 3, 3] -> 0*^0,
                         Cud1[3, 2, 1, 1] -> 0*^0,
                         Cud1[3, 2, 1, 2] -> 0*^0,
                         Cud1[3, 2, 1, 3] -> 0*^0,
                         Cud1[3, 2, 2, 1] -> 0*^0,
                         Cud1[3, 2, 2, 2] -> 0*^0,
                         Cud1[3, 2, 2, 3] -> 0*^0,
                         Cud1[3, 2, 3, 1] -> 0*^0,
                         Cud1[3, 2, 3, 2] -> 0*^0,
                         Cud1[3, 2, 3, 3] -> 0*^0,
                         Cud1[3, 3, 1, 1] -> 0*^0,
                         Cud1[3, 3, 1, 2] -> 0*^0,
                         Cud1[3, 3, 1, 3] -> 0*^0,
                         Cud1[3, 3, 2, 1] -> 0*^0,
                         Cud1[3, 3, 2, 2] -> 0*^0,
                         Cud1[3, 3, 2, 3] -> 0*^0,
                         Cud1[3, 3, 3, 1] -> 0*^0,
                         Cud1[3, 3, 3, 2] -> 0*^0,
                         Cud1[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ud1],
    Description      -> "Qud1 coupling"
    },


 Cud8 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cud8[1, 1, 1, 1] -> 0*^0,
                         Cud8[1, 1, 1, 2] -> 0*^0,
                         Cud8[1, 1, 1, 3] -> 0*^0,
                         Cud8[1, 1, 2, 1] -> 0*^0,
                         Cud8[1, 1, 2, 2] -> 0*^0,
                         Cud8[1, 1, 2, 3] -> 0*^0,
                         Cud8[1, 1, 3, 1] -> 0*^0,
                         Cud8[1, 1, 3, 2] -> 0*^0,
                         Cud8[1, 1, 3, 3] -> 0*^0,
                         Cud8[1, 2, 1, 1] -> 0*^0,
                         Cud8[1, 2, 1, 2] -> 0*^0,
                         Cud8[1, 2, 1, 3] -> 0*^0,
                         Cud8[1, 2, 2, 1] -> 0*^0,
                         Cud8[1, 2, 2, 2] -> 0*^0,
                         Cud8[1, 2, 2, 3] -> 0*^0,
                         Cud8[1, 2, 3, 1] -> 0*^0,
                         Cud8[1, 2, 3, 2] -> 0*^0,
                         Cud8[1, 2, 3, 3] -> 0*^0,
                         Cud8[1, 3, 1, 1] -> 0*^0,
                         Cud8[1, 3, 1, 2] -> 0*^0,
                         Cud8[1, 3, 1, 3] -> 0*^0,
                         Cud8[1, 3, 2, 1] -> 0*^0,
                         Cud8[1, 3, 2, 2] -> 0*^0,
                         Cud8[1, 3, 2, 3] -> 0*^0,
                         Cud8[1, 3, 3, 1] -> 0*^0,
                         Cud8[1, 3, 3, 2] -> 0*^0,
                         Cud8[1, 3, 3, 3] -> 0*^0,
                         Cud8[2, 1, 1, 1] -> 0*^0,
                         Cud8[2, 1, 1, 2] -> 0*^0,
                         Cud8[2, 1, 1, 3] -> 0*^0,
                         Cud8[2, 1, 2, 1] -> 0*^0,
                         Cud8[2, 1, 2, 2] -> 0*^0,
                         Cud8[2, 1, 2, 3] -> 0*^0,
                         Cud8[2, 1, 3, 1] -> 0*^0,
                         Cud8[2, 1, 3, 2] -> 0*^0,
                         Cud8[2, 1, 3, 3] -> 0*^0,
                         Cud8[2, 2, 1, 1] -> 0*^0,
                         Cud8[2, 2, 1, 2] -> 0*^0,
                         Cud8[2, 2, 1, 3] -> 0*^0,
                         Cud8[2, 2, 2, 1] -> 0*^0,
                         Cud8[2, 2, 2, 2] -> 0*^0,
                         Cud8[2, 2, 2, 3] -> 0*^0,
                         Cud8[2, 2, 3, 1] -> 0*^0,
                         Cud8[2, 2, 3, 2] -> 0*^0,
                         Cud8[2, 2, 3, 3] -> 0*^0,
                         Cud8[2, 3, 1, 1] -> 0*^0,
                         Cud8[2, 3, 1, 2] -> 0*^0,
                         Cud8[2, 3, 1, 3] -> 0*^0,
                         Cud8[2, 3, 2, 1] -> 0*^0,
                         Cud8[2, 3, 2, 2] -> 0*^0,
                         Cud8[2, 3, 2, 3] -> 0*^0,
                         Cud8[2, 3, 3, 1] -> 0*^0,
                         Cud8[2, 3, 3, 2] -> 0*^0,
                         Cud8[2, 3, 3, 3] -> 0*^0,
                         Cud8[3, 1, 1, 1] -> 0*^0,
                         Cud8[3, 1, 1, 2] -> 0*^0,
                         Cud8[3, 1, 1, 3] -> 0*^0,
                         Cud8[3, 1, 2, 1] -> 0*^0,
                         Cud8[3, 1, 2, 2] -> 0*^0,
                         Cud8[3, 1, 2, 3] -> 0*^0,
                         Cud8[3, 1, 3, 1] -> 0*^0,
                         Cud8[3, 1, 3, 2] -> 0*^0,
                         Cud8[3, 1, 3, 3] -> 0*^0,
                         Cud8[3, 2, 1, 1] -> 0*^0,
                         Cud8[3, 2, 1, 2] -> 0*^0,
                         Cud8[3, 2, 1, 3] -> 0*^0,
                         Cud8[3, 2, 2, 1] -> 0*^0,
                         Cud8[3, 2, 2, 2] -> 0*^0,
                         Cud8[3, 2, 2, 3] -> 0*^0,
                         Cud8[3, 2, 3, 1] -> 0*^0,
                         Cud8[3, 2, 3, 2] -> 0*^0,
                         Cud8[3, 2, 3, 3] -> 0*^0,
                         Cud8[3, 3, 1, 1] -> 0*^0,
                         Cud8[3, 3, 1, 2] -> 0*^0,
                         Cud8[3, 3, 1, 3] -> 0*^0,
                         Cud8[3, 3, 2, 1] -> 0*^0,
                         Cud8[3, 3, 2, 2] -> 0*^0,
                         Cud8[3, 3, 2, 3] -> 0*^0,
                         Cud8[3, 3, 3, 1] -> 0*^0,
                         Cud8[3, 3, 3, 2] -> 0*^0,
                         Cud8[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, ud8],
    Description      -> "Qud8 coupling"
    },


 Cuu == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cuu[1, 1, 1, 1] -> 0*^0,
                         Cuu[1, 1, 1, 2] -> 0*^0,
                         Cuu[1, 1, 1, 3] -> 0*^0,
                         Cuu[1, 1, 2, 1] -> 0*^0,
                         Cuu[1, 1, 2, 2] -> 0*^0,
                         Cuu[1, 1, 2, 3] -> 0*^0,
                         Cuu[1, 1, 3, 1] -> 0*^0,
                         Cuu[1, 1, 3, 2] -> 0*^0,
                         Cuu[1, 1, 3, 3] -> 0*^0,
                         Cuu[1, 2, 1, 1] -> 0*^0,
                         Cuu[1, 2, 1, 2] -> 0*^0,
                         Cuu[1, 2, 1, 3] -> 0*^0,
                         Cuu[1, 2, 2, 1] -> 0*^0,
                         Cuu[1, 2, 2, 2] -> 0*^0,
                         Cuu[1, 2, 2, 3] -> 0*^0,
                         Cuu[1, 2, 3, 1] -> 0*^0,
                         Cuu[1, 2, 3, 2] -> 0*^0,
                         Cuu[1, 2, 3, 3] -> 0*^0,
                         Cuu[1, 3, 1, 1] -> 0*^0,
                         Cuu[1, 3, 1, 2] -> 0*^0,
                         Cuu[1, 3, 1, 3] -> 0*^0,
                         Cuu[1, 3, 2, 1] -> 0*^0,
                         Cuu[1, 3, 2, 2] -> 0*^0,
                         Cuu[1, 3, 2, 3] -> 0*^0,
                         Cuu[1, 3, 3, 1] -> 0*^0,
                         Cuu[1, 3, 3, 2] -> 0*^0,
                         Cuu[1, 3, 3, 3] -> 0*^0,
                         Cuu[2, 1, 1, 1] -> 0*^0,
                         Cuu[2, 1, 1, 2] -> 0*^0,
                         Cuu[2, 1, 1, 3] -> 0*^0,
                         Cuu[2, 1, 2, 1] -> 0*^0,
                         Cuu[2, 1, 2, 2] -> 0*^0,
                         Cuu[2, 1, 2, 3] -> 0*^0,
                         Cuu[2, 1, 3, 1] -> 0*^0,
                         Cuu[2, 1, 3, 2] -> 0*^0,
                         Cuu[2, 1, 3, 3] -> 0*^0,
                         Cuu[2, 2, 1, 1] -> 0*^0,
                         Cuu[2, 2, 1, 2] -> 0*^0,
                         Cuu[2, 2, 1, 3] -> 0*^0,
                         Cuu[2, 2, 2, 1] -> 0*^0,
                         Cuu[2, 2, 2, 2] -> 0*^0,
                         Cuu[2, 2, 2, 3] -> 0*^0,
                         Cuu[2, 2, 3, 1] -> 0*^0,
                         Cuu[2, 2, 3, 2] -> 0*^0,
                         Cuu[2, 2, 3, 3] -> 0*^0,
                         Cuu[2, 3, 1, 1] -> 0*^0,
                         Cuu[2, 3, 1, 2] -> 0*^0,
                         Cuu[2, 3, 1, 3] -> 0*^0,
                         Cuu[2, 3, 2, 1] -> 0*^0,
                         Cuu[2, 3, 2, 2] -> 0*^0,
                         Cuu[2, 3, 2, 3] -> 0*^0,
                         Cuu[2, 3, 3, 1] -> 0*^0,
                         Cuu[2, 3, 3, 2] -> 0*^0,
                         Cuu[2, 3, 3, 3] -> 0*^0,
                         Cuu[3, 1, 1, 1] -> 0*^0,
                         Cuu[3, 1, 1, 2] -> 0*^0,
                         Cuu[3, 1, 1, 3] -> 0*^0,
                         Cuu[3, 1, 2, 1] -> 0*^0,
                         Cuu[3, 1, 2, 2] -> 0*^0,
                         Cuu[3, 1, 2, 3] -> 0*^0,
                         Cuu[3, 1, 3, 1] -> 0*^0,
                         Cuu[3, 1, 3, 2] -> 0*^0,
                         Cuu[3, 1, 3, 3] -> 0*^0,
                         Cuu[3, 2, 1, 1] -> 0*^0,
                         Cuu[3, 2, 1, 2] -> 0*^0,
                         Cuu[3, 2, 1, 3] -> 0*^0,
                         Cuu[3, 2, 2, 1] -> 0*^0,
                         Cuu[3, 2, 2, 2] -> 0*^0,
                         Cuu[3, 2, 2, 3] -> 0*^0,
                         Cuu[3, 2, 3, 1] -> 0*^0,
                         Cuu[3, 2, 3, 2] -> 0*^0,
                         Cuu[3, 2, 3, 3] -> 0*^0,
                         Cuu[3, 3, 1, 1] -> 0*^0,
                         Cuu[3, 3, 1, 2] -> 0*^0,
                         Cuu[3, 3, 1, 3] -> 0*^0,
                         Cuu[3, 3, 2, 1] -> 0*^0,
                         Cuu[3, 3, 2, 2] -> 0*^0,
                         Cuu[3, 3, 2, 3] -> 0*^0,
                         Cuu[3, 3, 3, 1] -> 0*^0,
                         Cuu[3, 3, 3, 2] -> 0*^0,
                         Cuu[3, 3, 3, 3] -> 0*^0},
    TeX              -> Superscript[C, uu],
    Description      -> "Quu coupling"
    },


(* Effective NP scale squared*)

  Lam == {
    ParameterType -> External,
    Value   -> 1,
    TeX           -> 1/\[CapitalLambda]^2,
    Description   -> "Effective NP scale squared"
  }


};

