(* SmeftFR v2.0 package *)
(* main initialization sequence, generation of mass basis Lagrangian
and Feynman rules in Mathematica format *)

Remove["Global`*"];
(*Off[General::stop];*)

(* FeynRules and SmeftFR package installation paths - edit if necessary *)
$FeynRulesPath = FileNameJoin[{"/home","rosiek","FeynRules"}];
SMEFT$MajorVersion      = "2";
SMEFT$MinorVersion      = "01";
SMEFT$Path = FileNameJoin[{$FeynRulesPath, "Models", "SMEFT_" <> 
                SMEFT$MajorVersion <> "_" <> SMEFT$MinorVersion}];
If[ ! DirectoryQ[SMEFT$Path], 
  Print["Directory " <> SMEFT$Path <> "does not exist, please check package setup"];
  Abort[];
];
  

(* Load FeynRules and SMEFT packages *)
Get[ FileNameJoin[{$FeynRulesPath,"FeynRules.m"}] ];
Get[ FileNameJoin[{ SMEFT$Path, "code", "smeft_package.m"}] ];


(* Choose operators to include, full list is:

OpList = { "G", "Gtilde", "W", "Wtilde", "phi", "phiBox", "phiD",
 "phiW", "phiB", "phiWB", "phiWtilde", "phiBtilde", "phiWtildeB",
 "phiGtilde", "phiG", "ephi", "dphi", "uphi", "eW", "eB", "uG", "uW",
 "uB", "dG", "dW", "dB", "phil1", "phil3", "phie", "phiq1", "phiq3",
 "phiu", "phid", "phiud", "ll", "qq1", "qq3", "lq1", "lq3", "ee",
 "uu", "dd", "eu", "ed", "ud1", "ud8", "le", "lu", "ld", "qe", "qu1",
 "qu8", "qd1", "qd8", "ledq", "quqd1", "quqd8", "lequ1", "lequ3",
 "vv", "duq", "qqu", "qqq", "duu" }; 
*)

(* Example of subset of operators (full list leads to lenghty
calculations!) *) 

OpList = {"W", "phiD", "phiWB", "phil1", "vv", "ledq"};

(* file with numerical values of SMEFT parameters in WCxf JSON format,
If equal to "wcxf_default.json" or does not exist, all WCs are by
initialized to 0 *)

WCXFInput = FileNameJoin[{SMEFT$Path, "definitions", "wcxf_example.json"}];

(* initialize time counter and calculate Feynman rules *)
CPUTime = TimeUsed[];

SMEFTInitializeModel[ Operators -> OpList, Gauge -> Rxi, WCXFInitFile -> WCXFInput ];

SMEFTLoadModel[];
Print[Style["Lagrangian generation completed, time = ", Bold ], TimeUsed[] - CPUTime];

SMEFTFindMassBasis[];
Print[Style["Transformations to physical basis calculated, time = ", Bold ], TimeUsed[] - CPUTime];

SMEFTFeynmanRules[];
Print[Style["Feynman rules evaluated, time = ", Bold], TimeUsed[] - CPUTime];

