(* Generated by WCXFToSMEFT routine from the file /home/rosiek/FeynRules/Models/SMEFT_2_01/definitions/wcxf_example.json *)
(* 6.9.2019 19:27 *)


(* Active operators included in Feynman Rules: {ledq, phiD, phil1, phiWB, vv, W} *)

(* SmeftFR v2.0 package *)
(* Contains definitions of SMEFT parameters in mass basis *)

(* ********************************** *)
(* ***** Parameters (SM + dim6) ***** *)
(* ********************************** *)
 
M$Parameters = {
  
(* parametrization of EW numerical input; if necessary update values
of SMEFT$... variables in the file smeft_variables.m *)

  aEWM1 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aeWM1,
    InteractionOrder -> {QED,-2},  
    TeX              -> Superscript[Subscript[\[Alpha],em],-1],
    Description      -> "1/alpha_em at MZ scale"
  },
  aEW == { 
    ParameterType    -> Internal, 
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},  
    TeX              -> Subscript[\[Alpha],em],
    Description      -> "alpha_em at MZ scale"
  },
  ee == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi/SMEFT$aeWM1],
    InteractionOrder -> {QED,1},  
    TeX              -> e, 
    Description      -> "Electric charge e at MZ scale"
  },
  Gf == { 
    ParameterType    -> External, 
    Value            -> SMEFT$Gf,
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,f], 
    Description      -> "Fermi constant"
  },
  sw2 == { 
    ParameterType    -> External, 
    Value            -> SMEFT$sw2, 
    TeX              -> Superscript[Subscript[s,W],2], 
    Description      -> "s_W^2"
  },
  sw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[SMEFT$sw2], 
    TeX              -> Subscript[s,W], 
    Description      -> "s_W"
  },
  cw2 == { 
    ParameterType    -> External, 
    Value            -> 1 - SMEFT$sw2, 
    TeX              -> Superscript[Subscript[c,W],2], 
    Description      -> "c_W^2"
  },
  cw  == { 
    ParameterType    -> External, 
    Value            -> Sqrt[1 - SMEFT$sw2], 
    TeX              -> Subscript[c,W], 
    Description      -> "c_W"
  },
  aS == { 
    ParameterType    -> External, 
    Value            -> SMEFT$aS,
    InteractionOrder -> {QCD,2},  
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "alpha_s at MZ scale"
  },

(* effective gauge coupling constants *)
  G1 == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf SMEFT$sw2/(1 - SMEFT$sw2)], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,1], 
    Description      -> "Effective U(1)Y coupling constant"
  },
  GW == { 
    ParameterType    -> External, 
    Value            -> 2 SMEFT$MW Sqrt[Sqrt[2] SMEFT$Gf], 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[G,W], 
    Description      -> "Effective SU(2) coupling constant"
  },
  GS == { 
    ParameterType    -> External, 
    Value            -> Sqrt[4 Pi SMEFT$aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[G,s], 
    Description      -> "Effective SU(3) coupling constant at the Z pole"
  },

(* Higgs vev and quartic coupling *)
  vev == {
    ParameterType    -> External,
    Value            -> 1/Sqrt[Sqrt[2] SMEFT$Gf], 
    TeX              -> v,
    Description      -> "Higgs vacuum expectation value"
  },
  hlambda == {
    ParameterType    -> External,
    Value            -> Sqrt[2] SMEFT$MH^2 SMEFT$Gf, 
    InteractionOrder -> {QED, 1},
    TeX              -> \[Lambda],
    Description      -> "Higgs quartic coupling"
  },

  
(* auxiliary parameter giving QED Interaction Order = 1 for Yukawa couplings *)
  YO == { 
    ParameterType    -> External, 
    Value            -> 1, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[Y,O], 
    Description      -> "Interaction order for Yukawa/fermion masses"
  },

(* gauge fixing parameters *)

xiW == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],W], 
    Description   -> "W gauge fixing parameter"
  },

xiZ == { 
    ParameterType -> External, 
    ComplexParameter -> False,
    Value            -> 1, 
    TeX           -> Subscript[\[Xi],Z], 
    Description   -> "Z gauge fixing parameter"
  },

xiA == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A], 
    Description   -> "Photon gauge fixing parameter"
  },

xiG == { 
    ParameterType -> External, 
    Value            -> 1, 
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G], 
    Description   -> "Gluon gauge fixing parameter"
  },

  (* unphysical field mass *)
  
  MgZ == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]Z],
    Description      -> "Z ghost mass"
  },

  MgW == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,\[Eta]W],
    Description      -> "W ghost mass"
  },

  MG0 == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,G0],
    Description      -> "G0 mass"
  },

  MGP == {
    ParameterType    -> External,
    Value            -> 1, 
    TeX              -> Subscript[M,GP],
    Description      -> "G+ and G- mass"
  },
  
(* physical flavor mixing *)

(* CKM matrix K = VUL^+ VDL + dim 6 corrections. Here we use pure
Wolfenstein, no dim-6 additions. Parameters are defined at the top of
smeft_variables.m, edit them there if necessary *)

Kq == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {Kq[1,1] -> CKM$mat[[1,1]],
            Kq[1,2] -> CKM$mat[[1,2]], 
            Kq[1,3] -> CKM$mat[[1,3]],
            Kq[2,1] -> CKM$mat[[2,1]],
            Kq[2,2] -> CKM$mat[[2,2]],
            Kq[2,3] -> CKM$mat[[2,3]],
            Kq[3,1] -> CKM$mat[[3,1]],
            Kq[3,2] -> CKM$mat[[3,2]],
            Kq[3,3] -> CKM$mat[[3,3]]},
Unitary -> False,
ComplexParameter -> True,
TeX           -> K,
Description -> "CKM Matrix"
},

(* PMNS matrix U = VLL^+ VVL + dim 6 corrections.  Here no dim-6
additions. Angles and phases are defined at the top of
smeft_variables.m, edit them there if necessary *)

Ul == {
ParameterType -> External,
Indices -> {Index[Generation], Index[Generation]},
Value   -> {Ul[1,1] -> PMNS$mat[[1,1]],
            Ul[1,2] -> PMNS$mat[[1,2]], 
            Ul[1,3] -> PMNS$mat[[1,3]], 
            Ul[2,1] -> PMNS$mat[[2,1]], 
            Ul[2,2] -> PMNS$mat[[2,2]], 
            Ul[2,3] -> PMNS$mat[[2,3]], 
            Ul[3,1] -> PMNS$mat[[3,1]], 
            Ul[3,2] -> PMNS$mat[[3,2]], 
            Ul[3,3] -> PMNS$mat[[3,3]]},
Unitary -> False,
TeX           -> U,
ComplexParameter -> True,
Description -> "PMNS Matrix"
},


(* neutrino masses *)

  v1mass == {
    ParameterType    -> External,
    Value            -> 0.529291*^-6,
    Description      -> "v1 mass"
  },
  v2mass == {
    ParameterType    -> External,
    Value            -> 0.450111*^-6,
    Description      -> "v2 mass"
  },
  v3mass == {
    ParameterType    -> External,
    Value            -> 0.368894*^-6,
    Description      -> "v3 mass"
  },

(* redefined (mass basis) dim-6 couplings *)

(* flavor independent *)

 CphiD == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0.743333*^-8,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]D],
    Description      -> "QphiD coupling"
    },


 CphiWB == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0.307843*^-10,
    ComplexParameter -> False,
    TeX              -> Superscript[C, \[Phi]WB],
    Description      -> "QphiWB coupling"
    },


 CW == {
    ParameterType    -> External,
    Indices          -> {},
    InteractionOrder -> {NP,1},
    Value            -> 0.381851*^-8,
    ComplexParameter -> False,
    TeX              -> Superscript[C, W],
    Description      -> "QW coupling"
    },


(* flavor dependent *)

(* 2 fermion operators *)

 Cphil1 == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cphil1[1, 1] -> 0.59398*^-8,
                         Cphil1[1, 2] -> 0.138656*^-8 + 0.28367*^-8*I,
                         Cphil1[1, 3] -> 0.192956*^-8 + 0.29134*^-8*I,
                         Cphil1[2, 1] -> 0*^0,
                         Cphil1[2, 2] -> 0.590665*^-8,
                         Cphil1[2, 3] -> 0.465319*^-8 + 0.965455*^-8*I,
                         Cphil1[3, 1] -> 0*^0,
                         Cphil1[3, 2] -> 0*^0,
                         Cphil1[3, 3] -> 0.840542*^-8},
    Hermitian        -> True,
    TeX              -> Superscript[C, \[Phi]l1],
    Description      -> "Qphil1 coupling"
    },


 Cvv == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cvv[1, 1] -> 0.619741*^-13 + 0.873048*^-11*I,
                         Cvv[1, 2] -> 0*^0,
                         Cvv[1, 3] -> 0*^0,
                         Cvv[2, 1] -> 0*^0,
                         Cvv[2, 2] -> -0.977992*^-12 + 0.735992*^-11*I,
                         Cvv[2, 3] -> 0*^0,
                         Cvv[3, 1] -> 0*^0,
                         Cvv[3, 2] -> 0*^0,
                         Cvv[3, 3] -> -0.978002*^-12 + 0.600583*^-11*I},
    Hermitian        -> False,
    TeX              -> Superscript[C, vv],
    Description      -> "Qvv coupling"
    },


(* 4 fermion operators *)

 Cledq == {
    ParameterType    -> External,
    Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
    InteractionOrder -> {NP,1},
    Value            -> {Cledq[1, 1, 1, 1] -> 0.558569*^-8 + 0.590302*^-9*I,
                         Cledq[1, 1, 1, 2] -> 0.472397*^-8 + 0.121627*^-9*I,
                         Cledq[1, 1, 1, 3] -> 0.781901*^-8 + 0.724389*^-8*I,
                         Cledq[1, 1, 2, 1] -> 0.266899*^-8 + 0.229546*^-8*I,
                         Cledq[1, 1, 2, 2] -> 0.146348*^-8 + 0.105657*^-8*I,
                         Cledq[1, 1, 2, 3] -> 0.586384*^-8 + 0.236215*^-8*I,
                         Cledq[1, 1, 3, 1] -> 0.371172*^-8 + 0.991563*^-8*I,
                         Cledq[1, 1, 3, 2] -> 0.764518*^-8 + 0.711135*^-8*I,
                         Cledq[1, 1, 3, 3] -> 0.77387*^-8 + 0.129864*^-8*I,
                         Cledq[1, 2, 1, 1] -> 0.734342*^-8 + 0.646314*^-8*I,
                         Cledq[1, 2, 1, 2] -> 0.729125*^-8 + 0.285962*^-8*I,
                         Cledq[1, 2, 1, 3] -> 0.682565*^-9 + 0.219463*^-8*I,
                         Cledq[1, 2, 2, 1] -> 0.942597*^-8 + 0.654263*^-9*I,
                         Cledq[1, 2, 2, 2] -> 0.496573*^-8 + 0.931858*^-9*I,
                         Cledq[1, 2, 2, 3] -> 0.460078*^-8 + 0.546559*^-9*I,
                         Cledq[1, 2, 3, 1] -> 0.975917*^-8 + 0.449424*^-9*I,
                         Cledq[1, 2, 3, 2] -> 0.322281*^-8 + 0.235688*^-8*I,
                         Cledq[1, 2, 3, 3] -> 0.274834*^-8 + 0.819806*^-8*I,
                         Cledq[1, 3, 1, 1] -> 0.721043*^-9 + 0.941429*^-8*I,
                         Cledq[1, 3, 1, 2] -> 0.701653*^-8 + 0.591896*^-8*I,
                         Cledq[1, 3, 1, 3] -> 0.515998*^-8 + 0.587143*^-8*I,
                         Cledq[1, 3, 2, 1] -> 0.638116*^-8 + 0.855238*^-8*I,
                         Cledq[1, 3, 2, 2] -> 0.906191*^-8 + 0.815802*^-8*I,
                         Cledq[1, 3, 2, 3] -> 0.180654*^-8 + 0.984345*^-9*I,
                         Cledq[1, 3, 3, 1] -> 0.341271*^-8 + 0.498388*^-8*I,
                         Cledq[1, 3, 3, 2] -> 0.248802*^-8 + 0.526869*^-8*I,
                         Cledq[1, 3, 3, 3] -> 0.326803*^-8 + 0.268645*^-8*I,
                         Cledq[2, 1, 1, 1] -> 0.853479*^-8 + 0.482078*^-8*I,
                         Cledq[2, 1, 1, 2] -> 0.251745*^-8 + 0.635039*^-8*I,
                         Cledq[2, 1, 1, 3] -> 0.832006*^-8 + 0.521207*^-8*I,
                         Cledq[2, 1, 2, 1] -> 0.385922*^-8 + 0.296348*^-8*I,
                         Cledq[2, 1, 2, 2] -> 0.740958*^-8 + 0.228976*^-8*I,
                         Cledq[2, 1, 2, 3] -> 0.371658*^-10 + 0.957911*^-8*I,
                         Cledq[2, 1, 3, 1] -> 0.7714*^-8 + 0.162478*^-8*I,
                         Cledq[2, 1, 3, 2] -> 0.138474*^-8 + 0.785843*^-8*I,
                         Cledq[2, 1, 3, 3] -> 0.562483*^-8 + 0.947126*^-8*I,
                         Cledq[2, 2, 1, 1] -> 0.636052*^-8 + 0.86115*^-8*I,
                         Cledq[2, 2, 1, 2] -> 0.267204*^-8 + 0.546887*^-8*I,
                         Cledq[2, 2, 1, 3] -> 0.952914*^-8 + 0.18011*^-8*I,
                         Cledq[2, 2, 2, 1] -> 0.682165*^-8 + 0.172595*^-8*I,
                         Cledq[2, 2, 2, 2] -> 0.49541*^-8 + 0.865351*^-8*I,
                         Cledq[2, 2, 2, 3] -> 0.118683*^-8 + 0.877498*^-9*I,
                         Cledq[2, 2, 3, 1] -> 0.477716*^-8 + 0.769973*^-8*I,
                         Cledq[2, 2, 3, 2] -> 0.21841*^-8 + 0.185646*^-8*I,
                         Cledq[2, 2, 3, 3] -> 0.896597*^-8 + 0.915849*^-9*I,
                         Cledq[2, 3, 1, 1] -> 0.699549*^-8 + 0.666785*^-8*I,
                         Cledq[2, 3, 1, 2] -> 0.858143*^-8 + 0.745303*^-8*I,
                         Cledq[2, 3, 1, 3] -> 0.279111*^-8 + 0.500778*^-8*I,
                         Cledq[2, 3, 2, 1] -> 0.682512*^-8 + 0.401957*^-8*I,
                         Cledq[2, 3, 2, 2] -> 0.560862*^-8 + 0.591418*^-8*I,
                         Cledq[2, 3, 2, 3] -> 0.431324*^-8 + 0.289523*^-8*I,
                         Cledq[2, 3, 3, 1] -> 0.844397*^-8 + 0.185521*^-9*I,
                         Cledq[2, 3, 3, 2] -> 0.165828*^-8 + 0.139363*^-8*I,
                         Cledq[2, 3, 3, 3] -> 0.568321*^-8 + 0.409037*^-8*I,
                         Cledq[3, 1, 1, 1] -> 0.233302*^-8 + 0.645428*^-8*I,
                         Cledq[3, 1, 1, 2] -> 0.715577*^-8 + 0.996881*^-8*I,
                         Cledq[3, 1, 1, 3] -> 0.799145*^-8 + 0.217672*^-9*I,
                         Cledq[3, 1, 2, 1] -> 0.748384*^-8 + 0.389407*^-8*I,
                         Cledq[3, 1, 2, 2] -> 0.18528*^-8 + 0.302829*^-8*I,
                         Cledq[3, 1, 2, 3] -> 0.657859*^-8 + 0.467947*^-8*I,
                         Cledq[3, 1, 3, 1] -> 0.277214*^-8 + 0.673642*^-8*I,
                         Cledq[3, 1, 3, 2] -> 0.703334*^-8 + 0.424661*^-8*I,
                         Cledq[3, 1, 3, 3] -> 0.349475*^-8 + 0.861876*^-9*I,
                         Cledq[3, 2, 1, 1] -> 0.849848*^-8 + 0.741251*^-8*I,
                         Cledq[3, 2, 1, 2] -> 0.296574*^-8 + 0.927358*^-8*I,
                         Cledq[3, 2, 1, 3] -> 0.340082*^-8 + 0.183722*^-8*I,
                         Cledq[3, 2, 2, 1] -> 0.936349*^-8 + 0.139835*^-8*I,
                         Cledq[3, 2, 2, 2] -> 0.908669*^-9 + 0.142005*^-8*I,
                         Cledq[3, 2, 2, 3] -> 0.307453*^-8 + 0.448088*^-8*I,
                         Cledq[3, 2, 3, 1] -> 0.938981*^-8 + 0.430183*^-8*I,
                         Cledq[3, 2, 3, 2] -> 0.97516*^-8 + 0.688274*^-8*I,
                         Cledq[3, 2, 3, 3] -> 0.259218*^-8 + 0.988496*^-8*I,
                         Cledq[3, 3, 1, 1] -> 0.957331*^-8 + 0.946184*^-8*I,
                         Cledq[3, 3, 1, 2] -> 0.218404*^-8 + 0.321348*^-8*I,
                         Cledq[3, 3, 1, 3] -> 0.830501*^-8 + 0.611913*^-8*I,
                         Cledq[3, 3, 2, 1] -> 0.216701*^-8 + 0.670943*^-9*I,
                         Cledq[3, 3, 2, 2] -> 0.795833*^-8 + 0.177196*^-8*I,
                         Cledq[3, 3, 2, 3] -> 0.970461*^-8 + 0.609277*^-8*I,
                         Cledq[3, 3, 3, 1] -> 0.145061*^-8 + 0.153798*^-8*I,
                         Cledq[3, 3, 3, 2] -> 0.110948*^-8 + 0.229875*^-9*I,
                         Cledq[3, 3, 3, 3] -> 0.192172*^-9 + 0.789466*^-8*I},
    TeX              -> Superscript[C, ledq],
    Description      -> "Qledq coupling"
    },


(* Effective NP scale squared*)

  Lam == {
    ParameterType -> External,
    Value   -> 1,
    TeX           -> 1/\[CapitalLambda]^2,
    Description   -> "Effective NP scale squared"
  }


};

