(* SmeftFR v3.0 package *)
(* predefined variables *)

(******************************************************************)

(* do not edit unless you know what you are doing!
Decides if CKM and PMNS are defined as unitary (=0) or non-unitary (=1) *)
SMEFT$Unitary = 0;

(* general model version info *)
SMEFT$Version           = SMEFT$MajorVersion <> "." <> SMEFT$MinorVersion;

SMEFT$Authors      = {"A. Dedes, J. Rosiek, M. Ryczkowski, K. Suxho, L. Trifyllis"};
SMEFT$Date         = "01. 02. 2023";
SMEFT$Institutions = {"University of Warsaw, University of Ioannina"};
SMEFT$Emails       = {"janusz.rosiek@fuw.edu.pl"};
SMEFT$URLs         = "URL: www.fuw.edu.pl/smeft";
SMEFT$ModelName    = "SMEFT";

(* welcome printout *)
SMEFT$WelcomePrint = True;

(* set sign of covariant derivative - do not edit *)
FR$DSign = -1;

(* WC first letter in Warsaw and mass basis *)
SMEFT$WB = "c";
SMEFT$MB = "C";

(* default: no user input scheme defined *)
SMEFT$UserInputInitialization = False;
SMEFT$InputListStatus = False;

(* Expansion order in 1/Lamda^2, default 1 - dim6 terms included. Set
to 2 for dim6^2 and bosonic dim8 terms added *)
SMEFT$ExpansionOrder = 1;

(* default CKM input scheme *)
SMEFT$CKMInput = "yes";
(* allowed size of CKM corrections, default value below is 20% *)
SMEFT$CKMTreshold = 0.2;

(* default maximal number of legs in vertices *)
SMEFT$MaxParticles = 6;

(* default treatment of complex parameters *)
SMEFT$RealParameters = False;    

(* identities for field and parameter normalizations valid to all
   orders in SMEFT *)
SMEFT$Identities = {AZnorm[Index[SU2W,1],Index[SU2W,2]] -> G1 g1norm/GW/gwnorm AZnorm[Index[SU2W,2],Index[SU2W,2]],
                    (*AZnorm[Index[SU2W,2],Index[SU2W,1]] ->  (- 2 MZ/G0norm/vev +
                                             GW gwnorm AZnorm[Index[SU2W,1],Index[SU2W,1]])/G1/g1norm,
                    GPnorm -> GW vev/2/MW,*)
                    Wnorm -> 1/gwnorm,
                    Gnorm -> 1/gsnorm};


(* operator classes in string format, SMEFT naming *)

SMEFT$Dim6Operators = { "G", "Gtilde", "W", "Wtilde", "phi", "phiBox",
 "phiD", "phiW", "phiB", "phiWB", "phiWtilde", "phiBtilde",
 "phiWtildeB", "phiGtilde", "phiG", "ephi", "dphi", "uphi", "eW",
 "eB", "uG", "uW", "uB", "dG", "dW", "dB", "phil1", "phil3", "phie",
 "phiq1", "phiq3", "phiu", "phid", "phiud", "ll", "qq1", "qq3", "lq1",
 "lq3", "ee", "uu", "dd", "eu", "ed", "ud1", "ud8", "le", "lu", "ld",
 "qe", "qu1", "qu8", "qd1", "qd8", "ledq", "quqd1", "quqd8", "lequ1",
 "lequ3", "vv", "duq", "qqu", "qqq", "duu" };

SMEFT$Dim8Operators = {"phi8", "phi6Box", "phi6D2", "G2phi4n1",
"G2phi4n2", "W2phi4n1", "W2phi4n2", "W2phi4n3", "W2phi4n4",
"WBphi4n1", "WBphi4n2", "B2phi4n1", "B2phi4n2", "G4n1", "G4n2",
"G4n3", "G4n4", "G4n5", "G4n6", "G4n7", "G4n8", "G4n9", "W4n1",
"W4n2", "W4n3", "W4n4", "W4n5", "W4n6", "B4n1", "B4n2", "B4n3",
"G3Bn1", "G3Bn2", "G3Bn3", "G3Bn4", "G2W2n1", "G2W2n2", "G2W2n3",
"G2W2n4", "G2W2n5", "G2W2n6", "G2W2n7", "G2B2n1", "G2B2n2", "G2B2n3",
"G2B2n4", "G2B2n5", "G2B2n6", "G2B2n7", "W2B2n1", "W2B2n2", "W2B2n3",
"W2B2n4", "W2B2n5", "W2B2n6", "W2B2n7", "phi4n1", "phi4n2", "phi4n3",
"G3phi2n1", "G3phi2n2", "W3phi2n1", "W3phi2n2", "W2Bphi2n1",
"W2Bphi2n2", "G2phi2D2n1", "G2phi2D2n2", "G2phi2D2n3", "W2phi2D2n1",
"W2phi2D2n2", "W2phi2D2n3", "W2phi2D2n4", "W2phi2D2n5", "W2phi2D2n6",
"WBphi2D2n1", "WBphi2D2n2", "WBphi2D2n3", "WBphi2D2n4", "WBphi2D2n5",
"WBphi2D2n6", "B2phi2D2n1", "B2phi2D2n2", "B2phi2D2n3", "Wphi4D2n1",
"Wphi4D2n2", "Wphi4D2n3", "Wphi4D2n4", "Bphi4D2n1", "Bphi4D2n2"};

SMEFT$AllOperators = Join[ SMEFT$Dim6Operators, SMEFT$Dim8Operators ];

SMEFT$OperatorList = SMEFT$AllOperators;

GaugeBilinearOperators = { "phi", "phiBox", "phiD", "phiW",
"phiWtilde", "phiB", "phiBtilde", "phiWB", "phiWtildeB", "phiG",
"phiGtilde" };

GaugeBilinearOperators8 = { "phi8", "phi6Box", "phi6D2", "G2phi4n1",
"G2phi4n2", "W2phi4n1", "W2phi4n2", "W2phi4n3", "W2phi4n4",
"WBphi4n1", "WBphi4n2", "B2phi4n1", "B2phi4n2" };

GaugeTripleOperators = {"G", "Gtilde", "W", "Wtilde"};

GaugeQuadrupleOperators = {"G4n1", "G4n2", "G4n3", "G4n4", "G4n5",
"G4n6", "G4n7", "G4n8", "G4n9", "W4n1", "W4n2", "W4n3", "W4n4",
"W4n5", "W4n6", "B4n1", "B4n2", "B4n3", "G3Bn1", "G3Bn2", "G3Bn3",
"G3Bn4", "G2W2n1", "G2W2n2", "G2W2n3", "G2W2n4", "G2W2n5", "G2W2n6",
"G2W2n7", "G2B2n1", "G2B2n2", "G2B2n3", "G2B2n4", "G2B2n5", "G2B2n6",
"G2B2n7", "W2B2n1", "W2B2n2", "W2B2n3", "W2B2n4", "W2B2n5", "W2B2n6",
"W2B2n7", "B2phi2D2n1", "B2phi2D2n2", "B2phi2D2n3", "Bphi4D2n1",
"Bphi4D2n2", "G2phi2D2n1", "G2phi2D2n2", "G2phi2D2n3", "G3phi2n1",
"G3phi2n2", "phi4n1", "phi4n2", "phi4n3", "W2Bphi2n1", "W2Bphi2n2",
"W2phi2D2n1", "W2phi2D2n2", "W2phi2D2n3", "W2phi2D2n4", "W2phi2D2n5",
"W2phi2D2n6", "W3phi2n1", "W3phi2n2", "WBphi2D2n1", "WBphi2D2n2",
"WBphi2D2n3", "WBphi2D2n4", "WBphi2D2n5", "WBphi2D2n6", "Wphi4D2n1",
"Wphi4D2n2", "Wphi4D2n3", "Wphi4D2n4"};

TwoFermionMassOperators = {"ephi", "uphi", "dphi"};

TwoFermionOperators = {"eW", "eB", "uG", "uW", "uB", "dG", "dW", "dB",
 "phil1", "phil3", "phie", "phiq1", "phiq3", "phiu", "phid", "phiud"};

FourFermionOperators = { "ll", "qq1", "qq3", "lq1", "lq3", "ee", "uu",
"dd", "eu", "ed", "ud1", "ud8", "le", "lu", "ld", "qe", "qu1", "qu8",
"qd1", "qd8", "ledq", "quqd1", "quqd8", "lequ1", "lequ3" };

BLViolatingOperators = {"vv", "duq", "qqu", "qqq", "duu"};

(* assigns NP=1 or 2 to dim6 and dim8 operators *)
Module[{np1,np2,i},
np1 = Rule @@@ Partition[ Riffle[ SMEFT$Dim6Operators,
                         Table[1, {i, 1, Length[SMEFT$Dim6Operators]} ] ], 2];
np2 = Rule @@@ Partition[ Riffle[ SMEFT$Dim8Operators,
                         Table[2, {i, 1, Length[SMEFT$Dim8Operators]} ] ], 2];
SMEFT$NPOrder= Association[ Join[ np1, np2 ] ];
];


(* operator classes including flavor rotations for 2- and 4-fermion operators *)

ScalarWC = Join[ GaugeBilinearOperators, GaugeBilinearOperators8, GaugeTripleOperators, GaugeQuadrupleOperators ];

(* Tensor2WC attributes: name, left rotation, right rotation, hermicity, L violating *)
Tensor2WC = { {"ephi",VLL,VLR,False,False},
              {"dphi",VDL,VDR,False,False},
              {"uphi",VUL,VUR,False,False},
              {"eW",  VLL,VLR,False,False},
              {"eB",  VLL,VLR,False,False},
              {"uG",  VUL,VUR,False,False},
              {"uW",  VUL,VUR,False,False},
              {"uB",  VUL,VUR,False,False},
              {"dG",  VDL,VDR,False,False},
              {"dW",  VDL,VDR,False,False},
              {"dB",  VDL,VDR,False,False},
              {"phil1", VLL,VLL,True,False},
              {"phil3", VLL,VLL,True,False},
              {"phie",  VLR,VLR,True,False},
              {"phiq1", VDL,VDL,True,False},
              {"phiq3", VDL,VDL,True,False},
              {"phiu",  VUR,VUR,True,False},
              {"phid",  VDR,VDR,True,False},
              {"phiud", VUR,VDR,False,False},
              {"vv",    VVL,VVL,True,True} };

(* Tensor4WC attributes: name, left rotations, right rotations, BL violating *)
Tensor4WC = { {"ll",   VLL,VLL,VLL,VLL,False},
              {"qq1",  VDL,VDL,VDL,VDL,False},
              {"qq3",  VDL,VDL,VDL,VDL,False},
              {"lq1",  VLL,VDL,VLL,VDL,False},
              {"lq3",  VLL,VDL,VLL,VDL,False},
              {"ee",   VLR,VLR,VLR,VLR,False},
              {"uu",   VUR,VUR,VUR,VUR,False},
              {"dd",   VDR,VDR,VDR,VDR,False},
              {"eu",   VLR,VUR,VLR,VUR,False},
              {"ed",   VLR,VDR,VLR,VDR,False},
              {"ud1",  VUR,VDR,VUR,VDR,False},
              {"ud8",  VUR,VDR,VUR,VDR,False},
              {"le",   VLL,VLR,VLL,VLR,False},
              {"lu",   VLL,VUR,VLL,VUR,False},
              {"ld",   VLL,VDR,VLL,VDR,False},
              {"qe",   VDL,VLR,VDL,VLR,False},
              {"qu1",  VDL,VUR,VDL,VUR,False},
              {"qu8",  VDL,VUR,VDL,VUR,False},
              {"qd1",  VDL,VDR,VDL,VDR,False},
              {"qd8",  VDL,VDR,VDL,VDR,False},
              {"ledq", VLL,VDR,VLR,VDL,False},
              {"quqd1",VDL,VDL,VUR,VDR,False},
              {"quqd8",VDL,VDL,VUR,VDR,False},
              {"lequ1",VLL,VDL,VLR,VUR,False},
              {"lequ3",VLL,VDL,VLR,VUR,False},
              {"duq",  VDR,VDL,VUR,VLL,True},
              {"qqu",  VDL,VUR,VDL,VLR,True},
              {"qqq",  VDL,VDL,VDL,VLL,True},
              {"duu",  VDR,VUR,VUR,VLR,True} };


(* translation of WC names to WCxf JSON format *)

ScalarJSON = { };

Tensor2JSON = { "vv"->"llphiphi" };

Tensor4JSON = { "duq"->"duql", "qqu"->"qque", "qqq"->"qqql",
   "duu"->"duue" };

(* symmetrization of fermionic WC's. Following D. Straub notation of WC "classes":

Class      Type
0          Scalar object
1          2F general 3x3 matrix
                ["uphi", "dphi", "ephi", "eW", "eB", "uG", "uW", "uB", "dG", "dW", "dB",
                 "phiud", 'Gu', 'Gd', 'Ge']
2          2F Hermitian matrix
                ["phil1", "phil3", "phie", "phiq1", "phiq3", "phiu", "phid",]
3          2F symmetric matrix
                ["llphiphi"]
4          4F two identical ffbar currents
                ["ll", "qq1", "qq3", "uu", "dd"]
5          4F two independent ffbar currents
                ["lq1", "lq3", "eu", "ed", "ud1", "ud8", "le", "lu", "ld", "qe", "qu1",
                 "qd1", "qu8", "qd8"]
6          4F two identical ffbar currents - special case ["ee"]
7          4F Baryon-number-violating - special case ["qque"]
8          4F Baryon-number-violating - special case ["qqql"]
9          4F general 3x3x3x3 object
                ["ledq", "quqd1", "quqd8", "lequ1", "lequ3", "duql", "duue"]

*)

Tensor2Class = { "uphi" -> 1, "dphi" -> 1, "ephi" -> 1, "eW" -> 1,
                 "eB" -> 1, "uG" -> 1, "uW" -> 1, "uB" -> 1, "dG" ->
                 1, "dW" -> 1, "dB" -> 1, "phil1" -> 2, "phil3" -> 2,
                 "phie" -> 2, "phiq1" -> 2, "phiq3" -> 2, "phiu" -> 2,
                 "phid" -> 2, "phiud" -> 1, "vv" -> 3 };


Tensor4Class = { "ll" -> 4, "qq1" -> 4, "qq3" -> 4, "lq1" -> 5, "lq3" -> 5,
                 "ee" -> 6, "uu" -> 4, "dd" -> 4, "eu" -> 5,
                 "ed" -> 5, "ud1" -> 5, "ud8" -> 5, "le" -> 5, "lu" ->
                 5, "ld" -> 5, "qe" -> 5, "qu1" -> 5, "qd1" -> 5,
                 "qu8" -> 5, "qd8" -> 5, "ledq" -> 9, "quqd1" -> 9,
                 "quqd8" -> 9, "lequ1" -> 9, "lequ3" -> 9, "duq" -> 9,
                 "qqu" -> 7, "qqq" -> 8, "duu" -> 9 };

(* indices of non-redundant tensorial fermionic WC's. Last element in
each sublist - False for complex and true for real entries *)

Tensor2Ind = <|"uphi" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "dphi" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "ephi" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False},    {3, 3, False}},
 "eW" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "eB" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "uG" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "uW" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "uB" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "dG" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "dW" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "dB" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "phil1" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phil3" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phie" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phiq1" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phiq3" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phiu" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phid" -> {{1, 1, True}, {1, 2, False}, {1, 3, False},
   {2, 2, True}, {2, 3, False}, {3, 3, True}},
 "phiud" -> {{1, 1, False}, {1, 2, False}, {1, 3, False},
   {2, 1, False}, {2, 2, False}, {2, 3, False},
   {3, 1, False}, {3, 2, False}, {3, 3, False}},
 "vv" -> {{1, 1, False}, {2, 2, False}, {3, 3, False}}|>;



Tensor4Ind = <|"ll" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 1, True},
   {1, 2, 2, 2, False}, {1, 2, 2, 3, False}, {1, 2, 3, 1, False},
   {1, 2, 3, 2, False}, {1, 2, 3, 3, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 2, False}, {1, 3, 2, 3, False}, {1, 3, 3, 1, True},
   {1, 3, 3, 2, False}, {1, 3, 3, 3, False}, {2, 2, 2, 2, True},
   {2, 2, 2, 3, False}, {2, 2, 3, 3, True}, {2, 3, 2, 3, False},
   {2, 3, 3, 2, True}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "qq1" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 1, True},
   {1, 2, 2, 2, False}, {1, 2, 2, 3, False}, {1, 2, 3, 1, False},
   {1, 2, 3, 2, False}, {1, 2, 3, 3, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 2, False}, {1, 3, 2, 3, False}, {1, 3, 3, 1, True},
   {1, 3, 3, 2, False}, {1, 3, 3, 3, False}, {2, 2, 2, 2, True},
   {2, 2, 2, 3, False}, {2, 2, 3, 3, True}, {2, 3, 2, 3, False},
   {2, 3, 3, 2, True}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "qq3" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 1, True},
   {1, 2, 2, 2, False}, {1, 2, 2, 3, False}, {1, 2, 3, 1, False},
   {1, 2, 3, 2, False}, {1, 2, 3, 3, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 2, False}, {1, 3, 2, 3, False}, {1, 3, 3, 1, True},
   {1, 3, 3, 2, False}, {1, 3, 3, 3, False}, {2, 2, 2, 2, True},
   {2, 2, 2, 3, False}, {2, 2, 3, 3, True}, {2, 3, 2, 3, False},
   {2, 3, 3, 2, True}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "lq1" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "lq3" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ee" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 2, False},
   {1, 2, 2, 3, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 3, False}, {1, 3, 2, 3, False}, {1, 3, 3, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 2, 3, False}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "uu" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 1, True},
   {1, 2, 2, 2, False}, {1, 2, 2, 3, False}, {1, 2, 3, 1, False},
   {1, 2, 3, 2, False}, {1, 2, 3, 3, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 2, False}, {1, 3, 2, 3, False}, {1, 3, 3, 1, True},
   {1, 3, 3, 2, False}, {1, 3, 3, 3, False}, {2, 2, 2, 2, True},
   {2, 2, 2, 3, False}, {2, 2, 3, 3, True}, {2, 3, 2, 3, False},
   {2, 3, 3, 2, True}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "dd" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 2, False}, {1, 2, 1, 3, False}, {1, 2, 2, 1, True},
   {1, 2, 2, 2, False}, {1, 2, 2, 3, False}, {1, 2, 3, 1, False},
   {1, 2, 3, 2, False}, {1, 2, 3, 3, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 2, False}, {1, 3, 2, 3, False}, {1, 3, 3, 1, True},
   {1, 3, 3, 2, False}, {1, 3, 3, 3, False}, {2, 2, 2, 2, True},
   {2, 2, 2, 3, False}, {2, 2, 3, 3, True}, {2, 3, 2, 3, False},
   {2, 3, 3, 2, True}, {2, 3, 3, 3, False}, {3, 3, 3, 3, True}},
 "eu" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ed" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ud1" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ud8" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "le" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "lu" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ld" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "qe" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "qu1" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "qd1" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "qu8" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "qd8" -> {{1, 1, 1, 1, True}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 2, True}, {1, 1, 2, 3, False}, {1, 1, 3, 3, True},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, True}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 2, True}, {2, 2, 2, 3, False}, {2, 2, 3, 3, True},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, True}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 2, True}, {3, 3, 2, 3, False}, {3, 3, 3, 3, True}},
 "ledq" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "quqd1" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "quqd8" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "lequ1" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "lequ3" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "duq" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "qqu" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "qqq" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}},
 "duu" -> {{1, 1, 1, 1, False}, {1, 1, 1, 2, False}, {1, 1, 1, 3, False},
   {1, 1, 2, 1, False}, {1, 1, 2, 2, False}, {1, 1, 2, 3, False},
   {1, 1, 3, 1, False}, {1, 1, 3, 2, False}, {1, 1, 3, 3, False},
   {1, 2, 1, 1, False}, {1, 2, 1, 2, False}, {1, 2, 1, 3, False},
   {1, 2, 2, 1, False}, {1, 2, 2, 2, False}, {1, 2, 2, 3, False},
   {1, 2, 3, 1, False}, {1, 2, 3, 2, False}, {1, 2, 3, 3, False},
   {1, 3, 1, 1, False}, {1, 3, 1, 2, False}, {1, 3, 1, 3, False},
   {1, 3, 2, 1, False}, {1, 3, 2, 2, False}, {1, 3, 2, 3, False},
   {1, 3, 3, 1, False}, {1, 3, 3, 2, False}, {1, 3, 3, 3, False},
   {2, 1, 1, 1, False}, {2, 1, 1, 2, False}, {2, 1, 1, 3, False},
   {2, 1, 2, 1, False}, {2, 1, 2, 2, False}, {2, 1, 2, 3, False},
   {2, 1, 3, 1, False}, {2, 1, 3, 2, False}, {2, 1, 3, 3, False},
   {2, 2, 1, 1, False}, {2, 2, 1, 2, False}, {2, 2, 1, 3, False},
   {2, 2, 2, 1, False}, {2, 2, 2, 2, False}, {2, 2, 2, 3, False},
   {2, 2, 3, 1, False}, {2, 2, 3, 2, False}, {2, 2, 3, 3, False},
   {2, 3, 1, 1, False}, {2, 3, 1, 2, False}, {2, 3, 1, 3, False},
   {2, 3, 2, 1, False}, {2, 3, 2, 2, False}, {2, 3, 2, 3, False},
   {2, 3, 3, 1, False}, {2, 3, 3, 2, False}, {2, 3, 3, 3, False},
   {3, 1, 1, 1, False}, {3, 1, 1, 2, False}, {3, 1, 1, 3, False},
   {3, 1, 2, 1, False}, {3, 1, 2, 2, False}, {3, 1, 2, 3, False},
   {3, 1, 3, 1, False}, {3, 1, 3, 2, False}, {3, 1, 3, 3, False},
   {3, 2, 1, 1, False}, {3, 2, 1, 2, False}, {3, 2, 1, 3, False},
   {3, 2, 2, 1, False}, {3, 2, 2, 2, False}, {3, 2, 2, 3, False},
   {3, 2, 3, 1, False}, {3, 2, 3, 2, False}, {3, 2, 3, 3, False},
   {3, 3, 1, 1, False}, {3, 3, 1, 2, False}, {3, 3, 1, 3, False},
   {3, 3, 2, 1, False}, {3, 3, 2, 2, False}, {3, 3, 2, 3, False},
   {3, 3, 3, 1, False}, {3, 3, 3, 2, False}, {3, 3, 3, 3, False}}|>;


(* sigma_munu Dirac matrix *)
Sigma[mu_,nu_,sp1_,sp2_] = I/2 Module[{spx},(Ga[mu,sp1,spx] Ga[nu,spx,sp2] -
                                              Ga[nu,sp1,spx] Ga[mu,spx,sp2])];


