Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS GUIDE", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Functions \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"AnySpinorQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/AnySpinorQ"], "\<\"AppendPhase\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/AppendPhase"], \
"\<\"ASpinorProportionalQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ASpinorProportionalQ"], \
"\<\"BSpinorProportionalQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/BSpinorProportionalQ"], \
"\<\"DeclareASpinorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareASpinorProportional"], \
"\<\"DeclareBSpinorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareBSpinorProportional"], \
"\<\"DeclareLVectorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareLVectorProportional"], \
"\<\"DeclarePlusMinusOne\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclarePlusMinusOne"], \
"\<\"DeclarePossiblePol\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclarePossiblePol"], \
"\<\"DeclareSpinorRandomMomentum\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareSpinorRandomMomentum"], \
"\<\"DecomposeASpinor\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DecomposeASpinor"], \
"\<\"DecomposeBSpinor\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DecomposeBSpinor"], "\<\"ExpandMPToSpinors\"\
\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandMPToSpinors"], "\<\"ExpandPolVec\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandPolVec"], "\<\"ExpandSToMPs\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandSToMPs"], "\<\"ExpandSToSpinors\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandSToSpinors"], "\<\"ExplicitRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExplicitRef"], "\<\"GenComplexMomenta\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/GenComplexMomenta"], "\<\"ImplicitRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ImplicitRef"], "\<\"LightConeDecompose\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LightConeDecompose"], "\<\"LvBA\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LvBA"], "\<\"LVectorProportionalQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LVectorProportionalQ"], "\<\"MassiveLVectorQ\
\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/MassiveLVectorQ"], "\<\"MassiveSpinorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/MassiveSpinorQ"], "\<\"Phase\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/Phase"], "\<\"PlusMinusOneQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PlusMinusOneQ"], "\<\"PolVec\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PolVec"], "\<\"PossiblePolQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PossiblePolQ"], "\<\"RefInvariantQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/RefInvariantQ"], "\<\"RefSimplify\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/RefSimplify"], "\<\"ReplaceASpinor\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceASpinor"], "\<\"ReplaceBSpinor\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceBSpinor"], "\<\"ReplaceLVector\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceLVector"], "\<\"SimpleTensorGetALabel\
\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SimpleTensorGetALabel"], \
"\<\"SimpleTensorGetBLabel\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SimpleTensorGetBLabel"], \
"\<\"SimpleTensorQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SimpleTensorQ"], "\<\"SpAssoc\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpAssoc"], "\<\"SpM\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"SpOpen\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpOpen"], "\<\"SpRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpRef"], "\<\"UndeclarePlusMinusOne\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/UndeclarePlusMinusOne"], \
"\<\"UndeclarePossiblePol\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/UndeclarePossiblePol"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/guide/SpinorsExtras\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/guide/SpinorsExtras"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/guide/\
SpinorsExtras.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/guide/SpinorsExtras", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["SpinorsExtras", "GuideTitle",
 CellID->942062912],

Cell["\<\
An overview of all public symbols introduced by SpinorsExtras package.\
\>", "GuideAbstract",
 CellFrame->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {{0, 0}, {1, 0}}, 
   Inherited],
 CellID->2001916300]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reference vectors and spinors", "GuideFunctionsSection",
 CellTags->"Ref",
 CellID->637046919],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpRef",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SpRef"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Labels default reference spinor for given Lorentz vector."
}], "GuideText",
 CellID->625625839],

Cell[TextData[{
 Cell[TextData[ButtonBox["RefInvariantQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/RefInvariantQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Tests whether expression is invariant with respect to changes of reference \
spinors."
}], "GuideText",
 CellID->1359289893],

Cell[TextData[{
 Cell[TextData[ButtonBox["RefSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/RefSimplify"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Finds simplest form of expression by inserting possible reference spinors."
}], "GuideText",
 CellID->466363227],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExplicitRef",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ExplicitRef"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Changes implicit reference vectors, in given expressions, to ",
 "explicit ",
 " reference vectors."
}], "GuideText",
 CellID->369540706],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImplicitRef",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ImplicitRef"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Changes explicit reference vectors, in given expressions, to ",
 "implicit",
 "  reference vectors."
}], "GuideText",
 CellID->1727962905]
}, Open  ]],

Cell[CellGroupData[{

Cell["Massive vectors and spinors", "GuideFunctionsSection",
 CellTags->"Massive",
 CellID->1637911951],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpM",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Labels spinor for given massive momentum."
}], "GuideText",
 CellID->1221869693],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpAssoc",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Labels vector associated, ",
 "by light cone decomposition,",
 " with massive momentum."
}], "GuideText",
 CellID->718190056],

Cell[TextData[{
 Cell[TextData[ButtonBox["LightConeDecompose",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/LightConeDecompose"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Performs light cone decomposition of vectors and spinors."
}], "GuideText",
 CellID->1947510594],

Cell[TextData[{
 Cell[TextData[ButtonBox["MassiveSpinorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/MassiveSpinorQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Tests whether given expression is interpretable as massive spinor."
}], "GuideText",
 CellID->795113620],

Cell[TextData[{
 Cell[TextData[ButtonBox["MassiveLVectorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/MassiveLVectorQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Tests whether given expression is interpretable as massive LVector."
}], "GuideText",
 CellID->773913457]
}, Open  ]],

Cell[CellGroupData[{

Cell["Composite vectors", "GuideFunctionsSection",
 CellTags->"Composite",
 CellID->2082911707],

Cell[TextData[{
 Cell[TextData[ButtonBox["LvBA",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/LvBA"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Labels vector composed of two independent spinors with different labels."
}], "GuideText",
 CellID->1151565734]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polarization vectors", "GuideFunctionsSection",
 CellTags->"Pol",
 CellID->1202474653],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolVec",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Labels polarization vector for given momentum, polarization and reference \
vector."
}], "GuideText",
 CellID->1185164174],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandPolVec",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Expresses polarization vectors by momentum and reference vectors."
}], "GuideText",
 CellID->101358937],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclarePossiblePol",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclarePossiblePol"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Sets given symbols to be treated as vector boson polarization."
}], "GuideText",
 CellID->717228035],

Cell[TextData[{
 Cell[TextData[ButtonBox["UndeclarePossiblePol",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/UndeclarePossiblePol"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Removes given symbols from list of ",
 "vector boson polarizations",
 "."
}], "GuideText",
 CellID->328125485],

Cell[TextData[{
 Cell[TextData[ButtonBox["PossiblePolQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/PossiblePolQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Tests whether given expression is interpretable as vector boson \
polarization."
}], "GuideText",
 CellID->458894032]
}, Open  ]],

Cell[CellGroupData[{

Cell["Utilities", "GuideFunctionsSection",
 CellTags->"Utilities",
 CellID->1866139230],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceLVector",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ReplaceLVector"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Replaces given Lorentz vector in given expression."
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceBSpinor",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ReplaceBSpinor"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Replaces given massless or massive B spinor in given expression."
}], "GuideText",
 CellID->1980581541],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceASpinor",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ReplaceASpinor"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Replaces given massless or massive A spinor in given expression."
}], "GuideText",
 CellID->147106611],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandMPToSpinors",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ExpandMPToSpinors"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Replaces ",
 "Minkowski",
 " products by spinor products."
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandSToMPs",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ExpandSToMPs"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Replaces s invariants by Minkowski products."
}], "GuideText",
 CellID->1997734232],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclarePlusMinusOne",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclarePlusMinusOne"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Sets given symbols to be treated as \[PlusMinus]1."
}], "GuideText",
 CellID->1136509273],

Cell[TextData[{
 Cell[TextData[ButtonBox["UndeclarePlusMinusOne",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/UndeclarePlusMinusOne"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Removes given symbols from list of expressions ",
 "treated",
 " as \[PlusMinus]1."
}], "GuideText",
 CellID->8833082],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlusMinusOneQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/PlusMinusOneQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Tests whether given expression is interpretable as ",
 "\[PlusMinus]1",
 "."
}], "GuideText",
 CellID->1108616988],

Cell[TextData[{
 Cell[TextData[ButtonBox["AnySpinorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/AnySpinorQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Tests whether given expression is interpretable as massless or massive \
spinor."
}], "GuideText",
 CellID->132945599]
}, Open  ]],

Cell[CellGroupData[{

Cell["Proportional spinors and vectors", "GuideFunctionsSection",
 CellTags->"Proportional",
 CellID->931350017],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclareBSpinorProportional",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclareBSpinorProportional"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Declares that B spinors with given labels are proportional."
}], "GuideText",
 CellID->35380236],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclareASpinorProportional",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclareASpinorProportional"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Declares that A spinors with given labels are proportional."
}], "GuideText",
 CellID->20619885],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclareLVectorProportional",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclareLVectorProportional"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Declares that LVectors with given labels are proportional."
}], "GuideText",
 CellID->680492504],

Cell[TextData[{
 Cell[TextData[ButtonBox["BSpinorProportionalQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/BSpinorProportionalQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Tests whether B spinors with given labels are proportional."
}], "GuideText",
 CellID->1307375252],

Cell[TextData[{
 Cell[TextData[ButtonBox["ASpinorProportionalQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ASpinorProportionalQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Tests whether A spinors with given labels are proportional."
}], "GuideText",
 CellID->1206367247],

Cell[TextData[{
 Cell[TextData[ButtonBox["LVectorProportionalQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/LVectorProportionalQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Tests whether LVectors with given labels are proportional."
}], "GuideText",
 CellID->955640042]
}, Open  ]],

Cell[CellGroupData[{

Cell["Phases management", "GuideFunctionsSection",
 CellTags->"Phase",
 CellID->2001832966],

Cell[TextData[{
 Cell[TextData[ButtonBox["AppendPhase",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/AppendPhase"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Multiplies parts of expression with additional phases."
}], "GuideText",
 CellID->1464233173],

Cell[TextData[{
 Cell[TextData[ButtonBox["Phase",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Represents additional phase of given expression."
}], "GuideText",
 CellID->1118283958]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spinor decomposition", "GuideFunctionsSection",
 CellTags->"Decompose",
 CellID->1889681529],

Cell[TextData[{
 Cell[TextData[ButtonBox["DecomposeBSpinor",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DecomposeBSpinor"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Decomposes B spinor in given basis."
}], "GuideText",
 CellID->1869993586],

Cell[TextData[{
 Cell[TextData[ButtonBox["DecomposeASpinor",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DecomposeASpinor"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Decomposes A spinor in given basis."
}], "GuideText",
 CellID->1992400640]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple Tensors", "GuideFunctionsSection",
 CellTags->"SimpleTensor",
 CellID->191384282],

Cell[TextData[{
 Cell[TextData[ButtonBox["SimpleTensorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SimpleTensorQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Tests whether given expression represents simple tensor."
}], "GuideText",
 CellID->747907827],

Cell[TextData[{
 Cell[TextData[ButtonBox["SimpleTensorGetBLabel",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SimpleTensorGetBLabel"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Extracts B spinor from tensor product of B and A spinors."
}], "GuideText",
 CellID->914745121],

Cell[TextData[{
 Cell[TextData[ButtonBox["SimpleTensorGetALabel",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SimpleTensorGetALabel"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Extracts A spinor from tensor product of B and A spinors."
}], "GuideText",
 CellID->1198598140]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerics", "GuideFunctionsSection",
 CellTags->"Numerics",
 CellID->1165413658],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeclareSpinorRandomMomentum",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/DeclareSpinorRandomMomentum"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Generates random numerics for given spinor."
}], "GuideText",
 CellID->809927871],

Cell[TextData[{
 Cell[TextData[ButtonBox["GenComplexMomenta",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/GenComplexMomenta"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Generates random complex momenta for spinors so that they sum to zero."
}], "GuideText",
 CellID->4462393]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Functions from original Spinors` context with modified behavior\
\>", "GuideFunctionsSection",
 CellTags->"SatMModifications",
 CellID->1414967100],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpOpen",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/SpOpen"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Decomposes spinor chains to products of smaller spinor chains."
}], "GuideText",
 CellID->455222366],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpandSToSpinors",
  BaseStyle->"Link",
  ButtonData->"paclet:SpinorsExtras/ref/ExpandSToSpinors"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Converts s invariants to products of spinor chains."
}], "GuideText",
 CellID->75094675]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "GuideMoreAboutSection",
 WholeCellGroupOpener->True,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
   Inherited, {{Inherited, Inherited}, {Inherited, 20}}],
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
     "TUTORIALS", "GuideMoreAboutSection", CellSize -> {5000, Inherited}], 
     Cell[
      TextData[{
        Cell[
         BoxData[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[24]]]], "Tutorials"}], "GuideMoreAboutSection", 
      CellSize -> {5000, Inherited}]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->415694126],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "GuideMoreAbout",
 
 CellID->1885805579],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpinorsExtras - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "GuideColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        StyleBox[
         ButtonBox[
         "Mathematica", ButtonData -> "paclet:guide/Mathematica", 
          BaseStyle -> {"Link", "DockedLinkTrail"}], FontSlant -> "Italic"], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 2, 12.597744}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "SpinorsExtras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Guide", "language" -> "en", "paclet" -> "SpinorsExtras", 
    "status" -> "None", "summary" -> 
    "An overview of all public symbols introduced by SpinorsExtras package.", 
    "synonyms" -> {}, "title" -> "SpinorsExtras", "titlemodifier" -> "", 
    "windowtitle" -> "SpinorsExtras", "type" -> "Guide", "uri" -> 
    "SpinorsExtras/guide/SpinorsExtras"}, "SearchTextTranslated" -> ""},
FrontEndVersion -> "6.0",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "UTF-8"]
]

