Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Phase\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/Phase"], "\<\"ExpandPolVec\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ExpandPolVec"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/AppendPhase\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/AppendPhase"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
AppendPhase.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/AppendPhase", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["AppendPhase", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AppendPhase", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", " ", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]multiplies each subexpression of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ", with a ",
     Cell[BoxData[
      ButtonBox["Phase",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1952799835],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<PhaseConvention\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[Cell[BoxData[
    Cell[TextData[{
      "name of convention that will be passed as first argument of appended ",
      
      Cell[BoxData[
       ButtonBox["Phase",
        BaseStyle->"Link",
        ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"]
     }], "TableText"]], "3ColumnTableMod",
     GridBoxOptions->{
     GridBoxBackground->{
      "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{"Rows" -> {{True}}}}]], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(5)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1160128293],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->482918986],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419547208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592562241],

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1842457721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendPhase", "[", 
  RowBox[{"expr", ",", "_La", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1167584451],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"La", "[", "2", "]"}]}], "]"}]}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->163158837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendPhase", "[", 
  RowBox[{"expr", ",", "_CLa", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1156857816],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"CLa", "[", "1", "]"}]}], "]"}]}]], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1877102824]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendPhase", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"_La", "|", "_CLa"}], ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->437741062],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"CLa", "[", "1", "]"}]}], "]"}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"La", "[", "2", "]"}]}], "]"}]}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1783837777]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PhaseConvention",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"PhaseConvention\" set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (default value) using ",
 Cell[BoxData["AppendPhase"], "InlineFormula"],
 " does not change given expression, since ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Phase",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"],
 " is define to be ",
 Cell[BoxData["1"], "InlineFormula"],
 " for all expressions:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788674970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1682259325],

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->789949389]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendPhase", "[", 
  RowBox[{"%", ",", "_La", ",", 
   RowBox[{"\"\<PhaseConvention\>\"", "\[Rule]", "Automatic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2035914951],

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56565436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1506267403],

Cell[TextData[{
 "With \"PhaseConvention\" set to anything else than ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData["AppendPhase"], "InlineFormula"],
 " multiplies matched expressions with ",
 Cell[BoxData[
  ButtonBox["Phase",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"],
 " for given convention:"
}], "ExampleText",
 CellID->1026934843],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1675902777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490370464],

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1316719249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendPhase", "[", 
  RowBox[{"%", ",", "_La", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1197379257],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"La", "[", "2", "]"}]}], "]"}]}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475867230]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Phase",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/Phase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandPolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->2077150716],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AppendPhase - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 2, 32.857711}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Phase`", 
    "keywords" -> {"phase convention", "PhaseConvention"}, 
    "specialkeywords" -> {}, "tutorialcollectionlinks" -> {}, "index" -> True,
     "label" -> "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "AppendPhase[expr, patt] multiplies each subexpression of expr, that \
match pattern patt, with a Phase.", "synonyms" -> {}, "title" -> 
    "AppendPhase", "titlemodifier" -> "", "windowtitle" -> "AppendPhase", 
    "type" -> "Symbol", "uri" -> "SpinorsExtras/ref/AppendPhase"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

