Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ASpinorProportionalQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ASpinorProportionalQ"], \
"\<\"LVectorProportionalQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LVectorProportionalQ"], \
"\<\"DeclareASpinorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareASpinorProportional"], \
"\<\"DeclareBSpinorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareBSpinorProportional"], \
"\<\"DeclareLVectorProportional\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclareLVectorProportional"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"SpinorsExtras/ref/BSpinorProportionalQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/BSpinorProportionalQ"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
BSpinorProportionalQ.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/BSpinorProportionalQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["BSpinorProportionalQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BSpinorProportionalQ", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     " or ",
     Cell[BoxData[
      RowBox[{"BSpinorProportionalQ", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], 
        StyleBox["}", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula",
      ShowStringCharacters->False],
     " if |",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "], |",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "], ... B spinors are proportional. Returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula",
      ShowStringCharacters->False],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(6)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->127757232],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->915877025],

Cell["Spinor is proportional to itself:", "ExampleText",
 CellID->1498866351],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1182576787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", "b", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46955],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "b", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`b}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1203095566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"b", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43669098],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2106902476]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1212818453],

Cell["\<\
Two generic Spinors are by default considered non-proportional:\
\>", "ExampleText",
 CellID->1523715098],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2077921902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1543901143],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->716241183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2101052887],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1767017373]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell["\<\
Proportionality between more than two spinors can be tested at once:\
\>", "ExampleText",
 CellID->588260061],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440186322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1441056565],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`c}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->458365105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->904144220],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->872462962]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73133690],

Cell["\<\
Symbols not interpretable as Spinor can't be used in proportionality tests:\
\>", "ExampleText",
 CellID->1512491876],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1720922077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", "b", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1407076443],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "b", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`b}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->334768584]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"b", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1869853784],

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"b", ",", "x"}], "]"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->669196343]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2123667759],

Cell[TextData[{
 "Proportionality between B spinors can be established using ",
 Cell[BoxData[
  ButtonBox["DeclareBSpinorProportional",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/DeclareBSpinorProportional"]], 
  "InlineFormula",
  ShowStringCharacters->False],
 " function:"
}], "ExampleText",
 CellID->141768300],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1105221950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1563944587],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1200152466]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1344138963],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->619082921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareBSpinorProportional", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->345019280],

Cell[BoxData["\<\"B spinors: {a, b} are now considered proportional.\"\>"], \
"Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->2017838212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->801268524],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->529480603]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->511657596],

Cell["\<\
Proportionality between A spinors is implied by proportionality between \
corresponding vectors:\
\>", "ExampleText",
 CellID->647064750],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1182104215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2049482388],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2039472488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1139357113],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1406426332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVectorProportional", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->522490953],

Cell[BoxData["\<\"LVectors: {a, b} are now considered proportional.\"\>"], \
"Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->739389459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BSpinorProportionalQ", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1497218228],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->502568688]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ASpinorProportionalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ASpinorProportionalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LVectorProportionalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/LVectorProportionalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclareASpinorProportional",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/DeclareASpinorProportional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclareBSpinorProportional",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/DeclareBSpinorProportional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclareLVectorProportional",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/DeclareLVectorProportional"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->111092388],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BSpinorProportionalQ - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 2, 44.813693}", 
    "history" -> {"XX", "", "", ""}, "context" -> 
    "SpinorsExtras`Proportional`", "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "BSpinorProportionalQ[x, y, ...] or BSpinorProportionalQ[{x, y, ...}] \
returns True if |x], |y], ... B spinors are proportional. Returns False \
otherwise.", "synonyms" -> {}, "title" -> "BSpinorProportionalQ", 
    "titlemodifier" -> "", "windowtitle" -> "BSpinorProportionalQ", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/BSpinorProportionalQ"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

