Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"UndeclarePlusMinusOne\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/UndeclarePlusMinusOne"], \
"\<\"PlusMinusOneQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PlusMinusOneQ"], "\<\"SpM\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"PolVec\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PolVec"], "\<\"DeclarePossiblePol\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclarePossiblePol"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"SpinorsExtras/ref/DeclarePlusMinusOne\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/DeclarePlusMinusOne"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
DeclarePlusMinusOne.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/DeclarePlusMinusOne", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["DeclarePlusMinusOne", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeclarePlusMinusOne", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]declares ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " as symbolic representation of ",
     Cell[BoxData[
      RowBox[{"+", "1"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeclarePlusMinusOne", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", " ", 
        StyleBox["y", "TI"], ",", "  ", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]declares ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ... as symbolic representations of ",
     Cell[BoxData[
      RowBox[{"+", "1"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(5)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1239329751],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->761790013],

Cell[TextData[{
 "Set a symbol to be treated as ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1433605585],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1944434619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlusMinusOneQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2109503315],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2052421034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1222171504],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "x", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{$CellContext`x}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->2130483715]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlusMinusOneQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->281484712],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1646192397]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 "Set many symbols to be treated as ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1593738283],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->885553258],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PlusMinusOneQ", "[", "x", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", "y", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", "z", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->637909957],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->709178145],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1184132896],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->857966266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1258191910],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{$CellContext`x, $CellContext`y, $CellContext`z}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1801041810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PlusMinusOneQ", "[", "x", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", "y", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", "z", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->554292327],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1089450473],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1942335574],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1642152103]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1728709829],

Cell[TextData[{
 "Set all expressions matching given pattern to be treated as ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2083149880],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2051215862],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PlusMinusOneQ", "[", 
  RowBox[{"pm", "[", "x", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", 
  RowBox[{"pm", "[", "y", "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->2145911464],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1324788973],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1754821504]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", "_pm", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1360490415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "_pm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{
    Blank[$CellContext`pm]}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->1807386644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PlusMinusOneQ", "[", 
  RowBox[{"pm", "[", "x", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PlusMinusOneQ", "[", 
  RowBox[{"pm", "[", "y", "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1595353859],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->155320752],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1814628106]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157],

Cell["\<\
Keep polarization of polarization vector symbolic but restrict it to \
transverse case:\
\>", "ExampleText",
 CellID->1216475192],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767193878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1444285693],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1929195592]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
 " is not treated as massless spinor since ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " can represent any polarization including 0:"
}], "ExampleText",
 CellID->1458680615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "pol"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1108780007],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1486369140]
}, Open  ]],

Cell["\<\
Some automatic simplifications are not performed e.g. such spinor chain stays \
nonzero:\
\>", "ExampleText",
 CellID->45008355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "pol"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "pol"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->844012719],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{"PolVec", "(", 
    RowBox[{"P", ",", "pol"}], ")"}], "|", 
   RowBox[{"PolVec", "(", 
    RowBox[{"P", ",", "pol"}], ")"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{205, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->605504673]
}, Open  ]],

Cell[TextData[{
 "Declare ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " symbol to be treated as plus or minus one:"
}], "ExampleText",
 CellID->1926370437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", "pol", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2083879906],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "pol", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{$CellContext`pol}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1081723231]
}, Open  ]],

Cell[TextData[{
 "After setting ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " to represent plus or minus one ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that  ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
 " represents massless spinor:"
}], "ExampleText",
 CellID->87781149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "pol"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1002408761],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->128567489]
}, Open  ]],

Cell["Package can use automatic simplifications:", "ExampleText",
 CellID->2083916571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "pol"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "pol"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->347598858],

Cell[BoxData["0"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2005078944]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1574019868],

Cell["Keep mass sign of massive spinor label symbolic:", "ExampleText",
 CellID->140764351],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->844337244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208906894],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->907434992]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpM", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is not treated as proper massive spinor label since ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is not interpreted as ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->730510513],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", "x"}], "]"}], ",", "2"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", "P"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->549586100],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{"SpM", "(", 
    RowBox[{"P", ",", "x"}], ")"}], "|", "2", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{98, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1810001714],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{"SpM", "(", 
    RowBox[{"P", ",", "x"}], ")"}], "|", "2", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{98, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2009735508]
}, Open  ]],

Cell[TextData[{
 "Declare ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " symbol to be treated as plus or minus one:"
}], "ExampleText",
 CellID->1016824470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1899760541],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "x", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{$CellContext`x}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->315505769]
}, Open  ]],

Cell[TextData[{
 "After setting ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to represent plus or minus one ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that ",
 Cell[BoxData[
  RowBox[{"SpM", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " represents massive spinor label:"
}], "ExampleText",
 CellID->1527509028],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", "x"}], "]"}], ",", "2"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", "P"}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->710068887],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "x"], "P"}], "|", "2", "]"}], TraditionalForm]], "Output",
 ImageSize->{58, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1215259719],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", " ", 
   SqrtBox[
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "P"}], "]"}]], " ", 
   FormBox[
    RowBox[{"[", 
     SubscriptBox["q", "P"], "|", "2", "]"}],
    TraditionalForm]}], 
  FormBox[
   RowBox[{"[", 
    SubscriptBox["q", "P"], "|", 
    SuperscriptBox["P", "\[Flat]"], "]"}],
   TraditionalForm]]], "Output",
 ImageSize->{167, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->130214290]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UndeclarePlusMinusOne",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/UndeclarePlusMinusOne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlusMinusOneQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PlusMinusOneQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclarePossiblePol",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/DeclarePossiblePol"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->493450762],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeclarePlusMinusOne - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 7.688191}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Utilities`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "DeclarePlusMinusOne[x] declares x as symbolic representation of +1 or \
-1.DeclarePlusMinusOne[x, y, ...] declares x, y, ... as symbolic \
representations of +1 or -1.", "synonyms" -> {}, "title" -> 
    "DeclarePlusMinusOne", "titlemodifier" -> "", "windowtitle" -> 
    "DeclarePlusMinusOne", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/DeclarePlusMinusOne"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

