Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"DecomposeBSpinor\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/DecomposeBSpinor"]},
       
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/DecomposeASpinor\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/DecomposeASpinor"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
DecomposeASpinor.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/DecomposeASpinor", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["DecomposeASpinor", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DecomposeASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["a", "TI"], 
         StyleBox["\[Rule]", "TI"], 
         RowBox[{"{", 
          RowBox[{
           StyleBox["b", "TI"], ",", 
           StyleBox["c", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     " with all occurrences of spinor |",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "> decomposed in basis {|",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     ">, |",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     ">}: |",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "> = ",
     Cell[BoxData[
      FractionBox[
       RowBox[{
        RowBox[{"<", 
         StyleBox["c", "TI"]}], "|", 
        RowBox[{
         StyleBox["a", "TI"], ">"}]}], 
       RowBox[{
        RowBox[{"<", 
         StyleBox["c", "TI"]}], "|", 
        RowBox[{
         StyleBox["b", "TI"], ">"}]}]]], "InlineFormula"],
     " |",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "> + ",
     Cell[BoxData[
      FractionBox[
       RowBox[{
        RowBox[{"<", 
         StyleBox["b", "TI"]}], "|", 
        RowBox[{
         StyleBox["a", "TI"], ">"}]}], 
       RowBox[{
        RowBox[{"<", 
         StyleBox["b", "TI"]}], "|", 
        RowBox[{
         StyleBox["c", "TI"], ">"}]}]]], "InlineFormula"],
     " |",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     ">."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(2)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->752009982],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1112624285],

Cell["Decompose A spinor in given basis:", "ExampleText",
 CellID->11011261],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511982264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79742139],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1288617960]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DecomposeASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->134834294],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "a", "|", "b", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{43, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1711412572],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     FormBox[
      RowBox[{"\[LeftAngleBracket]", "a", "|", "d", "\[RightAngleBracket]"}],
      TraditionalForm], " ", 
     FormBox[
      RowBox[{"\[LeftAngleBracket]", "b", "|", "c", "\[RightAngleBracket]"}],
      TraditionalForm]}], 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "c", "|", "d", "\[RightAngleBracket]"}],
     TraditionalForm]]}], "+", 
  FractionBox[
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "a", "|", "c", "\[RightAngleBracket]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "b", "|", "d", "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "c", "|", "d", "\[RightAngleBracket]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{245, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->415019030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1066059545],

Cell["B spinors are not decomposed:", "ExampleText",
 CellID->1860551676],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1258370281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->678546251],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1710438296]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spbb", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DecomposeASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->778573789],

Cell[BoxData[
 RowBox[{"-", 
  FormBox[
   RowBox[{"[", "b", "|", "a", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{62, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1562254782],

Cell[BoxData[
 RowBox[{"-", 
  FormBox[
   RowBox[{"[", "b", "|", "a", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{62, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1451732262]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DecomposeBSpinor",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/DecomposeBSpinor"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->1210544705],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DecomposeASpinor - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 18.267277}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Decompose`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "DecomposeASpinor[expr, a -> {b, c}] returns expr with all occurrences of \
spinor |a> decomposed in basis {|b>, |c>}: |a> = (< c | a >)/(< c | b >) |b> \
+ (< b | a >)/(< b | c >) |c>.", "synonyms" -> {}, "title" -> 
    "DecomposeASpinor", "titlemodifier" -> "", "windowtitle" -> 
    "DecomposeASpinor", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/DecomposeASpinor"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

