Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ExpandSToSpinors\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandSToSpinors"], "\<\"ExpandSToMPs\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ExpandSToMPs"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ExpandMPToSpinors\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ExpandMPToSpinors"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ExpandMPToSpinors.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ExpandMPToSpinors", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ExpandMPToSpinors", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandMPToSpinors", "[", 
       StyleBox[
        RowBox[{"expr", ",", "a"}], "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with Minkowski products (",
     Cell[BoxData[
      ButtonBox["MP",
       BaseStyle->"Link",
       ButtonData->"paclet:Spinors/ref/MP"]], "InlineFormula"],
     ") containing label ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " replaced by spinor products."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandMPToSpinors", "[", 
       StyleBox[
        RowBox[{"expr", ",", "patt"}], "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with Minkowski products (",
     Cell[BoxData[
      ButtonBox["MP",
       BaseStyle->"Link",
       ButtonData->"paclet:Spinors/ref/MP"]], "InlineFormula"],
     ") containing labels matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by spinor products."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandMPToSpinors", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all Minkowski products (",
     Cell[BoxData[
      ButtonBox["MP",
       BaseStyle->"Link",
       ButtonData->"paclet:Spinors/ref/MP"]], "InlineFormula"],
     ") replaced by spinor products."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1650344352],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Massive\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to expand Minkowski products of massive LVectors", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UOrVFunction\>\"", 
    RowBox[{"1", "&"}], Cell[TextData[Cell[BoxData[Cell[TextData[{
      "function that accept LVector label and returns ",
      Cell[BoxData[
       RowBox[{"+", "1"}]], "InlineFormula"],
      " for u spinor or ",
      Cell[BoxData[
       RowBox[{"-", "1"}]], "InlineFormula"],
      " for v spinor"
     }], "TableText"]], "3ColumnTableMod",
     GridBoxOptions->{
     GridBoxBackground->{
      "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{"Rows" -> {{True}}}}]], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1477614930],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(12)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1974924878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->357670732],

Cell["Expand Minkowski products of given massless spinor label:", \
"ExampleText",
 CellID->512370754],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1054926503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->805223789],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->578762720]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}]}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->599702604],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{275, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1857029935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2042637775],

Cell["Expand Minkowski products of given LVector label:", "ExampleText",
 CellID->1700070232],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575481017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2092786010],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1523775210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}]}], ",", "P"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1283937943],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "1", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{344, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2000661278]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1221265840],

Cell["Expand Minkowski products of labels matching given pattern:", \
"ExampleText",
 CellID->433310790],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1021995223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1190858617],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1322965547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Sp", "[", "2", "]"}], "|", "Q"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->930083884],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "1"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "2", "|", "1", "|", "2", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "Q"}], "|", "P", "|", 
     RowBox[{
      SubscriptBox["", "+"], "Q"}], "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{308, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1386998552]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1578737533],

Cell["Expand all Minkowski products:", "ExampleText",
 CellID->1749464733],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855650626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->576741247],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->133131756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "+", 
   RowBox[{"MP", "[", 
    RowBox[{"P", ",", "1"}], "]"}], "+", 
   RowBox[{"MP", "[", 
    RowBox[{"P", ",", "Q"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1030650666],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->719940056]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Massive",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"Massive\" set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " (default value) Minkowski products (",
 Cell[BoxData[
  ButtonBox["MP",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/MP"]], "InlineFormula"],
 ") of two massive LVectors are also expanded:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788674970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->984973820],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->356494721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}]}], ",", 
   RowBox[{"\"\<Massive\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1764641545],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158715390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1022994496],

Cell[TextData[{
 "With \"Massive\" set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " Minkowski products (",
 Cell[BoxData[
  ButtonBox["MP",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/MP"]], "InlineFormula"],
 ") of two massive LVectors are not expanded (so no massive spinors are \
introduced):"
}], "ExampleText",
 CellID->239826287],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1755089758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1677735888],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->210911843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}]}], ",", 
   RowBox[{"\"\<Massive\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1325967899],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{304, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115710533]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "UOrVFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->491364819],

Cell[TextData[{
 "\"UOrVFunction\" should be a function accepting one argument, LVector \
label, and returning ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " which will be used as second argument of ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " when given label is used at end of spinor chain:"
}], "ExampleText",
 CellID->250414307],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1270423006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->669604355],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[27]:=",
 CellID->1724646694]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "Q"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"Q", ",", "R"}], "]"}]}], ",", 
   RowBox[{"\"\<UOrVFunction\>\"", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Switch", "[", 
       RowBox[{"#", ",", "P", ",", 
        RowBox[{"+", "1"}], ",", "_", ",", 
        RowBox[{"-", "1"}]}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1495558808],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "|", "R", "|", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{268, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->597910947]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387236499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33019565],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1162380274]
}, Open  ]],

Cell["\<\
Stand alone integer given as second argument is treated as spinor label:\
\>", "ExampleText",
 CellID->1965629178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"2", ",", "P"}], "]"}]}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1822042503],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "2"}], "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{274, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1883393771]
}, Open  ]],

Cell["\<\
but integers inside expressions are not automatically \"spinorized\":\
\>", "ExampleText",
 CellID->1842339045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"2", ",", "P"}], "]"}]}], ",", 
   RowBox[{"1", "|", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1223085164],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "1"}], "]"}], "+", 
  RowBox[{"MP", "[", 
   RowBox[{"P", ",", "2"}], "]"}], "+", 
  RowBox[{"MP", "[", 
   RowBox[{"1", ",", "2"}], "]"}]}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1517229053]
}, Open  ]],

Cell[TextData[{
 "for integers in complex expressions to be treated as ",
 "spinor",
 " labels wrap them in ",
 Cell[BoxData[
  ButtonBox["Sp",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/Sp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->677857385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "1"}], "]"}], "+", 
    RowBox[{"MP", "[", 
     RowBox[{"2", ",", "P"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Sp", "[", "1", "]"}], "|", 
    RowBox[{"Sp", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->188974086],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "2", "|", "P", "|", "2", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{330, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->755005985]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1930458278],

Cell[TextData[{
 "When massive LVector label is given as second argument but \"Massive\" \
option is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " no expansion is performed:"
}], "ExampleText",
 CellID->2045278071],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1247727710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1087014531],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2015952658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandMPToSpinors", "[", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{"P", ",", "1"}], "]"}], ",", "P", ",", 
   RowBox[{"\"\<Massive\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->540842281],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ExpandMPToSpinors", "::", "massiveFalse"}], "MessageName"], ":", 
  " ", "\<\"ExpandMPToSpinors called with massive LVector \
\[NoBreak]\\!\\(P\\)\[NoBreak] as second argument, but option \\\"Massive\\\" \
is set to \[NoBreak]\\!\\(False\\)\[NoBreak] so nothing is expanded in \
\[NoBreak]\\!\\(ExpandMPToSpinors[\\(\\(\\(\\(MP[\\(\\(P, 1\\)\\)]\\)\\), P, \
\\(\\(\\\"Massive\\\" \[Rule] False\\)\\)\\)\\)]\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1284886521],

Cell[BoxData[
 RowBox[{"MP", "[", 
  RowBox[{"P", ",", "1"}], "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->587949220]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandSToSpinors",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandSToSpinors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandSToMPs",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandSToMPs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->1247397754],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpandMPToSpinors - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 23.352296}", 
    "history" -> {"XX", "", "", ""}, "context" -> 
    "SpinorsExtras`MassiveUtilities`", "keywords" -> {}, 
    "specialkeywords" -> {}, "tutorialcollectionlinks" -> {}, "index" -> True,
     "label" -> "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ExpandMPToSpinors[expr, a] returns expr with Minkowski products (MP) \
containing label a replaced by spinor products.ExpandMPToSpinors[expr, patt] \
returns expr with Minkowski products (MP) containing labels matching patt \
replaced by spinor products.ExpandMPToSpinors[expr] returns expr with all \
Minkowski products (MP) replaced by spinor products.", "synonyms" -> {}, 
    "title" -> "ExpandMPToSpinors", "titlemodifier" -> "", "windowtitle" -> 
    "ExpandMPToSpinors", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ExpandMPToSpinors"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

