Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"PolVec\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PolVec"], "\<\"Phase\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/Phase"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ExpandPolVec\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ExpandPolVec"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ExpandPolVec.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ExpandPolVec", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ExpandPolVec", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandPolVec", "[", 
       RowBox[{
        StyleBox["expr", "TI"], 
        StyleBox[",", "TI"], 
        RowBox[{
         ButtonBox["PolVec",
          BaseStyle->"Link",
          ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
         RowBox[{
          StyleBox["P", "TI"], 
          StyleBox[" ", "TI"], ",", 
          StyleBox["pol", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with occurrences of polarization vectors ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolVec",
        BaseStyle->"Link",
        ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
       RowBox[{
        StyleBox["P", "TI"], 
        StyleBox[" ", "TI"], ",", 
        StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
     " replaced by proper, for given polarization ",
     Cell[BoxData[
      StyleBox["pol", "TI"]], "InlineFormula"],
     ", combinations of four-vectors, slashed matrices and spinors associated \
with momentum ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     " and default reference vector."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandPolVec", "[", 
       RowBox[{
        StyleBox["expr", "TI"], 
        StyleBox[",", "TI"], 
        RowBox[{
         ButtonBox["PolVec",
          BaseStyle->"Link",
          ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
         RowBox[{
          StyleBox["P", "TI"], 
          StyleBox[" ", "TI"], ",", 
          StyleBox["pol", "TI"], 
          StyleBox[",", "TI"], 
          StyleBox["q", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes occurrences of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolVec",
        BaseStyle->"Link",
        ButtonData->"paclet:SpinorsExtras/ref/PolVec"], "[", 
       RowBox[{
        StyleBox["P", "TI"], 
        StyleBox[" ", "TI"], ",", 
        StyleBox["pol", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     ", in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", using reference vector ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandPolVec", "[", 
       StyleBox[
        RowBox[{"expr", ",", "patt"}], "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes those occurrences of polarization vectors, \
in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", which match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpandPolVec", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes all polarization vectors in given expression \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->190718041],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "PhaseConvention", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "name of convention that will be passed as first argument of ",
     Cell[BoxData[
      ButtonBox["Phase",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"],
     " of expanded polarization vectors"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(7)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->2089331541],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->685607532],

Cell["Expand only given polarization vector:", "ExampleText",
 CellID->18660621],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1502531598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556268004],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->155149889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MP", "[", 
  RowBox[{
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1450549939],

Cell[BoxData[
 RowBox[{"MP", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Epsilon]", "+"], 
    RowBox[{"(", "P", ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "-"], 
    RowBox[{"(", "Q", ")"}]}]}], "]"}]], "Output",
 ImageSize->{141, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1884949669],

Cell[BoxData[
 FractionBox[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox["P", "\[Flat]"], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", "Q", ")"}]}], "|", 
    SubscriptBox["q", "P"], "]"}],
   TraditionalForm], 
  RowBox[{
   SqrtBox["2"], " ", 
   FormBox[
    RowBox[{"[", 
     SubscriptBox["q", "P"], "|", 
     SuperscriptBox["P", "\[Flat]"], "]"}],
    TraditionalForm]}]]], "Output",
 ImageSize->{136, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1300958203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522866511],

Cell["Expand polarization vectors matching given pattern:", "ExampleText",
 CellID->1264287711],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1505565916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1731137827],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->976867250]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"s", "[", 
  RowBox[{
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"Q", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}], ",", "2"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", "_", ",", 
     RowBox[{"Sp", "[", 
      RowBox[{"_", "?", "OddQ"}], "]"}]}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1342423610],

Cell[BoxData[
 SubscriptBox["s", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Epsilon]", "-"], 
    RowBox[{"(", 
     RowBox[{"P", ",", "3"}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "0"], 
    RowBox[{"(", 
     RowBox[{"P", ",", "1"}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "+"], 
    RowBox[{"(", 
     RowBox[{"P", ",", "2"}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "0"], 
    RowBox[{"(", 
     RowBox[{"Q", ",", "1"}], ")"}]}]}]]], "Output",
 ImageSize->{229, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6460104],

Cell[BoxData[
 RowBox[{
  SubscriptBox["s", 
   RowBox[{
    FractionBox["P", 
     SqrtBox[
      RowBox[{"Abs", "[", 
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", "P"}], "]"}], "]"}]]], 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", 
      RowBox[{"P", ",", "2"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", "P"}], "]"}], " ", "1"}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Abs", "[", 
         RowBox[{"MP", "[", 
          RowBox[{"P", ",", "P"}], "]"}], "]"}]], " ", 
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", "1"}], "]"}]}]]}]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "3", "|", 
      RowBox[{
       SuperscriptBox["\[Epsilon]", "+"], 
       RowBox[{"(", 
        RowBox[{"P", ",", "2"}], ")"}]}], "|", 
      SuperscriptBox["P", "3"], "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "3", "|", 
     SuperscriptBox["P", "3"], "\[RightAngleBracket]"}],
    TraditionalForm]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "3", "|", 
      RowBox[{
       SuperscriptBox["\[Epsilon]", "0"], 
       RowBox[{"(", 
        RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
      SuperscriptBox["P", "3"], "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "3", "|", 
     SuperscriptBox["P", "3"], "\[RightAngleBracket]"}],
    TraditionalForm]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       FormBox[
        RowBox[{"\[LeftAngleBracket]", "3", "|", "P", "|", 
         SuperscriptBox["P", "3"], "]"}],
        TraditionalForm], 
       SqrtBox[
        RowBox[{"Abs", "[", 
         RowBox[{"MP", "[", 
          RowBox[{"P", ",", "P"}], "]"}], "]"}]]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"MP", "[", 
         RowBox[{"P", ",", "P"}], "]"}], " ", 
        FormBox[
         RowBox[{"\[LeftAngleBracket]", "3", "|", "1", "|", 
          SuperscriptBox["P", "3"], "]"}],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Abs", "[", 
          RowBox[{"MP", "[", 
           RowBox[{"P", ",", "P"}], "]"}], "]"}]], " ", 
        RowBox[{"MP", "[", 
         RowBox[{"P", ",", "1"}], "]"}]}]]}], ")"}]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "3", "|", 
     SuperscriptBox["P", "3"], "\[RightAngleBracket]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{397, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1890593822]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1748014383],

Cell["Expand all polarization vectors:", "ExampleText",
 CellID->1712807926],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1837640060],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->588509405],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->139826645],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->94613213]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{
   RowBox[{"PolVec", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"Q", ",", "0", ",", "a"}], "]"}], ",", 
   RowBox[{"PolVec", "[", 
    RowBox[{"R", ",", 
     RowBox[{"-", "1"}], ",", "b"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", "%", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1309281939],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "+"], 
    RowBox[{"(", "P", ")"}]}], "|", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "0"], 
    RowBox[{"(", 
     RowBox[{"Q", ",", "a"}], ")"}]}], "|", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", "-"], 
    RowBox[{"(", 
     RowBox[{"R", ",", "b"}], ")"}]}], "]"}], TraditionalForm]], "Output",
 ImageSize->{190, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->468120875],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"MP", "[", 
         RowBox[{"Q", ",", "Q"}], "]"}], " ", 
        FormBox[
         RowBox[{"\[LeftAngleBracket]", 
          SuperscriptBox["P", "\[Flat]"], "|", "a", "|", 
          SuperscriptBox["R", "b"], "]"}],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Abs", "[", 
          RowBox[{"MP", "[", 
           RowBox[{"Q", ",", "Q"}], "]"}], "]"}]], " ", 
        RowBox[{"MP", "[", 
         RowBox[{"a", ",", "Q"}], "]"}]}]]}], "+", 
     FractionBox[
      FormBox[
       RowBox[{"\[LeftAngleBracket]", 
        SuperscriptBox["P", "\[Flat]"], "|", "Q", "|", 
        SuperscriptBox["R", "b"], "]"}],
       TraditionalForm], 
      SqrtBox[
       RowBox[{"Abs", "[", 
        RowBox[{"MP", "[", 
         RowBox[{"Q", ",", "Q"}], "]"}], "]"}]]]}], ")"}]}], 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "b", "|", 
     SuperscriptBox["R", "b"], "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", 
     SubscriptBox["q", "P"], "|", 
     SuperscriptBox["P", "\[Flat]"], "]"}],
    TraditionalForm]}]]], "Output",
 ImageSize->{324, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->190119617]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PhaseConvention",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"PhaseConvention\" set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (default value) no additional phase factors are added to expanded \
polarization vectors:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788674970],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sm", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"1", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PhaseConvention\>\"", "\[Rule]", "Automatic"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->2035914951],

Cell[BoxData[
 RowBox[{"Sm", "[", 
  RowBox[{
   SuperscriptBox["\[Epsilon]", "+"], 
   RowBox[{"(", "1", ")"}]}], "]"}]], "Output",
 ImageSize->{84, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->914266024],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"SmBA", "[", 
    RowBox[{
     SubscriptBox["q", "1"], ",", "1"}], "]"}]}], 
  FormBox[
   RowBox[{"[", 
    SubscriptBox["q", "1"], "|", "1", "]"}],
   TraditionalForm]]], "Output",
 ImageSize->{129, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->651880328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1506267403],

Cell[TextData[{
 "With \"PhaseConvention\" set to anything else than ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", each expanded polarization vector is multiplied with ",
 Cell[BoxData[
  ButtonBox["Phase",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/Phase"]], "InlineFormula"],
 " for given convention:"
}], "ExampleText",
 CellID->1026934843],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1675902777],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sm", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"1", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"%", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1197379257],

Cell[BoxData[
 RowBox[{"Sm", "[", 
  RowBox[{
   SuperscriptBox["\[Epsilon]", "+"], 
   RowBox[{"(", "1", ")"}]}], "]"}]], "Output",
 ImageSize->{84, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1505462116],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"Phase", "[", 
    RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
     RowBox[{
      SuperscriptBox["\[Epsilon]", "+"], 
      RowBox[{"(", "1", ")"}]}]}], "]"}], " ", 
   RowBox[{"SmBA", "[", 
    RowBox[{
     SubscriptBox["q", "1"], ",", "1"}], "]"}]}], 
  FormBox[
   RowBox[{"[", 
    SubscriptBox["q", "1"], "|", "1", "]"}],
   TraditionalForm]]], "Output",
 ImageSize->{387, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1426374528]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Phase",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/Phase"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->1983124445],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpandPolVec - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 26.916934}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Pol`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ExpandPolVec[expr, PolVec[P , pol]] returns expr with occurrences of \
polarization vectors PolVec[P , pol] replaced by proper, for given \
polarization pol, combinations of four-vectors, slashed matrices and spinors \
associated with momentum P and default reference vector.ExpandPolVec[expr, \
PolVec[P , pol, q]] decomposes occurrences of PolVec[P , pol, q], in expr, \
using reference vector q.ExpandPolVec[expr, patt] decomposes those \
occurrences of polarization vectors, in expr, which match pattern \
patt.ExpandPolVec[expr] decomposes all polarization vectors in given \
expression expr.", "synonyms" -> {}, "title" -> "ExpandPolVec", 
    "titlemodifier" -> "", "windowtitle" -> "ExpandPolVec", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/ExpandPolVec"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

