Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ImplicitRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ImplicitRef"], "\<\"SpRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpRef"], "\<\"SpAssoc\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpAssoc"], "\<\"SpM\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"PolVec\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/PolVec"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ExplicitRef\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ExplicitRef"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ExplicitRef.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ExplicitRef", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ExplicitRef", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExplicitRef", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     " where all occurrences of ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with implicit reference vectors have added explicit default reference \
vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExplicitRef", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["P", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds reference vectors only to ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with label ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExplicitRef", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds reference vectors only to ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with labels matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(5)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1244355910],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->980831095],

Cell[TextData[{
 "Explicit default reference vectors are added to ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with implicit reference vectors:"
}], "ExampleText",
 CellID->1344538458],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1752712815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135526820],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->994912274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1027073850],

Cell[BoxData[
 SuperscriptBox["P", "\[Flat]"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1239132229],

Cell[BoxData[
 SuperscriptBox["P", 
  SubscriptBox["q", "P"]]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->410714734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->644198539],

Cell[BoxData[
 RowBox[{
  SubscriptBox["", "\[PlusMinus]"], "P"}]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1053629259],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", 
   SubscriptBox["q", "P"]], "P"}]], "Output",
 ImageSize->{24, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1759182485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->88279474],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", "P", ")"}]}]], "Output",
 ImageSize->{25, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->801817978],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", 
    SubscriptBox["q", "P"]}], ")"}]}]], "Output",
 ImageSize->{29, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2004480379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55592443],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with explicit reference vectors are unchanged:"
}], "ExampleText",
 CellID->1722574156],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2095819514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->625200535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1731042291]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1684131913],

Cell[BoxData[
 SuperscriptBox["P", "1"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1142224396],

Cell[BoxData[
 SuperscriptBox["P", "1"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->394835441]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->168275978],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", "2"], "P"}]], "Output",
 ImageSize->{21, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->452607304],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", "2"], "P"}]], "Output",
 ImageSize->{21, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1001891238]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ExplicitRef"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1718656058],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", "3"}], ")"}]}]], "Output",
 ImageSize->{25, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1540390104],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", "3"}], ")"}]}]], "Output",
 ImageSize->{25, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->449406574]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 "Add explicit reference vectors to all occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->724827522],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1440536946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1728219325],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1537543349]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{"PolVec", "[", 
     RowBox[{"Q", ",", "0"}], "]"}], ",", 
    RowBox[{"SpAssoc", "[", "P", "]"}]}], "]"}], 
  RowBox[{"Spaa", "[", 
   RowBox[{
    RowBox[{"SpAssoc", "[", 
     RowBox[{"Q", ",", "1"}], "]"}], ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{"P", ",", "1"}], "]"}]}], "]"}], 
  RowBox[{"Spbb", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"-", "1"}]}], "]"}], ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"R", ",", "1"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ExplicitRef", "[", "%", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1980619307],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", "\[Flat]"]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{299, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1223158601],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", 
       SubscriptBox["q", "Q"]}], ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "P"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "+", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "Q"]], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{390, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1147004859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41462811],

Cell[TextData[{
 "Add explicit reference vectors to occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with given label:"
}], "ExampleText",
 CellID->1064799327],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->851145621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->466784185],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2087006574]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "0"}], "]"}], ",", 
     RowBox[{"SpAssoc", "[", "P", "]"}]}], "]"}], 
   RowBox[{"Spaa", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"P", ",", "1"}], "]"}]}], "]"}], 
   RowBox[{"Spbb", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", "1"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641073180],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", "\[Flat]"]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{299, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->589115820]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitRef", "[", 
  RowBox[{"expr", ",", "P"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1304563749],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "P"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{338, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->422914578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitRef", "[", 
  RowBox[{"expr", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->779357452],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Epsilon]", "0"], 
      RowBox[{"(", 
       RowBox[{"Q", ",", 
        SubscriptBox["q", "Q"]}], ")"}]}], ",", 
     SuperscriptBox["P", "\[Flat]"]}], "]"}]}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "Q"]], "Q"}], "|", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{349, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1832743419]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitRef", "[", 
  RowBox[{"expr", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1346674596],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", "\[Flat]"]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "+", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{310, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->245163668]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1145155664],

Cell[TextData[{
 "Add explicit reference vectors to occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with label matching given pattern:"
}], "ExampleText",
 CellID->1923664632],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1680824472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->306750854],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1697351856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "0"}], "]"}], ",", 
     RowBox[{"SpAssoc", "[", "P", "]"}]}], "]"}], 
   RowBox[{"Spaa", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"P", ",", "1"}], "]"}]}], "]"}], 
   RowBox[{"Spbb", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", "1"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1621210354],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", "\[Flat]"]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{299, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1502044920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitRef", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"P", "|", "Q"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1165966655],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Epsilon]", "0"], 
      RowBox[{"(", 
       RowBox[{"Q", ",", 
        SubscriptBox["q", "Q"]}], ")"}]}], ",", 
     SuperscriptBox["P", 
      SubscriptBox["q", "P"]]}], "]"}]}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "Q"]], "Q"}], "|", 
    RowBox[{
     SubscriptBox["", "+"], "R"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{388, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->849352356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitRef", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"Except", "[", "P", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1345715144],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", 
       SubscriptBox["q", "Q"]}], ")"}]}], ",", 
    SuperscriptBox["P", "\[Flat]"]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "1"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "+", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "Q"]], "Q"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{351, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->455345876]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImplicitRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ImplicitRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpAssoc",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->1469606967],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExplicitRef - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 35.317028}", 
    "history" -> {"XX", "", "", ""}, "context" -> 
    "SpinorsExtras`RefUtilities`", "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ExplicitRef[expr] returns expr where all occurrences of SpAssoc, SpM and \
PolVec with implicit reference vectors have added explicit default reference \
vectors.ExplicitRef[expr, P] adds reference vectors only to SpAssoc, SpM and \
PolVec with label P .ExplicitRef[expr, patt] adds reference vectors only to \
SpAssoc, SpM and PolVec with labels matching patt.", "synonyms" -> {}, 
    "title" -> "ExplicitRef", "titlemodifier" -> "", "windowtitle" -> 
    "ExplicitRef", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ExplicitRef"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

