Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->
        False], {"\<\"SpinorsExtras/ref/ExternalMomentaPartitions\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["SpinorsExtras/ref/ExternalMomentaPartitions"]}, Visible -> 
           False]]; SelectionMove[
        DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ExternalMomentaPartitions.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", 
            "SpinorsExtras/ref/ExternalMomentaPartitions", ".html"]], 
          None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["ExternalMomentaPartitions", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExternalMomentaPartitions", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["P", "TI"], "1"], ",", " ", 
          SubscriptBox[
           StyleBox["P", "TI"], "2"], ",", "  ", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["P", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["P", "TI"], 
           StyleBox["i", "TI"]], ",", " ", 
          SubscriptBox[
           StyleBox["P", "TI"], 
           StyleBox["j", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns list of possible partitions of given momenta ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["P", "TI"], "1"], ",", " ", 
       SubscriptBox[
        StyleBox["P", "TI"], "2"], ",", "  ", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       SubscriptBox[
        StyleBox["P", "TI"], 
        StyleBox["n", "TI"]]}]], "InlineFormula"],
     " into two lists such that each list contains ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P", "TI"], 
       StyleBox["j", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(2)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->398564418],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1588139317],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1613906594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExternalMomentaPartitions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1851580302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{473, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->972003285]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 "When at least one of singled out momenta are not present in given momentum \
list ",
 Cell[BoxData["ExternalMomentaPartitions"], "InlineFormula"],
 " prints a warning message:"
}], "ExampleText",
 CellID->1643985101],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->834448690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExternalMomentaPartitions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174051073],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ExternalMomentaPartitions", "::", "momMissing"}], "MessageName"], 
  ":", " ", "\<\"\[NoBreak]\\!\\({7}\\)\[NoBreak] momenta are not present in \
\[NoBreak]\\!\\({1, 2, 3, 4, 5}\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->722590279],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204962820]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExternalMomentaPartitions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1296323517],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ExternalMomentaPartitions", "::", "momMissing"}], "MessageName"], 
  ":", " ", "\<\"\[NoBreak]\\!\\({6, 7}\\)\[NoBreak] momenta are not present \
in \[NoBreak]\\!\\({1, 2, 3, 4, 5}\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->406624117],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1396924601]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExternalMomentaPartitions - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 37.814619}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Utilities`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ExternalMomentaPartitions[{P_1, P_2, ..., P_n}, {P_i, P_j}] returns list \
of possible partitions of given momenta P_1, P_2, ..., P_n into two lists \
such that each list contains P_i or P_j.", "synonyms" -> {}, "title" -> 
    "ExternalMomentaPartitions", "titlemodifier" -> "", "windowtitle" -> 
    "ExternalMomentaPartitions", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ExternalMomentaPartitions"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

