Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ScalarQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScalarQ"], "\<\"ScaledLVectorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScaledLVectorQ"], "\<\"ScaledSpinorQ\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ScaledSpinorQ"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"SpinorsExtras/ref/GetScalarCoefficient\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/GetScalarCoefficient"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
GetScalarCoefficient.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/GetScalarCoefficient", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["GetScalarCoefficient", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetScalarCoefficient", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being scaled LVector returns scalar coefficient multiplying LVector."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(3)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->614056556],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->730287691],

Cell[TextData[{
 "For LVectors ",
 Cell[BoxData["1"], "InlineFormula"],
 " is returned:"
}], "ExampleText",
 CellID->2073075395],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->982992957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1456020199],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1410363421]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GetScalarCoefficient", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetScalarCoefficient", "[", 
  RowBox[{"Sp", "[", "1", "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->79369595],

Cell[BoxData["1"], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1999075038],

Cell[BoxData["1"], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->961064791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2082205424],

Cell["For scaled LVectors scaling coefficient is returned:", "ExampleText",
 CellID->1502132539],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1843205197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->513288895],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->1774290609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GetScalarCoefficient", "[", 
  RowBox[{"x", " ", "P"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetScalarCoefficient", "[", 
  RowBox[{"5", 
   RowBox[{"MP", "[", 
    RowBox[{"3", ",", "4"}], "]"}], 
   RowBox[{"Sp", "[", "1", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->986080301],

Cell[BoxData["x"], "Output",
 ImageSize->{14, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1636697098],

Cell[BoxData[
 RowBox[{"5", " ", 
  RowBox[{"MP", "[", 
   RowBox[{"3", ",", "4"}], "]"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1044181977]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47154486],

Cell["For anything else than scaled LVectors function fails:", "ExampleText",
 CellID->1990448598],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176485064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->741040730],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1280345626]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GetScalarCoefficient", "[", 
  RowBox[{"P", " ", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetScalarCoefficient", "[", 
  RowBox[{"P", "+", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"GetScalarCoefficient", "[", "x", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1796196045],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"GetScalarCoefficient", "::", "notScaledLVector"}], "MessageName"],
   ":", " ", "\<\"GetScalarCoefficient called with \[NoBreak]\\!\\(P\\\\ Q\\)\
\[NoBreak] argument which is not a scaled LVector.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->806569967],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{31, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1631113166],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"GetScalarCoefficient", "::", "notScaledLVector"}], "MessageName"],
   ":", " ", "\<\"GetScalarCoefficient called with \[NoBreak]\\!\\(P + Q\\)\
\[NoBreak] argument which is not a scaled LVector.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->853411264],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{31, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1581974023],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"GetScalarCoefficient", "::", "notScaledLVector"}], "MessageName"],
   ":", " ", "\<\"GetScalarCoefficient called with \[NoBreak]\\!\\(x\\)\
\[NoBreak] argument which is not a scaled LVector.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1733640754],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{31, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1669740961]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScalarQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaledLVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScaledLVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaledSpinorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScaledSpinorQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetScalarCoefficient - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 42.383172}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "SpinorsExtras`Package`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Symbol", "language" -> "en", "paclet" -> "SpinorsExtras", 
    "status" -> "None", "summary" -> 
    "GetScalarCoefficient[x] for x being scaled LVector returns scalar \
coefficient multiplying LVector.", "synonyms" -> {}, "title" -> 
    "GetScalarCoefficient", "titlemodifier" -> "", "windowtitle" -> 
    "GetScalarCoefficient", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/GetScalarCoefficient"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

