Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ExplicitRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExplicitRef"], "\<\"SpRef\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpRef"], "\<\"SpAssoc\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpAssoc"], "\<\"SpM\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"PolVec\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/PolVec"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ImplicitRef\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ImplicitRef"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ImplicitRef.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ImplicitRef", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ImplicitRef", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImplicitRef", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     " where all occurrences of ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with explicit default reference vectors have those vectors removed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImplicitRef", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["P", "TI"]}], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     "\[LineSeparator]removes reference vectors only from ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with label ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImplicitRef", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     "\[LineSeparator]removes reference vectors only from ",
     Cell[BoxData[
      ButtonBox["SpAssoc",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["PolVec",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
     " with labels matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->766126579],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "HideNonDefault", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to remove all explicit reference vectors including non-default ones\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(9)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->970671177],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->951117165],

Cell[TextData[{
 "Explicit default reference vectors are removed from ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1722574156],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2095819514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->625200535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->672225755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", 
   RowBox[{"SpRef", "[", "P", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1684131913],

Cell[BoxData[
 SuperscriptBox["P", 
  SubscriptBox["q", "P"]]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1479991462],

Cell[BoxData[
 SuperscriptBox["P", "\[Flat]"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1760519697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", 
   RowBox[{"SpRef", "[", "P", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->168275978],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", 
   SubscriptBox["q", "P"]], "P"}]], "Output",
 ImageSize->{24, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->157587787],

Cell[BoxData[
 RowBox[{
  SubscriptBox["", "\[PlusMinus]"], "P"}]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->426608890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", 
   RowBox[{"SpRef", "[", "P", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1718656058],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", 
    SubscriptBox["q", "P"]}], ")"}]}]], "Output",
 ImageSize->{37, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1089386631],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", "P", ")"}]}]], "Output",
 ImageSize->{37, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1746744722]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2054992586],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with implicit reference vectors",
 " are unchanged",
 ":"
}], "ExampleText",
 CellID->1344538458],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1752712815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135526820],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->267682369]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1027073850],

Cell[BoxData[
 SuperscriptBox["P", "\[Flat]"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->684653568],

Cell[BoxData[
 SuperscriptBox["P", "\[Flat]"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1260472250]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->644198539],

Cell[BoxData[
 RowBox[{
  SubscriptBox["", "\[PlusMinus]"], "P"}]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->303187466],

Cell[BoxData[
 RowBox[{
  SubscriptBox["", "\[PlusMinus]"], "P"}]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1206300396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ImplicitRef"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->88279474],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", "P", ")"}]}]], "Output",
 ImageSize->{37, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1206460863],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", "P", ")"}]}]], "Output",
 ImageSize->{37, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->491629563]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 "Remove explicit default reference vectors from all occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->724827522],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1440536946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1728219325],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->370637659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{"PolVec", "[", 
     RowBox[{"Q", ",", "1"}], "]"}], ",", 
    RowBox[{"SpAssoc", "[", 
     RowBox[{"P", ",", 
      RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}]}], "]"}], 
  RowBox[{"Spaa", "[", 
   RowBox[{
    RowBox[{"SpAssoc", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}], ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{"P", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", "1"}], "]"}], ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{"Q", ",", "0", ",", "1"}], "]"}], ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"R", ",", "1", ",", "2"}], "]"}]}], "]"}], 
  RowBox[{"Spbb", "[", 
   RowBox[{
    RowBox[{"SpAssoc", "[", 
     RowBox[{"P", ",", "3"}], "]"}], ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"R", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"SpRef", "[", "R", "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", "%", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1980619307],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", 
     SubscriptBox["q", "Q"]], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{522, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->573924201],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "\[Flat]"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "-"], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{470, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1002121518]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41462811],

Cell[TextData[{
 "Remove explicit default reference vectors from occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with given label:"
}], "ExampleText",
 CellID->1064799327],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->851145621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->466784185],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->390325775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"SpAssoc", "[", 
      RowBox[{"P", ",", 
       RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}]}], "]"}], 
   RowBox[{"Spaa", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"P", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}], "]"}], 
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "0", ",", "1"}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", "1", ",", "2"}], "]"}]}], "]"}], 
   RowBox[{"Spbb", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"P", ",", "3"}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"SpRef", "[", "R", "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641073180],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", 
     SubscriptBox["q", "Q"]], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{522, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1871198120]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"expr", ",", "P"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1304563749],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", 
     SubscriptBox["q", "Q"]], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{491, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1898546906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"expr", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->779357452],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", "\[Flat]"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{512, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1850181395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"expr", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1346674596],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", 
     SubscriptBox["q", "Q"]], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "-"], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{511, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1586792764]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1145155664],

Cell[TextData[{
 "Remove explicit default reference vectors from occurrences of ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with label matching given pattern:"
}], "ExampleText",
 CellID->1923664632],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1680824472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "R"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->306750854],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "R"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`R}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1089527862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"SpAssoc", "[", 
      RowBox[{"P", ",", 
       RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}]}], "]"}], 
   RowBox[{"Spaa", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"SpRef", "[", "Q", "]"}]}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"P", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}], "]"}], 
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", "1"}], "]"}], ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{"Q", ",", "0", ",", "1"}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", "1", ",", "2"}], "]"}]}], "]"}], 
   RowBox[{"Spbb", "[", 
    RowBox[{
     RowBox[{"SpAssoc", "[", 
      RowBox[{"P", ",", "3"}], "]"}], ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"R", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"SpRef", "[", "R", "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1621210354],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", 
     SubscriptBox["q", "Q"]], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{522, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->873920849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"P", "|", "Q"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1165966655],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", "P", ")"}]}], "|", 
    SuperscriptBox["Q", "\[Flat]"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubsuperscriptBox["", "-", 
      SubscriptBox["q", "R"]], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{481, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->931244737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"Except", "[", "P", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1345715144],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Epsilon]", "+"], 
     RowBox[{"(", "Q", ")"}]}], ",", 
    SuperscriptBox["P", 
     SubscriptBox["q", "Q"]]}], "]"}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "-"], 
     RowBox[{"(", 
      RowBox[{"P", ",", 
       SubscriptBox["q", "P"]}], ")"}]}], "|", 
    SuperscriptBox["Q", "\[Flat]"], "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", 
    RowBox[{
     SuperscriptBox["\[Epsilon]", "0"], 
     RowBox[{"(", 
      RowBox[{"Q", ",", "1"}], ")"}]}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "2"], "R"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["", "-"], "R"}], "|", 
    SuperscriptBox["P", "3"], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{501, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->532420704]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "HideNonDefault",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"HideNonDefault\" set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (default value) ",
 Cell[BoxData[
  ButtonBox["SpAssoc",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " with non-default explicit reference vectors are unchanged:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444978689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->511285909],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2077260453]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "False"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1591076966],

Cell[BoxData[
 SuperscriptBox["P", "1"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1262507595],

Cell[BoxData[
 SuperscriptBox["P", "1"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1146880881]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "False"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1096536223],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", "2"], "P"}]], "Output",
 ImageSize->{29, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1180862055],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", "2"], "P"}]], "Output",
 ImageSize->{29, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->972800038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "False"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->2031610758],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", "3"}], ")"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1970534056],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", "3"}], ")"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->676313328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550115669],

Cell[TextData[{
 "With \"HideNonDefault\" set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " all explicit reference vectors are removed:"
}], "ExampleText",
 CellID->1339036093],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110703992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124041415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1287985790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "True"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->568552033],

Cell[BoxData[
 SuperscriptBox["P", "1"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->188549331],

Cell[BoxData[
 SuperscriptBox["P", "\[Flat]"]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->418811752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpM", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "True"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->657746663],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["", "\[PlusMinus]", "2"], "P"}]], "Output",
 ImageSize->{29, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->445231148],

Cell[BoxData[
 RowBox[{
  SubscriptBox["", "\[PlusMinus]"], "P"}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->428425388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitRef", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<HideNonDefault\>\"", "\[Rule]", "True"}]}], " ", 
  "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1091941965],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", 
   RowBox[{"P", ",", "3"}], ")"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1596195008],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
  RowBox[{"(", "P", ")"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1632447392]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExplicitRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExplicitRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpAssoc",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PolVec"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->869596258],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImplicitRef - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 44.898780}", 
    "history" -> {"XX", "", "", ""}, "context" -> 
    "SpinorsExtras`RefUtilities`", "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ImplicitRef[expr] returns expr where all occurrences of SpAssoc, SpM and \
PolVec with explicit default reference vectors have those vectors \
removed.ImplicitRef[expr, P] removes reference vectors only from SpAssoc, SpM \
and PolVec with label P .ImplicitRef[expr, patt] removes reference vectors \
only from SpAssoc, SpM and PolVec with labels matching patt.", 
    "synonyms" -> {}, "title" -> "ImplicitRef", "titlemodifier" -> "", 
    "windowtitle" -> "ImplicitRef", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ImplicitRef"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

