Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpRef\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpRef"], "\<\"SpAssoc\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpAssoc"], "\<\"SpM\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/SpM"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/LightConeDecompose\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/LightConeDecompose"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
LightConeDecompose.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/LightConeDecompose", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["LightConeDecompose", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["P", "TI"]}], " ", "]"}]], "InlineFormula"],
     "\[LineSeparator]performs light cone decomposition of Lorentz vectors \
and massive spinors, in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with label ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     ". Lorentz vectors are decomposed with default reference vector and \
massive spinors with their reference vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       StyleBox[
        RowBox[{"expr", ",", "patt"}], "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs light cone decomposition of those Lorentz \
vectors and massive spinors in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " which label matches pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". Lorentz vectors are decomposed with default reference vector and \
massive spinors with their reference vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["P", "TI"], " ", "\[Rule]", 
         StyleBox["q", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]with ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " being massless spinor. Decomposes Lorentz vectors and massive spinors, \
in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with label ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     ". Lorentz vectors and spinors with implicit reference vectors are \
decomposed with reference vector ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " and massive spinors with explicit reference vector are decomposed with \
their reference vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["P", "TI"], "\[Rule]", 
         StyleBox["Q", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
     " being massive LVector. Decomposition where Lorentz vectors and spinors \
with implicit reference vectors are decomposed with reference vector being \
vector associated with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
     " coming from simultaneous decomposition with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     ". Massive spinors with explicit reference vectors are decomposed with \
their reference vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["patt", "TI"], "\[Rule]", 
         StyleBox["x", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes all Lorentz vectors and massive spinors of \
which label matches pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". Lorentz vectors and spinors with implicit reference vectors are \
decomposed with reference vector inferred from ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and massive spinors with explicit reference vectors are decomposed \
with their reference vectors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox[
         RowBox[{"patt", "\[RuleDelayed]", "replacement"}], "TI"]}], 
       StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]Decomposition with reference vector inferred from ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " can have named patterns inside and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     " can use variables matched by those named patterns."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["p1", "TI"], "\[Rule]", 
           StyleBox["x1", "TI"]}], ",", 
          StyleBox["p2", "TI"], ",", 
          RowBox[{
           StyleBox["p3", "TI"], "\[Rule]", 
           StyleBox["x3", "TI"]}], ",", "..."}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]performs decompositions using all given patterns and \
rules."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             StyleBox["p11", "TI"], "\[Rule]", 
             StyleBox["x11", "TI"]}], ",", 
            StyleBox["p12", "TI"], ",", "..."}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             StyleBox["p21", "TI"], "\[Rule]", 
             StyleBox["x21", "TI"]}], ",", "..."}], "}"}], ",", "..."}], 
         "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a ",
     Cell[BoxData[
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"]], "InlineFormula"],
     ", each element of this list is a result of decomposition using \
subsequent list of patterns and rules."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LightConeDecompose", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]Decomposes Lorentz vectors and massive spinors with all \
labels. Lorentz vectors are decomposed with default reference vector and \
massive spinors with their reference vectors."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1803415945],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ForceRefChange\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["SpM",
       BaseStyle->"Link",
       ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula"],
     " with explicit reference spinors should have their reference spinors \
changed to one used by ",
     Cell[BoxData["LightConeDecompose"], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(13)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->484162104],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1969944078],

Cell["Decomposition with default reference vector:", "ExampleText",
 CellID->427585760],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1460825651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "L"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->372465491],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "L"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`L}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->21979979]
}, Open  ]],

Cell["LVector decomposition:", "ExampleText",
 CellID->571545523],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sm", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", "P"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->22761238],

Cell[BoxData[
 RowBox[{"Sm", "[", "P", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->211299538],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sm", "[", 
   SuperscriptBox["P", "\[Flat]"], "]"}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "P"}], "]"}], " ", 
    RowBox[{"Sm", "[", 
     SubscriptBox["q", "P"], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox["P", "\[Flat]"], ",", 
      SubscriptBox["q", "P"]}], "]"}]}]]}]], "Output",
 ImageSize->{190, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2030169109]
}, Open  ]],

Cell["Massive spinor decomposition:", "ExampleText",
 CellID->1480068594],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"L", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", "P"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->2066884932],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", 
   RowBox[{
    SubscriptBox["", "+"], "L"}], "]"}], TraditionalForm]], "Output",
 ImageSize->{76, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1350267406],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox["P", "\[Flat]"], "|", 
    RowBox[{
     SubscriptBox["", "+"], "L"}], "]"}],
   TraditionalForm], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", "P"], "|", 
      RowBox[{
       SubscriptBox["", "+"], "L"}], "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SubscriptBox["q", "P"], "|", 
     SuperscriptBox["P", "\[Flat]"], "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{260, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1244982312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1588043465],

Cell["Decomposition with given massless reference vector:", "ExampleText",
 CellID->1285149250],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->850876252],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "L"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1064083701],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "L"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`L}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1885524717],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->602736145]
}, Open  ]]
}, Open  ]],

Cell["LVector decomposition:", "ExampleText",
 CellID->418139926],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MP", "[", 
  RowBox[{"P", ",", "L"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"P", "\[Rule]", "q"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->696582666],

Cell[BoxData[
 RowBox[{"MP", "[", 
  RowBox[{"L", ",", "P"}], "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->118471629],

Cell[BoxData[
 RowBox[{
  RowBox[{"MP", "[", 
   RowBox[{"L", ",", 
    SuperscriptBox["P", "q"]}], "]"}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"L", ",", "q"}], "]"}], " ", 
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "P"}], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{"q", ",", 
      SuperscriptBox["P", "q"]}], "]"}]}]]}]], "Output",
 ImageSize->{227, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1835499056]
}, Open  ]],

Cell["Massive spinor decomposition:", "ExampleText",
 CellID->2034488626],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spbb", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"L", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"P", "\[Rule]", "q"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->735817603],

Cell[BoxData[
 FormBox[
  RowBox[{"[", 
   RowBox[{
    SubscriptBox["", "-"], "P"}], "|", 
   RowBox[{
    SubscriptBox["", "+"], "L"}], "]"}], TraditionalForm]], "Output",
 ImageSize->{74, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1842070033],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"MP", "[", 
       RowBox[{"P", ",", "P"}], "]"}]], " ", 
     FormBox[
      RowBox[{"\[LeftAngleBracket]", "q", "|", 
       RowBox[{
        SubscriptBox["", "+"], "L"}], "]"}],
      TraditionalForm]}], 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "q", "|", 
      SuperscriptBox["P", "q"], "\[RightAngleBracket]"}],
     TraditionalForm]]}], "+", 
  FormBox[
   RowBox[{"[", 
    SuperscriptBox["P", "q"], "|", 
    RowBox[{
     SubscriptBox["", "+"], "L"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{263, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->62547937]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621276582],

Cell["Decomposition with given massive reference vector:", "ExampleText",
 CellID->559496242],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2005309836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "L", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255828161],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "L", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`L, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1329805609]
}, Open  ]],

Cell["LVector decomposition:", "ExampleText",
 CellID->1505249982],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spba", "[", 
  RowBox[{"1", ",", "P", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"P", "\[Rule]", "Q"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->854582656],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "2", "|", "P", "|", "1", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{58, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1082885272],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", 
    SuperscriptBox["P", "Q"], "|", "1", "]"}],
   TraditionalForm], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"P", ",", "P"}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "2", "|", 
      SuperscriptBox["Q", "P"], "|", "1", "]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox["P", "Q"], ",", 
      SuperscriptBox["Q", "P"]}], "]"}]}]]}]], "Output",
 ImageSize->{252, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1474815801]
}, Open  ]],

Cell["Massive spinor decomposition:", "ExampleText",
 CellID->1604177257],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"L", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"P", "\[Rule]", "Q"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->560443272],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "-"], "L"}], "|", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->953193782],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "L"}], "|", 
    SuperscriptBox["P", "Q"], "\[RightAngleBracket]"}],
   TraditionalForm], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "-"], "L"}], "|", 
      SuperscriptBox["Q", "P"], "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox["Q", "P"], "|", 
     SuperscriptBox["P", "Q"], "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{264, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1898138794]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell["\<\
Decompose all labels matching given pattern, with default reference vectors:\
\>", "ExampleText",
 CellID->1146795390],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1039245352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1466133179],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     SubscriptBox["P", "2"], ",", 
     SubscriptBox["P", "3"], ",", 
     SubscriptBox["P", "4"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{
    Subscript[$CellContext`P, 1], 
    Subscript[$CellContext`P, 2], 
    Subscript[$CellContext`P, 3], 
    Subscript[$CellContext`P, 4]}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1048097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "4"], ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LightConeDecompose", "[", 
   RowBox[{"%", ",", 
    SubscriptBox["P", 
     RowBox[{"_", "?", "OddQ"}]]}], "]"}], "//", "Expand"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->211319136],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], 
    SubscriptBox["P", "1"]}], "|", 
   SubscriptBox["P", "2"], "|", 
   SubscriptBox["P", "3"], "|", 
   RowBox[{
    SubscriptBox["", "-"], 
    SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1668388947],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox[
     SubscriptBox["P", "1"], "\[Flat]"], "|", 
    SubscriptBox["P", "2"], "|", 
    SuperscriptBox[
     SubscriptBox["P", "3"], "\[Flat]"], "|", 
    RowBox[{
     SubscriptBox["", "-"], 
     SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "\[Flat]"], "|", 
      SubscriptBox["P", "2"], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]], "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", 
       SubscriptBox["P", "1"]], "|", 
      SubscriptBox["P", "2"], "|", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SubscriptBox["q", 
      SubscriptBox["P", "1"]], "|", 
     SuperscriptBox[
      SubscriptBox["P", "1"], "\[Flat]"], "]"}],
    TraditionalForm]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", 
       SubscriptBox["P", "1"]], "|", 
      SubscriptBox["P", "2"], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]], "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", 
       SubscriptBox["P", "1"]], "|", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "\[Flat]"], "]"}],
     TraditionalForm]}]]}]], "Output",
 ImageSize->{421, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1666306847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1922938364],

Cell["\<\
Decompose all labels matching given pattern, with given reference vector:\
\>", "ExampleText",
 CellID->1567072457],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1811869769],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->174746329],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     SubscriptBox["P", "2"], ",", 
     SubscriptBox["P", "3"], ",", 
     SubscriptBox["P", "4"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{
    Subscript[$CellContext`P, 1], 
    Subscript[$CellContext`P, 2], 
    Subscript[$CellContext`P, 3], 
    Subscript[$CellContext`P, 4]}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->572887338],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->891428938]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "4"], ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LightConeDecompose", "[", 
   RowBox[{"%", ",", 
    RowBox[{
     SubscriptBox["P", 
      RowBox[{"_", "?", "OddQ"}]], "\[Rule]", "q"}]}], "]"}], "//", 
  "Expand"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->535877969],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], 
    SubscriptBox["P", "1"]}], "|", 
   SubscriptBox["P", "2"], "|", 
   SubscriptBox["P", "3"], "|", 
   RowBox[{
    SubscriptBox["", "-"], 
    SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->72961126],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "q"], "|", 
      SubscriptBox["P", "2"], "|", "q", "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{"q", ",", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "q"]}], "]"}]}]], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox[
     SubscriptBox["P", "1"], "q"], "|", 
    SubscriptBox["P", "2"], "|", 
    SuperscriptBox[
     SubscriptBox["P", "3"], "q"], "|", 
    RowBox[{
     SubscriptBox["", "-"], 
     SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
   TraditionalForm], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", "q", "|", 
      SubscriptBox["P", "2"], "|", "q", "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{"q", ",", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "q"]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "q"], "|", "q", "]"}],
     TraditionalForm]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    FormBox[
     RowBox[{"[", "q", "|", 
      SubscriptBox["P", "2"], "|", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "q"], "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox[
      SubscriptBox["P", "1"], "q"], "|", "q", "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{414, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->954489995]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415482573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " with named patterns can be used:"
}], "ExampleText",
 CellID->834474956],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1296623946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84204283],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     SubscriptBox["P", "2"], ",", 
     SubscriptBox["P", "3"], ",", 
     SubscriptBox["P", "4"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{
    Subscript[$CellContext`P, 1], 
    Subscript[$CellContext`P, 2], 
    Subscript[$CellContext`P, 3], 
    Subscript[$CellContext`P, 4]}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->1629611250]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{
     SubscriptBox["P", "4"], ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LightConeDecompose", "[", 
   RowBox[{"%", ",", 
    RowBox[{
     SubscriptBox["P", 
      RowBox[{"i_", "?", "OddQ"}]], "\[RuleDelayed]", 
     RowBox[{"Sp", "[", "i", "]"}]}]}], "]"}], "//", "Expand"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1791163993],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], 
    SubscriptBox["P", "1"]}], "|", 
   SubscriptBox["P", "2"], "|", 
   SubscriptBox["P", "3"], "|", 
   RowBox[{
    SubscriptBox["", "-"], 
    SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->354244356],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "1"], "|", 
      SubscriptBox["P", "2"], "|", "3", "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{"3", ",", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "3"]}], "]"}]}]], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox[
     SubscriptBox["P", "1"], "1"], "|", 
    SubscriptBox["P", "2"], "|", 
    SuperscriptBox[
     SubscriptBox["P", "3"], "3"], "|", 
    RowBox[{
     SubscriptBox["", "-"], 
     SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
   TraditionalForm], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", "1", "|", 
      SubscriptBox["P", "2"], "|", "3", "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{"3", ",", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"[", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "1"], "|", "1", "]"}],
     TraditionalForm]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{
       SubscriptBox["P", "1"], ",", 
       SubscriptBox["P", "1"]}], "]"}]], " ", 
    FormBox[
     RowBox[{"[", "1", "|", 
      SubscriptBox["P", "2"], "|", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "3"], "|", 
      RowBox[{
       SubscriptBox["", "-"], 
       SubscriptBox["P", "4"]}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox[
      SubscriptBox["P", "1"], "1"], "|", "1", "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{405, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1621125979]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->828134022],

Cell["List of rules, patterns and labels can be used:", "ExampleText",
 CellID->201122541],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669104977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"], ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1212538091],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     SubscriptBox["P", "2"], ",", 
     SubscriptBox["P", "3"], ",", 
     SubscriptBox["P", "4"], ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{
    Subscript[$CellContext`P, 1], 
    Subscript[$CellContext`P, 2], 
    Subscript[$CellContext`P, 3], 
    Subscript[$CellContext`P, 4], $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[20]:=",
 CellID->1060626524],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[20]:=",
 CellID->1005997481]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", 
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"], ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LightConeDecompose", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["P", "1"], "\[Rule]", "1"}], ",", 
      RowBox[{
       SubscriptBox["P", "2"], "|", 
       SubscriptBox["P", "3"]}], ",", 
      RowBox[{
       SubscriptBox["P", "3"], "\[Rule]", "Q"}]}], "}"}]}], "]"}], "//", 
  "Expand"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->2060719012],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", 
   SubscriptBox["P", "1"], "|", 
   SubscriptBox["P", "2"], "|", 
   SubscriptBox["P", "3"], "|", 
   SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2104109862],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", 
    SuperscriptBox[
     SubscriptBox["P", "1"], "1"], "|", 
    SuperscriptBox[
     SubscriptBox["P", "2"], "\[Flat]"], "|", 
    SuperscriptBox[
     SubscriptBox["P", "3"], "\[Flat]"], "|", 
    SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "1", "|", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "1"], "|", 
      SuperscriptBox[
       SubscriptBox["P", "2"], "\[Flat]"], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]], "|", 
      SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "2"], ",", 
      SubscriptBox["P", "2"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "1", "|", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "1"], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "2"]], "|", 
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], "|", 
      SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "2"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "2"]]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "2"], ",", 
      SubscriptBox["P", "2"]}], "]"}], " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SubscriptBox["P", "3"], ",", 
      SubscriptBox["P", "3"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "1", "|", 
      SuperscriptBox[
       SubscriptBox["P", "1"], "1"], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "2"]], "|", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]], "|", 
      SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   RowBox[{"4", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "2"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "2"]]}], "]"}], " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["P", "3"], "\[Flat]"], ",", 
      SubscriptBox["q", 
       SubscriptBox["P", "3"]]}], "]"}]}]]}]], "Output",
 ImageSize->{495, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->163043262]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506862189],

Cell[TextData[{
 "List of lists of rules can be used, ",
 Cell[BoxData["LightConeDecompose"], "InlineFormula"],
 " will return list or results:"
}], "ExampleText",
 CellID->1916300259],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55031983],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"], ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->2007065762],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", 
     SubscriptBox["P", "2"], ",", 
     SubscriptBox["P", "3"], ",", 
     SubscriptBox["P", "4"], ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{
    Subscript[$CellContext`P, 1], 
    Subscript[$CellContext`P, 2], 
    Subscript[$CellContext`P, 3], 
    Subscript[$CellContext`P, 4], $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[27]:=",
 CellID->1089477013],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[27]:=",
 CellID->1731828535]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", 
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"], ",", 
   SubscriptBox["P", "4"], ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LightConeDecompose", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["P", "1"], "\[Rule]", "1"}], ",", 
         RowBox[{
          SubscriptBox["P", "2"], "|", 
          SubscriptBox["P", "3"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["P", "3"], "\[Rule]", "Q"}], "}"}]}], "}"}]}], "]"}], "//",
    "Expand"}], "//", "TableForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->807473661],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", 
   SubscriptBox["P", "1"], "|", 
   SubscriptBox["P", "2"], "|", 
   SubscriptBox["P", "3"], "|", 
   SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->567819260],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       FormBox[
        RowBox[{"\[LeftAngleBracket]", "1", "|", 
         SuperscriptBox[
          SubscriptBox["P", "1"], "1"], "|", 
         SuperscriptBox[
          SubscriptBox["P", "2"], "\[Flat]"], "|", 
         SuperscriptBox[
          SubscriptBox["P", "3"], "\[Flat]"], "|", 
         SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
        TraditionalForm], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"MP", "[", 
          RowBox[{
           SubscriptBox["P", "3"], ",", 
           SubscriptBox["P", "3"]}], "]"}], " ", 
         FormBox[
          RowBox[{"\[LeftAngleBracket]", "1", "|", 
           SuperscriptBox[
            SubscriptBox["P", "1"], "1"], "|", 
           SuperscriptBox[
            SubscriptBox["P", "2"], "\[Flat]"], "|", 
           SubscriptBox["q", 
            SubscriptBox["P", "3"]], "|", 
           SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["P", "3"], "\[Flat]"], ",", 
           SubscriptBox["q", 
            SubscriptBox["P", "3"]]}], "]"}]}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"MP", "[", 
          RowBox[{
           SubscriptBox["P", "2"], ",", 
           SubscriptBox["P", "2"]}], "]"}], " ", 
         FormBox[
          RowBox[{"\[LeftAngleBracket]", "1", "|", 
           SuperscriptBox[
            SubscriptBox["P", "1"], "1"], "|", 
           SubscriptBox["q", 
            SubscriptBox["P", "2"]], "|", 
           SuperscriptBox[
            SubscriptBox["P", "3"], "\[Flat]"], "|", 
           SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["P", "2"], "\[Flat]"], ",", 
           SubscriptBox["q", 
            SubscriptBox["P", "2"]]}], "]"}]}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"MP", "[", 
          RowBox[{
           SubscriptBox["P", "2"], ",", 
           SubscriptBox["P", "2"]}], "]"}], " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SubscriptBox["P", "3"], ",", 
           SubscriptBox["P", "3"]}], "]"}], " ", 
         FormBox[
          RowBox[{"\[LeftAngleBracket]", "1", "|", 
           SuperscriptBox[
            SubscriptBox["P", "1"], "1"], "|", 
           SubscriptBox["q", 
            SubscriptBox["P", "2"]], "|", 
           SubscriptBox["q", 
            SubscriptBox["P", "3"]], "|", 
           SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
          TraditionalForm]}], 
        RowBox[{"4", " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["P", "2"], "\[Flat]"], ",", 
           SubscriptBox["q", 
            SubscriptBox["P", "2"]]}], "]"}], " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["P", "3"], "\[Flat]"], ",", 
           SubscriptBox["q", 
            SubscriptBox["P", "3"]]}], "]"}]}]]}]},
     {
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"MP", "[", 
          RowBox[{
           SubscriptBox["P", "3"], ",", 
           SubscriptBox["P", "3"]}], "]"}], " ", 
         FormBox[
          RowBox[{"\[LeftAngleBracket]", "1", "|", 
           SubscriptBox["P", "1"], "|", 
           SubscriptBox["P", "2"], "|", 
           SuperscriptBox["Q", 
            SubscriptBox["P", "3"]], "|", 
           SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         RowBox[{"MP", "[", 
          RowBox[{
           SuperscriptBox["Q", 
            SubscriptBox["P", "3"]], ",", 
           SuperscriptBox[
            SubscriptBox["P", "3"], "Q"]}], "]"}]}]], "+", 
       FormBox[
        RowBox[{"\[LeftAngleBracket]", "1", "|", 
         SubscriptBox["P", "1"], "|", 
         SubscriptBox["P", "2"], "|", 
         SuperscriptBox[
          SubscriptBox["P", "3"], "Q"], "|", 
         SubscriptBox["P", "4"], "|", "2", "\[RightAngleBracket]"}],
        TraditionalForm]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 ImageSize->{932, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->544262658]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1482960458],

Cell["Decompose all massive objects:", "ExampleText",
 CellID->831890605],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1701849469],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "L"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->971010996],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "L"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`L}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->144049737],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1748139365]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", "Q", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"L", ",", 
     RowBox[{"+", "1"}], ",", "q"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LightConeDecompose", "[", "%", "]"}], "//", "Expand"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->48879808],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "-"], "P"}], "|", "Q", "|", 
   RowBox[{
    SubsuperscriptBox["", "+", "q"], "L"}], "]"}], TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1520189701],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox["P", "\[Flat]"], "|", 
    SuperscriptBox["Q", "\[Flat]"], "|", 
    SuperscriptBox["L", "q"], "]"}],
   TraditionalForm], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"MP", "[", 
     RowBox[{"Q", ",", "Q"}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      SuperscriptBox["P", "\[Flat]"], "|", 
      SubscriptBox["q", "Q"], "|", 
      SuperscriptBox["L", "q"], "]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox["Q", "\[Flat]"], ",", 
      SubscriptBox["q", "Q"]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"L", ",", "L"}], "]"}]], " ", 
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "q", "|", 
      SuperscriptBox["Q", "\[Flat]"], "|", 
      SubscriptBox["q", "P"], "]"}],
     TraditionalForm]}], 
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "q", "|", 
      SuperscriptBox["L", "q"], "\[RightAngleBracket]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", "P"], "|", 
      SuperscriptBox["P", "\[Flat]"], "]"}],
     TraditionalForm]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"L", ",", "L"}], "]"}]], " ", 
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    RowBox[{"MP", "[", 
     RowBox[{"Q", ",", "Q"}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "q", "|", 
      SubscriptBox["q", "Q"], "|", 
      SubscriptBox["q", "P"], "]"}],
     TraditionalForm]}], 
   RowBox[{"2", " ", 
    RowBox[{"MP", "[", 
     RowBox[{
      SuperscriptBox["Q", "\[Flat]"], ",", 
      SubscriptBox["q", "Q"]}], "]"}], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "q", "|", 
      SuperscriptBox["L", "q"], "\[RightAngleBracket]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"[", 
      SubscriptBox["q", "P"], "|", 
      SuperscriptBox["P", "\[Flat]"], "]"}],
     TraditionalForm]}]]}]], "Output",
 ImageSize->{353, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->133053079]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ForceRefChange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"ForceRefChange\" set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (default value) if massive spinor has explicit reference vector this \
vector is used for it's decomposition:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788674970],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"q1", ",", "q2"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->872460898],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1004141025],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q1", ",", "q2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q1, $CellContext`q2}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2126146656]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}], ",", "q1"}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"P", "\[Rule]", "q2"}], "}"}], ",", 
   RowBox[{"\"\<ForceRefChange\>\"", "\[Rule]", "False"}]}], "]"}]}], "Input",
 
 CellLabel->"In[3]:=",
 CellID->369926059],

Cell[BoxData[
 RowBox[{"-", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "q1"], "P"}], "\[RightAngleBracket]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{103, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->843811682],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "|", 
     SuperscriptBox["P", "q1"], "\[RightAngleBracket]"}],
    TraditionalForm]}], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "-"], "Q"}], "|", "q1", "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox["P", "q1"], "|", "q1", "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{273, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->407727203]
}, Open  ]],

Cell[TextData[{
 "Massive spinors with implicit reference vectors are decomposed with \
reference vector used by ",
 Cell[BoxData["LightConeDecompose"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->174282542],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"P", "\[Rule]", "q2"}], "}"}], ",", 
   RowBox[{"\"\<ForceRefChange\>\"", "\[Rule]", "False"}]}], "]"}]}], "Input",
 
 CellLabel->"In[4]:=",
 CellID->122844518],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->478748204],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    SuperscriptBox["P", "q2"], "|", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
   TraditionalForm], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"[", "q2", "|", 
      RowBox[{
       SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox["P", "q2"], "|", "q2", "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{262, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1918597113]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1022994496],

Cell[TextData[{
 "With \"ForceRefChange\" set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " all spinors are decomposed with reference vector used by ",
 Cell[BoxData["LightConeDecompose"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->239826287],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1755089758],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"q1", ",", "q2"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1679864969],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1301107592],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q1", ",", "q2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q1, $CellContext`q2}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1266220026]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}], ",", "q1"}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LightConeDecompose", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"P", "\[Rule]", "q2"}], "}"}], ",", 
   RowBox[{"\"\<ForceRefChange\>\"", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->335497109],

Cell[BoxData[
 RowBox[{"-", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "|", 
    RowBox[{
     SubsuperscriptBox["", "+", "q1"], "P"}], "\[RightAngleBracket]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{103, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->859316815],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "|", 
     SuperscriptBox["P", "q2"], "\[RightAngleBracket]"}],
    TraditionalForm]}], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", "P"}], "]"}]], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "-"], "Q"}], "|", "q2", "]"}],
     TraditionalForm]}], 
   FormBox[
    RowBox[{"[", 
     SuperscriptBox["P", "q2"], "|", "q2", "]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{271, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->743026073]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpAssoc",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpAssoc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->
  "paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "RelatedDemonstrations",
 CellID->1285121743],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->532317707],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightConeDecompose - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 3, 47.885327}", 
    "history" -> {"XX", "", "", ""}, "context" -> 
    "SpinorsExtras`MassiveUtilities`", 
    "keywords" -> {"light cone", "decomposition"}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "LightConeDecompose[expr, P ] performs light cone decomposition of \
Lorentz vectors and massive spinors, in expr, with label P . Lorentz vectors \
are decomposed with default reference vector and massive spinors with their \
reference vectors.LightConeDecompose[expr, patt] performs light cone \
decomposition of those Lorentz vectors and massive spinors in expr which \
label matches pattern patt. Lorentz vectors are decomposed with default \
reference vector and massive spinors with their reference \
vectors.LightConeDecompose[expr, P -> q] with q being massless spinor. \
Decomposes Lorentz vectors and massive spinors, in expr, with label P . \
Lorentz vectors and spinors with implicit reference vectors are decomposed \
with reference vector q and massive spinors with explicit reference vector \
are decomposed with their reference vectors.LightConeDecompose[expr, P -> Q] \
with Q being massive LVector. Decomposition where Lorentz vectors and spinors \
with implicit reference vectors are decomposed with reference vector being \
vector associated with Q coming from simultaneous decomposition with P . \
Massive spinors with explicit reference vectors are decomposed with their \
reference vectors.LightConeDecompose[expr, patt -> x] decomposes all Lorentz \
vectors and massive spinors of which label matches pattern patt. Lorentz \
vectors and spinors with implicit reference vectors are decomposed with \
reference vector inferred from x and massive spinors with explicit reference \
vectors are decomposed with their reference vectors.LightConeDecompose[expr, \
patt :> replacement ] Decomposition with reference vector inferred from \
replacement . patt can have named patterns inside and replacement can use \
variables matched by those named patterns.LightConeDecompose[expr, {p1 -> x1, \
p2, p3 -> x3, ...}] performs decompositions using all given patterns and \
rules.LightConeDecompose[expr, {{p11 -> x11, p12, ...}, {p21 -> x21, ...}, \
...}] returns a List, each element of this list is a result of decomposition \
using subsequent list of patterns and rules.LightConeDecompose[expr] \
Decomposes Lorentz vectors and massive spinors with all labels. Lorentz \
vectors are decomposed with default reference vector and massive spinors with \
their reference vectors.", "synonyms" -> {}, "title" -> "LightConeDecompose", 
    "titlemodifier" -> "", "windowtitle" -> "LightConeDecompose", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/LightConeDecompose"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

