Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpM\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"AnySpinorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/AnySpinorQ"], "\<\"MassiveLVectorQ\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/MassiveLVectorQ"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/MassiveSpinorQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/MassiveSpinorQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
MassiveSpinorQ.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/MassiveSpinorQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["MassiveSpinorQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MassiveSpinorQ", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula",
      ShowStringCharacters->False],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     " is interpretable as massive spinor label. Returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula",
      ShowStringCharacters->False],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(3)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->724338574],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->145336004],

Cell["\<\
Arbitrary symbols, massless Spinors, LVectors and slashed matrices are not \
interpreted as massive spinors:\
\>", "ExampleText",
 CellID->985853592],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->584950450],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "M", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1131463511],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1474803667],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1094919411],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "M", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`M}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1812858942]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MassiveSpinorQ", "[", "x", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", "M", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->84665286],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1118313812],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->164764286],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->282037675],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1311090785]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1401855930],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"], "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[" ", "TI"], ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], "]"}]], "InlineFormula",
  ShowStringCharacters->False],
 " with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector, is interpreted as massive spinor:"
}], "ExampleText",
 CellID->2127355215],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265825617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->798072144],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1788429219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->852495210],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->653027873],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2000509704],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1579199177],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1481346307]
}, Open  ]],

Cell[TextData[{
 "When first argument of ",
 Cell[BoxData[
  ButtonBox["SpM",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/SpM"]], "InlineFormula",
  ShowStringCharacters->False],
 " is not LVector or second is not interpretable as ",
 Cell[BoxData[
  RowBox[{"\[PlusMinus]", "1"}]], "InlineFormula"],
 ", expression is not interpreted as massive spinor:"
}], "ExampleText",
 CellID->1323017349],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->987329385],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1010971961],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1592747830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1665125691],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"], "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[" ", "TI"], ",", 
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula",
  ShowStringCharacters->False],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor, is interpreted as massive spinor:"
}], "ExampleText",
 CellID->1595957069],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42393444],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->166075545],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1529183632],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1554588383]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}], ",", "q"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}], ",", "q"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1635340903],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->407443456],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1180656833],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1264266916],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1184670238]
}, Open  ]],

Cell[TextData[{
 "When first argument of ",
 Cell[BoxData["SpM"], "InlineFormula"],
 " is not LVector, second is not interpretable as ",
 Cell[BoxData[
  RowBox[{"\[PlusMinus]", "1"}]], "InlineFormula"],
 " or third is not massless Spinor",
 ", expression is not interpreted as massive spinor",
 ":"
}], "ExampleText",
 CellID->574967913],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", "x", ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MassiveSpinorQ", "[", 
  RowBox[{"SpM", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}], ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1433349059],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1543335110],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->569896417],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->656478573]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnySpinorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/AnySpinorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MassiveLVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/MassiveLVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->174772621],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MassiveSpinorQ - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 2.817279}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Massive`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "MassiveSpinorQ[x] returns True if x is interpretable as massive spinor \
label. Returns False otherwise.", "synonyms" -> {}, "title" -> 
    "MassiveSpinorQ", "titlemodifier" -> "", "windowtitle" -> 
    "MassiveSpinorQ", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/MassiveSpinorQ"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

