Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"AppendPhase\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/AppendPhase"], "\<\"ExpandPolVec\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ExpandPolVec"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/Phase\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/Phase"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
Phase.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/Phase", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["Phase", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Phase", "[", 
       RowBox[{
        StyleBox["phaseConvention", "TI"], ",", " ", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents additional phase of expression represented \
by ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(4)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->252982194],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157],

Cell["Define your own phase convention for polarization vectors:", \
"ExampleText",
 CellID->384717591],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->790387550],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Phase", "[", 
   RowBox[{"\"\<MyPhaseConvention\>\"", ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{
      RowBox[{"P_", "?", "LVectorQ"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Spaa", "[", 
    RowBox[{"P", ",", 
     RowBox[{"SpRef", "[", "P", "]"}]}], "]"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", " ", 
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", 
       RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Phase", "[", 
    RowBox[{"\"\<MyPhaseConvention\>\"", ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{
       RowBox[{"P_", "?", "LVectorQ"}], ",", 
       RowBox[{"-", "1"}], ",", "ref_"}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Spaa", "[", 
     RowBox[{"P", ",", "ref"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", " ", 
      RowBox[{"MP", "[", 
       RowBox[{"P", ",", "ref"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phase", "[", 
   RowBox[{"\"\<MyPhaseConvention\>\"", ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{
      RowBox[{"P_", "?", "LVectorQ"}], ",", 
      RowBox[{"+", "1"}]}], "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Spbb", "[", 
    RowBox[{"P", ",", 
     RowBox[{"SpRef", "[", "P", "]"}]}], "]"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", " ", 
     RowBox[{"MP", "[", 
      RowBox[{"P", ",", 
       RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phase", "[", 
    RowBox[{"\"\<MyPhaseConvention\>\"", ",", 
     RowBox[{"PolVec", "[", 
      RowBox[{
       RowBox[{"P_", "?", "LVectorQ"}], ",", 
       RowBox[{"+", "1"}], ",", "ref_"}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Spbb", "[", 
     RowBox[{"P", ",", "ref"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", " ", 
      RowBox[{"MP", "[", 
       RowBox[{"P", ",", "ref"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phase", "[", 
   RowBox[{"\"\<MyPhaseConvention\>\"", ",", 
    RowBox[{"PolVec", "[", 
     RowBox[{
      RowBox[{"P_", "?", "LVectorQ"}], ",", "0", ",", 
      RowBox[{"Repeated", "[", 
       RowBox[{
        RowBox[{"_", "?", "SpinorQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}], ":=", 
  "1"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->391899192],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"expr", "=", 
  RowBox[{"Sm", "[", 
   RowBox[{"PolVec", "[", 
    RowBox[{"1", ",", 
     RowBox[{"+", "1"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", "expr", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"expr", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->31826371],

Cell[BoxData[
 RowBox[{"Sm", "[", 
  RowBox[{
   SuperscriptBox["\[Epsilon]", "+"], 
   RowBox[{"(", "1", ")"}]}], "]"}]], "Output",
 ImageSize->{84, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45100500],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"SmBA", "[", 
    RowBox[{
     SubscriptBox["q", "1"], ",", "1"}], "]"}]}], 
  FormBox[
   RowBox[{"[", 
    SubscriptBox["q", "1"], "|", "1", "]"}],
   TraditionalForm]]], "Output",
 ImageSize->{129, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1535594278],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"SmBA", "[", 
    RowBox[{
     SubscriptBox["q", "1"], ",", "1"}], "]"}], 
   SqrtBox[
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", 
      SubscriptBox["q", "1"]}], "]"}]]]}]], "Output",
 ImageSize->{109, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1749386685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"expr", "=", 
  RowBox[{"Sm", "[", 
   RowBox[{"PolVec", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", "expr", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{"expr", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1153640823],

Cell[BoxData[
 RowBox[{"Sm", "[", 
  RowBox[{
   SuperscriptBox["\[Epsilon]", "-"], 
   RowBox[{"(", "1", ")"}]}], "]"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1952838093],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"SmBA", "[", 
     RowBox[{"1", ",", 
      SubscriptBox["q", "1"]}], "]"}]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", 
     SubscriptBox["q", "1"], "\[RightAngleBracket]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{138, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2131108012],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"SmBA", "[", 
    RowBox[{"1", ",", 
     SubscriptBox["q", "1"]}], "]"}], 
   SqrtBox[
    RowBox[{"MP", "[", 
     RowBox[{"1", ",", 
      SubscriptBox["q", "1"]}], "]"}]]]}]], "Output",
 ImageSize->{109, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->533697848]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData["Phase"], "InlineFormula"],
 " is appended to expressions by ",
 Cell[BoxData[
  ButtonBox["AppendPhase",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/AppendPhase"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->528970134],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669661617],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"AppendPhase", "[", 
  RowBox[{"%", ",", "_La", ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1167584451],

Cell[BoxData[
 RowBox[{
  RowBox[{"CLa", "[", "1", "]"}], ".", 
  RowBox[{"La", "[", "2", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266510376],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CLa", "[", "1", "]"}], ".", 
   RowBox[{"La", "[", "2", "]"}]}], " ", 
  RowBox[{"Phase", "[", 
   RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
    RowBox[{"La", "[", "2", "]"}]}], "]"}]}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->800095814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350341712],

Cell[TextData[{
 Cell[BoxData["Phase"], "InlineFormula"],
 " is added to ",
 Cell[BoxData[
  ButtonBox["PolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/PolVec"]], "InlineFormula"],
 " when it's expanded by ",
 Cell[BoxData[
  ButtonBox["ExpandPolVec",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->540286035],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233967699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPolVec", "[", 
  RowBox[{
   RowBox[{"Sm", "[", 
    RowBox[{"PolVec", "[", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
   RowBox[{
   "\"\<PhaseConvention\>\"", "\[Rule]", "\"\<MyPhaseConvention\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1227228616],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Phase", "[", 
     RowBox[{"\<\"MyPhaseConvention\"\>", ",", 
      RowBox[{
       SuperscriptBox["\[Epsilon]", "-"], 
       RowBox[{"(", 
        RowBox[{"1", ",", 
         SubscriptBox["q", "1"]}], ")"}]}]}], "]"}], " ", 
    RowBox[{"SmBA", "[", 
     RowBox[{"1", ",", 
      SubscriptBox["q", "1"]}], "]"}]}], 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", 
     SubscriptBox["q", "1"], "\[RightAngleBracket]"}],
    TraditionalForm]]}]], "Output",
 ImageSize->{425, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1413767430]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->700603436],

Cell[TextData[{
 "Automatic phase is ",
 Cell[BoxData["1"], "InlineFormula"],
 " for all expressions:"
}], "ExampleText",
 CellID->1232215555],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247032227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Phase", "[", 
  RowBox[{"Automatic", ",", "anything"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->712962833],

Cell[BoxData["1"], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1157827660]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppendPhase",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/AppendPhase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandPolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->30849576],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Phase - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 5.220626}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Phase`", 
    "keywords" -> {"phase convention", "PhaseConvention"}, 
    "specialkeywords" -> {}, "tutorialcollectionlinks" -> {}, "index" -> True,
     "label" -> "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "Phase[phaseConvention, expr] represents additional phase of expression \
represented by expr.", "synonyms" -> {}, "title" -> "Phase", "titlemodifier" -> 
    "", "windowtitle" -> "Phase", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/Phase"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

