Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ExpandPolVec\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandPolVec"], "\<\"DeclarePossiblePol\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/DeclarePossiblePol"], \
"\<\"UndeclarePossiblePol\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/UndeclarePossiblePol"], \
"\<\"PossiblePolQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/PossiblePolQ"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/PolVec\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/PolVec"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
PolVec.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/PolVec", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["PolVec", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolVec", "[", 
       RowBox[{
        StyleBox["P", "TI"], ",", " ", 
        StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents polarization vector of vector boson with \
momentum ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     ", polarization ",
     Cell[BoxData[
      StyleBox["pol", "TI"]], "InlineFormula"],
     " and implicit reference vector. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolVec", "[", 
       RowBox[{
        StyleBox["P", "TI"], ",", " ", 
        StyleBox["pol", "TI"], ",", " ", 
        StyleBox["ref", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents polarization vector of vector boson with \
momentum ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     ", polarization ",
     Cell[BoxData[
      StyleBox["pol", "TI"]], "InlineFormula"],
     " and reference vector ",
     Cell[BoxData[
      StyleBox["ref", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->2001069453],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 "Transverse polarization vectors are lightlike four-vectors, so ",
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", " ", 
    RowBox[{"\[PlusMinus]", "1"}], ",", " ", "..."}], "]"}]], "InlineFormula"],
 " can be interpreted as massless spinor."
}], "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(19)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->60884705],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2123667759],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Notation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->2034196178],

Cell[TextData[{
 "With activated notation ",
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", " ", 
    StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " interpretable as possible polarization, is denoted by",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "pol"], 
   RowBox[{"(", "P", ")"}]}]], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->1250971477],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1677056277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->798072144],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1804346174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"+", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"-", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[MinusPlus]", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "0"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "\"\<S\>\""}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->852495210],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "+"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 1]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183098698],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "-"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, -1]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1866070867],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 
   PlusMinus[1]]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1800922859],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\[MinusPlus]"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 
   MinusPlus[1]]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1080150769],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "0"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 0]]], "Output",
 ImageSize->{49, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->564204803],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\<\"S\"\>"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, "S"]]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1282903043]
}, Open  ]],

Cell[TextData[{
 "When first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector or second is not interpretable as ",
 "possible polarization",
 " notation is not changed:"
}], "ExampleText",
 CellID->1323017349],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->987329385],

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->919984573],

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "x"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1375198965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1665125691],

Cell[TextData[{
 "With activated notation ",
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[",", "TI"], 
    StyleBox["pol", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector, ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " interpretable as possible polarization",
 " and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor, is denoted by ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "pol"], 
   RowBox[{"(", 
    RowBox[{"P", ",", "q"}], ")"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1595957069],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42393444],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->166075545],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->572304184],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1198811982]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"+", "1"}], ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"-", "1"}], ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[PlusMinus]", "1"}], ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"\[MinusPlus]", "1"}], ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "0", ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "\"\<S\>\"", ",", "q"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1635340903],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "+"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 1, $CellContext`q]]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->366366724],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "-"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, -1, $CellContext`q]]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1604442430],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\[PlusMinus]"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 
   PlusMinus[1], $CellContext`q]]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->60430475],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\[MinusPlus]"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 
   MinusPlus[1], $CellContext`q]]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1657154283],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "0"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, 0, $CellContext`q]]], "Output",
 ImageSize->{72, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1617231719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "\<\"S\"\>"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, "S", $CellContext`q]]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57368003]
}, Open  ]],

Cell[TextData[{
 "When first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector, second is not interpretable as possible polarization or \
third is not massless Spinor notation is not changed:"
}], "ExampleText",
 CellID->574967913],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "1"}], ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "x", ",", "q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"-", "1"}], ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1433349059],

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "1"}], ",", "q"}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->350854633],

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "x", ",", "q"}], "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->580072080],

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", 
   RowBox[{"-", "1"}], ",", "x"}], "]"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->773645049]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244626948],

Cell[TextData[{
 "To keep symbolic second argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " but still use special notation, a symbol can be set to be interpreted as \
possible polarization using ",
 Cell[BoxData[
  ButtonBox["DeclarePossiblePol",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/DeclarePossiblePol"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->823689037],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1878679328],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->972599496],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1247725055],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1144933690]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePossiblePol", "[", "y", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1921593776],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "y", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of possible vector boson \
polarizations\"\>"}],
  SequenceForm[{$CellContext`y}, 
   " added to the list of possible vector boson polarizations"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1159511928]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "y"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PolVec", "[", 
  RowBox[{"P", ",", "y", ",", "q"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1692310075],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "y"], 
   RowBox[{"(", "P", ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, $CellContext`y]]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->277395203],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "y"], 
   RowBox[{"(", 
    TemplateBox[{",","\",\"","P","q"},
     "RowWithSeparators"], ")"}]}],
  SpinorsExtras`Pol`PolVec[$CellContext`P, $CellContext`y, $CellContext`q]]], \
"Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1356689547]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LVector interpretation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->1087942709],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", " ", 
    StyleBox["pol", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " interpretable as possible polarization, is interpreted as LVector:"
}], "ExampleText",
 CellID->529855805],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675163668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->993999087],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1755389782]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "0"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "\"\<S\>\""}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1835046455],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88604501],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1013044317],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1876471797],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->833387310],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->974390230],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1722257951]
}, Open  ]],

Cell[TextData[{
 "If first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector or second is not interpretable as ",
 "possible polarization",
 ", then ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not interpreted as LVector:"
}], "ExampleText",
 CellID->317463178],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"x", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->2035745354],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1146070914],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1503310826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1653769037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[",", "TI"], 
    StyleBox["pol", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector,",
 Cell[BoxData[
  StyleBox["pol", "TI"]], "InlineFormula"],
 " interpretable as possible polarization",
 " and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor, is interpreted as LVector:"
}], "ExampleText",
 CellID->27330892],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388194211],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->432909847],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->838598799],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1633522131]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}], ",", "q"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}], ",", "q"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "0", ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "\"\<S\>\"", ",", "q"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1499106446],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->556599421],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->661441933],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2031391561],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194319733],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1541707210],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40101477]
}, Open  ]],

Cell[TextData[{
 "If first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector, second is not interpretable as ",
 "possible polarization",
 " or third is not massless Spinor, then ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not interpreted as LVector:"
}], "ExampleText",
 CellID->1559873741],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"x", ",", 
    RowBox[{"+", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "x", ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}], ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->311908890],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->937754604],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1995969109],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1235831527]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113716567],

Cell[TextData[{
 "To keep symbolic second argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " but still make it interpretable as LVector,",
 "a symbol can be set to be interpreted as possible polarization using ",
 Cell[BoxData[
  ButtonBox["DeclarePossiblePol",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/DeclarePossiblePol"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1128661457],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259912330],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1031555122],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->696040683],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->656195993]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePossiblePol", "[", "y", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1604470607],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "y", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of possible vector boson \
polarizations\"\>"}],
  SequenceForm[{$CellContext`y}, 
   " added to the list of possible vector boson polarizations"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->320724023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LVectorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "y", ",", "q"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->628292793],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1731468047],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->758115408]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spinor interpretation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->757426455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[",", "TI"], 
    RowBox[{"\[PlusMinus]", "1"}]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector, is interpreted as massless Spinor:"
}], "ExampleText",
 CellID->1184113083],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1350091403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1845061486],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1368138694]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1120899999],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->355464076],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->393103565],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1507429591],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1107157776]
}, Open  ]],

Cell[TextData[{
 "If first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector or second is not interpretable as ",
 Cell[BoxData[
  RowBox[{"\[PlusMinus]", "1"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not interpreted as ",
 "massless Spinor",
 ":"
}], "ExampleText",
 CellID->887473094],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"x", ",", 
    RowBox[{"+", "1"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1338724009],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->244846316],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1670667889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->565631654],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PolVec", "[", 
   RowBox[{
    StyleBox["P", "TI"], 
    StyleBox[",", "TI"], 
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor, is interpreted as ",
 "massless Spinor",
 ":"
}], "ExampleText",
 CellID->113450558],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1592868189],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1749573708],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->511772017],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1818646344]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"-", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[PlusMinus]", "1"}], ",", "q"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"\[MinusPlus]", "1"}], ",", "q"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1606288142],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->74043589],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1210318063],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1443163345],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1412081180]
}, Open  ]],

Cell[TextData[{
 "If first argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not LVector, second is not interpretable as ",
 Cell[BoxData[
  RowBox[{"\[PlusMinus]", "1"}]], "InlineFormula"],
 " or third is not massless Spinor, then ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " is not interpreted as ",
 "massless Spinor",
 ":"
}], "ExampleText",
 CellID->855304791],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"x", ",", 
    RowBox[{"+", "1"}], ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "x", ",", "q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", 
    RowBox[{"+", "1"}], ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->582522588],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2126258356],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52283171],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->114492685]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->492981477],

Cell[TextData[{
 "To keep symbolic second argument of ",
 Cell[BoxData["PolVec"], "InlineFormula"],
 " but still make it interpretable as massless Spinor, a symbol can be set to \
be interpreted as ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["DeclarePlusMinusOne",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/DeclarePlusMinusOne"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1620229631],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397030002],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->645010041],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[20]:=",
 CellID->962744255],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[20]:=",
 CellID->1754275091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePlusMinusOne", "[", "y", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1662175769],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "y", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of symbolic representations \
of +1 or -1\"\>"}],
  SequenceForm[{$CellContext`y}, 
   " added to the list of symbolic representations of +1 or -1"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->756006303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"PolVec", "[", 
   RowBox[{"P", ",", "y", ",", "q"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1119038285],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->369364899],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->867927902]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1305812373],

Cell["\<\
For massless particles longitudinal and scalar polarizations are not allowed:\
\
\>", "ExampleText",
 CellID->288354576],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1162894113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1240850679],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`q}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1092430992]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"a", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->292280451],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"PolVec", "::", "forbidden0Pol"}], "MessageName"], ":", 
  " ", "\<\"In \[NoBreak]\\!\\(\\*InterpretationBox[\\(\[Epsilon]\\^0 \
\\(\\((a)\\)\\)\\), PolVec[a, 0]]\\)\[NoBreak] first argument \
\[NoBreak]\\!\\(a\\)\[NoBreak] is massless so \[NoBreak]\\!\\(0\\)\[NoBreak] \
polarization does not exist.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->828755662],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158523847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"a", ",", "0", ",", "q"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1778828326],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"PolVec", "::", "forbidden0Pol"}], "MessageName"], ":", 
  " ", "\<\"In \[NoBreak]\\!\\(\\*InterpretationBox[\\(\[Epsilon]\\^0 \\(\\((\
\\*TemplateBox[List[\\\",\\\", \\\"\\\\\\\",\\\\\\\"\\\", \\\"a\\\", \
\\\"q\\\"], \\\"RowWithSeparators\\\"])\\)\\)\\), PolVec[a, 0, q]]\\)\
\[NoBreak] first argument \[NoBreak]\\!\\(a\\)\[NoBreak] is massless so \
\[NoBreak]\\!\\(0\\)\[NoBreak] polarization does not exist.\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->994230709],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1574104754]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"a", ",", "\"\<S\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->658998135],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"PolVec", "::", "forbidden0Pol"}], "MessageName"], ":", 
  " ", "\<\"In \[NoBreak]\\!\\(\\*InterpretationBox[\\(\[Epsilon]\\^\\\"S\\\" \
\\(\\((a)\\)\\)\\), PolVec[a, \\\"S\\\"]]\\)\[NoBreak] first argument \
\[NoBreak]\\!\\(a\\)\[NoBreak] is massless so \[NoBreak]\\!\\(\\\"S\\\"\\)\
\[NoBreak] polarization does not exist.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1397366122],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1007873229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolVec", "[", 
  RowBox[{"a", ",", "\"\<S\>\"", ",", "q"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1095870769],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"PolVec", "::", "forbidden0Pol"}], "MessageName"], ":", 
  " ", "\<\"In \[NoBreak]\\!\\(\\*InterpretationBox[\\(\[Epsilon]\\^\\\"S\\\" \
\\(\\((\\*TemplateBox[List[\\\",\\\", \\\"\\\\\\\",\\\\\\\"\\\", \\\"a\\\", \
\\\"q\\\"], \\\"RowWithSeparators\\\"])\\)\\)\\), PolVec[a, \\\"S\\\", q]]\\)\
\[NoBreak] first argument \[NoBreak]\\!\\(a\\)\[NoBreak] is massless so \
\[NoBreak]\\!\\(\\\"S\\\"\\)\[NoBreak] polarization does not exist.\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1471303633],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->971431592]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandPolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclarePossiblePol",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/DeclarePossiblePol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UndeclarePossiblePol",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/UndeclarePossiblePol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossiblePolQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/PossiblePolQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->38072901],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolVec - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 10.058540}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Pol`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "PolVec[P, pol] represents polarization vector of vector boson with \
momentum P , polarization pol and implicit reference vector. PolVec[P, pol, \
ref] represents polarization vector of vector boson with momentum P , \
polarization pol and reference vector ref.", "synonyms" -> {}, "title" -> 
    "PolVec", "titlemodifier" -> "", "windowtitle" -> "PolVec", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/PolVec"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

