Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->False], {"\<\"SpinorsExtras/ref/QuietSpinorPrint\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["SpinorsExtras/ref/QuietSpinorPrint"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
QuietSpinorPrint.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", 
            "SpinorsExtras/ref/QuietSpinorPrint", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["QuietSpinorPrint", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"QuietSpinorPrint", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with turned off printing from ",
     Cell[BoxData["Spinors`"], "InlineFormula"],
     " package."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->638106345],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData["QuietSpinorPrint"], "InlineFormula"],
 " works internally by overriding ",
 Cell[BoxData["Spinors`Private`PRINT"], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->820456779],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1720944004],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->970043493],

Cell[TextData[{
 "Functions from ",
 Cell[BoxData["Spinors`"], "InlineFormula"],
 " package that usually print some output e.g. ",
 Cell[BoxData[
  ButtonBox["DeclareSpinor",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/DeclareSpinor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->739101685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1769359563],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->740623981]
}, Open  ]],

Cell[TextData[{
 "When used inside ",
 Cell[BoxData["QuietSpinorPrint"], "InlineFormula"],
 " print nothing:"
}], "ExampleText",
 CellID->705471557],

Cell[BoxData[
 RowBox[{"QuietSpinorPrint", "[", 
  RowBox[{"DeclareSpinor", "[", "b", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2032450824],

Cell["But other effects of their evaluation remain unchanged:", "ExampleText",
 
 CellID->1277955294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", "b", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->64925625],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1345295807]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QuietSpinorPrint - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 15.691515}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Package`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "QuietSpinorPrint[expr] evaluates expr with turned off printing from \
Spinors` package.", "synonyms" -> {}, "title" -> "QuietSpinorPrint", 
    "titlemodifier" -> "", "windowtitle" -> "QuietSpinorPrint", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/QuietSpinorPrint"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

