Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ReplaceLVector\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceLVector"], "\<\"ReplaceBSpinor\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ReplaceBSpinor"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ReplaceASpinor\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ReplaceASpinor"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ReplaceASpinor.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ReplaceASpinor", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ReplaceASpinor", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["x", "TI"], "\[Rule]", 
         StyleBox["r", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with massless or massive A spinors, labeled by ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", replaced by ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " can be linear combination of massless or massive spinors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["x", "TI"], "\[Rule]", 
         RowBox[{"{", 
          StyleBox[
           RowBox[{"a", ",", "b"}], "TI"], "}"}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces massless or massive A spinor ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " at beginning of spinor chain with difference of A spinor ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     ". A spinor ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " at end of spinor chain will be replaced by sum of A spinor ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     " can be linear combinations of labels they will be interpreted as \
linear combinations of B spinors, analogously ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " can be linear combinations of labels and they will be interpreted as \
linear combinations of A spinors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["patt", "TI"], "\[Rule]", 
         StyleBox["r", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive A spinors that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["patt", "TI"], "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["a", "TI"], ",", 
           StyleBox["b", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive A spinors, at beginning of spinor chain, \
that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by difference of A spinor ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     ". A spinors at end of spinor chain, that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ", will be replaced by sum of A spinor ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["patt", "TI"], "\[RuleDelayed]", 
         StyleBox["replacement", "TI"]}]}], 
       StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive A spinors that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " can have named patterns inside and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     " can use variables matched by those named patterns."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["patt", "TI"], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["replacementA", "TI"], 
           StyleBox[" ", "TI"], ",", 
           StyleBox["replacementB", "TI"]}], 
          StyleBox[" ", "TI"], "}"}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces A spinors, that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ", with difference of A spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementA", " "}], "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementB", "  "}], "TI"]], "InlineFormula"],
     ". A spinors at end of spinor chain, that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ", will be replaced by sum of A spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementA", " "}], "TI"]], "InlineFormula"],
     " and B spinor ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementB", "  "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementB", "  "}], "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementA", " "}], "TI"]], "InlineFormula"],
     " can use variables matched by named patterns in ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceASpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             StyleBox["a", "TI"], ",", 
             StyleBox["b", "TI"]}], "}"}]}], ",", 
          RowBox[{
           StyleBox["patt", "TI"], "\[RuleDelayed]", 
           StyleBox["replacement", "TI"]}], 
          StyleBox[" ", "TI"], ",", "\[Ellipsis]"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with replacement using all given rules."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"ReplaceASpinor", "[", 
        RowBox[{
         StyleBox["expr", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              SubscriptBox[
               StyleBox["x", "TI"], 
               StyleBox["1", "TR"]], "\[Rule]", 
              SubscriptBox[
               StyleBox["r", "TI"], 
               StyleBox["1", "TR"]]}], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              SubscriptBox[
               StyleBox["x", "TI"], 
               StyleBox["2", "TR"]], "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                SubscriptBox[
                 StyleBox["a", "TI"], 
                 StyleBox["2", "TR"]], ",", 
                SubscriptBox[
                 StyleBox["b", "TI"], 
                 StyleBox["2", "TR"]]}], "}"}]}], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}]}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a ",
     Cell[BoxData[
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"]], "InlineFormula"],
     ", each element of this list is a result of replacement using subsequent \
list of rules."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->373014317],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceASpinor",
   BaseStyle->"Link",
   ButtonData->"paclet:SpinorsExtras/ref/ReplaceASpinor"]], "InlineFormula"],
 " behaves as built-in ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " function but replaces only expressions that are found in places where they \
can be interpreted as massless or massive A spinors."
}], "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(9)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1175873949],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1170865661],

Cell["A spinors are replaced:", "ExampleText",
 CellID->255613305],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1473893814],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"1", "\[Rule]", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->609025611],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{41, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134641416],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "3", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{41, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1383661757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SmBA", "[", 
  RowBox[{"2", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"1", "\[Rule]", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->47422107],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"2", ",", "1"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1909465290],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->917684046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1718961174],

Cell["B spinors are not replaced:", "ExampleText",
 CellID->103006950],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485335172],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spbb", "[", 
  RowBox[{"2", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"1", "\[Rule]", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1317136587],

Cell[BoxData[
 FormBox[
  RowBox[{"[", "2", "|", "1", "]"}], TraditionalForm]], "Output",
 ImageSize->{37, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28083156],

Cell[BoxData[
 FormBox[
  RowBox[{"[", "2", "|", "1", "]"}], TraditionalForm]], "Output",
 ImageSize->{37, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171403286]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"1", "\[Rule]", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->633974453],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1486235704],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->780856519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527741998],

Cell["\<\
Occurrences of replaced label that don't scale as square root of four-vector \
are not changed:\
\>", "ExampleText",
 CellID->409975463],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1539828447],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"2", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1102074149],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1340404589],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->505892586]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446616572],

Cell["\<\
Massive A spinors can be replaced by linear combination of B and A spinors:\
\>", "ExampleText",
 CellID->116235080],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186576270],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->286615802],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1790703753],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->849291870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"+", "1"}]}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->206820029],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", 
   RowBox[{
    SubscriptBox["", "+"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->561451592],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "a", "|", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "\[RightAngleBracket]"}],
   TraditionalForm], "-", 
  FormBox[
   RowBox[{"[", "b", "|", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "\[RightAngleBracket]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->719525142]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"+", "1"}]}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->160201456],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", 
   RowBox[{
    SubscriptBox["", "+"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->763323636],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "a", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "b", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1736298190]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " with patterns can be used:"
}], "ExampleText",
 CellID->890521524],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654699718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "r"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2039354501],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`r}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->62695901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Spaa", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "+", 
  RowBox[{"Spaa", "[", 
   RowBox[{"3", ",", "4"}], "]"}], "+", 
  RowBox[{"Spaa", "[", 
   RowBox[{"5", ",", "6"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Sp", "[", 
     RowBox[{"_", "?", "OddQ"}], "]"}], "\[Rule]", "r"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1817397899],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "5", "|", "6", "\[RightAngleBracket]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{172, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1082916140],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "r", "|", "2", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "r", "|", "4", "\[RightAngleBracket]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "r", "|", "6", "\[RightAngleBracket]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{180, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12224049]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557928810],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " with named patterns can be used:"
}], "ExampleText",
 CellID->305713516],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182488126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "L"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1130438402],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "L"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`L}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->522724010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}]}], "]"}], ",", "Q", ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"L", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}], "+", 
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", "L", ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->621831919],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
    RowBox[{
     SubscriptBox["", "-"], "L"}], "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "|", "L", "|", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{232, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1384167633]
}, Open  ]],

Cell["Change u A spinors to v A spinors and vice versa:", "ExampleText",
 CellID->560461286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"x_", ",", "t_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"SpM", "[", 
     RowBox[{"x", ",", 
      RowBox[{"-", "t"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1411052761],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "P"}], "|", "Q", "|", 
    RowBox[{
     SubscriptBox["", "-"], "L"}], "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", "L", "|", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{232, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->471608936]
}, Open  ]],

Cell["\<\
Change all massive A spinors to linear combination of A and B spinors with \
coefficients depending on replaced spinor properties:\
\>", "ExampleText",
 CellID->246400544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1538968348],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1350329767]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"x_", ",", "t_", ",", "___"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"MP", "[", 
        RowBox[{"x", ",", "2"}], "]"}], "a"}], ",", 
      RowBox[{"t", " ", "b"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1846741050],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{"Q", ",", "2"}], "]"}], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "a", "|", "L", "|", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   RowBox[{"MP", "[", 
    RowBox[{"P", ",", "2"}], "]"}], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "a", "|", "Q", "|", 
     RowBox[{
      SubscriptBox["", "-"], "L"}], "]"}],
    TraditionalForm]}], "+", 
  FormBox[
   RowBox[{"[", "b", "|", "L", "|", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "]"}],
   TraditionalForm], "-", 
  FormBox[
   RowBox[{"[", "b", "|", "Q", "|", 
    RowBox[{
     SubscriptBox["", "-"], "L"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{543, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1843079277]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->828134022],

Cell["List of rules can be used:", "ExampleText",
 CellID->201122541],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1064992176],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "r"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->564972812],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`r}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->2089910352],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1828189554]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Spab", "[", 
   RowBox[{"2", ",", "P", ",", "1"}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"+", "1"}]}], "]"}], ",", "2", ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"\[PlusMinus]", "1"}]}], "]"}]}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"\[MinusPlus]", "1"}]}], "]"}], ",", "1", ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "r"}], ",", 
     RowBox[{
      RowBox[{"SpM", "[", 
       RowBox[{"P", ",", "___"}], "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->93228186],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", "P", "|", "1", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "2", "|", 
    RowBox[{
     SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "\[MinusPlus]"], "Q"}], "|", "1", "|", 
    RowBox[{
     SubsuperscriptBox["", "-", "2"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{295, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1674174141],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "r", "|", "P", "|", "1", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "\[MinusPlus]"], "Q"}], "|", "1", "|", 
    RowBox[{
     SubsuperscriptBox["", "-", "2"], "P"}], "]"}],
   TraditionalForm], " ", 
  RowBox[{"(", 
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "a", "|", "2", "|", 
      RowBox[{
       SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
     TraditionalForm], "-", 
    FormBox[
     RowBox[{"[", "b", "|", "2", "|", 
      RowBox[{
       SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
     TraditionalForm]}], ")"}]}]], "Output",
 ImageSize->{399, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17905096]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506862189],

Cell[TextData[{
 "List of lists of rules can be used, ",
 Cell[BoxData["ReplaceASpinor"], "InlineFormula"],
 " will return list or results:"
}], "ExampleText",
 CellID->1916300259],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416371927],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "r"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1159102138],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`r}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->1752333074],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->809058526]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Spab", "[", 
   RowBox[{"2", ",", "P", ",", "1"}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"+", "1"}]}], "]"}], ",", "2", ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"\[PlusMinus]", "1"}]}], "]"}]}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"\[MinusPlus]", "1"}]}], "]"}], ",", "1", ",", 
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", "\[Rule]", "r"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SpM", "[", 
        RowBox[{"P", ",", "___"}], "]"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1073908681],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", "P", "|", "1", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "2", "|", 
    RowBox[{
     SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "\[MinusPlus]"], "Q"}], "|", "1", "|", 
    RowBox[{
     SubsuperscriptBox["", "-", "2"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{295, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1162839730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "r", "|", "P", "|", "1", "]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "+"], "P"}], "|", "2", "|", 
      RowBox[{
       SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "\[MinusPlus]"], "Q"}], "|", "1", "|", 
      RowBox[{
       SubsuperscriptBox["", "-", "2"], "P"}], "]"}],
     TraditionalForm]}], ",", 
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "2", "|", "P", "|", "1", "]"}],
     TraditionalForm], " ", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       SubscriptBox["", "\[MinusPlus]"], "Q"}], "|", "1", "|", 
      RowBox[{
       SubsuperscriptBox["", "-", "2"], "P"}], "]"}],
     TraditionalForm], " ", 
    RowBox[{"(", 
     RowBox[{
      FormBox[
       RowBox[{"\[LeftAngleBracket]", "a", "|", "2", "|", 
        RowBox[{
         SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
       TraditionalForm], "-", 
      FormBox[
       RowBox[{"[", "b", "|", "2", "|", 
        RowBox[{
         SubscriptBox["", "\[PlusMinus]"], "Q"}], "]"}],
       TraditionalForm]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{413, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1907997773]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1827247986],

Cell["\<\
Any expression can be replaced by any other expression only requirement is \
that expression is inside symbol in which it can be interpreted as massless \
or massive A spinor:\
\>", "ExampleText",
 CellID->1604873341],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1775071775],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"w", ",", 
   RowBox[{"x", " ", "y"}]}], " ", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceASpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"x", " ", "y"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"w", " ", 
        RowBox[{"Sp", "[", "1", "]"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"Sp", "[", "2", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"y", " ", 
        RowBox[{"Sp", "[", "3", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"Sp", "[", "4", "]"}]}]}]}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->363482266],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "w", "|", 
   RowBox[{"x", " ", "y"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211932370],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "w", "|", "1", "\[RightAngleBracket]"}],
    TraditionalForm]}], "+", 
  RowBox[{"x", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "w", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm]}], "+", 
  RowBox[{"y", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "w", "|", "3", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{"z", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "w", "|", "4", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{302, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364521387]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceLVector",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ReplaceLVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceBSpinor",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ReplaceBSpinor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->472374676],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceASpinor - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 24.086249}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Utilities`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ReplaceASpinor[expr, x -> r] returns expr with massless or massive A \
spinors, labeled by x, replaced by r, r can be linear combination of massless \
or massive spinors.ReplaceASpinor[expr, x -> {a, b}] replaces massless or \
massive A spinor x at beginning of spinor chain with difference of A spinor a \
and B spinor b . A spinor x at end of spinor chain will be replaced by sum of \
A spinor a and B spinor b . b can be linear combinations of labels they will \
be interpreted as linear combinations of B spinors, analogously a can be \
linear combinations of labels and they will be interpreted as linear \
combinations of A spinors.ReplaceASpinor[expr, patt -> r] returns expr with \
all massless or massive A spinors that match pattern patt replaced by \
r.ReplaceASpinor[expr, patt -> {a, b}] returns expr with all massless or \
massive A spinors, at beginning of spinor chain, that match pattern patt \
replaced by difference of A spinor a and B spinor b . A spinors at end of \
spinor chain, that match pattern patt, will be replaced by sum of A spinor a \
and B spinor b .ReplaceASpinor[expr, patt :> replacement ] returns expr with \
all massless or massive A spinors that match pattern patt replaced by \
replacement . patt can have named patterns inside and replacement can use \
variables matched by those named patterns.ReplaceASpinor[expr, patt :> \
{replacementA , replacementB }] replaces A spinors, that match pattern patt, \
with difference of A spinor replacementA and B spinor replacementB . A \
spinors at end of spinor chain, that match pattern patt, will be replaced by \
sum of A spinor replacementA and B spinor replacementB . replacementB and \
replacementA can use variables matched by named patterns in \
patt.ReplaceASpinor[expr, {x -> {a, b}, patt :> replacement , ...}] returns \
expr with replacement using all given rules.ReplaceASpinor[expr, {{x_1 -> \
r_1, ...}, {x_2 -> {a_2, b_2}, ...}, ...] returns a List, each element of \
this list is a result of replacement using subsequent list of rules.", 
    "synonyms" -> {}, "title" -> "ReplaceASpinor", "titlemodifier" -> "", 
    "windowtitle" -> "ReplaceASpinor", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ReplaceASpinor"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

