Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ReplaceLVector\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceLVector"], "\<\"ReplaceAspinor\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ReplaceAspinor"], "\<\"ReplaceBspinor\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/ReplaceBspinor"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ReplaceSpinor\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ReplaceSpinor"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ReplaceSpinor.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ReplaceSpinor", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["ReplaceSpinor", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       StyleBox[
        RowBox[{"expr", ",", 
         RowBox[{"x", "\[Rule]", "r"}]}], "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with massless or massive spinors ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " can be linear combination of massless or massive spinors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], 
        StyleBox[",", "TI"], 
        RowBox[{
         StyleBox["x", "TI"], 
         StyleBox["\[Rule]", "TI"], 
         RowBox[{
          StyleBox["{", "TI"], 
          StyleBox[
           RowBox[{"b", ",", "a"}], "TI"], "}"}]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces B spinor ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     " and A spinor ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     " can be linear combinations of massless or massive spinors."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox[
         RowBox[{"patt", "\[Rule]", "r"}], "TI"]}], " ", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive spinors that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox[
         RowBox[{"patt", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"b", ",", "a"}], "}"}]}], "TI"]}], " ", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive B spinors that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"b", " "}], "TI"]], "InlineFormula"],
     " and all A spinors that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula",
      ShowStringCharacters->False],
     " with ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       StyleBox[
        RowBox[{"expr", ",", 
         RowBox[{"patt", "\[RuleDelayed]", "replacement"}]}], "TI"], " ", 
       "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all massless or massive spinors that match pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " replaced by ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " can have named patterns inside and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacement", " "}], "TI"]], "InlineFormula"],
     " can use variables matched by those named patterns."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       StyleBox[
        RowBox[{"expr", ",", 
         RowBox[{"patt", "\[RuleDelayed]", 
          RowBox[{"{", 
           RowBox[{"replacementB", " ", ",", "replacementA"}], " ", "}"}]}]}],
         "TI"], " ", "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces B spinors with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementB", "  "}], "TI"]], "InlineFormula"],
     " and A spinors with ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementA", " "}], "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementB", "  "}], "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"replacementA", " "}], "TI"]], "InlineFormula"],
     " can use variables matched by named patterns in ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], 
           StyleBox["\[Rule]", "TI"], 
           RowBox[{
            StyleBox["{", "TI"], 
            StyleBox[
             RowBox[{"b", ",", "a"}], "TI"], "}"}]}], ",", 
          StyleBox[
           RowBox[{"patt", "\[RuleDelayed]", "replacement"}], "TI"], " ", ",",
           "..."}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with replacement using all given rules."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceSpinor", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox[
             RowBox[{"x1", "\[Rule]", "r1"}], "TI"], ",", "..."}], "}"}], ",",
           " ", 
          RowBox[{"{", 
           RowBox[{
            StyleBox[
             RowBox[{"x2", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"b2", ",", "a2"}], "}"}]}], "TI"], ",", "..."}], "}"}],
           ",", " ", "..."}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a ",
     Cell[BoxData[
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"]], "InlineFormula"],
     ", each element of this list is a result of replacement using subsequent \
list of rules."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->104634450],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData["ReplaceSpinor"], "InlineFormula"],
 " behaves similar to built-in ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " function but replaces only expressions that are found in places where they \
can be interpreted as objects that scale as square root of four-vector."
}], "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(9)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1542895714],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->922332145],

Cell["\<\
Occurrences of replaced label that represent object that scales as square \
root of four-vector are replaced:\
\>", "ExampleText",
 CellID->255613305],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1473893814],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"2", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->609025611],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{41, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321485057],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "4", "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{41, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93613310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"2", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->47422107],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1304512198],

Cell[BoxData[
 RowBox[{"SmBA", "[", 
  RowBox[{"1", ",", "4"}], "]"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1439961196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527741998],

Cell["\<\
Occurrences of replaced label that don't scale as square root of four-vector \
are not replaced:\
\>", "ExampleText",
 CellID->409975463],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1539828447],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"2", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1102074149],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87280340],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->575728128]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446616572],

Cell["B and A spinors can be replaced by different labels:", "ExampleText",
 CellID->116235080],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186576270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286615802],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[57]:=",
 CellID->532344868]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"b", ",", "a"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->206820029],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "1", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1755388436],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "a", "|", "2", "|", "b", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{57, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1000821206]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610251512],

Cell["\<\
Labels representing massive objects can be used, but only occurrences \
representing objects scaling as square root of four-vector will be replaced:\
\>", "ExampleText",
 CellID->1901596012],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1825887211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->886652696],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[35]:=",
 CellID->2107465187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}]}], "]"}], ",", "2", ",", "3"}], "]"}], "+", 
   RowBox[{"Spab", "[", 
    RowBox[{"1", ",", "P", ",", "3"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"P", ",", 
      RowBox[{"+", "1"}]}], "]"}], "\[Rule]", 
    RowBox[{"SpM", "[", 
     RowBox[{"Q", ",", 
      RowBox[{"+", "1"}]}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"P", "\[Rule]", "Q"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1945117343],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "3", "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "2", "|", "3", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{175, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2029884545],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "3", "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", "2", "|", "3", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{175, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->911197403],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "P", "|", "3", "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "2", "|", "3", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{175, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->441153]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " with patterns can be used:"
}], "ExampleText",
 CellID->890521524],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654699718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "r"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2039354501],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`r}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[65]:=",
 CellID->1693959802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Spaa", "[", 
     RowBox[{"1", ",", "2"}], "]"}], 
    RowBox[{"Spbb", "[", 
     RowBox[{"3", ",", "2"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Spaa", "[", 
     RowBox[{"4", ",", "3"}], "]"}], 
    RowBox[{"Spbb", "[", 
     RowBox[{"4", ",", "1"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"Sp", "[", 
     RowBox[{"_", "?", "OddQ"}], "]"}], "\[Rule]", "r"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"Sp", "[", 
     RowBox[{"_", "?", "OddQ"}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"b", ",", "a"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1817397899],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "3", "|", "2", "]"}],
    TraditionalForm]}], "-", 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "4", "|", "1", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{216, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->717754099],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "r", "|", "2", "\[RightAngleBracket]"}],
     TraditionalForm]}], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "r", "]"}],
    TraditionalForm]}], "-", 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "r", "|", "4", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "4", "|", "r", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{235, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->621139262],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "a", "|", "2", "\[RightAngleBracket]"}],
     TraditionalForm]}], " ", 
   FormBox[
    RowBox[{"[", "2", "|", "b", "]"}],
    TraditionalForm]}], "-", 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "a", "|", "4", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "4", "|", "b", "]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{229, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1447709797]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557928810],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " with named patterns can be used:"
}], "ExampleText",
 CellID->305713516],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182488126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q", ",", "L"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1130438402],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q", ",", "L"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q, $CellContext`L}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[73]:=",
 CellID->1903617643]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}]}], "]"}], ",", "Q", ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"L", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}], "+", 
   RowBox[{"Spab", "[", 
    RowBox[{
     RowBox[{"SpM", "[", 
      RowBox[{"Q", ",", 
       RowBox[{"+", "1"}]}], "]"}], ",", "L", ",", 
     RowBox[{"SpM", "[", 
      RowBox[{"P", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->621831919],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
    RowBox[{
     SubscriptBox["", "-"], "L"}], "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", "L", "|", 
    RowBox[{
     SubscriptBox["", "-"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{232, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1530152538]
}, Open  ]],

Cell["Change u spinors to v spinors and vice versa:", "ExampleText",
 CellID->560461286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"SpM", "[", 
     RowBox[{"x_", ",", "t_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"SpM", "[", 
     RowBox[{"x", ",", 
      RowBox[{"-", "t"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1411052761],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "P"}], "|", "Q", "|", 
    RowBox[{
     SubscriptBox["", "+"], "L"}], "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "-"], "Q"}], "|", "L", "|", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{232, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->710182403]
}, Open  ]],

Cell[TextData[{
 "Change reference vector of all massive B spinors to ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2096104694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", "q", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->531203713],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[78]:=",
 CellID->1762652561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{
    RowBox[{"sp", ":", 
     RowBox[{"SpM", "[", 
      RowBox[{"x_", ",", "t_", ",", "___"}], "]"}]}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SpM", "[", 
       RowBox[{"x", ",", "t", ",", "q"}], "]"}], ",", "sp"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1846741050],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "Q", "|", 
    RowBox[{
     SubsuperscriptBox["", "-", "q"], "L"}], "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "Q"}], "|", "L", "|", 
    RowBox[{
     SubsuperscriptBox["", "-", "q"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{238, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2008868475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->828134022],

Cell["List of rules can be used:", "ExampleText",
 CellID->201122541],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1064992176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinor", "[", 
  RowBox[{"a", ",", "b", ",", "r"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564972812],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a, $CellContext`b, $CellContext`r}, 
   " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[82]:=",
 CellID->377836304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Spab", "[", 
   RowBox[{"1", ",", "2", ",", "3"}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{"2", ",", "3", ",", "1"}], "]"}], 
  RowBox[{"Spab", "[", 
   RowBox[{"3", ",", "1", ",", "2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "r"}], ",", 
     RowBox[{"2", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"b", ",", "a"}], "}"}]}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->93228186],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", "3", "|", "1", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "1", "|", "2", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{221, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1399080357],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "a", "|", "3", "|", "r", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "r", "|", "2", "|", "3", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "1", "|", "b", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{228, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->890265878]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506862189],

Cell[TextData[{
 "List of lists of rules can be used, ",
 Cell[BoxData["ReplaceSpinor"], "InlineFormula"],
 " will return list or results:"
}], "ExampleText",
 CellID->1916300259],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416371927],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Spab", "[", 
   RowBox[{"1", ",", "2", ",", "3"}], "]"}], "+", 
  RowBox[{"Spab", "[", 
   RowBox[{"2", ",", "1", ",", "3"}], "]"}], "+", 
  RowBox[{"Spab", "[", 
   RowBox[{"1", ",", "3", ",", "2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", "\[Rule]", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sp", "[", 
        RowBox[{"_", "?", "OddQ"}], "]"}], "\[Rule]", "4"}], "}"}]}], "}"}]}],
   "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1073908681],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "3", "|", "2", "]"}],
   TraditionalForm], "+", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", "1", "|", "3", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{239, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->895303848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "2", "|", "1", "|", "3", "]"}],
     TraditionalForm], "+", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "2", "|", "3", "|", "2", "]"}],
     TraditionalForm]}], ",", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}],
    TraditionalForm], ",", 
   RowBox[{
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "2", "|", "1", "|", "4", "]"}],
     TraditionalForm], "+", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "4", "|", "2", "|", "4", "]"}],
     TraditionalForm], "+", 
    FormBox[
     RowBox[{"\[LeftAngleBracket]", "4", "|", "3", "|", "2", "]"}],
     TraditionalForm]}]}], "}"}]], "Output",
 ImageSize->{503, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1237864239]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1827247986],

Cell["\<\
Any expression can be replaced by any other expression only requirement is \
that expression is inside symbol in which it can be interpreted as object \
scaling as square root of four-vector:\
\>", "ExampleText",
 CellID->1604873341],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1775071775],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", 
   RowBox[{"x", " ", "y"}]}], " ", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ReplaceSpinor", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"x", " ", "y"}], "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", 
      RowBox[{"Sp", "[", "3", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"Sp", "[", "4", "]"}]}]}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->363482266],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", 
   RowBox[{"x", " ", "y"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->720135741],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "3", "\[RightAngleBracket]"}],
    TraditionalForm]}], "+", 
  RowBox[{"z", " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "4", "\[RightAngleBracket]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{141, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->963854753]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceLVector",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ReplaceLVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAspinor",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ReplaceAspinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceBspinor",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ReplaceBspinor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceSpinor - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 32.141361}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Utilities`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "ReplaceSpinor[expr, x -> r] returns expr with massless or massive \
spinors x replaced by r, r can be linear combination of massless or massive \
spinors.ReplaceSpinor[expr, x -> {b, a}] replaces B spinor x with b and A \
spinor x with a, a and b can be linear combinations of massless or massive \
spinors.ReplaceSpinor[expr, patt -> r ] returns expr with all massless or \
massive spinors that match pattern patt replaced by r.ReplaceSpinor[expr, \
patt -> {b, a} ] returns expr with all massless or massive B spinors that \
match pattern patt replaced by b and all A spinors that match patt with \
a.ReplaceSpinor[expr, patt :> replacement ] returns expr with all massless or \
massive spinors that match pattern patt replaced by replacement . patt can \
have named patterns inside and replacement can use variables matched by those \
named patterns.ReplaceSpinor[expr, patt :> {replacementB , replacementA } ] \
replaces B spinors with replacementB and A spinors with replacementA . \
replacementB and replacementA can use variables matched by named patterns in \
patt.ReplaceSpinor[expr, {x -> {b, a}, patt :> replacement , ...}] returns \
expr with replacement using all given rules.ReplaceSpinor[expr, {{x1 -> r1, \
...}, {x2 -> {b2, a2}, ...}, ...}] returns a List, each element of this list \
is a result of replacement using subsequent list of rules.", "synonyms" -> {},
     "title" -> "ReplaceSpinor", "titlemodifier" -> "", "windowtitle" -> 
    "ReplaceSpinor", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ReplaceSpinor"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

