Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"LVectorInterpretableQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LVectorInterpretableQ"], \
"\<\"SpinorInterpretableQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpinorInterpretableQ"], "\<\"MassiveLVectorQ\
\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/MassiveLVectorQ"], "\<\"ScaledLVectorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScaledLVectorQ"], "\<\"ScaledSpinorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScaledSpinorQ"], "\<\"GetScalarCoefficient\"\
\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/GetScalarCoefficient"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ScalarQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ScalarQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ScalarQ.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ScalarQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["ScalarQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScalarQ", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " contain bare Spinor, LVector or SMatrix label i.e. label that is not \
inside some scalar quantity: ",
     Cell[BoxData["Spxy"], "InlineFormula"],
     ", ",
     Cell[BoxData["MP"], "InlineFormula"],
     ", ",
     Cell[BoxData["MP2"], "InlineFormula"],
     ", ",
     Cell[BoxData["s"], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(6)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1816237773],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1810296281],

Cell["\<\
Numbers and symbols without special interpretation are treated as scalars:\
\>", "ExampleText",
 CellID->2034808702],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1155063516],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScalarQ", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", "x", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1326598051],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1498136567],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650666097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1923079559],

Cell["Labels of Spinors, LVectors and SMatrices are not scalars:", \
"ExampleText",
 CellID->1325888551],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320591367],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1007608110],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->501664756],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2060393180],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1974609654]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Sp", "[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->2036297387],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1847388096],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1548366868],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->666293082],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98338072]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1541221495],

Cell["Spinor and scalar products are treated as scalars:", "ExampleText",
 CellID->243674001],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30500217],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1192338520],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[21]:=",
 CellID->987741661],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[21]:=",
 CellID->499676783],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[21]:=",
 CellID->2033255349]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Spaa", "[", 
   RowBox[{"a", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Spbb", "[", 
   RowBox[{"a", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Spab", "[", 
   RowBox[{"a", ",", "sm", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Spba", "[", 
   RowBox[{"a", ",", "sm", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"s", "[", 
   RowBox[{"a", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"MP", "[", 
   RowBox[{"a", ",", "P"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"MP2", "[", "P", "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->177125264],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1478923388],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1233020385],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->691828072],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1444070849],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1887624193],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->579336325],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1535928365]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57648719],

Cell["\<\
Other functions of Spinors, LVectors and SMatrices are not treated as scalars:\
\>", "ExampleText",
 CellID->758012876],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1261224454],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->143376477],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[32]:=",
 CellID->200073156],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[32]:=",
 CellID->367553582],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[32]:=",
 CellID->1829011068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScalarQ", "[", 
  RowBox[{"x", "+", "sm"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"x", " ", "P"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"Sin", "[", "a", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScalarQ", "[", 
  RowBox[{"SpAssoc", "[", "P", "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1826708836],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1774617749],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2084735732],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1599108233],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->287003155],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[49]:=",
 CellID->1764367109],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[49]:=",
 CellID->1474885022],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[49]:=",
 CellID->720172457]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1465783607],

Cell["Any function of only scalars is treated as scalar:", "ExampleText",
 CellID->1791456170],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1658197113],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->125022420],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[54]:=",
 CellID->957128907],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[54]:=",
 CellID->1947495101],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[54]:=",
 CellID->583689297]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarQ", "[", 
  RowBox[{
   RowBox[{"Spba", "[", 
    RowBox[{"a", ",", "sm", ",", "P"}], "]"}], "+", 
   RowBox[{
    RowBox[{"MP2", "[", "P", "]"}], "/", 
    RowBox[{"s", "[", 
     RowBox[{"a", ",", "P"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1853415837],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->694799088]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174446771],

Cell["\<\
Any occurrence of Spinor, LVector or SMatrix outside of scalar or spinor \
product makes expression a non-scalar:\
\>", "ExampleText",
 CellID->861954371],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135460688],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareSpinor", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVector", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->2132457307],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "a", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`a}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[60]:=",
 CellID->1748918148],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[60]:=",
 CellID->1265293278],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[60]:=",
 CellID->332552825]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Spba", "[", 
     RowBox[{"a", ",", "sm", ",", "P"}], "]"}], " ", "P"}], "+", 
   RowBox[{
    RowBox[{"MP2", "[", "P", "]"}], "/", 
    RowBox[{"s", "[", 
     RowBox[{"a", ",", "P"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1976333057],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->238602789]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LVectorInterpretableQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/LVectorInterpretableQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpinorInterpretableQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpinorInterpretableQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MassiveLVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/MassiveLVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaledLVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScaledLVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaledSpinorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScaledSpinorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetScalarCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/GetScalarCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScalarQ - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 34.562859}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "SpinorsExtras`Package`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Symbol", "language" -> "en", "paclet" -> "SpinorsExtras", 
    "status" -> "None", "summary" -> 
    "ScalarQ[x] returns False if x contain bare Spinor, LVector or SMatrix \
label i.e. label that is not inside some scalar quantity: Spxy, MP, MP2, s.", 
    "synonyms" -> {}, "title" -> "ScalarQ", "titlemodifier" -> "", 
    "windowtitle" -> "ScalarQ", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/ScalarQ"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

