Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ScaledSpinorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScaledSpinorQ"], "\<\"ScalarQ\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ScalarQ"], "\<\"GetScalarCoefficient\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/GetScalarCoefficient"], \
"\<\"LVectorInterpretableQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LVectorInterpretableQ"], \
"\<\"SpinorInterpretableQ\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpinorInterpretableQ"], "\<\"MassiveLVectorQ\
\"\>":>Documentation`HelpLookup["paclet:SpinorsExtras/ref/MassiveLVectorQ"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/ScaledLVectorQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/ScaledLVectorQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
ScaledLVectorQ.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/ScaledLVectorQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["ScaledLVectorQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ScaledLVectorQ", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns True if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a LVector or a LVector times scalar coefficient."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(2)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1447465839],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->501598975],

Cell["\<\
LVectors and LVectors multiplied by scalar coefficients are interpreted as \
scaled LVectors:\
\>", "ExampleText",
 CellID->1179399084],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->912876743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1705768946],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1696916494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScaledLVectorQ", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", 
  RowBox[{"x", " ", "P"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", 
  RowBox[{"5", 
   RowBox[{"MP", "[", 
    RowBox[{"Q", ",", "1"}], "]"}], " ", "P"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->69970422],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13113446],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1205802406],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1933180214]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->719886587],

Cell["\<\
LVectors multiplied by anything else than scalar coefficients and other \
expressions are not interpreted as scaled LVectors:\
\>", "ExampleText",
 CellID->908596359],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`Package`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->932816698],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSMatrix", "[", "sm", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->249122396],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[21]:=",
 CellID->1299798183],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "sm", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of slashed matrices\"\>"}],
  SequenceForm[{$CellContext`sm}, " added to the list of slashed matrices"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[21]:=",
 CellID->777760977]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ScaledLVectorQ", "[", 
  RowBox[{"P", " ", "Q"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", "sm", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", "x", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", 
  RowBox[{"s", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ScaledLVectorQ", "[", 
  RowBox[{"P", "+", "Q"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->615093071],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->218491610],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1031827503],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->903346743],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->971226373],

Cell[BoxData["False"], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224626583]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaledSpinorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScaledSpinorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ScalarQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetScalarCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/GetScalarCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LVectorInterpretableQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/LVectorInterpretableQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpinorInterpretableQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpinorInterpretableQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MassiveLVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/MassiveLVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScaledLVectorQ - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 37.005084}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "SpinorsExtras`Package`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Symbol", "language" -> "en", "paclet" -> "SpinorsExtras", 
    "status" -> "None", "summary" -> 
    "ScaledLVectorQ[x] returns True if x is a LVector or a LVector times \
scalar coefficient.", "synonyms" -> {}, "title" -> "ScaledLVectorQ", 
    "titlemodifier" -> "", "windowtitle" -> "ScaledLVectorQ", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/ScaledLVectorQ"}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

