Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"QED with Muons\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/tutorial/QEDWithMuons"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpRef\"\>":>Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpRef"], "\<\"SpM\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/SpM"], "\<\"LightConeDecompose\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/LightConeDecompose"], "\<\"ExpandPolVec\"\>":>
       Documentation`HelpLookup[
       "paclet:SpinorsExtras/ref/ExpandPolVec"], "\<\"LvBA\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/ref/LvBA"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/SpAssoc\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/SpAssoc"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
SpAssoc.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/SpAssoc", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell["SpAssoc", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpAssoc", "[", 
       StyleBox["P", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents lightlike vector associated with four-vector \
",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     " through light cone decomposition with default reference vector."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpAssoc", "[", 
       RowBox[{
        StyleBox["P", "TI"], ",", 
        StyleBox["ref", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents lightlike vector associated with four-vector \
",
     Cell[BoxData[
      StyleBox[
       RowBox[{"P", " "}], "TI"]], "InlineFormula"],
     " through light cone decomposition with (massless or massive) reference \
vector ",
     Cell[BoxData[
      StyleBox["ref", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->953128287],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector labels lightlike four-vector ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["P", "\[Flat]"], "=", 
   RowBox[{"P", "-", 
    RowBox[{
     FractionBox[
      SuperscriptBox["P", "2"], 
      RowBox[{"2", " ", "P", " ", 
       SubscriptBox["q", "P"]}]], 
     SubscriptBox["q", "P"]}]}]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  SubscriptBox["q", "P"]], "InlineFormula"],
 " denotes default reference vector ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"], "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->383275875],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor labels ",
 "lightlike ",
 "four-vector ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["P", "q"], "=", 
   RowBox[{"P", "-", 
    RowBox[{
     FractionBox[
      SuperscriptBox["P", "2"], 
      RowBox[{"2", " ", "P", " ", "q"}]], "q"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", " ", 
    StyleBox["Q", "TI"]}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " being massive LVector labels lightlike four-vector ",
 Cell[BoxData[
  SuperscriptBox["P", "Q"]], "InlineFormula"],
 " obtained by \"simultaneous\" lightcone decomposition of ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " such that: ",
 Cell[BoxData[
  RowBox[{"P", "=", 
   RowBox[{
    SuperscriptBox["P", "Q"], "-", 
    RowBox[{
     FractionBox[
      SuperscriptBox["P", "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["P", "Q"], " ", 
       SuperscriptBox["Q", "P"]}]], 
     SuperscriptBox["Q", "P"]}]}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"Q", "=", 
   RowBox[{
    SuperscriptBox["Q", "P"], "-", 
    RowBox[{
     FractionBox[
      SuperscriptBox["Q", "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["Q", "P"], " ", 
       SuperscriptBox["P", "Q"]}]], 
     SuperscriptBox["P", "Q"]}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1450300036],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(16)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1709042181],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2123667759],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Notation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->2034196178],

Cell[TextData[{
 "With activated notation ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector, is denoted by ",
 Cell[BoxData[
  SuperscriptBox["P", "\[Flat]"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1250971477],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1677056277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->798072144],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1965416871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpAssoc", "[", "P", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->906963348],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox["P", "\[Flat]"],
  SpinorsExtras`Massive`SpAssoc[$CellContext`P]]], "Output",
 ImageSize->{20, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->571670224]
}, Open  ]],

Cell[TextData[{
 "When argument of ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " is not LVector notation is not changed:"
}], "ExampleText",
 CellID->1323017349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpAssoc", "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5898699],

Cell[BoxData[
 RowBox[{"SpAssoc", "[", "x", "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1931525737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1665125691],

Cell[TextData[{
 "With activated notation ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox[
    RowBox[{"P", ",", "Q"}], "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " being LVectors, is denoted by ",
 Cell[BoxData[
  SuperscriptBox["P", "Q"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1595957069],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42393444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166075545],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->436233078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1635340903],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox["P", "Q"],
  SpinorsExtras`Massive`SpAssoc[$CellContext`P, $CellContext`Q]]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1876530410]
}, Open  ]],

Cell[TextData[{
 "When arguments of ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " are not LVectors notation is not changed:"
}], "ExampleText",
 CellID->355137566],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpAssoc", "[", 
  RowBox[{"x", ",", "Q"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->308944785],

Cell[BoxData[
 RowBox[{"SpAssoc", "[", 
  RowBox[{"P", ",", "x"}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1198107786],

Cell[BoxData[
 RowBox[{"SpAssoc", "[", 
  RowBox[{"x", ",", "Q"}], "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->561340881]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spinor interpretation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->1087942709],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector, is interpreted as massless Spinor:"
}], "ExampleText",
 CellID->529855805],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675163668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", "P", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->993999087],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->986964480]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", 
  RowBox[{"SpAssoc", "[", "P", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1835046455],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1145438826]
}, Open  ]],

Cell[TextData[{
 "If argument of ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " is not LVector, then ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " is not treated as Spinor:"
}], "ExampleText",
 CellID->971955117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", 
  RowBox[{"SpAssoc", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1739090869],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1836731008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1653769037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["Q", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " being LVectors, is interpreted as massless Spinor:"
}], "ExampleText",
 CellID->27330892],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388194211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->432909847],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1645253949]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorQ", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1499106446],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->888648818]
}, Open  ]],

Cell[TextData[{
 "If arguments of ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " are not LVectors, then ",
 Cell[BoxData["SpAssoc"], "InlineFormula"],
 " is not treated as Spinor:"
}], "ExampleText",
 CellID->1559873741],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SpinorQ", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"x", ",", "Q"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpinorQ", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "x"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->537895941],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->900877874],

Cell[BoxData["False"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1718887253]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numerics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->1770987213],

Cell[TextData[{
 "Default numerical components for ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector with declared numerical components, can be declared by using \
",
 Cell[BoxData[
  ButtonBox["DeclareSpinorMomentum",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/DeclareSpinorMomentum"]], 
  "InlineFormula"],
 " with one argument (this will also automatically set default numerical \
values for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"], "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 " if it was not set earlier):"
}], "ExampleText",
 CellID->1932248285],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1205126483],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVectorMomentum", "[", 
  RowBox[{"P", ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "4"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1724605989],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->980078692],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Four Momentum \"\>", "\[InvisibleSpace]", "P", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.6524678079740285`", ",", "0.633070356251368`", ",", 
     "0.6828130868666602`", ",", "0.5663518310933229`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Four Momentum ", $CellContext`P, " set to ", {0.6524678079740285, 
   0.633070356251368, 0.6828130868666602, 0.5663518310933229}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1463958850]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", "P", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->873231688],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SubscriptBox["q", "P"],
    SpinorsExtras`Ref`SpRef[$CellContext`P]], 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.0898468627029079`", ",", 
     RowBox[{"-", "0.633070356251368`"}], ",", 
     RowBox[{"-", "0.6828130868666602`"}], ",", 
     RowBox[{"-", "0.5663518310933229`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum for spinor ", 
   SpinorsExtras`Ref`SpRef[$CellContext`P], " set to ", {
   1.0898468627029079`, -0.633070356251368, -0.6828130868666602, \
-0.5663518310933229}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->2093635501],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["P", "\[Flat]"],
    SpinorsExtras`Massive`SpAssoc[$CellContext`P]], 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.8711573353384682`", ",", "0.5060379613938994`", ",", 
     "0.5457992766192385`", ",", "0.4527072278904354`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum for spinor ", 
   SpinorsExtras`Massive`SpAssoc[$CellContext`P], " set to ", {
   0.8711573353384682, 0.5060379613938994, 0.5457992766192385, 
   0.4527072278904354}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->2121159500]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Numerical values obtained this way are equal to following combination of \
numerical values of ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"], "[", 
   StyleBox["P", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1970133306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Num4V", "[", 
    RowBox[{"SpAssoc", "[", "P", "]"}], "]"}], "==", 
   RowBox[{
    RowBox[{"Num4V", "[", "P", "]"}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"MP2", "[", "P", "]"}], 
      RowBox[{"2", " ", 
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", 
         RowBox[{"SpRef", "[", "P", "]"}]}], "]"}]}]], " ", 
     RowBox[{"Num4V", "[", 
      RowBox[{"SpRef", "[", "P", "]"}], "]"}]}]}]}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2131461622],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->41397997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->896999159],

Cell[TextData[{
 "Default numerical components for ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox[
    RowBox[{"P", ",", "q"}], "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " being LVector and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " being massless Spinor both with declared numerical components, can be \
declared by using ",
 Cell[BoxData[
  ButtonBox["DeclareSpinorMomentum",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/DeclareSpinorMomentum"]], 
  "InlineFormula"],
 " with one argument:"
}], "ExampleText",
 CellID->558378819],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->695754110],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVectorMomentum", "[", 
  RowBox[{"P", ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "4"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareSpinorRandomMomentum", "[", "q", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->44669637],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1136779769],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Four Momentum \"\>", "\[InvisibleSpace]", "P", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.6524678079740285`", ",", "0.633070356251368`", ",", 
     "0.6828130868666602`", ",", "0.5663518310933229`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Four Momentum ", $CellContext`P, " set to ", {0.6524678079740285, 
   0.633070356251368, 0.6828130868666602, 0.5663518310933229}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2136250776],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of spinors\"\>"}],
  SequenceForm[{$CellContext`q}, " added to the list of spinors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->553790844],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", "q", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1.3922115467713956`", ",", "0.8704043933186636`", ",", 
     "0.9523755138042027`", ",", 
     RowBox[{"-", "0.5230966103516175`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Momentum for spinor ", $CellContext`q, " set to ", {1.3922115467713956`, 
   0.8704043933186636, 0.9523755138042027, -0.5230966103516175}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->891747911]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1917125080],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["P", "q"],
    SpinorsExtras`Massive`SpAssoc[$CellContext`P, $CellContext`q]], 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "160.99944288085496`", ",", "100.88127752164631`", ",", 
     "110.37198577483035`", ",", 
     RowBox[{"-", "59.68092835795119`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum for spinor ", 
   SpinorsExtras`Massive`SpAssoc[$CellContext`P, $CellContext`q], 
   " set to ", {160.99944288085496`, 100.88127752164631`, 
   110.37198577483035`, -59.68092835795119}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->408315379]
}, Open  ]],

Cell[TextData[{
 "Numerical values obtained this way are equal to following combination of \
numerical values of ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1308915963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Num4V", "[", 
    RowBox[{"SpAssoc", "[", 
     RowBox[{"P", ",", "q"}], "]"}], "]"}], "==", 
   RowBox[{
    RowBox[{"Num4V", "[", "P", "]"}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"MP2", "[", "P", "]"}], 
      RowBox[{"2", " ", 
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", "q"}], "]"}]}]], " ", 
     RowBox[{"Num4V", "[", "q", "]"}]}]}]}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1419065702],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->345872359]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1643256678],

Cell[TextData[{
 "Default numerical components for ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   StyleBox[
    RowBox[{"P", ",", "Q"}], "TI"], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " being LVectors with declared numerical components, can be declared by \
using ",
 Cell[BoxData[
  ButtonBox["DeclareSpinorMomentum",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/DeclareSpinorMomentum"]], 
  "InlineFormula"],
 " with one argument:"
}], "ExampleText",
 CellID->2118154490],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639597257],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DeclareLVectorMomentum", "[", 
     RowBox[{"#", ",", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", "4"}], "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1696760281],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "P", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->720798553],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Four Momentum \"\>", "\[InvisibleSpace]", "P", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.6524678079740285`", ",", "0.633070356251368`", ",", 
     "0.6828130868666602`", ",", "0.5663518310933229`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Four Momentum ", $CellContext`P, " set to ", {0.6524678079740285, 
   0.633070356251368, 0.6828130868666602, 0.5663518310933229}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1545796706],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", "Q", "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`Q}, " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1292990330],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Four Momentum \"\>", "\[InvisibleSpace]", "Q", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.9352021966593318`", ",", "0.9761877569021014`", ",", 
     "0.23845169482419126`", ",", "0.6375622957902416`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Four Momentum ", $CellContext`Q, " set to ", {0.9352021966593318, 
   0.9761877569021014, 0.23845169482419126`, 0.6375622957902416}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->82452201]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->970095468],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["P", "Q"],
    SpinorsExtras`Massive`SpAssoc[$CellContext`P, $CellContext`Q]], 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.32623390398701424`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.507052834459896`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.316535178125684`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.5646509020657273`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.3414065434333301`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.25140556395443125`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.28317591554666144`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.2560862434184307`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum for spinor ", 
   SpinorsExtras`Massive`SpAssoc[$CellContext`P, $CellContext`Q], " set to ", {
    Complex[0.32623390398701424`, 0.507052834459896], 
    Complex[0.316535178125684, 0.5646509020657273], 
    Complex[0.3414065434333301, -0.25140556395443125`], 
    Complex[0.28317591554666144`, 0.2560862434184307]}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->622378264]
}, Open  ]],

Cell[TextData[{
 "Numerical values obtained this way are equal to following combination of \
numerical values of ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["Q", "TI"], 
   StyleBox["P", "TI"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1486254896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"Q", ",", "P"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2094664197],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum for spinor \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["Q", "P"],
    SpinorsExtras`Massive`SpAssoc[$CellContext`Q, $CellContext`P]], 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.4676010983296659`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.19938810523145167`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.48809387845105073`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.24416636609416412`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.11922584741209565`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.3369941522020727`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.3187811478951208`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.044658857178702244`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum for spinor ", 
   SpinorsExtras`Massive`SpAssoc[$CellContext`Q, $CellContext`P], " set to ", {
    Complex[0.4676010983296659, -0.19938810523145167`], 
    Complex[0.48809387845105073`, -0.24416636609416412`], 
    Complex[0.11922584741209565`, 0.3369941522020727], 
    Complex[0.3187811478951208, -0.044658857178702244`]}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1841905140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Num4V", "[", 
    RowBox[{"SpAssoc", "[", 
     RowBox[{"P", ",", "Q"}], "]"}], "]"}], "==", 
   RowBox[{
    RowBox[{"Num4V", "[", "P", "]"}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"MP2", "[", "P", "]"}], 
      RowBox[{"2", " ", 
       RowBox[{"MP", "[", 
        RowBox[{"P", ",", 
         RowBox[{"SpAssoc", "[", 
          RowBox[{"Q", ",", "P"}], "]"}]}], "]"}]}]], " ", 
     RowBox[{"Num4V", "[", 
      RowBox[{"SpAssoc", "[", 
       RowBox[{"Q", ",", "P"}], "]"}], "]"}]}]}]}], "//", "N"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1285468150],

Cell[BoxData["True"], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->995372433]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->872087118],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["DeclareSpinorMomentum",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/DeclareSpinorMomentum"]], 
  "InlineFormula"],
 ", with ",
 Cell[BoxData[
  RowBox[{"SpAssoc", "[", 
   RowBox[{
    StyleBox["P", "TI"], ",", 
    StyleBox["Q", "TI"]}], "]"}]], "InlineFormula"],
 " as only argument,  is called when ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"P", " "}], "TI"]], "InlineFormula"],
 "  or ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Q", " "}], "TI"]], "InlineFormula"],
 " does not have declared numerical components declaration fails and a \
warning message is printed:"
}], "ExampleText",
 CellID->1565716961],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406084266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1296373522],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1762488612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1657158084],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DeclareSpinorMomentum", "::", "firstDeclare"}], "MessageName"], 
  ":", " ", "\<\"Declaration of default value for \
\[NoBreak]\\!\\(\\*InterpretationBox[\\(P\\^Q\\), SpAssoc[P, Q]]\\)\[NoBreak] \
is possible after declaring values for \[NoBreak]\\!\\({P, Q}\\)\[NoBreak].\"\
\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1577597452],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->635411019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DeclareLVectorMomentum", "[", 
  RowBox[{"P", ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "4"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->524275416],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Four Momentum \"\>", "\[InvisibleSpace]", "P", 
   "\[InvisibleSpace]", "\<\" set to \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.6524678079740285`", ",", "0.633070356251368`", ",", 
     "0.6828130868666602`", ",", "0.5663518310933229`"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Four Momentum ", $CellContext`P, " set to ", {0.6524678079740285, 
   0.633070356251368, 0.6828130868666602, 0.5663518310933229}, "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1879367239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareSpinorMomentum", "[", 
  RowBox[{"SpAssoc", "[", 
   RowBox[{"P", ",", "Q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->361595193],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DeclareSpinorMomentum", "::", "firstDeclare"}], "MessageName"], 
  ":", " ", "\<\"Declaration of default value for \
\[NoBreak]\\!\\(\\*InterpretationBox[\\(P\\^Q\\), SpAssoc[P, Q]]\\)\[NoBreak] \
is possible after declaring values for \
\[NoBreak]\\!\\({Q}\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1693676854],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->894556449]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpRef",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpRef"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpM",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/SpM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightConeDecompose",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/LightConeDecompose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandPolVec",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/ExpandPolVec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LvBA",
    BaseStyle->"Link",
    ButtonData->"paclet:SpinorsExtras/ref/LvBA"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["QED with Muons",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/tutorial/QEDWithMuons"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->660782540],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpAssoc - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 4, 55.133641}", 
    "history" -> {"XX", "", "", ""}, "context" -> "SpinorsExtras`Massive`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "SpAssoc[P] represents lightlike vector associated with four-vector P \
through light cone decomposition with default reference vector.SpAssoc[P, \
ref] represents lightlike vector associated with four-vector P through light \
cone decomposition with (massless or massive) reference vector ref.", 
    "synonyms" -> {}, "title" -> "SpAssoc", "titlemodifier" -> "", 
    "windowtitle" -> "SpAssoc", "type" -> "Symbol", "uri" -> 
    "SpinorsExtras/ref/SpAssoc"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

