Notebook[{
Cell[BoxData[GridBox[{
   {Cell["SPINORS EXTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras\"\>":>
       Documentation`HelpLookup["paclet:SpinorsExtras/guide/SpinorsExtras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"SpinorsExtras/ref/SpOpen\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["SpinorsExtras/ref/SpOpen"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/SpinorsExtras/ref/\
SpOpen.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "SpinorsExtras/ref/SpOpen", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell["SpOpen", "ObjectName",
 CellID->1224892054],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpOpen", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes spinor products in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " containing slashed matrices into products of smaller spinor products, \
by applying: k-slashed = |k>[k| + |k]<k|."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpOpen", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does the same selectively, at the occurrence of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "-slashed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpOpen", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does the same selectively, at the occurrence of any \
massless Spinor that matches pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}}],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1954407741],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["The following options can be given: ", "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BothEndsMassive\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to decompose spinor chains with massive spinors on both ends\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(10)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->76119778],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1114962327],

Cell["Decompose spinor chain:", "ExampleText",
 CellID->445849485],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70471114],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", "%", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1802144689],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "|", 
   "6", "\[RightAngleBracket]"}], TraditionalForm]], "Output",
 ImageSize->{106, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->584266046],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "5", "|", "6", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", "3", "|", "2", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", "5", "|", "4", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{257, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->987698297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688993725],

Cell["Decompose spinor chain at occurrence of one label:", "ExampleText",
 CellID->1600790559],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294660549],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", "4"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1534739210],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "|", 
   "6", "\[RightAngleBracket]"}], TraditionalForm]], "Output",
 ImageSize->{106, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671220616],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{
   "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", 
    "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "6", "|", "5", "|", "4", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{170, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->500222414]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->400383970],

Cell["\<\
Decompose spinor chain at occurrence of labels matching pattern:\
\>", "ExampleText",
 CellID->1575081753],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1292071526],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Sp", "[", 
    RowBox[{"_", "?", "OddQ"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1552423742],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "|", 
   "6", "\[RightAngleBracket]"}], TraditionalForm]], "Output",
 ImageSize->{106, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->613331105],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "5", "|", "6", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", "3", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "|", "5", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{198, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->906849958]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265],

Cell["Decompose spinor chain with massive spinor at one end:", "ExampleText",
 CellID->249102019],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1088126146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2081255681],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1649456965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", "%", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1383012668],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "|", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "]"}], TraditionalForm]], "Output",
 ImageSize->{74, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->302187195],

Cell[BoxData[
 RowBox[{
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", "2", "|", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{120, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1173458070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", "1", ",", "Q", ",", "2", ",", "3", ",",
    "4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", "%", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1346785387],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", "Q", "|", "2", "|", "3", "|",
    "4", "\[RightAngleBracket]"}], TraditionalForm]], "Output",
 ImageSize->{126, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2087858135],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "\[RightAngleBracket]"}],
    TraditionalForm]}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     SubscriptBox["", "+"], "P"}], "|", "1", "\[RightAngleBracket]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "2", "|", "Q", "|", "1", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", "3", "|", "2", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{257, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1515579845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BothEndsMassive",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True],

Cell[TextData[{
 "With \"BothEndsMassive\" set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " (default value) spinor chains with massive spinors on both ends are not \
decomposed:"
}], "ExampleText",
 CellID->1715838032],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->788674970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->984973820],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1006945849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", "1", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<BothEndsMassive\>\"", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->369926059],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->334292852],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->910789244]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1022994496],

Cell[TextData[{
 "With \"BothEndsMassive\" set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " spinor chains with massive spinors on both ends are also decomposed:"
}], "ExampleText",
 CellID->239826287],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1755089758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1677735888],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1362306197]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", "1", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<BothEndsMassive\>\"", "\[Rule]", "True"}]}], "]"}]}], "Input",
 
 CellLabel->"In[3]:=",
 CellID->1323342488],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1934963147],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "1", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "1", "|", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{288, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->486165881]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387236499],

Cell["\<\
Stand alone integer given as second argument is treated as spinor label:\
\>", "ExampleText",
 CellID->1965629178],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", "2"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1822042503],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{87, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1509370997],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm]}], " ", 
  FormBox[
   RowBox[{"[", "5", "|", "4", "|", "3", "|", "2", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{156, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2073617382]
}, Open  ]],

Cell["\<\
but integers inside expressions are not automatically \"spinorized\":\
\>", "ExampleText",
 CellID->1842339045],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{"2", "|", "3"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1223085164],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{87, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2001495088],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{87, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1389434014]
}, Open  ]],

Cell[TextData[{
 "for integers in complex expressions to be treated as ",
 "spinor",
 " labels wrap them in ",
 Cell[BoxData[
  ButtonBox["Sp",
   BaseStyle->"Link",
   ButtonData->"paclet:Spinors/ref/Sp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->677857385],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spab", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Sp", "[", "2", "]"}], "|", 
    RowBox[{"Sp", "[", "3", "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1303986309],

Cell[BoxData[
 FormBox[
  RowBox[{
  "\[LeftAngleBracket]", "1", "|", "2", "|", "3", "|", "4", "|", "5", "]"}], 
  TraditionalForm]], "Output",
 ImageSize->{87, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->839168820],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", "2", "\[RightAngleBracket]"}],
    TraditionalForm]}], " ", 
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "3", "|", "4", "|", "5", "]"}],
   TraditionalForm], " ", 
  FormBox[
   RowBox[{"[", "3", "|", "2", "]"}],
   TraditionalForm]}]], "Output",
 ImageSize->{185, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->95256545]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->510217909],

Cell["\<\
Decomposition of spinor chains with massive spinors on both ends leads to sum \
of products of spinor chains, in contrast to spinor chains with massless \
spinor at at least one end, which decomposition gives simple product of \
spinor chains. That's why chains with massive spinors on both ends are not \
decomposed by default:\
\>", "ExampleText",
 CellID->1070330617],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinorsExtras`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->688319293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclareLVector", "[", 
  RowBox[{"P", ",", "Q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1894233796],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P", ",", "Q"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added to the list of Lorentz vectors\"\>"}],
  SequenceForm[{$CellContext`P, $CellContext`Q}, 
   " added to the list of Lorentz vectors"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->399389396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", "1", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", "%", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1579152724],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->676592575],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47652243]
}, Open  ]],

Cell[TextData[{
 "To decompose them set \"BothEndsMassive\" option to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->528557104],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Spaa", "[", 
  RowBox[{
   RowBox[{"SpM", "[", 
    RowBox[{"P", ",", 
     RowBox[{"+", "1"}]}], "]"}], ",", "1", ",", 
   RowBox[{"SpM", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SpOpen", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<BothEndsMassive\>\"", "\[Rule]", "True"}]}], "]"}]}], "Input",
 
 CellLabel->"In[4]:=",
 CellID->1294642164],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox["", "+"], "P"}], "|", "1", "|", 
   RowBox[{
    SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}], 
  TraditionalForm]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->259321248],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", "1", "|", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "1", "]"}],
    TraditionalForm]}], "+", 
  RowBox[{
   FormBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      SubscriptBox["", "+"], "P"}], "|", "1", "\[RightAngleBracket]"}],
    TraditionalForm], " ", 
   FormBox[
    RowBox[{"[", "1", "|", 
     RowBox[{
      SubscriptBox["", "-"], "Q"}], "\[RightAngleBracket]"}],
    TraditionalForm]}]}]], "Output",
 ImageSize->{288, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->583130231]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["SpinorsExtras",
 BaseStyle->"Link",
 ButtonData->"paclet:SpinorsExtras/guide/SpinorsExtras"]], "MoreAbout",
 CellID->886259888],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpOpen - Wolfram Mathematica",
PrivateNotebookOptions->{"FileOutlineCache"->False},
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "SpinorsExtras", ButtonData -> 
         "paclet:SpinorsExtras/guide/SpinorsExtras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 6, 21, 14, 5, 7.999873}", 
    "history" -> {"XX", "", "", ""}, "context" -> "Spinors`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "Spinors Extras Package Symbol", "language" -> "en", "paclet" -> 
    "SpinorsExtras Package", "status" -> "None", "summary" -> 
    "SpOpen[x] decomposes spinor products in x containing slashed matrices \
into products of smaller spinor products, by applying: k-slashed = |k>[k| + \
|k]<k|.SpOpen[x, a] does the same selectively, at the occurrence of \
a-slashed.SpOpen[x, patt] does the same selectively, at the occurrence of any \
massless Spinor that matches pattern patt.", "synonyms" -> {}, "title" -> 
    "SpOpen", "titlemodifier" -> "", "windowtitle" -> "SpOpen", "type" -> 
    "Symbol", "uri" -> "SpinorsExtras/ref/SpOpen"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

