#include <stdio.h>
#if -1U!=0xffffU	/* distingushes Linux from DOS */
#include <unistd.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#define ER_FATAL	4
#define ER_DATRD	2
#define ER_DFILSH	1
#define OPT_VERB	1
#define DEBUG 0
#define CLOPT 0		/* do not use file options.ctl */
/*
Options.CTL structure:
offset	value
000-003	86 A7 00 00
004-103	collating table: use character value as index in the table to get
			 value used to build key (in key and index files)
104-136	uppercase alpha in national order
137-169	lowercase alpha in national order
16A-199	month names abbreviations (each char[4] = 3-char + 0-terminator)
19A-235	month names (each char[13] = 12-char + 0-terminator)
236-552	various strings to be used in error displays
*/

typedef unsigned char byte;
typedef unsigned short word;
#if -1U==0xffffU
typedef unsigned long ulong;	/* Linux defines ulong, what other OS-es? */
#define strncasecmp strnicmp
#define P1
#else
#define P1 __attribute__ ((aligned(1),packed))	/* Linux needs it */
#endif

/* Data file header structure: */
struct cl_file_header {
/*00*/	word	filesig;	/* file signature: 0x3343 */
/*02*/	word	sfatr;		/* file attribute and status */
	/* bit	0:locked, 1:owned, 2:encrypted, 3:memo exists, 4:compressed,
		5:reclaim deleted record, 6:read only, 7:may be created */
/*04*/	byte	numbkeys;	/* number of keys in file */
/*05*/	ulong	numrecs;	/* number of records in file */
/*09*/	ulong	numdels;	/* number of deleted records */
/*0d*/	word	numflds;	/* number of fields */
/*0f*/	word	numpics;	/* number of pictures */
/*11*/	word	numarrs;	/* number of array descriptors */
/*13*/	word	reclen ;	/* record length (including record header) */
/*15*/	ulong	datofs ;	/* start of data area */
/*19*/	ulong	logeof ;	/* logical end of file */
/*1d*/	ulong	logbof ;	/* logical beginning of file */
/*21*/	ulong	freerec;	/* first usable deleted record */
/*25*/	byte	recname[12];	/* record name w/o prefix ("RECORD", 0 fill) */
/*31*/	byte	memnam[12];	/* memo name without prefix */
/*3d*/	byte	filpre[3];	/* file name prefix */
/*40*/	byte	recpre[3];	/* record name prefix */
/*43*/	word	memolen;	/* size of memo */
/*45*/	word	memowid;	/* column width of memo */
/*47*/	ulong	reserved1;	/* reserved (really always was 0) */
/*4b*/	ulong	chgtime;	/* time of last change (sec/100 s/ midnight) */
/*4f*/	ulong	chgdate;	/* date of last change (days s/ 28-Dec-1800) */
/*53*/	word	reserved2;	/* reserved */
				/* (sum of all preceding bytes in encrypted
				    file, was always 0 in unencrypted) */
	/* encryption, if used, applies to bytes 4..53: "numbkeys" to HALF of
	 * word "reserved2" - it is always done by words, whole words only */
} P1;

struct field_descr {
	byte	fldtype;	/* type of field */
	/*	1:long, 2:real, 3:string, 4:string with picture token,
		5:byte, 6:short, 7:group, 8:decimal	*/
	char	fldname[16];	/* name of field (blank pad) */
	word	foffset;	/* offset into record (from 0) */
	word	length;		/* length of field */
	byte	decsig;		/* significance for decimals */
	byte	decdec;		/* number of decimal places */
	word	arrnum;		/* array number */
	word	picnum;		/* picture number */
} P1;

struct key_sect_info {
	byte	numcomps;	/* number of components for key */
	char	keynams[16];	/* name of this key */
	byte	comptype;	/* type of composite */
		/* bit	7:	loksw(1:key file locked, 0:not),
			6:	optsw(1:don't, 0:exclude nulls),
			5:	uprsw(1:uppercase, 0:case sensitive),
			4:	dupsw(1:duplicate keys allowed, 0:unique)
			3-0:	ftyp=0:key,1:index(dupsw never set) */
	byte	complen;	/* length of composite */
	/* struct key_part_info keypart[numcomps]; */
} P1;
struct key_part_info {
	byte	fldtype;	/* type of field (same as in f.d.) */
	word	fldnum;		/* field number (first is 1) */
	word	elmoff;		/* record offset of this element */
	byte	elmlen;		/* length of element */
} P1;

struct data_header {
	byte	rhd;		/* record header type and status */
	/* bits	0:new, 1:old, 2:revised, 4:deleted, 6:held */
	ulong	rptr;		/* pointer for next deleted record
				   or memo if active */
} P1;

/* .MEM file structure:
 00	char mhdr[2]={"M3"};
 02	long fdro; - first deleted record (0 if none)
 {	long link; - link to next memo record; also deleted records are linked
	char info[252]; - information in the .MEMO
 }[]; */

char collate1[256],collate2[256]; /* 1 maps to uppercase, 2 uses 2 cases */
char monthnam[48]=
	{"Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec"};
byte Options=0,ErrFlag=0;

void setfnext(char *fns,const char *ext) {
	int lng,dot;
	for(dot=lng=strlen(fns); lng-->0; ) {
		switch(fns[lng]) {
			case '.': dot=lng;
			case '/':; case '\\':; case ':': break;
			default: continue;
		} break;
	}
	fns[dot++]='.'; strcpy(fns+dot,ext);
}

int time_to_hmsf(ulong clt,char *hour,char *min,char *sec,char *frac) {
	if(--clt>=8640000LU) return(-1); clt++;
	*frac=(byte)(clt%100U); clt/=100U; *sec=(byte)(clt%60U); clt/=60U;
	*min=(byte)(clt%60U); clt/=60U; *hour=(byte)(clt); return(0);
}

int date_to_ymd(ulong cld,int *year,char *mon,char *day) {
	int y,m,d; char ndm[12]={31,28,31,30,31,30,31,31,30,31,30,31};
	if(cld<=3 || cld>109211LU) return(-1); cld+=(cld>36527LU)-4;
	y=(word)(1801U+(4*(cld/1461U))); if((d=(word)(cld%1461U))!=1460U)
		{ y+=d/365; d%=365; } else { y+=3; d=365; }
	if(y<100) y+=1900; *year=y; ndm[1]=28+(y%4==0 && y!=1900);
	for(m=0; m<12 && d>=ndm[m]; d-=ndm[m++]); *mon=m+1; *day=d+1;
	return(0);
}

int read_options_ctl(void) {
#if CLOPT
	char upperalpha[51],loweralpha[51]; int idx;
	FILE *ocf; static char ocfns[]="options.ctl";
	if((ocf=fopen(ocfns,"rb"))==NULL) goto ferr;
	if(fread(upperalpha,4,1,ocf)!=1) goto ferr;
	if(*(long*)upperalpha!=0x0000A786L)
		{ fprintf(stderr,"%s: signature bad\n",ocfns); goto errx; }
	if(fread(collate2,sizeof(collate2),1,ocf)!=1) goto ferr;
	if(fread(upperalpha,sizeof(upperalpha),1,ocf)!=1) goto ferr;
	if(fread(loweralpha,sizeof(loweralpha),1,ocf)!=1) goto ferr;
	for(idx=0; idx<sizeof(collate1); idx++) collate1[idx]=collate2[idx];
	for(idx=0; idx<sizeof(loweralpha); idx++)
		if(upperalpha[idx]==0 || loweralpha[idx]==0) break;
		else	collate1[0xff&loweralpha[idx]]=
			collate2[0xff&upperalpha[idx]];
	if(fread(upperalpha,sizeof(monthnam),1,ocf)!=1) goto ferr;
	for(idx=0; idx<sizeof(monthnam); idx++) monthnam[idx]=upperalpha[idx];
	fclose(ocf); return(0);
ferr:	perror(ocfns);
errx:	if(ocf!=NULL) { fclose(ocf); ErrFlag=ER_FATAL; }
#else
	int idx;
#endif
	for(idx=0; idx<sizeof(collate1); idx++)
		collate1[idx]=collate2[idx]=idx;
	for(idx='a'; idx<='z'; idx++) collate1[idx]^=' '; return(-1);
}

FILE *cdf=NULL; struct cl_file_header cfh;
char *rdp; word encr_key;

char *showfileinfo(char *fn) {
	int dy; char dm,dd,th,tm,ts,tf;
	if(date_to_ymd(cfh.chgdate,&dy,&dm,&dd)<0)
		return("%s: Invalid change date value\n");
	if(time_to_hmsf(cfh.chgtime,&th,&tm,&ts,&tf)<0)
		return("%s: Invalid change time value\n");
	if(Options & OPT_VERB)
		printf("%s, changed: %02u-%-3s-%04u %02u:%02u:%02u.%02u\n",
			fn,dd,monthnam+((dm-1)<<2),dy,th,tm,ts,tf);
	return(NULL);
}

void cl2crypt(void *data, int size) {
	int i; for(i=size/sizeof(word); i>0; ((word*)data)[--i]^=encr_key);
}

int get_encr_key(void) {
	int ks,ki;
	encr_key=0; if((cfh.sfatr&4)==0) return 0; /* not encrypted */
	if(*(word*)&cfh.reserved1!=((word*)&cfh.reserved1)[1]) return -1;
	encr_key=*(word*)(1+(char*)&cfh.reserved1);
	cl2crypt(&cfh.numbkeys,(char*)(&cfh+1)-(char*)&cfh.numbkeys);
	for(ks=ki=0; ki<(char*)(&cfh.reserved2)-(char*)&cfh;
		ks+=((byte*)&cfh)[ki++]);
	if(ks!=cfh.reserved2) return -1; /* unencrypt check failed */
	return 1;
}

void dumphex(void *data, int size) {
	int i; for(i=0; i<size; i++) printf(" %02x"+(i==0),((byte*)data)[i]);
}

byte *rec_data; struct field_descr *fds;
struct { int fidx,fwid,fchr; char *ffmt; } *afds;

assign_field(int fi, char *fn) {
	int c,d,i,l,p,s,w; char *fmt,fb[60];
	l=(fmt=strchr(fn,'%'))==NULL?strlen(fn):fmt-fn;
	for(p=0; p<4 && fds[0].fldname[p++]!=':'; );
	for(i=0; i<cfh.numflds; i++)
		if(strncasecmp(fds[i].fldname+p,fn,l)==0
		&& (p+l==16 || (fds[i].fldname[p+l]|' ')==' ')) goto asg;
	fprintf(stderr,"No field '%.*s'\n",l,fn); return -1;
uer:	fprintf(stderr,"Unrecognizable field '%.*s'\n",l,fn); return -1;
fer:	fprintf(stderr,"Bad format for field '%.*s': %s\n",l,fn,fmt); return -1;
asg:	afds[fi].fidx=i; c=d=w=s=0; 
	if(fmt!=NULL)
		while((c=fmt[++s])!=0 && (unsigned)(c-'a')>('z'-'a'))
			if((unsigned)(c-'0')<10) w=w*10+(c-'0');
			else if(w) { d++; if(c=='.') w=0; }
/*	printf("d=%i w=%i c='%c'(%02x)\n",d,w,c,c);	*/
	if(d>0 && c==0) goto fer;
	s=fds[i].length; afds[fi].fchr=c;
	switch(fds[i].fldtype) {
	case 1:	if(s!=4) goto uer;
		if(c!=0 && strchr("iouxdt",c)==NULL) goto fer;
		if(w>0 && c!=0) {
			if((s=strchr(fmt,c)-fmt)>=sizeof(fb)-2) goto fer;
			strncpy(fb,fmt,s); fb[s++]='l'; fb[s++]=c;
			fb[s]=0; fmt=strdup(fb); break;
		}
		if(w==0) switch(c) {
			case 0:	case'i': case'o': w=11; break;
			case'u': w=10; break;
			case'x': w=8; break;
			case'd': w=11; break;
			case't': w=8; break;
		}
		if(w>0) {
			if(c==0) c='i';
			sprintf(fb,"%%%u%c",w,c);
			fmt=strdup(fb);
		}
		break;
	case 2:	if(s!=8) goto uer;
		if(c!=0 && strchr("feg",c)==NULL) goto fer;
		if(c==0) {
			if(w==0) w=14; if(w<4) w=4;
			sprintf(fb,"%%%u.2f",w);
			fmt=strdup(fb);
		}
		break;
	case 7:	if(c==0) { fmt=NULL; break; }
	case 3:	case 4:	if(s==0) goto uer;
		if(c!=0 && c!='s' && c!='x') goto fer;
		if(w<1 || w>s) w=s; else if(c=='s') break;
		if(c!='x') { sprintf(fb,"%%.%us",w,'s'); fmt=strdup(fb); }
		break;
	case 5:	if(s!=1) goto uer;
		if(c!=0 && strchr("ioux",c)==NULL) goto fer;
		if(w>0 && c!=0) break; if(c==0) c='u';
		if(w<1) switch(c) {
			case'i': w=4; break;
			case'u': case'o': w=3; break;
			case'x': w=2; break;
		}
		sprintf(fb,"%%%u%c",w,c); fmt=strdup(fb);
		break;
	case 6:	if(s!=2) goto uer;
		if(c!=0 && strchr("ioux",c)==NULL) goto fer;
		if(w>0 && c!=0) break; if(c==0) c='i';
		if(w<1) switch(c) {
			case'i': case'o': w=6; break;
			case'u': w=5; break;
			case'x': w=4; break;
		}
		sprintf(fb,"%%%u%c",w,c); fmt=strdup(fb);
		break;
	case 8:	if(s==0) goto uer;
		if(c!=0 && c!='x' && c!='b') goto fer; if(c==0) c='b';
		if(w<1) w=(c=='x')?fds[i].length
			:2+fds[i].decsig+fds[i].decdec;
		break;
	default: goto uer;
	}
/*	printf("fmt=%s\n",fmt);	*/
	afds[fi].ffmt=fmt; afds[fi].fwid=w; return 0;
}

void show_date(long d, int w) {
	char mon,day,*fmt,*mn; int yr;
	if(date_to_ymd(d,&yr,&mon,&day)==-1) { printf("%*li",w,d); return; }
	mn=monthnam+((mon-1)<<2); fmt=NULL;
	if(w<=0) w=11; if(w<10) yr%=100;
	switch(w) {
	case 1:	case 2:	fmt="%2d"; break;
	case 3:	printf("/%02d",yr); break;
	case 4:	fmt="%2d%02d"; break;
	case 5:	fmt="%2d%/02d"; break;
	case 6:	fmt="%2d%02d%02d"; break;
	case 7:	printf("%2d%.3s%02d",day,mn); break;
	case 8:	fmt="%2d/%02d/%02d"; break;
	case 9:	printf("%2d-%.3s-%02d",day,mn,yr); break;
	case 10:fmt="%2d/%02d/%04d"; break;
	case 11:printf("%2d-%.3s-%04d",day,mn,yr); break;
	default:printf("%2d-%.3s-%04d%*s",day,mn,yr,w-11," "); break;
	}
	if(fmt!=NULL) printf(fmt,day,mon,yr);
}

void show_time(long t, int w) {
	char h,m,s,f,*fmt; fmt=NULL; if(w<=0) w=8;
	switch(w) {
	case 1:	case 2:	fmt="%2d"; break;
	case 3:	case 4: fmt="%2d%02d"; break;
	case 5: fmt="%2d:%02d"; break;
	case 6: fmt="%2d%02d%02d"; break;
	case 7:	case 8: fmt="%2d:%02d:%02d"; break;
	case 9:	case 10: fmt="%2d:%02d:%02d.%d"; break;
	case11: fmt="%2d:%02d:%02d.%02d"; break;
	default:fmt="%2d:%02d:%02d.%02d%*s"; break;
	}
	if(time_to_hmsf(t,&h,&m,&s,&f)==-1 || fmt==NULL) printf("%*li",w,t);
	else { if(w==9 || w==10) f/=10; printf(fmt,h,m,s,f,w-11," "); }
}

dump_field(int fi) {
	struct field_descr *fd; char *fmt; int fl,fp,fc,fw,i; byte *fa;
	fd=fds+afds[fi].fidx; fmt=afds[fi].ffmt; fc=afds[fi].fchr;
	fw=afds[fi].fwid; fl=fd->length; fa=rec_data+fd->foffset;
	putchar('\t'); switch(fd->fldtype) {
/*	"Format depends on data type, always width alone is allowed:"
	"for Long (type 1) can specify conversion '%<width>{i,o,x}',"
	"or format 'd' or 't' for date or time conversion;"
	"for Real (type 2) '%<width>.<prec>{f,e,g}' can be specified;"
	"for String (types 3,4) can specify '%<width>.<prec>s';"
	"for Byte (type 5) and Short (type 6) '%<width>{i,o,x}';"
	"Group (type 7) can be shown as hex dump: '%<width>x' only;"
	"BCD (type 8) allows hex dump, or '%<width>.<prec>b'."; */
	case 1:	/* long: i,o,x,d,t */
		if(fc=='d') { show_date(*(long*)fa,fw); break; }
		if(fc=='t') { show_time(*(long*)fa,fw); break; }
		printf(fmt,*(long*)fa); break;
	case 2:	/* real?: f,e,g */
		printf(fmt,*(double*)fa); break;
	case 7:	/* group: s,x */ if(fmt==NULL) break;
	case 3:	/* string; next is picture: s,x */
	case 4:	if(fc=='x') dumphex(fa,fw);
		else /* if(fc=='s') */ printf(fmt,fa);
		break;
	case 5:	/* byte: i,o,x */
		printf(fmt,*(byte*)fa); break;
	case 6:	/* short: i,o,x */
		printf(fmt,*(short*)fa); break;
	case 8:	/* BCD: x,b */ fa+=fl-1;
	/*	fp=fd->decdec; fs=fd->decsig;
		for(i=fs+fp; i-->1+fp; )
			if( ( (fa[-(i>>1)] >> ((i&1)<<2)) &0x0f) !=0) break;
			else printf(" ");
		for(; i>=0; i--) printf(i==fp?"%1x.":"%1x",
				(fa[-(i>>1)] >> ((i&1)<<2)) &0x0f);	*/
	/*	i=1+(fmt[1]=='.'); i=((unsigned)(fmt[i]-'0')>9)?-1:atoi(fmt+i)-1;
		if(i<0) i=fd->decsig+fd->decdec; else i-=(fd->decdec>1);
		while(--i>=fd->decdec && i>=fd->decsig+fd->decdec
		 && ((fa[-(i>>1)]>>((i&1)<<2))&0x0f)==0) putchar(' ');
		putchar(0x80&fa[1-fl]?'-':'+');
		for(; i>=0; i--) printf(i+1==fd->decdec?".%1x":"%1x",
					(fa[-(i>>1)]>>((i&1)<<2))&0x0f); */
		if(fc=='x') { dumphex(fa,fw); break; }
		i=fd->decsig+(fp=fd->decdec); fw=fw-1-(fp>0);
		if(i<fw) printf("%*s",fw-i," "); else i=fw;
		while(--i>=fp && ((fa[-(i>>1)]>>((i&1)<<2))&0xf)==0)
			putchar(' '); putchar(0x80&fa[1-fl]?'-':'+');
		for(; i>=0; i--) printf(i+1==fd->decdec?".%1x":"%1x",
					(fa[-(i>>1)]>>((i&1)<<2))&0x0f);
		break;
	default:;
	}
	return 0;
}

const char fldtypename[9][6]={"Long ","Real ","Str. ",
	"Pic. ","Byte ","Short","Group"," BCD ","Undef"};

char *processfile(char *fnam, ulong bgn, ulong end, char **fnfs) {
	ulong dri,lt; int fi,fn,rf; struct data_header *rbp;

 	/* open file and read Clarion file header */
	if((cdf=fopen(fnam,"rb"))==NULL) goto ioerr;
	if(fread((char*)&cfh,sizeof(cfh),1,cdf)!=1) goto ioerr;

	/* show file info: name, date, time */
	if(get_encr_key()==-1) { /* get encryption key failed */
		fclose(cdf); return "%s: fail to decrypt"; }
	if((char*)(lt=(ulong)showfileinfo(fnam))!=NULL) return((char*)lt);

	/* allocate memory for data to be read and for fields */
	for(fn=0; fnfs[fn]!=NULL; fn++);
	if((fn>0 && (afds=malloc(sizeof(*afds)*fn))==NULL)
	|| (fds=malloc(sizeof(struct field_descr)*cfh.numflds))==NULL
	|| (rbp=malloc(cfh.reclen))==NULL) return "%s: cannot get memory\n";
	rec_data=(byte*)(rbp+1);

	/* read (and decrypt) field info, assign fields */
	if((fi=fread(fds,sizeof(struct field_descr),cfh.numflds,cdf))
	!=cfh.numflds) goto ioerr;
	for(fi=0; fi<cfh.numflds; fi++) {
		cl2crypt(fds+fi,sizeof(struct field_descr)); if(fn==0) {
			unsigned t; t=fds[fi].fldtype;
			printf("%3u. %.16s %02x", fi+1, fds[fi].fldname, t);
			t--; if(t>8) t=8; printf(" (%s) ", fldtypename[t]);
			dumphex(fds[fi].fldname+16,
				sizeof(struct field_descr)-17);
			printf("\n");
	}	}
	if(fn==0) {
		printf("%lu records, %u bytes each, %lu deleted\n",
			cfh.numrecs,cfh.reclen,cfh.numdels); goto done;
	}
	for(fi=0; fi<fn; fi++) if(assign_field(fi,fnfs[fi])<0) return NULL;

	/* verify file size if OK */
	lt=cfh.reclen*cfh.numrecs+cfh.datofs; fseek(cdf,0,SEEK_END);
	if((dri=ftell(cdf))<lt) {	ErrFlag|=ER_DFILSH;
		if(dri<cfh.datofs) return("%s: file much too short\n");
		cfh.numrecs=(dri-cfh.datofs)/cfh.reclen;
		fprintf(stderr,"Warning: file too short\n");
	}
	if(dri>lt) fprintf(stderr,"Warning: garbage on end of file.\n");

	for(dri=1,rf=0; dri<=cfh.numrecs; rf++) dri*=10;
	if(bgn==0) bgn=1; if(end==0 || end>cfh.numrecs) end=cfh.numrecs;
	fseek(cdf,cfh.datofs+(bgn-1)*cfh.reclen,SEEK_SET);

	for(dri=bgn; dri<=end; dri++) {
		if(fread(rbp,cfh.reclen,1,cdf)!=1) goto ioerr;
		if(rbp->rhd & 0x10) continue; /* this record is deleted */
		cl2crypt(rbp+1, cfh.reclen-sizeof(struct data_header));
		printf("%*u",rf,dri);
		for(fi=0; fi<fn; fi++) dump_field(fi);
		printf("\n");
	/*	printf("r.%u=",dri);
		dumphex(rbp+1, cfh.reclen-sizeof(struct data_header));
		printf("\n"); */
	}
done:	fclose(cdf); return(NULL);
ioerr:	perror(fnam); ErrFlag|=ER_DATRD; return("");
}

char *Usage="%s - dump Clarion data file;  Jerzy Tarasiuk 29-Dec-2001\n"
	"Published under terms of GNU Public License version 2.\n\n"
	"Usage:\t%s [begin [end]] clarion-data-file-name \\\n"
	"\tfield1[%%format] [field2[%%format] ...]\n\n"
	"If no field is specified, field list and statistics is output.\n"
	"'begin' and 'end' (numbers) specify record range to dump.\n\n"
	"Field names are to be specified without prefix, in any case\n"
	"(lower/upper/mixed), and repeated with many formats if needed.\n\n"
	"Format depends on data type, always width alone is allowed:\n\n"
	"Integer numbers: Byte(5), Short(6), Long(1) allow i,o,u,x\n"
	"conversion (do not use 'l' for Long - added automatically),\n"
	"default is 'i', Long allows 'd' and 't' for date and time;\n\n"
	"String(3), Picture(4), Group(7) allow 's' (default for first\n"
	"two) and 'x' (hex dump - width specifies bytes to dump);\n\n"
	"Real(2) allows f,e,g specifiers (default is '14.2f');\n"
	"BCD allows 'x' (hex dump), default is 'b' (BCD, with width).\n";

/*		"for Long (type 1) can specify conversion '%<width>{i,o,x}',\n"
		"or format 'd' or 't' for date or time conversion;\n"
		"for Real (type 2) '%<width>.<prec>{f,e,g}' can be specified;\n"
		"for String (types 3,4) can specify '%<width>.<prec>s';\n"
		"for Byte (type 5) and Short (type 6) '%<width>{i,o,x}';\n"
		"Group (type 7) can be shown as hex dump: '%<width>x' only;\n"
		"BCD (type 8) allows hex dump, or '%<width>.<prec>b'.\n"; */

void getoptions(char *os) {}

main(int acnt,char *avec[]) {
	int aix,ck; ulong bgn,end; char *em,*fn;
	/* read info from Options.CTL file */
	if(read_options_ctl()<0) /* return(-1) */;
	/* check if have any args, error if none */
	if(acnt<=1) { fn=avec[0];
		if((em=strrchr(fn,'/'))!=NULL) fn=em+1;
		em=Usage; goto errex;
	}
	/* process options/files specified by args */
	for(bgn=end=ck=0,aix=1; aix<acnt; ) {
		/* get arg, check if it is option */
		if(*(fn=avec[aix++])=='-') { getoptions(fn); continue; }
		/* or maybe it is a number, try decode */
		if(end==0) {
			if(sscanf(fn,"%lu%n",ck==0?&bgn:&end,&ck)==1
			&& fn[ck]==0) continue; else end=0;
		}
		/* otherwise assume it is file name */
		em=processfile(fn,bgn,end,avec+aix);
		if(em!=NULL) goto errex; else break;
	}
	return(ErrFlag);
errex:	if(em!=NULL) fprintf(stderr,em,fn,fn);
	if(cdf!=NULL) fclose(cdf); return(ErrFlag);
}
