//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "ff_config.h"
#include "skala.h"
#include <math.h>
#include "ff_ver.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
Tf_config *f_config;
//---------------------------------------------------------------------------
__fastcall Tf_config::Tf_config(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void Tf_config::Draw(TCanvas* dtCanvas, int ml, int mg, int mp, int md, int w, int h, int r, float dx)
{
   if(dx==0) return;
   int exmax = w-mp;
   int eymax = h-md;
   float k,g1,g2;
   g1 = 1/(sqrt(2*M_PI))/dx;
   g2 = -1/(2*dx*dx);
	TSkalowanieSmall sx(ml,exmax,-r,r);
   TSkalowanieSmall sy(mg,eymax,1,0);
	TRect tr;
   tr.Top=0;
   tr.Bottom=h;
   tr.Left=0;
   tr.Right=w;
   dtCanvas->FillRect(tr);
   for(int i=ml;i<exmax;i++)
   {
		k = sx.EkrToReal(i);
   	dtCanvas->Pixels[i][sy.RealToEkr(g1*exp(g2*k*k))]=clBlue;
   }
	dtCanvas->MoveTo(ml,mg);
   dtCanvas->LineTo(ml,eymax);
   dtCanvas->LineTo(exmax,eymax);
   dtCanvas->Font->Name="Arial";
   dtCanvas->Font->Size=8;
   int lh = abs(MulDiv(dtCanvas->Font->Size,GetDeviceCaps(dtCanvas->Handle,LOGPIXELSY),72));
   TRect R;
   R.Bottom = 2.8*lh;
   R.Top = 0;
   R.Left = ml;
   R.Right = ml+w-mp;
   DrawText(dtCanvas->Handle, "Rozkad prawdopodobiestwa zaponu", -1, (RECT*)&R, DT_CENTER);
   dtCanvas->TextOut(ml,mg,"1");
   dtCanvas->TextOut(ml,eymax+3,AnsiString(-r));
   dtCanvas->TextOut(exmax,eymax+3,AnsiString(r));
//   dtCanvas->TextOut(exmax+2,ml+(w-mp)/2,"0");
}
//---------------------------------------------------------------------------
void __fastcall Tf_config::FormPaint(TObject *Sender)
{
	Rysuj();
}
//---------------------------------------------------------------------------
void Tf_config::Rysuj()
{
   Draw(img->Canvas, 20, 20, 20, 20, img->Width, img->Height, 5, atof(ed_dx->Text.c_str()));
	img->Canvas->Refresh();
   img->Repaint();
}
//---------------------------------------------------------------------------
void __fastcall Tf_config::ed_dxChange(TObject *Sender)
{
	Rysuj();
}
//---------------------------------------------------------------------------
void __fastcall Tf_config::btn_anulujClick(TObject *Sender)
{
	Application->Terminate();	
}
//---------------------------------------------------------------------------
void __fastcall Tf_config::btn_verClick(TObject *Sender)
{
	Tf_ver* f_ver = new Tf_ver(this);
	f_ver->memo->Lines->SetText(Hint.c_str());
   f_ver->ShowModal();
   delete f_ver;
}
//---------------------------------------------------------------------------
void __fastcall Tf_config::FormShow(TObject *Sender)
{
	Refresh();
}
//---------------------------------------------------------------------------
