//---------------------------------------------------------------------------
#ifndef ioH
#define ioH
//---------------------------------------------------------------------------
#define BF_IO_VERSION "2.50"
#define BF_IO_DATE    "04.05.2001"
#define BF_IO_COMMENT "windows"
//---------------------------------------------------------------------------
#define BACKUP_FILE "lastwork.txt"
//---------------------------------------------------------------------------
#define TEKST_POMOCY "Pomoc na temat parametrw uruchamiania programu \
BurnForest\n\n<rozmiar_x> i <rozmiar_y> okreslaj rozmiary terenu na ktrym \
ponie las. Zaleca si stosowanie wartoci rwnych conajmniej 100, bowiem \
przy wartociach mniejszych geometria planszy ma zbyt silny wpyw na \
uzyskiwane wyniki. <gsto> to warto gstoci lasu. <odch._std.> okrela \
odchylenie standardowe dla rozkadu Gaussa prawdopodobiestwa zaponu \
generowanego w przestrzeni przez pojedyncze drzewo. <liczba_prb> okrela \
ile razy ma by powtrzony poar lasu dla zadanej gstoci i rozmiarw. Do \
dokadnego modelowania zaleca si wykonywanie duej iloci prb, bowiem \
rozkad drzew ma charakter losowy. Dla kadej badanej gstoci, BurnForest, \
po zakoczeniu procesu badania, zapisuje wyniki poaru do pliku okrelonego \
przez <nazwa_pliku>. W pliku tym pierwsza kolumna oznacza gsto, druga \
czas trwania poaru, a trzecia procent drzewostanu, ktry spon. Parametr \
<bez_wizualizacji> okrela, czy ma by wywietlany widok poaru lasu. Dla \
inspiracji, zabawy, bd na uytek pokazu wizualizacja jest przydatna, \
natomiast zwiksza znacznie czas potrzebny na wykonanie jednego poaru, w \
zwizku z czym przy duej iloci prb okazuje si bardzo przydatna mozliwo \
jej wyczenia. <rozmiar_x>, <rozmiar_y>, <liczba_prb> musz by wiksze od \
zera! <gsto> to liczba z przedziau <-100,100>. <odch._std.> to liczba \
rzeczywista nie mniejsza ni jeden. W przypadku podania gstoci ujemnej \
zostanie uruchomiony proces przebadania wszystkich gstoci od (-podanej) do \
100. <bez_wizualizacji> to albo 0 (ozn: nie), albo 1 (ozn: tak). \
<nazwa_pliku> nie moe zawiera spacji. Naley podawa parametry rozwanie, \
bowiem program wyczy si dopiero PO wykonaniu przez niego WSZYSTKICH \
zadanych prb (i, ewentualnie, gstoci). W razie potrzeby mona go \
oczywicie zatrzyma przy pomocy 'Ctrl-C' (lub 'Ctrl-Alt-Del' - w \
zalenoci od systemu), ale po tym (w przypadku kiepskiego systemu operacyjnego \
typu Windows 95/...) w pamici komputera mog pozosta nieuprztnite mieci, \
co moe wymaga bdzie restartu systemu. Istnieje jednak moliwo kontynuacji \
przerwanych oblicze. Program podczas pracy zapisuje bowiem aktualny stan oblicze \
i w wypadku ich przerwania przy nastpnym uruchomieniu zapyta uytkownika, czy \
chce kontynuowa. Program BurnForest mona te uruchamia z wiersza komend. \
Przykadowe konfiguracje argumentw:\n \
200 200 75 3 2 0 out.txt\nczy tez: 123 123 -32 1.9 1 1 test.dat \
\nArgumenty wywoania programu: <rozmiar_x> <rozmiar_y> <gsto> <odch._std.> \
<liczba_prb> <bez_wizualizacji> <nazwa_pliku>\nTrzeba poda poprawnie (czyli \
zgodnie z powyszymi zaleceniami) wszystkie argumenty!\n\nAutorem tego programu \
jest Ryszard Kostecki\ne-mail: rpkost@tempac.okwf.fuw.edu.pl\nNajnowsza wersja \
programu BurnForest znajduje si na stronie WWW autora:\n \
http:/tempac.okwf.fuw.edu.pl/~rpkost\n"
//---------------------------------------------------------------------------
extern int arg_xsize, arg_ysize, arg_nprob;
extern float arg_gestosc, arg_dx;
extern bool arg_silence;
extern char arg_fn[1000]; //szczerze powiedziawszy - nie chce mi si bawi w dynamiczne
//przydzielanie pamici, kopiowanie stringw, etc.
//---------------------------------------------------------------------------
void prep_wnd_bf(int x, int y);//przygotuj okienko do wyswietlania pozaru "na zywo"
void upd_wnd_bf(int xs, int ys, unsigned char **d);//odswiez zawartosc okienka
void prep_file(int x, int y, float dx, char* fn);//przygotuj plik do danych wyjsciowych umieszczania
void add2file(float g, int t, float pr);//dodaj dane do pliku
void close_wnd_bf();//zamknij okienko "online"
void close_file();//zamknij plik
void show_wnd_eff(char* fn);//pokaz okienko wynikow
//show_wnd_eff samozniszczenie zawiera: taki create, show & close
bool spr_popr(char* xs, char* ys, char* g, char* dx, char* np, char* silence, char* fn);
bool spr_popr();
void show_help();
bool get_cfg();
bool cont_last_work();
void upd_last_work(int xsize, int ysize, float gestosc, float dx, int nprob, bool silence, char* fn);
//---------------------------------------------------------------------------
#endif
