*********1*********2*********3*********4*********5*********6*********7** 
      SUBROUTINE  EIGEN()
      USE TABLES
      USE VALUES
      IMPLICIT NONE

      real*16 HH(N*(N+1)/2),DN(N*(N+1)/2)
      INTEGER I,J,S,T
      real*16 WA(3*N+1),EPS
      integer, PARAMETER :: ITMAX = 40
      CHARACTER( LEN = 20 ) :: out_file

      CALL HAMLNORM(HH,DN)

      EE = EP
      DO I=1,N
       WF(I) = 1.q0
      ENDDO
      EPS = 0.q0

      CALL invsg(HH,DN,N,EE,WF,EPS,0,ITMAX,WA)

      WRITE(*,*) 'Wave function in  wfunc.dat'
      out_file = "wfunc.dat"
      OPEN(UNIT=9,FILE=out_file,FORM='UNFORMATTED')
      DO I=1,N
C      write(*,*) 'WF(',i,')=',WF(i)
       WRITE(9) WF(i)
      ENDDO
      CLOSE(9)

      out_file = "out.dat"
      OPEN(UNIT=9,FILE=out_file,FORM='FORMATTED')
      write(*,*) 'EE = ', EE
      write(9,*) 'EE            = ', EE
      CLOSE(9)      

      return
      END  

*********1*********2*********3*********4*********5*********6*********7** 

      SUBROUTINE HAMLNORM(HH,DN)
       USE VALUES
       USE PRMTS
       USE TABLES
       IMPLICIT NONE

       real*16 HH(N*(N+1)/2),DN(N*(N+1)/2)
       real*16 a,a1,a2,a3,b,b1,b2,b3,bl1,bl2,bl3
       integer i,j,p,r,s,t,lin
       real*16 C(6),val1,val2,zero
       real*16 f(0:MAXF)

       integer idx6
       integer ml1,ml2,ml3,ml4,ml5,ml6
       integer k1,k2,k3,k4,k5,k6
       integer m1,m2,m3,m4,m5,m6      
       integer n1,n2,n3,n4,n5,n6      
       C(1)=2;C(2)=2;C(3)=-1;C(4)=-1;C(5)=-1;C(6)=-1

       zero = 0.0q0
       do lin=1,N*(N+1)/2
        HH(lin)=zero
        DN(lin)=zero
       enddo

        do j=1,M  

         bl1 = X((j-1)*3+1)
         bl2 = X((j-1)*3+2)
         bl3 = X((j-1)*3+3)

         do i=j,M
          a1 = X((i-1)*3+1)
          a2 = X((i-1)*3+2)
          a3 = X((i-1)*3+3)

         do s=1,6
C          write(*,*) 'i:',i,'j:',j,'s:',s
        
          select case(s)
           case(1)
            b1 = bl1;b2=bl2;b3=bl3
           case(2)
            b1 = bl2;b2=bl1;b3=bl3        
           case(3)
            b1 = bl3;b2=bl1;b3=bl2        
           case(4)
            b1 = bl2;b2=bl3;b3=bl1
          case(5)
            b1 = bl1;b2=bl3;b3=bl2  
           case (6)
            b1 = bl3;b2=bl2;b3=bl1
          end select

          call p_f(f,a1+b1,a2+b2,a3+b3,2*sm+6)

         do p=SECT(i,1),SECT(i,1)+SECT(i,2)-1
         k1=DT(p,1);k2=DT(p,2);k3=DT(p,3)
         k4=DT(p,4);k5=DT(p,5);k6=DT(p,6) 

       do  r=SECT(j,1),SECT(j,1)+SECT(j,2)-1

       if (p>=r) then 

         ml1=DT(r,1);ml2=DT(r,2);ml3=DT(r,3)
         ml4=DT(r,4);ml5=DT(r,5);ml6=DT(r,6)
          
           select case(s)
            case(1)
             m1=ml1;m2=ml2;m3=ml3;m4=ml4;m5=ml5;m6=ml6
            case(2)
             m1=ml2;m2=ml1;m3=ml3;m4=ml5;m5=ml4;m6=ml6
            case(3)
             m1=ml3;m2=ml1;m3=ml2;m4=ml6;m5=ml4;m6=ml5
            case(4)
             m1=ml2;m2=ml3;m3=ml1;m4=ml5;m5=ml6;m6=ml4
            case(5)
             m1=ml1;m2=ml3;m3=ml2;m4=ml4;m5=ml6;m6=ml5
            case (6)
             m1=ml3;m2=ml2;m3=ml1;m4=ml6;m5=ml5;m6=ml4
           end select
 
           n1=k1+m1;n2=k2+m2;n3=k3+m3;n4=k4+m4;n5=k5+m5;n6=k6+m6

          val1=(
     - -((k2*m1+k1*m2)*
     -f(idx6(-1+n1,-1+n2,3+n3,1+n4,1+n5,1+n6)))-
     -(k5*m1+k1*m5)*f(idx6(-1+n1,1+n2,1+n3,1+n4,-1+n5,3+n6))+
     -(b2*k1+a2*m1)*f(idx6(-1+n1,1+n2,1+n3,1+n4,n5,3+n6))+
     -(4*k1*m1+k2*m1+k3*m1+k5*m1+k6*m1+k1*m2+k1*m3+k1*m5+
     -k1*m6)*f(idx6(-1 + n1,1 + n2,1 + n3,1 + n4,1 + n5,1 + n6))-
     -(b3*k1+a3*m1)*f(idx6(-1+n1,1+n2,1+n3,1+n4,1+n5,2+n6))-
     -(b2*k1+a2*m1)*f(idx6(-1+n1,1+n2,1+n3,1+n4,2+n5,1+n6))-
     -(k6*m1+k1*m6)*f(idx6(-1+n1,1+n2,1+n3,1+n4,3+n5,-1+n6))+
     -(b3*k1+a3*m1)*f(idx6(-1+n1,1+n2,1+n3,1+n4,3+n5,n6))-
     -(k3*m1+k1*m3)*f(idx6(-1+n1,3+n2,-1+n3,1+n4,1+n5,1+n6))+
     -4*f(idx6(n1,1+n2,1+n3,1+n4,1+n5,1+n6))-
     -(k4*m2+k2*m4)*f(idx6(1+n1,-1+n2,1+n3,-1+n4,1+n5,3+n6))+
     -(b1*k2+a1*m2)*f(idx6(1+n1,-1+n2,1+n3,n4,1+n5,3+n6))+
     -(k2*m1+k1*m2+4*k2*m2+k3*m2+k4*m2+k6*m2+k2*m3+k2*m4+
     -k2*m6)*f(idx6(1+n1,-1+n2,1+n3,1+n4,1+n5,1+n6))-
     -(b3*k2+a3*m2)*f(idx6(1+n1,-1+n2,1+n3,1+n4,1+n5,2+n6))-
     -(b1*k2+a1*m2)*f(idx6(1+n1,-1+n2,1+n3,2+n4,1+n5,1+n6))-
     -(k6*m2+k2*m6)*f(idx6(1+n1,-1+n2,1+n3,3+n4,1+n5,-1+n6))+
     -(b3*k2+a3*m2)*f(idx6(1+n1,-1+n2,1+n3,3+n4,1+n5,n6))+
     -4*f(idx6(1+n1,n2,1+n3,1+n4,1+n5,1+n6))-
     -(k4*m3+k3*m4)*f(idx6(1+n1,1+n2,-1+n3,-1+n4,3+n5,1+n6))+
     -(b1*k3+a1*m3)*f(idx6(1+n1,1+n2,-1+n3,n4,3+n5,1+n6))+
     -(k3*m1+k3*m2+k1*m3+k2*m3+4*k3*m3+k4*m3+k5*m3+k3*m4+
     -k3*m5)*f(idx6(1+n1,1+n2,-1+n3,1+n4,1+n5,1+n6))-
     -(b2*k3+a2*m3)*f(idx6(1+n1,1+n2,-1+n3,1+n4,2+n5,1+n6))-
     -(b1*k3+a1*m3)*f(idx6(1+n1,1+n2,-1+n3,2+n4,1+n5,1+n6))-
     -(k5*m3+k3*m5)*f(idx6(1+n1,1+n2,-1+n3,3+n4,-1+n5,1+n6))+
     -(b2*k3+a2*m3)*f(idx6(1+n1,1+n2,-1+n3,3+n4,n5,1+n6))+
     -4*f(idx6(1+n1,1+n2,n3,1+n4,1+n5,1+n6))+
     -(k4*m2+k4*m3+k2*m4+k3*m4+2*k4*m4)*
     -f(idx6(1+n1,1+n2,1+n3,-1+n4,1+n5,1+n6))-
     -(b1*k2+b1*k3+2*b1*k4+a1*m2+a1*m3+2*a1*m4+4*Z)*
     -f(idx6(1+n1,1+n2,1+n3,n4,1+n5,1+n6))+
     -(k5*m1+k5*m3+k1*m5+k3*m5+2*k5*m5)*
     -f(idx6(1+n1,1+n2,1+n3,1+n4,-1+n5,1+n6))-
     -(b2*k1+b2*k3+2*b2*k5+a2*m1+a2*m3+2*a2*m5+4*Z)*
     -f(idx6(1+n1,1+n2,1+n3,1+n4,n5,1+n6))+
     -(k6*m1+k6*m2+k1*m6+k2*m6+2*k6*m6)*
     -f(idx6(1+n1,1+n2,1+n3,1+n4,1+n5,-1+n6))-
     -(b3*k1+b3*k2+2*b3*k6+a3*m1+a3*m2+2*a3*m6+4*Z)*
     -f(idx6(1+n1,1+n2,1+n3,1+n4,1+n5,n6))+
     -2*(a1*b1+a2*b2+a3*b3)*
     -f(idx6(1+n1,1+n2,1+n3,1+n4,1+n5,1+n6))-
     -(k3*m2+k2*m3)*f(idx6(3+n1,-1+n2,-1+n3,1+n4,1+n5,1+n6)))
     -*0.25Q0
 
      val2=f(idx6(n1+1,n2+1,n3+1,1+n4,1+n5,1+n6))

        lin = p*(p-1)/2+r
        HH(lin)=HH(lin)+C(s)*val1
        DN(lin)=DN(lin)+C(s)*val2

       endif

c      p,r,s,i,j
          enddo
           enddo
            enddo
             enddo
              enddo
      RETURN
      END
*********1*********2*********3*********4*********5*********6*********7**
