(* expectation value of Breit Hamiltonian with Uehling potential *)
(* for spinless nucleus *)


(* -1/8 (1/m^3+1/M^3) p^4 *)

umat1[stepNumber_]:=-1/2 (energy-V[r[stepNumber]])^2 (1/m1^3 + 1/m2^3) (y[stepNumber][[1]])^2*rO Exp[t[stepNumber]] ;
left=1;
right=nInfinity;
tt1a = h*(Sum[cint[j]/dint(umat1[left+j-1]+umat1[right-j+1]),{j,1,nq}]+Sum[umat1[k],{k,left+nq,right-nq}]);


(* nabla^2 V *)

umat2[stepNumber_]:= -4 (energy-V[r[stepNumber]]) V[r[stepNumber]] (y[stepNumber][[1]])^2*rO Exp[t[stepNumber]] +
                     2 ((y[stepNumber][[2]] - y[stepNumber][[1]] 1/r[stepNumber])^2 + l(l+1)/r[stepNumber]^2 (y[stepNumber][[1]])^2 ) V[r[stepNumber]]*rO Exp[t[stepNumber]] ;
left=1;
right=nInfinity;
ss1=h*(Sum[cint[j]/dint(umat2[left+j-1]+umat2[right-j+1]),{j,1,nq}]+Sum[umat2[k],{k,left+nq,right-nq}]);


(*  1/8m^2  nabla^2 V *) 

ds2 = 0;
tt1b = ( 1/8/m1^2 + 1/8/m2^2 ds2 ) ss1;


(* nabla^2 (r V)' *)

umat3[stepNumber_]:= rO Exp[t[stepNumber]]*(-4) ( (energy-V[r[stepNumber]]) V[r[stepNumber]] (y[stepNumber][[1]])^2 + V[r[stepNumber]] *
                      (-energy + 1/2 V[r[stepNumber]]) ( (y[stepNumber][[1]])^2 + 2 r[stepNumber] y[stepNumber][[1]] y[stepNumber][[2]]) );
left=1;
right=nInfinity;
ss2a=h*(Sum[cint[j]/dint(umat3[left+j-1]+umat3[right-j+1]),{j,1,nq}]+Sum[umat3[k],{k,left+nq,right-nq}]);

umat4[stepNumber_]:=rO Exp[t[stepNumber]]*(-4) r[stepNumber] V[r[stepNumber]] ( y[stepNumber][[1]] y[stepNumber][[2]] ( -2(energy-V[r[stepNumber]]) 
                         + 2(l(l+1)+1)/r[stepNumber]^2 ) - (y[stepNumber][[2]])^2/r[stepNumber] 
                         + (y[stepNumber][[1]])^2/r[stepNumber] ( 2(energy-V[r[stepNumber]]) - (2l(l+1)+1)/r[stepNumber]^2) );
left=1;
right=nInfinity;
ss2b=h*(Sum[cint[j]/dint(umat4[left+j-1]+umat4[right-j+1]),{j,1,nq}]+Sum[umat4[k],{k,left+nq,right-nq}]);

ss2 = ss2a+ss2b;


(* 1/2mM nabla^2 (V - 1/4 (rV)' ) *)

tt1c = 1/2 1/m1 1/m2 (ss1 - 1/4 ss2);


(* V'/r *)

umat5[stepNumber_]:= rO Exp[t[stepNumber]]*( -2 y[stepNumber][[1]] y[stepNumber][[2]]/r[stepNumber] + (y[stepNumber][[1]])^2/r[stepNumber]^2) V[r[stepNumber]];
left=1;
right=nInfinity;
ss3=h*(Sum[cint[j]/dint(umat5[left+j-1]+umat5[right-j+1]),{j,1,nq}]+Sum[umat5[k],{k,left+nq,right-nq}]);


(* p^2/2 r V' *)

umat6[stepNumber_]:= rO Exp[t[stepNumber]]* (-1) ( energy-V[r[stepNumber]]/2) V[r[stepNumber]] ( (y[stepNumber][[1]])^2 + 2 r[stepNumber] y[stepNumber][[1]] y[stepNumber][[2]]);
left=1;
right=nInfinity;
ss4=h*(Sum[cint[j]/dint(umat6[left+j-1]+umat6[right-j+1]),{j,1,nq}]+Sum[umat6[k],{k,left+nq,right-nq}]);


(* p^2/2 V *)

umat7[stepNumber_]:= rO Exp[t[stepNumber]]* (energy-V[r[stepNumber]]) V[r[stepNumber]] (y[stepNumber][[1]])^2;
left=1;
right=nInfinity;
ss5=h*(Sum[cint[j]/dint(umat7[left+j-1]+umat7[right-j+1]),{j,1,nq}]+Sum[umat7[k],{k,left+nq,right-nq}]);


(* 1/2mM ( V'/r L^2 + p^2/2(V-rV') + (V-rV')p^2/2 *)

tt1d = 1/2 1/m1 1/m2 ( ss3 l(l+1) + 2*ss5 - 2*ss4);


(* energy E4 centroid *)

E4cen = tt1a+tt1b+tt1c+tt1d;
E4cen = E4cen alp^2;

(* spin-orbit *)

E4so = alp^2 ( ((g1-1)/2/m1^2 + g1/2/m1/m2) If[l==0,0, LS1] ) ss3;


E4tot = (E4cen+E4so);
E4tot = E4tot/m evfac;

Print["Contribution E^(4) with exact vacuum polarization in eV"];
Print[NumberForm[E4tot, 20]];
Print[""]


