(* E^(5) correction for arbitrary masses, spinless nucleus *)

(* load table of Bethe logs *)
<<bethelog.m


(* only for non-S-states *)

E5L = If[l==0,0,-14/3 z^5 alp^3/(3 m1 m2) 1/(4 Pi) 2/( l(l+1)(2l+1)n^3)] - 4/3 (1/m1+z/m2)^2 z^4 alp^3/(n^3 Pi) lnk0[n,l] ;

E5tot = If[l==0,0,E5L];
E5tot = Expand[E5tot];
E5tot = E5tot/m evfac;
E5tot = Expand[E5tot]

Print["Contribution E^(5) without vacuum polarization in eV"];
Print[NumberForm[E5tot, 20]];
Print[""]

kap = (l-j)(2j+1);

(* E^(6) correction for arbitrary masses, spinless nucleus and l>1, omitting electric dipole polarizability since overall this contribution is small *)

E6L = z^6 alp^4 (X3/( (2kap+1)^3 Abs[kap] n^3) + X4/( (2kap+1)^2 n^4) + X5/( (2kap+1) Abs[kap] n^5) + X6/n^6 + 2 (ae1+ae2)/( (2l-1)(2l+1)(2l+3)) (1/n^5-3/(l(l+1)n^3)) )/.{ae1->0,ae2->0};
X6 = -5/16 + 3/16/m1/m2 - 1/16/(m1 m2)^2;
X5 = g1^2/(2kap-1)/(2kap+3) ( (3+kap)/8/m1^2 + kap/4/m1^3) + g1 (1/m1 + 3(1-2kap-2kap^2)/(2(2kap-1)(2kap+3)m1^2) + 3(-3+3kap+4kap^2)/(4(2kap-1)(2kap+3)m1^3) ) +
     3kap/2 + kap(3-8kap-8kap^2)/(2(2kap-1)(2kap+3)m1) + (15-26kap-4kap^2+16kap^3)/(4(2kap-1)(2kap+3)m1^2) + (-9+10kap+12kap^2)/(4(2kap-1)(2kap+3)m1^3 m2);
X4 = -3(2kap m1^2+g1 m1-1)^2/(8kap^2 m1^4);
X3 = g1^2/((1+kap)(2kap-1)(2kap+3)) ( -(-3-5kap+49kap^2+96kap^3+36kap^4)/(8kap^2 m1^2) - 3(2kap+1)^2/(4 m1^3) ) +
     g1 ( 3 (2kap+1)^2/((2kap-1)(2kap+3)m1^2) + (-3-5kap+43kap^2+60kap^3-36kap^4-48kap^5)/(4kap^2(1+kap)(2kap-1)(2kap+3)m1^3) - (1+6kap+6kap^2)/(2kap(1+kap)m1) ) -
     kap + 6 kap(2kap+1)^2/((2kap-1)(2kap+3)m1) + 3(2kap+1)^2/(2(1+kap)(2kap-1)(2kap+3)m1^3) + (3+2kap-48kap^2-24kap^3+48kap^4)/(8kap^2 (2kap-1)(2kap+3)m1^4) -
     (3+14kap+2kap^2+12kap^3+72kap^4+48kap^5)/(2kap(1+kap)(2kap-1)(2kap+3)m1^2);


E6tot = If[l==0,0,If[l==1,0,E6L]];
E6tot = Expand[E6tot];
E6tot = E6tot/m evfac;
E6tot = Expand[E6tot];

Print["Contribution E^(6) without vacuum polarization in eV"];
Print[NumberForm[E6tot, 20]];
Print[""]


(* E^(7) correction for spinless nucleus *)
(* only nonrecoil approximation and logarithmic terms  *)

E7L = If[l>1, z^6 alp^5/(Pi Delta) m1 (  8(3n^2-l(l+1))/3/n^5 Log[1/2 (z alp)^-2] )];
Delta = If[l>1,l(l+1)(2l-1)(2l+1)(2l+3)];

E7tot = E7L;
E7tot = Expand[E7tot];
E7tot = E7tot/m evfac;
E7tot = Expand[E7tot];

Print["Estimate of E^(7) based on nonrecoil result in eV"];
Print[NumberForm[E7tot, 20]];
Print[""]

E7unc = E7tot/2;

Print["With uncertainty 50%"];
Print[NumberForm[E7unc, 20]];
Print[""]


(* E^(8) *)
(* Dirac value *)

E8tot = z^8 alp^6 m1 1/16 (35/(8 n^8)-15/(Abs[kap] n^7) +15/(kap^2 n^6) -1/(Abs[kap]^3 n^5) -3/(kap^4 n^4) -1/(Abs[kap]^5 n^3) );
E8tot = E8tot/m evfac;
E8tot = Expand[E8tot];

Print["Estimate of E^(8) based on nonrecoil Dirac result in eV"];
Print[NumberForm[E8tot, 20]];
Print[""]

E8unc = E8tot/2;

Print["With uncertainty 50%"];
Print[NumberForm[E8unc, 20]];
Print[""]

