(* with pulled out factor 1/r *)

V3T[r_,l_] := V3T[r,l] = Which[
       r<0.065,r V3[r] (1+Sum[aWK[1,ii,jj] r^ii l^jj,{ii,0,9},{jj,1,4}]),
       r>=0.065&&r<0.57,r V3[r] (1+Sum[aWK[2,ii,jj] (r-3/10)^ii l^jj,{ii,0,9},{jj,1,4}]),
       r>=0.57&&r<4.9,r V3[r] (1+Sum[aWK[3,ii,jj] (r-3)^ii l^jj,{ii,0,12},{jj,1,3}]),
       r>=4.9,r V3[r]+l/r^8 ( Sum[aWK[ii]/r^(2ii),{ii,0,12}] + l Sum[aWK[13+ii]/r^(2ii),{ii,0,8}] + l^2 Sum[aWK[22+ii]/r^(2ii+4),{ii,0,2}])];

V3[r_]:= V3[r] = Which[r<2,Sum[cWK[ii] r^(ii-1),{ii,0,7}] + Log[r] Sum[cWK[8+ii] r^(2+ii),{ii,0,4}] + Log[r]^2 Sum[cWK[13+ii] r^(ii+3),{ii,0,3}],
                       r>=2&&r<6.5,1/r^6 Sum[cWK[17+ii] (r-4)^ii,{ii,0,15}],
                       r>=6.5, Sum[cWK[33+ii] r^(-2ii-5),{ii,0,13}]];

cWK[0] = 2.09400223230612`20 10^-2;
cWK[1] =-6.32872935135875`20 10^-2;
cWK[2] = 1.65731329889455`20 10^-1;
cWK[3] = 8.94917333993648`20 10^-2;
cWK[4] =-1.49037972938795`20 10^-1;
cWK[5] = 1.61060326456320`20 10^-1;
cWK[6] =-2.77795743346460`20 10^-1;
cWK[7] = 5.51070428239548`20 10^-2;
cWK[8] = 2.22206163237763`20 10^-1;
cWK[9] = 1.44438097905071`20 10^-1;
cWK[10]= 1.01183787049750`20 10^-1;
cWK[11]= 8.08066257659644`20 10^-2;
cWK[12]=-1.77383292897469`20 10^-2;
cWK[13]= 2.57622481609891`20 10^-2;
cWK[14]= 2.72935944302010`20 10^-2;
cWK[15]=-3.65042490774651`20 10^-2;
cWK[16]= 1.60265697878146`20 10^-3;
cWK[17]= 1.840599562`20 10^-2;
cWK[18]= 6.904293516`20 10^-4;
cWK[19]=-2.336919042`20 10^-4;
cWK[20]= 4.141690871`20 10^-4;
cWK[21]=-1.357377739`20 10^-4;
cWK[22]= 1.054579484`20 10^-5;
cWK[23]= 7.166337955`20 10^-6;
cWK[24]=-3.118572223`20 10^-6;
cWK[25]= 5.747464015`20 10^-7;
cWK[26]=-1.397176849`20 10^-8;
cWK[27]=-2.380401218`20 10^-8;
cWK[28]= 8.302652500`20 10^-9;
cWK[29]=-1.493740499`20 10^-9;
cWK[30]= 3.379894309`20 10^-11;
cWK[31]= 4.711700526`20 10^-11;
cWK[32]=-6.930992009`20 10^-12;
cWK[33]= 2.829421201`20 10^-3;
cWK[34]= 1.419531914`20 10^-2;
cWK[35]= 1.329122936`20 10^-1;
cWK[36]= 2.440142043`20 10^0;
cWK[37]=-1.666377891`20 10^2;
cWK[38]= 8.263939921`20 10^4;
cWK[39]=-1.830462942`20 10^7;
cWK[40]= 2.608074207`20 10^9;
cWK[41]=-2.290806982`20 10^11;
cWK[42]= 1.277392347`20 10^13;
cWK[43]=-4.598075106`20 10^14;
cWK[44]= 1.043509719`20 10^16;
cWK[45]=-1.365036352`20 10^17;
cWK[46]= 7.873870977`20 10^17; 

(* a coefficients for r<0.065 *)

aWK[1,0,1] = 6.8013144`20 10^-1;
aWK[1,1,1] =-9.3543301`20 10^-1;
aWK[1,2,1] = 7.1137824`20 10^0;
aWK[1,3,1] =-1.4457279`20 10^2;
aWK[1,4,1] = 4.3669940`20 10^3;
aWK[1,5,1] =-1.1677107`20 10^5;
aWK[1,6,1] = 2.2324625`20 10^6;
aWK[1,7,1] =-2.7487106`20 10^7;
aWK[1,8,1] = 1.9337939`20 10^8;
aWK[1,9,1] =-5.8809002`20 10^8;

aWK[1,0,2] = 3.6574339`20 10^-1;
aWK[1,1,2] =-1.4404188`20 10^0;
aWK[1,2,2] = 2.6269637`20 10^1;
aWK[1,3,2] =-1.1348017`20 10^3;
aWK[1,4,2] = 5.0452898`20 10^4;
aWK[1,5,2] =-1.6249559`20 10^6;
aWK[1,6,2] = 3.4426517`20 10^7;
aWK[1,7,2] =-4.5191326`20 10^8;
aWK[1,8,2] = 3.3208324`20 10^9;
aWK[1,9,2] =-1.0421858`20 10^10;

aWK[1,0,3] = 1.6560327`20 10^-1;
aWK[1,1,3] =-7.5766000`20 10^-1;
aWK[1,2,3] =-1.8505126`20 10^1;
aWK[1,3,3] = 2.4366205`20 10^3;
aWK[1,4,3] =-1.4242866`20 10^5;
aWK[1,5,3] = 5.0879516`20 10^6;
aWK[1,6,3] =-1.1347061`20 10^8;
aWK[1,7,3] = 1.5349659`20 10^9;
aWK[1,8,3] =-1.1502721`20 10^10;
aWK[1,9,3] = 3.6598717`20 10^10;

aWK[1,0,4] = 9.5427961`20 10^-2;
aWK[1,1,4] =-3.3837419`20 10^0;
aWK[1,2,4] = 2.0348253`20 10^2;
aWK[1,3,4] =-1.3637254`20 10^4;
aWK[1,4,4] = 6.8808164`20 10^5;
aWK[1,5,4] =-2.3214427`20 10^7;
aWK[1,6,4] = 5.0283395`20 10^8;
aWK[1,7,4] =-6.6843170`20 10^9;
aWK[1,8,4] = 4.9515440`20 10^10;
aWK[1,9,4] =-1.5626036`20 10^11;

(* coefficients for 0.065<=r<0.57 *)

aWK[2,0,1] = 5.5381732`20 10^-1;
aWK[2,1,1] =-2.3966131`20 10^-1;
aWK[2,2,1] = 2.6033390`20 10^-1;
aWK[2,3,1] =-4.5084888`20 10^-1;
aWK[2,4,1] = 8.5843022`20 10^-1;
aWK[2,5,1] =-1.6173338`20 10^0;
aWK[2,6,1] = 1.5646938`20 10^0;
aWK[2,7,1] =-5.1707013`20 10^0;
aWK[2,8,1] = 4.3780788`20 10^1;
aWK[2,9,1] =-8.5568916`20 10^1;

aWK[2,0,2] = 2.3667464`20 10^-1;
aWK[2,1,2] =-1.8182894`20 10^-1;
aWK[2,2,2] = 2.8245365`20 10^-1;
aWK[2,3,2] =-5.6011797`20 10^-1;
aWK[2,4,2] = 1.2720945`20 10^0;
aWK[2,5,2] =-2.6245828`20 10^0;
aWK[2,6,2] = 1.3091473`20 10^0;
aWK[2,7,2] =-7.8489891`20 10^0;
aWK[2,8,2] = 1.0332338`20 10^2;
aWK[2,9,2] =-2.1249129`20 10^2;

aWK[2,0,3] = 8.5746818`20 10^-2;
aWK[2,1,3] =-9.0973983`20 10^-2;
aWK[2,2,3] = 1.7596765`20 10^-1;
aWK[2,3,3] =-3.8814037`20 10^-1;
aWK[2,4,3] = 9.6933191`20 10^-1;
aWK[2,5,3] =-2.1055817`20 10^0;
aWK[2,6,3] = 1.1391913`20 10^0;
aWK[2,7,3] =-7.4464685`20 10^0;
aWK[2,8,3] = 8.9269215`20 10^1;
aWK[2,9,3] =-1.8083996`20 10^2;

aWK[2,0,4] = 6.3305888`20 10^-3;
aWK[2,1,4] =-3.6693154`20 10^-2;
aWK[2,2,4] = 1.1434172`20 10^-1;
aWK[2,3,4] =-3.2293834`20 10^-1;
aWK[2,4,4] = 1.2234564`20 10^0;
aWK[2,5,4] =-2.8790135`20 10^0;
aWK[2,6,4] =-6.2287475`20 10^0;
aWK[2,7,4] = 1.5404821`20 10^0;
aWK[2,8,4] = 2.5520220`20 10^2;
aWK[2,9,4] =-5.8123897`20 10^2;

(* coefficients for 0.57<=r<4.9 *)

aWK[3,0,1] = 2.1235467`20 10^-1;
aWK[3,1,1] =-1.1502542`20 10^-1;
aWK[3,2,1] = 6.3151761`20 10^-3;
aWK[3,3,1] = 5.4395251`20 10^-3;
aWK[3,4,1] = 4.6491182`20 10^-4;
aWK[3,5,1] =-4.9584061`20 10^-4;
aWK[3,6,1] =-7.2384297`20 10^-5;
aWK[3,7,1] = 3.2523395`20 10^-5;
aWK[3,8,1] = 2.1778491`20 10^-5;
aWK[3,9,1] =-5.0581404`20 10^-6;
aWK[3,10,1]=-3.5768089`20 10^-6;
aWK[3,11,1]= 3.2368941`20 10^-7;
aWK[3,12,1]= 3.2702252`20 10^-7;

aWK[3,0,2] = 7.0458174`20 10^-2;
aWK[3,1,2] =-4.3314202`20 10^-2;
aWK[3,2,2] = 4.1863834`20 10^-3;
aWK[3,3,2] = 1.8360565`20 10^-3;
aWK[3,4,2] = 1.4449149`20 10^-4;
aWK[3,5,2] =-2.3732722`20 10^-4;
aWK[3,6,2] =-3.0259596`20 10^-5;
aWK[3,7,2] = 2.2953495`20 10^-5;
aWK[3,8,2] = 1.8254077`20 10^-5;
aWK[3,9,2] =-5.2611411`20 10^-6;
aWK[3,10,2]=-3.7153954`20 10^-6;
aWK[3,11,2]= 3.9365340`20 10^-7;
aWK[3,12,2]= 3.5942137`20 10^-7;

aWK[3,0,3] = 2.8420734`20 10^-2;
aWK[3,1,3] =-1.3682886`20 10^-2;
aWK[3,2,3] =-1.3170048`20 10^-4;
aWK[3,3,3] = 6.6785609`20 10^-4;
aWK[3,4,3] = 2.3730633`20 10^-4;
aWK[3,5,3] =-1.1803236`20 10^-4;
aWK[3,6,3] =-3.5713158`20 10^-5;
aWK[3,7,3] = 1.8474119`20 10^-5;
aWK[3,8,3] = 1.7525942`20 10^-5;
aWK[3,9,3] =-5.1550770`20 10^-6;
aWK[3,10,3]=-3.8022523`20 10^-6;
aWK[3,11,3]= 4.3553406`20 10^-7;
aWK[3,12,3]= 3.6642311`20 10^-7;

(* coefficients for r>=4.9 *)

aWK[0] = 2.6215464259`20 10^-3;
aWK[1] = 2.8016643324`20 10^-1;
aWK[2] =-1.2813943377`20 10^2;
aWK[3] = 5.2102564154`20 10^4;
aWK[4] =-1.1228221003`20 10^7;
aWK[5] = 1.4206203493`20 10^9;
aWK[6] =-1.0593271001`20 10^11;
aWK[7] = 4.9935992403`20 10^12;
aWK[8] =-1.5471055562`20 10^14;
aWK[9] = 3.1609993750`20 10^15;
aWK[10]=-4.1146486069`20 10^16;
aWK[11]= 3.0987916586`20 10^17;
aWK[12]=-1.0290092533`20 10^18;
aWK[13]=-1.2482737415`20 10^-3;
aWK[14]=-2.3189219713`20 10^-1;
aWK[15]= 9.3772578109`20 10^1;
aWK[16]=-2.1128439281`20 10^4;
aWK[17]= 2.0371525781`20 10^6;
aWK[18]=-9.2032018146`20 10^7;
aWK[19]= 2.1824057189`20 10^9;
aWK[20]=-2.6583114556`20 10^10;
aWK[21]= 1.3203353312`20 10^11;
aWK[22]=-6.6477713417`20 10^0;
aWK[23]= 1.2137936596`20 10^3;
aWK[24]=-2.0320050743`20 10^4;

(* coefficients used for low-r expansion *)

coefWKm1 = (z^3 alp^3*(1 + lbd*aWK[1, 0, 1] + lbd^2*aWK[1, 0, 2] + lbd^3*aWK[1, 0, 3] + lbd^4*aWK[1, 0, 4])*cWK[0]);

coefWK0 =  ((z^3 alp^3*m*(lbd*aWK[1, 1, 1]*cWK[0] + lbd^2*aWK[1, 1, 2]*cWK[0] + lbd^3*aWK[1, 1, 3]*cWK[0] + lbd^4*aWK[1, 1, 4]*cWK[0] 
  + cWK[1] + lbd*aWK[1, 0, 1]*cWK[1] + lbd^2*aWK[1, 0, 2]*cWK[1] + lbd^3*aWK[1, 0, 3]*cWK[1] + lbd^4*aWK[1, 0, 4]*cWK[1]))/alp);

coefWK10= ((z^3 alp^3*m^2*(lbd*aWK[1, 2, 1]*cWK[0] + lbd^2*aWK[1, 2, 2]*cWK[0] + lbd^3*aWK[1, 2, 3]*cWK[0] + lbd^4*aWK[1, 2, 4]*cWK[0] + 
   lbd*aWK[1, 1, 1]*cWK[1] + lbd^2*aWK[1, 1, 2]*cWK[1] + lbd^3*aWK[1, 1, 3]*cWK[1] + lbd^4*aWK[1, 1, 4]*cWK[1] + cWK[2] + lbd*aWK[1, 0, 1]*cWK[2] 
   + lbd^2*aWK[1, 0, 2]*cWK[2] + lbd^3*aWK[1, 0, 3]*cWK[2] + lbd^4*aWK[1, 0, 4]*cWK[2]))/alp^2);
   
coefWK20= ((z^3 alp^3*m^3*(lbd*aWK[1, 3, 1]*cWK[0] + 
        lbd^2*aWK[1, 3, 2]*cWK[0] + lbd^3*aWK[1, 3, 3]*cWK[0] + lbd^4*aWK[1, 3, 4]*cWK[0] + lbd*aWK[1, 2, 1]*cWK[1] 
        + lbd^2*aWK[1, 2, 2]*cWK[1] + lbd^3*aWK[1, 2, 3]*cWK[1] + lbd^4*aWK[1, 2, 4]*cWK[1] + lbd*aWK[1, 1, 1]*cWK[2] 
        + lbd^2*aWK[1, 1, 2]*cWK[2] + lbd^3*aWK[1, 1, 3]*cWK[2] + lbd^4*aWK[1, 1, 4]*cWK[2] + cWK[3] + lbd*aWK[1, 0, 1]*cWK[3] 
        + lbd^2*aWK[1, 0, 2]*cWK[3] + lbd^3*aWK[1, 0, 3]*cWK[3] + lbd^4*aWK[1, 0, 4]*cWK[3] + cWK[8]*Log[m/alp] + 
        lbd*aWK[1, 0, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 0, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 0, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 0, 4]*cWK[8]*Log[m/alp]))/alp^3);

coefWK31 = ((z^3 alp^3*m^3*(cWK[8] + lbd*aWK[1, 0, 1]*cWK[8] + lbd^2*aWK[1, 0, 2]*cWK[8] + lbd^3*aWK[1, 0, 3]*cWK[8] + lbd^4*aWK[1, 0, 4]*cWK[8]))/alp^3);

coefWK40 = ((z^3 alp^3*m^4*(lbd*aWK[1, 4, 1]*cWK[0] + lbd^2*aWK[1, 4, 2]*cWK[0] + lbd^3*aWK[1, 4, 3]*cWK[0] + lbd^4*aWK[1, 4, 4]*cWK[0] + 
             lbd*aWK[1, 3, 1]*cWK[1] + lbd^2*aWK[1, 3, 2]*cWK[1] + lbd^3*aWK[1, 3, 3]*cWK[1] + lbd^4*aWK[1, 3, 4]*cWK[1] + lbd*aWK[1, 2, 1]*cWK[2] 
             + lbd^2*aWK[1, 2, 2]*cWK[2] + lbd^3*aWK[1, 2, 3]*cWK[2] + lbd^4*aWK[1, 2, 4]*cWK[2] + lbd*aWK[1, 1, 1]*cWK[3] + 
             lbd^2*aWK[1, 1, 2]*cWK[3] + lbd^3*aWK[1, 1, 3]*cWK[3] + lbd^4*aWK[1, 1, 4]*cWK[3] + cWK[4] + lbd*aWK[1, 0, 1]*cWK[4] + 
             lbd^2*aWK[1, 0, 2]*cWK[4] + lbd^3*aWK[1, 0, 3]*cWK[4] + lbd^4*aWK[1, 0, 4]*cWK[4] + lbd*aWK[1, 1, 1]*cWK[8]*Log[m/alp] + 
             lbd^2*aWK[1, 1, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 1, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 1, 4]*cWK[8]*Log[m/alp] + 
             cWK[9]*Log[m/alp] + lbd*aWK[1, 0, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 0, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 0, 3]*cWK[9]*Log[m/alp] + 
    lbd^4*aWK[1, 0, 4]*cWK[9]*Log[m/alp] + cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 0, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 0, 2]*cWK[13]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 0, 3]*cWK[13]*Log[m/alp]^2 + lbd^4*aWK[1, 0, 4]*cWK[13]*Log[m/alp]^2))/alp^4);


coefWK41 = ((z^3 alp^3*m^4*(lbd*aWK[1, 1, 1]*cWK[8] + lbd^2*aWK[1, 1, 2]*cWK[8] 
   + lbd^3*aWK[1, 1, 3]*cWK[8] + lbd^4*aWK[1, 1, 4]*cWK[8] + cWK[9] + lbd*aWK[1, 0, 1]*cWK[9] + lbd^2*aWK[1, 0, 2]*cWK[9] + 
    lbd^3*aWK[1, 0, 3]*cWK[9] + lbd^4*aWK[1, 0, 4]*cWK[9] + 2*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 0, 1]*cWK[13]*Log[m/alp] + 
    2*lbd^2*aWK[1, 0, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 0, 3]*cWK[13]*Log[m/alp] + 2*lbd^4*aWK[1, 0, 4]*cWK[13]*Log[m/alp]))/alp^4);

coefWK42 = ((z^3 alp^3*m^4*(cWK[13] + lbd*aWK[1, 0, 1]*cWK[13] + lbd^2*aWK[1, 0, 2]*cWK[13] + 
             lbd^3*aWK[1, 0, 3]*cWK[13] + lbd^4*aWK[1, 0, 4]*cWK[13]))/alp^4);

coefWK50 = ((z^3 alp^3*m^5*(lbd*aWK[1, 5, 1]*cWK[0] + lbd^2*aWK[1, 5, 2]*cWK[0] + 
              lbd^3*aWK[1, 5, 3]*cWK[0] + lbd^4*aWK[1, 5, 4]*cWK[0] + lbd*aWK[1, 4, 1]*cWK[1] + lbd^2*aWK[1, 4, 2]*cWK[1] + 
    lbd^3*aWK[1, 4, 3]*cWK[1] + lbd^4*aWK[1, 4, 4]*cWK[1] + lbd*aWK[1, 3, 1]*cWK[2] + lbd^2*aWK[1, 3, 2]*cWK[2] + lbd^3*aWK[1, 3, 3]*cWK[2] + 
    lbd^4*aWK[1, 3, 4]*cWK[2] + lbd*aWK[1, 2, 1]*cWK[3] + lbd^2*aWK[1, 2, 2]*cWK[3] + lbd^3*aWK[1, 2, 3]*cWK[3] + lbd^4*aWK[1, 2, 4]*cWK[3] + 
    lbd*aWK[1, 1, 1]*cWK[4] + lbd^2*aWK[1, 1, 2]*cWK[4] + lbd^3*aWK[1, 1, 3]*cWK[4] + lbd^4*aWK[1, 1, 4]*cWK[4] + cWK[5] + lbd*aWK[1, 0, 1]*cWK[5] + 
    lbd^2*aWK[1, 0, 2]*cWK[5] + lbd^3*aWK[1, 0, 3]*cWK[5] + lbd^4*aWK[1, 0, 4]*cWK[5] + lbd*aWK[1, 2, 1]*cWK[8]*Log[m/alp] +
     lbd^2*aWK[1, 2, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 2, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 2, 4]*cWK[8]*Log[m/alp] + 
     lbd*aWK[1, 1, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 1, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 1, 3]*cWK[9]*Log[m/alp] + 
     lbd^4*aWK[1, 1, 4]*cWK[9]*Log[m/alp] + cWK[10]*Log[m/alp] + lbd*aWK[1, 0, 1]*cWK[10]*Log[m/alp] + 
    lbd^2*aWK[1, 0, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 0, 3]*cWK[10]*Log[m/alp] + lbd^4*aWK[1, 0, 4]*cWK[10]*Log[m/alp] + 
    lbd*aWK[1, 1, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 1, 2]*cWK[13]*Log[m/alp]^2 + lbd^3*aWK[1, 1, 3]*cWK[13]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 1, 4]*cWK[13]*Log[m/alp]^2 + cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 0, 1]*cWK[14]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 0, 2]*cWK[14]*Log[m/alp]^2 + lbd^3*aWK[1, 0, 3]*cWK[14]*Log[m/alp]^2 + lbd^4*aWK[1, 0, 4]*cWK[14]*Log[m/alp]^2))/alp^5);

coefWK51 = ((z^3 alp^3*m^5*(lbd*aWK[1, 2, 1]*cWK[8] + lbd^2*aWK[1, 2, 2]*cWK[8] + lbd^3*aWK[1, 2, 3]*cWK[8] + lbd^4*aWK[1, 2, 4]*cWK[8] + 
            lbd*aWK[1, 1, 1]*cWK[9] + lbd^2*aWK[1, 1, 2]*cWK[9] + lbd^3*aWK[1, 1, 3]*cWK[9] + lbd^4*aWK[1, 1, 4]*cWK[9] + cWK[10] + 
              lbd*aWK[1, 0, 1]*cWK[10] + lbd^2*aWK[1, 0, 2]*cWK[10] + lbd^3*aWK[1, 0, 3]*cWK[10] + lbd^4*aWK[1, 0, 4]*cWK[10] + 
    2*lbd*aWK[1, 1, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 1, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 1, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 1, 4]*cWK[13]*Log[m/alp] + 2*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 0, 1]*cWK[14]*Log[m/alp] + 
    2*lbd^2*aWK[1, 0, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 0, 3]*cWK[14]*Log[m/alp] + 2*lbd^4*aWK[1, 0, 4]*cWK[14]*Log[m/alp]))/alp^5);


coefWK52 = ((z^3 alp^3*m^5*(lbd*aWK[1, 1, 1]*cWK[13] + lbd^2*aWK[1, 1, 2]*cWK[13] + lbd^3*aWK[1, 1, 3]*cWK[13] + lbd^4*aWK[1, 1, 4]*cWK[13] + 
      cWK[14] + lbd*aWK[1, 0, 1]*cWK[14] + lbd^2*aWK[1, 0, 2]*cWK[14] + lbd^3*aWK[1, 0, 3]*cWK[14] + lbd^4*aWK[1, 0, 4]*cWK[14]))/alp^5);


coefWK60 =  ((z^3 alp^3*m^6*(lbd*aWK[1, 6, 1]*cWK[0] + lbd^2*aWK[1, 6, 2]*cWK[0] + lbd^3*aWK[1, 6, 3]*cWK[0] + lbd^4*aWK[1, 6, 4]*cWK[0] + 
             lbd*aWK[1, 5, 1]*cWK[1] + lbd^2*aWK[1, 5, 2]*cWK[1] + lbd^3*aWK[1, 5, 3]*cWK[1] + lbd^4*aWK[1, 5, 4]*cWK[1] + lbd*aWK[1, 4, 1]*cWK[2] 
             + lbd^2*aWK[1, 4, 2]*cWK[2] + lbd^3*aWK[1, 4, 3]*cWK[2] + lbd^4*aWK[1, 4, 4]*cWK[2] + lbd*aWK[1, 3, 1]*cWK[3] + 
             lbd^2*aWK[1, 3, 2]*cWK[3] + lbd^3*aWK[1, 3, 3]*cWK[3] + lbd^4*aWK[1, 3, 4]*cWK[3] + lbd*aWK[1, 2, 1]*cWK[4] + lbd^2*aWK[1, 2, 2]*cWK[4] + 
    lbd^3*aWK[1, 2, 3]*cWK[4] + lbd^4*aWK[1, 2, 4]*cWK[4] + lbd*aWK[1, 1, 1]*cWK[5] + lbd^2*aWK[1, 1, 2]*cWK[5] + lbd^3*aWK[1, 1, 3]*cWK[5] + 
    lbd^4*aWK[1, 1, 4]*cWK[5] + cWK[6] + lbd*aWK[1, 0, 1]*cWK[6] + lbd^2*aWK[1, 0, 2]*cWK[6] + lbd^3*aWK[1, 0, 3]*cWK[6] + lbd^4*aWK[1, 0, 4]*cWK[6] + 
    lbd*aWK[1, 3, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 3, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 3, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 3, 4]*cWK[8]*Log[m/alp] + 
    lbd*aWK[1, 2, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 2, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 2, 3]*cWK[9]*Log[m/alp] + lbd^4*aWK[1, 2, 4]*cWK[9]*Log[m/alp] +
     lbd*aWK[1, 1, 1]*cWK[10]*Log[m/alp] + lbd^2*aWK[1, 1, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 1, 3]*cWK[10]*Log[m/alp] + lbd^4*aWK[1, 1, 4]*cWK[10]*Log[m/alp] +
      cWK[11]*Log[m/alp] + lbd*aWK[1, 0, 1]*cWK[11]*Log[m/alp] + lbd^2*aWK[1, 0, 2]*cWK[11]*Log[m/alp] + lbd^3*aWK[1, 0, 3]*cWK[11]*Log[m/alp] + 
      lbd^4*aWK[1, 0, 4]*cWK[11]*Log[m/alp] + lbd*aWK[1, 2, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 2, 2]*cWK[13]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 2, 3]*cWK[13]*Log[m/alp]^2 + lbd^4*aWK[1, 2, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 1, 1]*cWK[14]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 1, 2]*cWK[14]*Log[m/alp]^2 +  lbd^3*aWK[1, 1, 3]*cWK[14]*Log[m/alp]^2 + lbd^4*aWK[1, 1, 4]*cWK[14]*Log[m/alp]^2 + 
    cWK[15]*Log[m/alp]^2 + lbd*aWK[1, 0, 1]*cWK[15]*Log[m/alp]^2 + lbd^2*aWK[1, 0, 2]*cWK[15]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 0, 3]*cWK[15]*Log[m/alp]^2 + lbd^4*aWK[1, 0, 4]*cWK[15]*Log[m/alp]^2))/alp^6);

coefWK61 = ((z^3 alp^3*m^6*(lbd*aWK[1, 3, 1]*cWK[8] + lbd^2*aWK[1, 3, 2]*cWK[8] + lbd^3*aWK[1, 3, 3]*cWK[8] + lbd^4*aWK[1, 3, 4]*cWK[8] + 
          lbd*aWK[1, 2, 1]*cWK[9] + lbd^2*aWK[1, 2, 2]*cWK[9] + lbd^3*aWK[1, 2, 3]*cWK[9] + lbd^4*aWK[1, 2, 4]*cWK[9] + lbd*aWK[1, 1, 1]*cWK[10] + 
          lbd^2*aWK[1, 1, 2]*cWK[10] + lbd^3*aWK[1, 1, 3]*cWK[10] + lbd^4*aWK[1, 1, 4]*cWK[10] + cWK[11] + 
    lbd*aWK[1, 0, 1]*cWK[11] + lbd^2*aWK[1, 0, 2]*cWK[11] + lbd^3*aWK[1, 0, 3]*cWK[11] + lbd^4*aWK[1, 0, 4]*cWK[11] + 2*lbd*aWK[1, 2, 1]*cWK[13]*Log[m/alp] + 
    2*lbd^2*aWK[1, 2, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 2, 3]*cWK[13]*Log[m/alp] + 2*lbd^4*aWK[1, 2, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 1, 1]*cWK[14]*Log[m/alp] + 
    2*lbd^2*aWK[1, 1, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 1, 3]*cWK[14]*Log[m/alp] + 2*lbd^4*aWK[1, 1, 4]*cWK[14]*Log[m/alp] + 
    2*cWK[15]*Log[m/alp] + 2*lbd*aWK[1, 0, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 0, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 0, 3]*cWK[15]*Log[m/alp] 
    + 2*lbd^4*aWK[1, 0, 4]*cWK[15]*Log[m/alp]))/alp^6);


coefWK62 = ((z^3 alp^3*m^6*(lbd*aWK[1, 2, 1]*cWK[13] + lbd^2*aWK[1, 2, 2]*cWK[13] + lbd^3*aWK[1, 2, 3]*cWK[13] + 
 	lbd^4*aWK[1, 2, 4]*cWK[13] + lbd*aWK[1, 1, 1]*cWK[14] + lbd^2*aWK[1, 1, 2]*cWK[14] + lbd^3*aWK[1, 1, 3]*cWK[14] + lbd^4*aWK[1, 1, 4]*cWK[14] + 
 	cWK[15] + lbd*aWK[1, 0, 1]*cWK[15] + lbd^2*aWK[1, 0, 2]*cWK[15] + lbd^3*aWK[1, 0, 3]*cWK[15] + lbd^4*aWK[1, 0, 4]*cWK[15]))/alp^6);

coefWK70 = ((z^3 alp^3*m^7*(lbd*aWK[1, 7, 1]*cWK[0] + lbd^2*aWK[1, 7, 2]*cWK[0] + lbd^3*aWK[1, 7, 3]*cWK[0] +
        lbd^4*aWK[1, 7, 4]*cWK[0] + lbd*aWK[1, 6, 1]*cWK[1] + lbd^2*aWK[1, 6, 2]*cWK[1] + 
    lbd^3*aWK[1, 6, 3]*cWK[1] + lbd^4*aWK[1, 6, 4]*cWK[1] + lbd*aWK[1, 5, 1]*cWK[2] + lbd^2*aWK[1, 5, 2]*cWK[2] + lbd^3*aWK[1, 5, 3]*cWK[2] + lbd^4*aWK[1, 5, 4]*cWK[2] + 
    lbd*aWK[1, 4, 1]*cWK[3] + lbd^2*aWK[1, 4, 2]*cWK[3] + lbd^3*aWK[1, 4, 3]*cWK[3] + lbd^4*aWK[1, 4, 4]*cWK[3] + lbd*aWK[1, 3, 1]*cWK[4] + lbd^2*aWK[1, 3, 2]*cWK[4] + 
    lbd^3*aWK[1, 3, 3]*cWK[4] + lbd^4*aWK[1, 3, 4]*cWK[4] + lbd*aWK[1, 2, 1]*cWK[5] + lbd^2*aWK[1, 2, 2]*cWK[5] + lbd^3*aWK[1, 2, 3]*cWK[5] + lbd^4*aWK[1, 2, 4]*cWK[5] + 
    lbd*aWK[1, 1, 1]*cWK[6] + lbd^2*aWK[1, 1, 2]*cWK[6] + lbd^3*aWK[1, 1, 3]*cWK[6] + lbd^4*aWK[1, 1, 4]*cWK[6] + cWK[7] + lbd*aWK[1, 0, 1]*cWK[7] + lbd^2*aWK[1, 0, 2]*cWK[7] + 
    lbd^3*aWK[1, 0, 3]*cWK[7] + lbd^4*aWK[1, 0, 4]*cWK[7] + lbd*aWK[1, 4, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 4, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 4, 3]*cWK[8]*Log[m/alp] + 
    lbd^4*aWK[1, 4, 4]*cWK[8]*Log[m/alp] + lbd*aWK[1, 3, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 3, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 3, 3]*cWK[9]*Log[m/alp] + 
    lbd^4*aWK[1, 3, 4]*cWK[9]*Log[m/alp] + lbd*aWK[1, 2, 1]*cWK[10]*Log[m/alp] + lbd^2*aWK[1, 2, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 2, 3]*cWK[10]*Log[m/alp] + 
    lbd^4*aWK[1, 2, 4]*cWK[10]*Log[m/alp] + lbd*aWK[1, 1, 1]*cWK[11]*Log[m/alp] + lbd^2*aWK[1, 1, 2]*cWK[11]*Log[m/alp] + lbd^3*aWK[1, 1, 3]*cWK[11]*Log[m/alp] + 
    lbd^4*aWK[1, 1, 4]*cWK[11]*Log[m/alp] + cWK[12]*Log[m/alp] + lbd*aWK[1, 0, 1]*cWK[12]*Log[m/alp] + lbd^2*aWK[1, 0, 2]*cWK[12]*Log[m/alp] + lbd^3*aWK[1, 0, 3]*cWK[12]*Log[m/alp] + 
    lbd^4*aWK[1, 0, 4]*cWK[12]*Log[m/alp] + lbd*aWK[1, 3, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 3, 2]*cWK[13]*Log[m/alp]^2 + lbd^3*aWK[1, 3, 3]*cWK[13]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 3, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 2, 1]*cWK[14]*Log[m/alp]^2 + lbd^2*aWK[1, 2, 2]*cWK[14]*Log[m/alp]^2 + lbd^3*aWK[1, 2, 3]*cWK[14]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 2, 4]*cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 1, 1]*cWK[15]*Log[m/alp]^2 + lbd^2*aWK[1, 1, 2]*cWK[15]*Log[m/alp]^2 + lbd^3*aWK[1, 1, 3]*cWK[15]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 1, 4]*cWK[15]*Log[m/alp]^2 + cWK[16]*Log[m/alp]^2 + lbd*aWK[1, 0, 1]*cWK[16]*Log[m/alp]^2 + lbd^2*aWK[1, 0, 2]*cWK[16]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 0, 3]*cWK[16]*Log[m/alp]^2 + lbd^4*aWK[1, 0, 4]*cWK[16]*Log[m/alp]^2))/alp^7);

coefWK71 = ((z^3 alp^3*m^7*(lbd*aWK[1, 4, 1]*cWK[8] + lbd^2*aWK[1, 4, 2]*cWK[8] + lbd^3*aWK[1, 4, 3]*cWK[8] + lbd^4*aWK[1, 4, 4]*cWK[8] + lbd*aWK[1, 3, 1]*cWK[9] + 
 lbd^2*aWK[1, 3, 2]*cWK[9] + lbd^3*aWK[1, 3, 3]*cWK[9] + lbd^4*aWK[1, 3, 4]*cWK[9] + lbd*aWK[1, 2, 1]*cWK[10] + lbd^2*aWK[1, 2, 2]*cWK[10] + 
 lbd^3*aWK[1, 2, 3]*cWK[10] + lbd^4*aWK[1, 2, 4]*cWK[10] + lbd*aWK[1, 1, 1]*cWK[11] + lbd^2*aWK[1, 1, 2]*cWK[11] + lbd^3*aWK[1, 1, 3]*cWK[11] + 
 lbd^4*aWK[1, 1, 4]*cWK[11] + cWK[12] + lbd*aWK[1, 0, 1]*cWK[12] + lbd^2*aWK[1, 0, 2]*cWK[12] +  lbd^3*aWK[1, 0, 3]*cWK[12] + lbd^4*aWK[1, 0, 4]*cWK[12] + 
 2*lbd*aWK[1, 3, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 3, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 3, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 3, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 2, 1]*cWK[14]*Log[m/alp] + 2*lbd^2*aWK[1, 2, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 2, 3]*cWK[14]*Log[m/alp] + 
    2*lbd^4*aWK[1, 2, 4]*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 1, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 1, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 1, 3]*cWK[15]*Log[m/alp] + 
    2*lbd^4*aWK[1, 1, 4]*cWK[15]*Log[m/alp] + 2*cWK[16]*Log[m/alp] + 2*lbd*aWK[1, 0, 1]*cWK[16]*Log[m/alp] + 2*lbd^2*aWK[1, 0, 2]*cWK[16]*Log[m/alp] +
     2*lbd^3*aWK[1, 0, 3]*cWK[16]*Log[m/alp] + 2*lbd^4*aWK[1, 0, 4]*cWK[16]*Log[m/alp]))/alp^7);

coefWK72 = ((z^3 alp^3*m^7*(lbd*aWK[1, 3, 1]*cWK[13] + lbd^2*aWK[1, 3, 2]*cWK[13] + lbd^3*aWK[1, 3, 3]*cWK[13] + lbd^4*aWK[1, 3, 4]*cWK[13] + 
   lbd*aWK[1, 2, 1]*cWK[14] + lbd^2*aWK[1, 2, 2]*cWK[14] + 
    lbd^3*aWK[1, 2, 3]*cWK[14] + lbd^4*aWK[1, 2, 4]*cWK[14] + lbd*aWK[1, 1, 1]*cWK[15] + lbd^2*aWK[1, 1, 2]*cWK[15] + lbd^3*aWK[1, 1, 3]*cWK[15] + 
    lbd^4*aWK[1, 1, 4]*cWK[15] + cWK[16] + lbd*aWK[1, 0, 1]*cWK[16] + lbd^2*aWK[1, 0, 2]*cWK[16] + lbd^3*aWK[1, 0, 3]*cWK[16] + lbd^4*aWK[1, 0, 4]*cWK[16]))/alp^7);


coefWK80 =  ((z^3 alp^3*m^8*(lbd*aWK[1, 8, 1]*cWK[0] + lbd^2*aWK[1, 8, 2]*cWK[0] + lbd^3*aWK[1, 8, 3]*cWK[0] + lbd^4*aWK[1, 8, 4]*cWK[0] + 
    lbd*aWK[1, 7, 1]*cWK[1] + lbd^2*aWK[1, 7, 2]*cWK[1] + 
    lbd^3*aWK[1, 7, 3]*cWK[1] + lbd^4*aWK[1, 7, 4]*cWK[1] + lbd*aWK[1, 6, 1]*cWK[2] + lbd^2*aWK[1, 6, 2]*cWK[2] + lbd^3*aWK[1, 6, 3]*cWK[2] + lbd^4*aWK[1, 6, 4]*cWK[2] + 
    lbd*aWK[1, 5, 1]*cWK[3] + lbd^2*aWK[1, 5, 2]*cWK[3] + lbd^3*aWK[1, 5, 3]*cWK[3] + lbd^4*aWK[1, 5, 4]*cWK[3] + lbd*aWK[1, 4, 1]*cWK[4] + lbd^2*aWK[1, 4, 2]*cWK[4] + 
    lbd^3*aWK[1, 4, 3]*cWK[4] + lbd^4*aWK[1, 4, 4]*cWK[4] + lbd*aWK[1, 3, 1]*cWK[5] + lbd^2*aWK[1, 3, 2]*cWK[5] + lbd^3*aWK[1, 3, 3]*cWK[5] + lbd^4*aWK[1, 3, 4]*cWK[5] + 
    lbd*aWK[1, 2, 1]*cWK[6] + lbd^2*aWK[1, 2, 2]*cWK[6] + lbd^3*aWK[1, 2, 3]*cWK[6] + lbd^4*aWK[1, 2, 4]*cWK[6] + lbd*aWK[1, 1, 1]*cWK[7] + lbd^2*aWK[1, 1, 2]*cWK[7] + 
    lbd^3*aWK[1, 1, 3]*cWK[7] + lbd^4*aWK[1, 1, 4]*cWK[7] + lbd*aWK[1, 5, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 5, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 5, 3]*cWK[8]*Log[m/alp] + 
    lbd^4*aWK[1, 5, 4]*cWK[8]*Log[m/alp] + lbd*aWK[1, 4, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 4, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 4, 3]*cWK[9]*Log[m/alp] + 
    lbd^4*aWK[1, 4, 4]*cWK[9]*Log[m/alp] + lbd*aWK[1, 3, 1]*cWK[10]*Log[m/alp] + lbd^2*aWK[1, 3, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 3, 3]*cWK[10]*Log[m/alp] + 
    lbd^4*aWK[1, 3, 4]*cWK[10]*Log[m/alp] + lbd*aWK[1, 2, 1]*cWK[11]*Log[m/alp] + lbd^2*aWK[1, 2, 2]*cWK[11]*Log[m/alp] + lbd^3*aWK[1, 2, 3]*cWK[11]*Log[m/alp] + 
    lbd^4*aWK[1, 2, 4]*cWK[11]*Log[m/alp] + lbd*aWK[1, 1, 1]*cWK[12]*Log[m/alp] + lbd^2*aWK[1, 1, 2]*cWK[12]*Log[m/alp] + lbd^3*aWK[1, 1, 3]*cWK[12]*Log[m/alp] + 
    lbd^4*aWK[1, 1, 4]*cWK[12]*Log[m/alp] + lbd*aWK[1, 4, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 4, 2]*cWK[13]*Log[m/alp]^2 + lbd^3*aWK[1, 4, 3]*cWK[13]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 4, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 3, 1]*cWK[14]*Log[m/alp]^2 + lbd^2*aWK[1, 3, 2]*cWK[14]*Log[m/alp]^2 + lbd^3*aWK[1, 3, 3]*cWK[14]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 3, 4]*cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 2, 1]*cWK[15]*Log[m/alp]^2 + lbd^2*aWK[1, 2, 2]*cWK[15]*Log[m/alp]^2 + lbd^3*aWK[1, 2, 3]*cWK[15]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 2, 4]*cWK[15]*Log[m/alp]^2 + lbd*aWK[1, 1, 1]*cWK[16]*Log[m/alp]^2 + lbd^2*aWK[1, 1, 2]*cWK[16]*Log[m/alp]^2 + lbd^3*aWK[1, 1, 3]*cWK[16]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 1, 4]*cWK[16]*Log[m/alp]^2))/alp^8);

coefWK81 =  ((z^3 alp^3*m^8*(lbd*aWK[1, 5, 1]*cWK[8] + lbd^2*aWK[1, 5, 2]*cWK[8] + lbd^3*aWK[1, 5, 3]*cWK[8] + lbd^4*aWK[1, 5, 4]*cWK[8] + 
      lbd*aWK[1, 4, 1]*cWK[9] + lbd^2*aWK[1, 4, 2]*cWK[9] + 
    lbd^3*aWK[1, 4, 3]*cWK[9] + lbd^4*aWK[1, 4, 4]*cWK[9] + lbd*aWK[1, 3, 1]*cWK[10] + lbd^2*aWK[1, 3, 2]*cWK[10] + lbd^3*aWK[1, 3, 3]*cWK[10] + lbd^4*aWK[1, 3, 4]*cWK[10] + 
    lbd*aWK[1, 2, 1]*cWK[11] + lbd^2*aWK[1, 2, 2]*cWK[11] + lbd^3*aWK[1, 2, 3]*cWK[11] + lbd^4*aWK[1, 2, 4]*cWK[11] + lbd*aWK[1, 1, 1]*cWK[12] + lbd^2*aWK[1, 1, 2]*cWK[12] + 
    lbd^3*aWK[1, 1, 3]*cWK[12] + lbd^4*aWK[1, 1, 4]*cWK[12] + 2*lbd*aWK[1, 4, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 4, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 4, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 4, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 3, 1]*cWK[14]*Log[m/alp] + 2*lbd^2*aWK[1, 3, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 3, 3]*cWK[14]*Log[m/alp] + 
    2*lbd^4*aWK[1, 3, 4]*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 2, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 2, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 2, 3]*cWK[15]*Log[m/alp] + 
    2*lbd^4*aWK[1, 2, 4]*cWK[15]*Log[m/alp] + 2*lbd*aWK[1, 1, 1]*cWK[16]*Log[m/alp] + 2*lbd^2*aWK[1, 1, 2]*cWK[16]*Log[m/alp] + 2*lbd^3*aWK[1, 1, 3]*cWK[16]*Log[m/alp] + 
    2*lbd^4*aWK[1, 1, 4]*cWK[16]*Log[m/alp]))/alp^8);

coefWK82 = ((z^3 alp^3*m^8*(lbd*aWK[1, 4, 1]*cWK[13] + lbd^2*aWK[1, 4, 2]*cWK[13] + lbd^3*aWK[1, 4, 3]*cWK[13] +
   lbd^4*aWK[1, 4, 4]*cWK[13] + lbd*aWK[1, 3, 1]*cWK[14] + lbd^2*aWK[1, 3, 2]*cWK[14] + 
    lbd^3*aWK[1, 3, 3]*cWK[14] + lbd^4*aWK[1, 3, 4]*cWK[14] + lbd*aWK[1, 2, 1]*cWK[15] + lbd^2*aWK[1, 2, 2]*cWK[15] + lbd^3*aWK[1, 2, 3]*cWK[15] + lbd^4*aWK[1, 2, 4]*cWK[15] + 
    lbd*aWK[1, 1, 1]*cWK[16] + lbd^2*aWK[1, 1, 2]*cWK[16] + lbd^3*aWK[1, 1, 3]*cWK[16] + lbd^4*aWK[1, 1, 4]*cWK[16]))/alp^8);

coefWK90 = ((z^3 alp^3*m^9*(lbd*aWK[1, 9, 1]*cWK[0] + lbd^2*aWK[1, 9, 2]*cWK[0] + lbd^3*aWK[1, 9, 3]*cWK[0] + lbd^4*aWK[1, 9, 4]*cWK[0] + lbd*aWK[1, 8, 1]*cWK[1] + lbd^2*aWK[1, 8, 2]*cWK[1] + 
    lbd^3*aWK[1, 8, 3]*cWK[1] + lbd^4*aWK[1, 8, 4]*cWK[1] + lbd*aWK[1, 7, 1]*cWK[2] + lbd^2*aWK[1, 7, 2]*cWK[2] + lbd^3*aWK[1, 7, 3]*cWK[2] + lbd^4*aWK[1, 7, 4]*cWK[2] + 
    lbd*aWK[1, 6, 1]*cWK[3] + lbd^2*aWK[1, 6, 2]*cWK[3] + lbd^3*aWK[1, 6, 3]*cWK[3] + lbd^4*aWK[1, 6, 4]*cWK[3] + lbd*aWK[1, 5, 1]*cWK[4] + lbd^2*aWK[1, 5, 2]*cWK[4] + 
    lbd^3*aWK[1, 5, 3]*cWK[4] + lbd^4*aWK[1, 5, 4]*cWK[4] + lbd*aWK[1, 4, 1]*cWK[5] + lbd^2*aWK[1, 4, 2]*cWK[5] + lbd^3*aWK[1, 4, 3]*cWK[5] + lbd^4*aWK[1, 4, 4]*cWK[5] + 
    lbd*aWK[1, 3, 1]*cWK[6] + lbd^2*aWK[1, 3, 2]*cWK[6] + lbd^3*aWK[1, 3, 3]*cWK[6] + lbd^4*aWK[1, 3, 4]*cWK[6] + lbd*aWK[1, 2, 1]*cWK[7] + lbd^2*aWK[1, 2, 2]*cWK[7] + 
    lbd^3*aWK[1, 2, 3]*cWK[7] + lbd^4*aWK[1, 2, 4]*cWK[7] + lbd*aWK[1, 6, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 6, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 6, 3]*cWK[8]*Log[m/alp] + 
    lbd^4*aWK[1, 6, 4]*cWK[8]*Log[m/alp] + lbd*aWK[1, 5, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 5, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 5, 3]*cWK[9]*Log[m/alp] + 
    lbd^4*aWK[1, 5, 4]*cWK[9]*Log[m/alp] + lbd*aWK[1, 4, 1]*cWK[10]*Log[m/alp] + lbd^2*aWK[1, 4, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 4, 3]*cWK[10]*Log[m/alp] + 
    lbd^4*aWK[1, 4, 4]*cWK[10]*Log[m/alp] + lbd*aWK[1, 3, 1]*cWK[11]*Log[m/alp] + lbd^2*aWK[1, 3, 2]*cWK[11]*Log[m/alp] + lbd^3*aWK[1, 3, 3]*cWK[11]*Log[m/alp] + 
    lbd^4*aWK[1, 3, 4]*cWK[11]*Log[m/alp] + lbd*aWK[1, 2, 1]*cWK[12]*Log[m/alp] + lbd^2*aWK[1, 2, 2]*cWK[12]*Log[m/alp] + lbd^3*aWK[1, 2, 3]*cWK[12]*Log[m/alp] + 
    lbd^4*aWK[1, 2, 4]*cWK[12]*Log[m/alp] + lbd*aWK[1, 5, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 5, 2]*cWK[13]*Log[m/alp]^2 + lbd^3*aWK[1, 5, 3]*cWK[13]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 5, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 4, 1]*cWK[14]*Log[m/alp]^2 + lbd^2*aWK[1, 4, 2]*cWK[14]*Log[m/alp]^2 + lbd^3*aWK[1, 4, 3]*cWK[14]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 4, 4]*cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 3, 1]*cWK[15]*Log[m/alp]^2 + lbd^2*aWK[1, 3, 2]*cWK[15]*Log[m/alp]^2 + lbd^3*aWK[1, 3, 3]*cWK[15]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 3, 4]*cWK[15]*Log[m/alp]^2 + lbd*aWK[1, 2, 1]*cWK[16]*Log[m/alp]^2 + lbd^2*aWK[1, 2, 2]*cWK[16]*Log[m/alp]^2 + lbd^3*aWK[1, 2, 3]*cWK[16]*Log[m/alp]^2 + 
    lbd^4*aWK[1, 2, 4]*cWK[16]*Log[m/alp]^2))/alp^9);

coefWK91 = ((z^3 alp^3*m^9*(lbd*aWK[1, 6, 1]*cWK[8] + lbd^2*aWK[1, 6, 2]*cWK[8] + lbd^3*aWK[1, 6, 3]*cWK[8] + 
 lbd^4*aWK[1, 6, 4]*cWK[8] + lbd*aWK[1, 5, 1]*cWK[9] + lbd^2*aWK[1, 5, 2]*cWK[9] + 
    lbd^3*aWK[1, 5, 3]*cWK[9] + lbd^4*aWK[1, 5, 4]*cWK[9] + lbd*aWK[1, 4, 1]*cWK[10] + lbd^2*aWK[1, 4, 2]*cWK[10] + lbd^3*aWK[1, 4, 3]*cWK[10] + lbd^4*aWK[1, 4, 4]*cWK[10] + 
    lbd*aWK[1, 3, 1]*cWK[11] + lbd^2*aWK[1, 3, 2]*cWK[11] + lbd^3*aWK[1, 3, 3]*cWK[11] + lbd^4*aWK[1, 3, 4]*cWK[11] + lbd*aWK[1, 2, 1]*cWK[12] + lbd^2*aWK[1, 2, 2]*cWK[12] + 
    lbd^3*aWK[1, 2, 3]*cWK[12] + lbd^4*aWK[1, 2, 4]*cWK[12] + 2*lbd*aWK[1, 5, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 5, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 5, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 5, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 4, 1]*cWK[14]*Log[m/alp] + 2*lbd^2*aWK[1, 4, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 4, 3]*cWK[14]*Log[m/alp] + 
    2*lbd^4*aWK[1, 4, 4]*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 3, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 3, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 3, 3]*cWK[15]*Log[m/alp] + 
    2*lbd^4*aWK[1, 3, 4]*cWK[15]*Log[m/alp] + 2*lbd*aWK[1, 2, 1]*cWK[16]*Log[m/alp] + 2*lbd^2*aWK[1, 2, 2]*cWK[16]*Log[m/alp] + 2*lbd^3*aWK[1, 2, 3]*cWK[16]*Log[m/alp] + 
    2*lbd^4*aWK[1, 2, 4]*cWK[16]*Log[m/alp]))/alp^9);

coefWK92 = ((z^3 alp^3*m^9*(lbd*aWK[1, 5, 1]*cWK[13] + lbd^2*aWK[1, 5, 2]*cWK[13] + lbd^3*aWK[1, 5, 3]*cWK[13] + lbd^4*aWK[1, 5, 4]*cWK[13] + 
 lbd*aWK[1, 4, 1]*cWK[14] + lbd^2*aWK[1, 4, 2]*cWK[14] + 
    lbd^3*aWK[1, 4, 3]*cWK[14] + lbd^4*aWK[1, 4, 4]*cWK[14] + lbd*aWK[1, 3, 1]*cWK[15] + lbd^2*aWK[1, 3, 2]*cWK[15] + lbd^3*aWK[1, 3, 3]*cWK[15] + lbd^4*aWK[1, 3, 4]*cWK[15] + 
    lbd*aWK[1, 2, 1]*cWK[16] + lbd^2*aWK[1, 2, 2]*cWK[16] + lbd^3*aWK[1, 2, 3]*cWK[16] + lbd^4*aWK[1, 2, 4]*cWK[16]))/alp^9);


coefWK100 = ((z^3 alp^3*m^10*(lbd*aWK[1, 9, 1]*cWK[1] + lbd^2*aWK[1, 9, 2]*cWK[1] + lbd^3*aWK[1, 9, 3]*cWK[1] + lbd^4*aWK[1, 9, 4]*cWK[1] + 
            lbd*aWK[1, 8, 1]*cWK[2] + lbd^2*aWK[1, 8, 2]*cWK[2] + 
    lbd^3*aWK[1, 8, 3]*cWK[2] + lbd^4*aWK[1, 8, 4]*cWK[2] + lbd*aWK[1, 7, 1]*cWK[3] + lbd^2*aWK[1, 7, 2]*cWK[3] + lbd^3*aWK[1, 7, 3]*cWK[3] + lbd^4*aWK[1, 7, 4]*cWK[3] + 
    lbd*aWK[1, 6, 1]*cWK[4] + lbd^2*aWK[1, 6, 2]*cWK[4] + lbd^3*aWK[1, 6, 3]*cWK[4] + lbd^4*aWK[1, 6, 4]*cWK[4] + lbd*aWK[1, 5, 1]*cWK[5] + lbd^2*aWK[1, 5, 2]*cWK[5] + 
    lbd^3*aWK[1, 5, 3]*cWK[5] + lbd^4*aWK[1, 5, 4]*cWK[5] + lbd*aWK[1, 4, 1]*cWK[6] + lbd^2*aWK[1, 4, 2]*cWK[6] + lbd^3*aWK[1, 4, 3]*cWK[6] + lbd^4*aWK[1, 4, 4]*cWK[6] + 
    lbd*aWK[1, 3, 1]*cWK[7] + lbd^2*aWK[1, 3, 2]*cWK[7] + lbd^3*aWK[1, 3, 3]*cWK[7] + lbd^4*aWK[1, 3, 4]*cWK[7] + lbd*aWK[1, 7, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 7, 2]*cWK[8]*Log[m/alp] + 
    lbd^3*aWK[1, 7, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 7, 4]*cWK[8]*Log[m/alp] + lbd*aWK[1, 6, 1]*cWK[9]*Log[m/alp] + lbd^2*aWK[1, 6, 2]*cWK[9]*Log[m/alp] + 
    lbd^3*aWK[1, 6, 3]*cWK[9]*Log[m/alp] + lbd^4*aWK[1, 6, 4]*cWK[9]*Log[m/alp] + lbd*aWK[1, 5, 1]*cWK[10]*Log[m/alp] + lbd^2*aWK[1, 5, 2]*cWK[10]*Log[m/alp] + 
    lbd^3*aWK[1, 5, 3]*cWK[10]*Log[m/alp] + lbd^4*aWK[1, 5, 4]*cWK[10]*Log[m/alp] + lbd*aWK[1, 4, 1]*cWK[11]*Log[m/alp] + lbd^2*aWK[1, 4, 2]*cWK[11]*Log[m/alp] + 
    lbd^3*aWK[1, 4, 3]*cWK[11]*Log[m/alp] + lbd^4*aWK[1, 4, 4]*cWK[11]*Log[m/alp] + lbd*aWK[1, 3, 1]*cWK[12]*Log[m/alp] + lbd^2*aWK[1, 3, 2]*cWK[12]*Log[m/alp] + 
    lbd^3*aWK[1, 3, 3]*cWK[12]*Log[m/alp] + lbd^4*aWK[1, 3, 4]*cWK[12]*Log[m/alp] + lbd*aWK[1, 6, 1]*cWK[13]*Log[m/alp]^2 + lbd^2*aWK[1, 6, 2]*cWK[13]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 6, 3]*cWK[13]*Log[m/alp]^2 + lbd^4*aWK[1, 6, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 5, 1]*cWK[14]*Log[m/alp]^2 + lbd^2*aWK[1, 5, 2]*cWK[14]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 5, 3]*cWK[14]*Log[m/alp]^2 + lbd^4*aWK[1, 5, 4]*cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 4, 1]*cWK[15]*Log[m/alp]^2 + lbd^2*aWK[1, 4, 2]*cWK[15]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 4, 3]*cWK[15]*Log[m/alp]^2 + lbd^4*aWK[1, 4, 4]*cWK[15]*Log[m/alp]^2 + lbd*aWK[1, 3, 1]*cWK[16]*Log[m/alp]^2 + lbd^2*aWK[1, 3, 2]*cWK[16]*Log[m/alp]^2 + 
    lbd^3*aWK[1, 3, 3]*cWK[16]*Log[m/alp]^2 + lbd^4*aWK[1, 3, 4]*cWK[16]*Log[m/alp]^2))/alp^10);

coefWK101 = ((z^3 alp^3*m^10*(lbd*aWK[1, 7, 1]*cWK[8] + lbd^2*aWK[1, 7, 2]*cWK[8] + lbd^3*aWK[1, 7, 3]*cWK[8] + lbd^4*aWK[1, 7, 4]*cWK[8] + lbd*aWK[1, 6, 1]*cWK[9] + lbd^2*aWK[1, 6, 2]*cWK[9] + 
    lbd^3*aWK[1, 6, 3]*cWK[9] + lbd^4*aWK[1, 6, 4]*cWK[9] + lbd*aWK[1, 5, 1]*cWK[10] + lbd^2*aWK[1, 5, 2]*cWK[10] + lbd^3*aWK[1, 5, 3]*cWK[10] + lbd^4*aWK[1, 5, 4]*cWK[10] + 
    lbd*aWK[1, 4, 1]*cWK[11] + lbd^2*aWK[1, 4, 2]*cWK[11] + lbd^3*aWK[1, 4, 3]*cWK[11] + lbd^4*aWK[1, 4, 4]*cWK[11] + lbd*aWK[1, 3, 1]*cWK[12] + lbd^2*aWK[1, 3, 2]*cWK[12] + 
    lbd^3*aWK[1, 3, 3]*cWK[12] + lbd^4*aWK[1, 3, 4]*cWK[12] + 2*lbd*aWK[1, 6, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 6, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 6, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 6, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 5, 1]*cWK[14]*Log[m/alp] + 2*lbd^2*aWK[1, 5, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 5, 3]*cWK[14]*Log[m/alp] + 
    2*lbd^4*aWK[1, 5, 4]*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 4, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 4, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 4, 3]*cWK[15]*Log[m/alp] + 
    2*lbd^4*aWK[1, 4, 4]*cWK[15]*Log[m/alp] + 2*lbd*aWK[1, 3, 1]*cWK[16]*Log[m/alp] + 2*lbd^2*aWK[1, 3, 2]*cWK[16]*Log[m/alp] + 2*lbd^3*aWK[1, 3, 3]*cWK[16]*Log[m/alp] + 
    2*lbd^4*aWK[1, 3, 4]*cWK[16]*Log[m/alp]))/alp^10);

coefWK102 = ((z^3 alp^3*m^10*(lbd*aWK[1, 6, 1]*cWK[13] + lbd^2*aWK[1, 6, 2]*cWK[13] + 
 lbd^3*aWK[1, 6, 3]*cWK[13] + lbd^4*aWK[1, 6, 4]*cWK[13] + lbd*aWK[1, 5, 1]*cWK[14] + lbd^2*aWK[1, 5, 2]*cWK[14] + 
    lbd^3*aWK[1, 5, 3]*cWK[14] + lbd^4*aWK[1, 5, 4]*cWK[14] + lbd*aWK[1, 4, 1]*cWK[15] + lbd^2*aWK[1, 4, 2]*cWK[15] + lbd^3*aWK[1, 4, 3]*cWK[15] + lbd^4*aWK[1, 4, 4]*cWK[15] + 
    lbd*aWK[1, 3, 1]*cWK[16] + lbd^2*aWK[1, 3, 2]*cWK[16] + lbd^3*aWK[1, 3, 3]*cWK[16] + lbd^4*aWK[1, 3, 4]*cWK[16]))/alp^10);

coefWK110 = ((z^3 alp^3*m^11*(lbd*aWK[1, 9, 1]*cWK[2] + lbd^2*aWK[1, 9, 2]*cWK[2] + lbd^3*aWK[1, 9, 3]*cWK[2] + lbd^4*aWK[1, 9, 4]*cWK[2] + lbd*aWK[1, 8, 1]*cWK[3] + lbd^2*aWK[1, 8, 2]*cWK[3] + 
    lbd^3*aWK[1, 8, 3]*cWK[3] + lbd^4*aWK[1, 8, 4]*cWK[3] + lbd*aWK[1, 7, 1]*cWK[4] + lbd^2*aWK[1, 7, 2]*cWK[4] + lbd^3*aWK[1, 7, 3]*cWK[4] + lbd^4*aWK[1, 7, 4]*cWK[4] + 
    lbd*aWK[1, 6, 1]*cWK[5] + lbd^2*aWK[1, 6, 2]*cWK[5] + lbd^3*aWK[1, 6, 3]*cWK[5] + lbd^4*aWK[1, 6, 4]*cWK[5] + lbd*aWK[1, 5, 1]*cWK[6] + lbd^2*aWK[1, 5, 2]*cWK[6] + 
    lbd^3*aWK[1, 5, 3]*cWK[6] + lbd^4*aWK[1, 5, 4]*cWK[6] + lbd*aWK[1, 4, 1]*cWK[7] + lbd^2*aWK[1, 4, 2]*cWK[7] + lbd^3*aWK[1, 4, 3]*cWK[7] + lbd^4*aWK[1, 4, 4]*cWK[7] + 
    lbd*aWK[1, 8, 1]*cWK[8]*Log[m/alp] + lbd^2*aWK[1, 8, 2]*cWK[8]*Log[m/alp] + lbd^3*aWK[1, 8, 3]*cWK[8]*Log[m/alp] + lbd^4*aWK[1, 8, 4]*cWK[8]*Log[m/alp] + 
    lbd*aWK[1, 7, 1]*cWK[9]*Log[m/alp] + 
    lbd^2*aWK[1, 7, 2]*cWK[9]*Log[m/alp] + lbd^3*aWK[1, 7, 3]*cWK[9]*Log[m/alp] + lbd^4*aWK[1, 7, 4]*cWK[9]*Log[m/alp] + lbd*aWK[1, 6, 1]*cWK[10]*Log[m/alp] + 
    lbd^2*aWK[1, 6, 2]*cWK[10]*Log[m/alp] + lbd^3*aWK[1, 6, 3]*cWK[10]*Log[m/alp] + lbd^4*aWK[1, 6, 4]*cWK[10]*Log[m/alp] + lbd*aWK[1, 5, 1]*cWK[11]*Log[m/alp] + 
    lbd^2*aWK[1, 5, 2]*cWK[11]*Log[m/alp] + lbd^3*aWK[1, 5, 3]*cWK[11]*Log[m/alp] + lbd^4*aWK[1, 5, 4]*cWK[11]*Log[m/alp] + lbd*aWK[1, 4, 1]*cWK[12]*Log[m/alp] + 
    lbd^2*aWK[1, 4, 2]*cWK[12]*Log[m/alp] + lbd^3*aWK[1, 4, 3]*cWK[12]*Log[m/alp] + lbd^4*aWK[1, 4, 4]*cWK[12]*Log[m/alp] + lbd*aWK[1, 7, 1]*cWK[13]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 7, 2]*cWK[13]*Log[m/alp]^2 + lbd^3*aWK[1, 7, 3]*cWK[13]*Log[m/alp]^2 + lbd^4*aWK[1, 7, 4]*cWK[13]*Log[m/alp]^2 + lbd*aWK[1, 6, 1]*cWK[14]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 6, 2]*cWK[14]*Log[m/alp]^2 + lbd^3*aWK[1, 6, 3]*cWK[14]*Log[m/alp]^2 + lbd^4*aWK[1, 6, 4]*cWK[14]*Log[m/alp]^2 + lbd*aWK[1, 5, 1]*cWK[15]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 5, 2]*cWK[15]*Log[m/alp]^2 + lbd^3*aWK[1, 5, 3]*cWK[15]*Log[m/alp]^2 + lbd^4*aWK[1, 5, 4]*cWK[15]*Log[m/alp]^2 + lbd*aWK[1, 4, 1]*cWK[16]*Log[m/alp]^2 + 
    lbd^2*aWK[1, 4, 2]*cWK[16]*Log[m/alp]^2 + lbd^3*aWK[1, 4, 3]*cWK[16]*Log[m/alp]^2 + lbd^4*aWK[1, 4, 4]*cWK[16]*Log[m/alp]^2))/alp^11);

coefWK111 = ((z^3 alp^3*m^11*(lbd*aWK[1, 8, 1]*cWK[8] + lbd^2*aWK[1, 8, 2]*cWK[8] + lbd^3*aWK[1, 8, 3]*cWK[8] + lbd^4*aWK[1, 8, 4]*cWK[8] + 
 lbd*aWK[1, 7, 1]*cWK[9] + lbd^2*aWK[1, 7, 2]*cWK[9] + 
    lbd^3*aWK[1, 7, 3]*cWK[9] + lbd^4*aWK[1, 7, 4]*cWK[9] + lbd*aWK[1, 6, 1]*cWK[10] + lbd^2*aWK[1, 6, 2]*cWK[10] + lbd^3*aWK[1, 6, 3]*cWK[10] + lbd^4*aWK[1, 6, 4]*cWK[10] + 
    lbd*aWK[1, 5, 1]*cWK[11] + lbd^2*aWK[1, 5, 2]*cWK[11] + lbd^3*aWK[1, 5, 3]*cWK[11] + lbd^4*aWK[1, 5, 4]*cWK[11] + lbd*aWK[1, 4, 1]*cWK[12] + lbd^2*aWK[1, 4, 2]*cWK[12] + 
    lbd^3*aWK[1, 4, 3]*cWK[12] + lbd^4*aWK[1, 4, 4]*cWK[12] + 2*lbd*aWK[1, 7, 1]*cWK[13]*Log[m/alp] + 2*lbd^2*aWK[1, 7, 2]*cWK[13]*Log[m/alp] + 2*lbd^3*aWK[1, 7, 3]*cWK[13]*Log[m/alp] + 
    2*lbd^4*aWK[1, 7, 4]*cWK[13]*Log[m/alp] + 2*lbd*aWK[1, 6, 1]*cWK[14]*Log[m/alp] + 2*lbd^2*aWK[1, 6, 2]*cWK[14]*Log[m/alp] + 2*lbd^3*aWK[1, 6, 3]*cWK[14]*Log[m/alp] + 
    2*lbd^4*aWK[1, 6, 4]*cWK[14]*Log[m/alp] + 2*lbd*aWK[1, 5, 1]*cWK[15]*Log[m/alp] + 2*lbd^2*aWK[1, 5, 2]*cWK[15]*Log[m/alp] + 2*lbd^3*aWK[1, 5, 3]*cWK[15]*Log[m/alp] + 
    2*lbd^4*aWK[1, 5, 4]*cWK[15]*Log[m/alp] + 2*lbd*aWK[1, 4, 1]*cWK[16]*Log[m/alp] + 2*lbd^2*aWK[1, 4, 2]*cWK[16]*Log[m/alp] + 2*lbd^3*aWK[1, 4, 3]*cWK[16]*Log[m/alp] + 
    2*lbd^4*aWK[1, 4, 4]*cWK[16]*Log[m/alp]))/alp^11);

coefWK112 = ((z^3 alp^3*m^11*(lbd*aWK[1, 7, 1]*cWK[13] + lbd^2*aWK[1, 7, 2]*cWK[13] + lbd^3*aWK[1, 7, 3]*cWK[13] + lbd^4*aWK[1, 7, 4]*cWK[13] + 
 lbd*aWK[1, 6, 1]*cWK[14] + lbd^2*aWK[1, 6, 2]*cWK[14] + 
    lbd^3*aWK[1, 6, 3]*cWK[14] + lbd^4*aWK[1, 6, 4]*cWK[14] + lbd*aWK[1, 5, 1]*cWK[15] + lbd^2*aWK[1, 5, 2]*cWK[15] + lbd^3*aWK[1, 5, 3]*cWK[15] + lbd^4*aWK[1, 5, 4]*cWK[15] + 
    lbd*aWK[1, 4, 1]*cWK[16] + lbd^2*aWK[1, 4, 2]*cWK[16] + lbd^3*aWK[1, 4, 3]*cWK[16] + lbd^4*aWK[1, 4, 4]*cWK[16]))/alp^11);
