(*
ABSCISSAS AND WEIGHTS OF EXTERNDED GAUSSIAN QUADRATURE RULES EXACT FOR INTEGRALS
 OF THE FORM: Int_0^1 dx (pol1(x) + Log(x) pol2(x))

Numerical algorithm from Ma, V. Rokhlin, S. Wandzura,
"Generalized gaussian quadrature rules for systems of arbitrary functions",
Soc. Indust. Appl. Math. J. Numer. Anal. 33(3) (1996) 971-996.

load by: <<gausext.m
calculate nodes and weights by: gausext[NumberOfPoints, NumberOfDigits]

ouput:
x(1)....x(NumberOfPoints) -- nodes of the quadrature formula with accuracy of NumberOfDigits
w(1)....w(NumberOfPoints) -- weights of the quadrature formula with accuracy of NumberOfDigits


test example:

In[1]:= <<gausext.m

In[2]:= gausext[5,20]
iteration = 1
iteration = 2
iteration = 3
iteration = 4
iteration = 5
iteration = 6
iteration = 7
iteration = 8
iteration = 9

      x(1)=5.6522282050800971359e-3
      x(2)=7.3430371742652273406e-2
      x(3)=2.8495740446255815371e-1
      x(4)=6.1948226408477838141e-1
      x(5)=9.1575808300469833378e-1

      w(1)=2.1046945791854629119e-2
      w(2)=1.3070554074444669759e-1
      w(3)=2.8970230167131415684e-1
      w(4)=3.5022037012039871029e-1
      w(5)=2.0832484167198580616e-1

testing ...
integration of Sum[x^i ((i+1) + (i+1)^2 Log[x]),{i,0,n-1}]
                              -47
gausext integration = -4.32 10
exact value of the integral = 0

*)

  SetOptions[$Output,PageWidth ->156];

  gausext[n_,outprecision_] :=
  Module[{f,g,precision,gauss,switch,m,v,dx,it,ff,xxi,wwi,test},
    precision  = IntegerPart[(2+ n/20) Max[outprecision,n/2]]; (* working precision *)
    f[x_,j_] = If[j<=n, x^(j-1)      , -Log[x] x^(j-n-1)];
    g[x_,j_] = If[j<=n, (j-1) x^(j-2), -((j-n-1) Log[x]+1) x^(j-n-2)];
    xi =  N[Solve[LegendreP[n, x] == 0, x], precision];
    xi = x/.xi;
    xi = N[(xi+1)/2,precision];
    xi = Sort[xi];
    xi = xi^2;
    xi = SetPrecision[xi,precision];
    switch = True;
    it=0;
    While[switch,(
	 m = Table[Join[Table[f[xi[[i]],j],{i,1,n}],Table[g[xi[[i]],j],{i,1,n}]],{j,1,2n}];
         v = Join[Table[1/i,{i,1,n}],Table[1/i^2,{i,1,n}]];
         v =  LinearSolve[m,v];
         dx = Table[v[[n+i]]/v[[i]],{i,1,n}];
         dx = SetPrecision[dx,precision];
         xi = xi+dx;
         it =it+1;
         If[Max[Abs[dx]]<10^(-outprecision-16), switch=False, switch=True])];
    wi = Table[N[v[[i]],outprecision],{i,1,n}];
    xi = N[xi,outprecision];
    ff[x_] = Sum[x^i ((i+1) + (i+1)^2 Log[x]),{i,0,n-1}];
    xxi = SetPrecision[xi,outprecision+64];
    wwi = SetPrecision[wi,outprecision+64];
    test = N[Sum[wwi[[i]] ff[xxi[[i]]],{i,1,n}],3]];






