(* parameters used in determination of the energy and amount of nodes *)

eupper = 0;
elower = 0;

(* number of nodes of the unperturbed reference state *)

nint = n - l - 1;

(* nonrelativistic energy without vacuum polarization, initial estimate *)

energy = -z^2/(2 n^2);

(* definition of the grid *)

t[stepNumber_] := t[stepNumber] = (stepNumber) h;
r[stepNumber_] := r[stepNumber] = rO (Exp[t[stepNumber]] - 1);

(* coefficients a[j] for Adams-Moulton method *)

array1 = {{1, 1, 0, 0, 0, 0, 0, 0, 0, 2}, {-1, 8, 5, 0, 0, 0, 0, 0, 0,
     12}, {1, -5, 19, 9, 0, 0, 0, 0, 0, 24}, {-19, 106, -264, 646,
    251, 0, 0, 0, 0, 720}, {27, -173, 482, -798, 1427, 475, 0, 0, 0,
    1440}, {-863, 6312, -20211, 37504, -46461, 65112, 19087, 0, 0,
    60480}, {1375, -11351, 41499, -88547, 123133, -121797, 139849,
    36799, 0, 120960}, {-33953, 312874, -1291214, 3146338, -5033120,
    5595358, -4604594, 4467094, 1070017, 3628800}};
d = array1[[k, 10]];
Block[{i = 1}, While[i <= k + 1, a[i] = array1[[k, i]]; i++]];

lam = h a[k + 1]/d;

(* definition of coefficients used in normalization procedure, number of points taken in trapezoid method *)

nq = 7;
array2 = {{1, 0, 0, 0, 0, 0, 0, 2}, {9, 28, 23, 0, 0, 0, 0, 24}, {475,
     1902, 1104, 1586, 1413, 0, 0, 1440}, {36799, 176648, 54851,
    177984, 89437, 130936, 119585, 120960}};
dint = array2[[(nq + 1)/2, 8]];
Block[{i = 1},
  While[i <= nq, cint[i] = array2[[(nq + 1)/2, i]]; i++]];

(* definition of potential *)

(* Coulomb *)
VC[r_]:=VC[r]=N[-z/r,60];

(* Uehling *)
V1[r_]:=V1[r]=-z/r (alp/Pi 1/3 2 ( (1 + (m/alp)^2 r^2/3) BesselK[0, 2 m/alp r] - r m/alp/6 (1/2 Pi (1 - (2 m r (BesselK[0, (2 m r)/alp] StruveL[-1, (2 m r)/alp] +
             BesselK[1, (2 m r)/alp] StruveL[0, (2 m r)/alp]))/alp)) - (5/6 + r^2 (m/alp)^2/3) ((2 m r (BesselK[1, (2 m r)/alp] - 1/2 Pi (1 -
             (2 m r (BesselK[0, (2 m r)/alp] StruveL[-1, (2 m r)/alp] + BesselK[1, (2 m r)/alp] StruveL[0, (2 m r)/alp]))/alp)))/alp) )  )

(* Kallen-Sabry *)
<<gausext.m;
gausext[32,80];
fcn[x_,r_]:= (E^((m*r*(2 + (-2 + x)*x))/(alp*(-1 + x)))*(-2 + x)*x*((-2 + x)*x*(2 + (-2 + x)*x)*(456 + (-2 + x)*x*(912 + (-2 + x)*x*(574 + (-2 + x)*x*(118 + 13*(-2 + x)*x)))) +
   24*(3*(-2 + x)*x*(2 + (-2 + x)*x)^3*(6 + (-2 + x)*x*(6 + (-2 + x)*x))*(2*Log[-((-2 + x)*x)] + Log[2 + (-2 + x)*x]) +
     Log[1 - x]*(-396 - (-2 + x)*x*(1620 + (-2 + x)*x*(2703 + (-2 + x)*x*(2310 + (-2 + x)*x*(1047 + 2*(-2 + x)*x*(117 + 10*(-2 + x)*x))))) + 12*(2 + (-2 + x)*x)^2*(2 + (-2 + x)*x*(2 + (-2 + x)*x))*(6 + (-2 + x)*x*(6 + (-2 + x)*x))*
        Log[-((-2 + x)*x)] + 6*(2 + (-2 + x)*x)^2*(2 + (-2 + x)*x*(2 + (-2 + x)*x))*(6 + (-2 + x)*x*(6 + (-2 + x)*x))*Log[2 + (-2 + x)*x])) + 72*(2 + (-2 + x)*x)^2*(2 + (-2 + x)*x*(2 + (-2 + x)*x))*(6 + (-2 + x)*x*(6 + (-2 + x)*x))*
    (2*PolyLog[2, (-1 + x)^2] + PolyLog[2, (-1 + x)^4])))/(54*(1 - x)*(2 + (-2 + x)*x)^7);
V2[r_]:=V2[r]=z/r alp^2/Pi^2 * Which[
2 m/alp r<10^-2,(-Zeta[3] - 65/648 - Pi^2/27) - 4/9 (EulerGamma+Log[x/2])^2 - 13/54 (EulerGamma+Log[x/2])
 +(13 Pi^2/18 + 16/9 Pi Log[2] - 383 Pi/135) x + 5/12 x^2 (EulerGamma+Log[x/2]) - 65/72 x^2 + (7 Pi^2/108 - 10 Pi/81) x^3
 -5/288 x^4 (EulerGamma+Log[x/2])^2 + 4187/86400 x^4 (EulerGamma+Log[x/2]) + (Zeta[3]/96-33841/207360-5Pi^2/3456) x^4
 +(11 Pi/3375-Pi^2/3600)x^5 - 7/17280 x^6 (EulerGamma+Log[x/2])^2 + 17833/7776000 x^6 (EulerGamma+Log[x/2])
 +(-1822711/466560000-7Pi^2/207360)x^6 + (34Pi/2083725+Pi^2/127008) x^7 - 29/4423680 x^8 (EulerGamma+Log[x/2])^2
 +32429/371589120 x^8 (EulerGamma+Log[x/2]) + (-13296077/195084288000-29Pi^2/53084160) x^8
 +(23Pi/241116750 + 11Pi^2/97977600) x^9 -167/2985984000 x^10 (EulerGamma+Log[x/2])^2
 -43214671/144850083840000 x^10 (EulerGamma+Log[x/2]) + (26826183589/58403553804288000-167Pi^2/35831808000) x^10
 +(58Pi/124804708875+17Pi^2/18441561600) x^11/.{x->2 m/alp r},
2 m/alp r >= 10^-2, Re[Sum[wi[[i]]  fcn[xi[[i]],r],{i,1,32}]]
]

(* Wichmann-Kroll *)

<<WKpotential.m

lbd = (alp z)^2/(1+Sqrt[1-(z alp)^2]);

VWK[r_]:=VWK[r]=z^3 alp^3 1/r V3T[r m/alp,lbd];

V[r_]:=V[r]=VC[r];

(* Uehling potential is accounted for until it is too small *)
Block[{parameter=1},While[V1[r[parameter]]/VC[r[parameter]]>Vdel,V[r[parameter]] = V[r[parameter]]+V1[r[parameter]];parameter++]];

(* two-loop is accounted for until it is too small *)
Block[{parameter=1},While[V2[r[parameter]]/VC[r[parameter]]>Vdel,V[r[parameter]] = V[r[parameter]]+V2[r[parameter]];parameter++]];

(* Wichmann-Kroll is accounted for until it is too small *)
Block[{parameter=1},While[Abs[VWK[r[parameter]]/VC[r[parameter]]]>Vdel,V[r[parameter]] = V[r[parameter]]+VWK[r[parameter]];parameter++]];

(* auxiliary parameter *)
breaker=0;

Print["Potential generated, proceeding to obtain iterations of nonrelativistic energy"]
Print[""]

(*##########################################################################*)

(* ALGORITHM *)

(* code will run until desired accuracy was achieved or for 25 iterations *)

Do[
Clear[coefSeries, aCoef, bCoef, cCoef, dCoef, eCoef, y, first, second,
      A02Coef,A21Coef,A31Coef,A40Coef,A41Coef,A42Coef,A50Coef,A51Coef,A52Coef,A60Coef,A61Coef,A62Coef,
      A70Coef,A71Coef,A72Coef,A80Coef,A81Coef,A82Coef,A90Coef,A100Coef,A101Coef,A102Coef,A110Coef,A91Coef,A92Coef,A111Coef,A112Coef];
 Catch[
 (* inc = +1 when r<r_turning *)
 inc = 1;

 (* searching for turning and infinite points *)

 nInfinity = numberOfSteps;
 (* condition so that Sqrt[-2E]*r[nInfinity] is approx 45 = Sqrt[2*1000] for which the ratio of
    the wave function in r[nInfinity] to its largest value is approx 10^-12 *)
 While[(energy - V[r[nInfinity]])*r[nInfinity]^2 + 1000 <= 0, nInfinity--];

 nTurning = nInfinity;
 While[energy <= V[r[nTurning]], nTurning--];


 (* definition of matrix elements b[t] and c[t] of matrix G(t) *)
 b[stepNumber_]:=If[0<=stepNumber<=numberOfSteps&&Element[stepNumber,Integers],inc*rO  Exp[t[stepNumber]],0];
 c[stepNumber_]:=If[0<=stepNumber<=numberOfSteps&&Element[stepNumber,Integers],-2 b[stepNumber](energy-V[r[stepNumber]]-l (l+1)/(2r[stepNumber]^2)),0];

 (* coefficients of the expansion of potential V around r=0 *)
 aCoef= z (1+alp ((-5)/(9 Pi)-2(EulerGamma/(3Pi))-Log[m^2/alp^2]/(3 Pi))) - alp^2/Pi^2 z (-Zeta[3]-65/648-Pi^2/27
                    - 4/9 (EulerGamma+Log[m/alp])^2 - 13/54 (EulerGamma+Log[m/alp])) - coefWKm1;
 bCoef= z (-2 alp)/(3  Pi)  - alp^2/Pi^2 z (-8/9 (EulerGamma+Log[m/alp]) - 13/54);
 eCoef= -(-energy-m z/2) - alp^2/Pi^2 z (2m/alp) (13/18 Pi^2+16/9Pi Log[2]-383 Pi/135) - coefWK0;
 cCoef= (- z m^2)/(Pi alp) - alp^2/Pi^2 z (2m/alp)^2 (5/12(EulerGamma+Log[m/alp]) - 65/72 ) - coefWK10;
 dCoef= (2z m^3 )/(9 alp^2) - alp^2/Pi^2 z (2m/alp)^3 (7 Pi^2/108 - 10/81 Pi) - coefWK20;
 A02Coef = - alp^2/Pi^2 z (-4/9);
 A21Coef = - alp^2/Pi^2 z (2m/alp)^2 (5/12);
 A31Coef = - coefWK31;
 A40Coef = - alp^2/Pi^2 z (2m/alp)^4 (-5/288 (EulerGamma+Log[m/alp])^2 + 4187/86400(EulerGamma+Log[m/alp]) + (Zeta[3]/96-33841/207360-5Pi^2/3456)) - coefWK40;
 A41Coef = - alp^2/Pi^2 z (2m/alp)^4 (-10/288 (EulerGamma+Log[m/alp]) + 4187/86400) - coefWK41;
 A42Coef = - alp^2/Pi^2 z (2m/alp)^4 (-5/288) - coefWK42;
 A50Coef = - alp^2/Pi^2 z (2m/alp)^5 (11Pi/3375-Pi^2/3600) - coefWK50;
 A51Coef = - coefWK51;
 A52Coef = - coefWK52;
 A60Coef = - alp^2/Pi^2 z (2m/alp)^6 (-7/17280(EulerGamma+Log[m/alp])^2+17833/7776000(EulerGamma+Log[m/alp])-1822711/466560000-7Pi^2/207360) - coefWK60;
 A61Coef = - alp^2/Pi^2 z (2m/alp)^6 (-14/17280(EulerGamma+Log[m/alp])+17833/7776000) - coefWK61;
 A62Coef = - alp^2/Pi^2 z (2m/alp)^6 (-7/17280) - coefWK62;
 A70Coef = - alp^2/Pi^2 z (2m/alp)^7 (34Pi/2083725+Pi^2/127008) - coefWK70;
 A71Coef = - coefWK71;
 A72Coef = - coefWK72;
 A80Coef = - alp^2/Pi^2 z (2m/alp)^8 (-13296077/195084288000-29Pi^2/53084160 - 29/4423680(EulerGamma+Log[m/alp])^2+32429/371589120(EulerGamma+Log[m/alp])) - coefWK80;
 A81Coef = - alp^2/Pi^2 z (2m/alp)^8 (-58/4423680 (EulerGamma+Log[m/alp]) + 32429/371589120) - coefWK81;
 A82Coef = - alp^2/Pi^2 z (2m/alp)^8 (-29/4423680) - coefWK82;
 A90Coef = - alp^2/Pi^2 z (2m/alp)^9 (23Pi/241116750 + 11Pi^2/97977600) - coefWK90;
 A91Coef = - coefWK91;
 A92Coef = - coefWK92;
 A100Coef = - alp^2/Pi^2 z (2m/alp)^10 (-167/2985984000(EulerGamma+Log[m/alp])^2-43214671/144850083840000(EulerGamma+Log[m/alp]) +
               26826183589/58403553804288000-167Pi^2/35831808000) - coefWK100;
 A101Coef = - alp^2/Pi^2 z (2m/alp)^10 (-2*167/2985984000 (EulerGamma+Log[m/alp]) - 43214671/144850083840000) - coefWK101;
 A102Coef = - alp^2/Pi^2 z (2m/alp)^10 (-167/2985984000) - coefWK102;
 A110Coef = - alp^2/Pi^2 z (2m/alp)^11 (58Pi/124804708875+17Pi^2/18441561600) - coefWK110;
 A111Coef = - coefWK111;
 A112Coef = - coefWK112;


 (*coefficients for higher powers of r^k and r^k Log[r] from Uehling, only odd powers are nonzero *)
 first[k_] := first[k] = z Expand[ SeriesCoefficient[FunctionExpand[Series[
          (8 m^3 rs^3+18 m rs alp^2+6 Pi alp^3 MeijerG[{{},{1/2,3/2}},{{0,0},{1/2,1/2}},(m^2 rs^2)/alp^2]
          +3 Pi alp^3 MeijerG[{{},{1/2,5/2}},{{0,1},{1/2,1/2}},(m^2 rs^2)/alp^2])/(36 alp^2 rs),{rs,0,2k+1},Assumptions->rs>0]],2k+1]/.{Log[rs]->0}];


 second[k_] := second[k] = z Coefficient[Expand[ SeriesCoefficient[FunctionExpand[Series[
          (8 m^3 rs^3+18 m rs alp^2+6 Pi alp^3 MeijerG[{{},{1/2,3/2}},{{0,0},{1/2,1/2}},(m^2 rs^2)/alp^2]
          +3 Pi alp^3 MeijerG[{{},{1/2,5/2}},{{0,1},{1/2,1/2}},(m^2 rs^2)/alp^2])/(36 alp^2 rs),{rs,0,2k+1},Assumptions->rs>0]],2k+1]],Log[rs]];

 (* coefficients for low-r expansion of P(r) and Q=dP/dr *)
 coefSeries[0,0]=1;
 coefSeries[i_,j_]:=0/;j>i;
 coefSeries[i_,j_]:=0/;j<0;
 coefSeries[i_,j_]:= coefSeries[i,j]= Simplify[-1/(i(i+1+2l))(2eCoef coefSeries[i-2,j]+2bCoef coefSeries[i-1,j-1]
                        +2aCoef coefSeries[i-1,j]+(1+2i+2l)(1+j)coefSeries[i,j+1]+(j+1)(j+2)coefSeries[i,j+2]+2cCoef coefSeries[i-3,j]
                        +2dCoef coefSeries[i-4,j]+2Sum[first[k] coefSeries[i-3-2k,j]+second[k] coefSeries[i-3-2k,j-1],{k,1,14}] + 2A31Coef coefSeries[i-4,j-1]
                        +2A02Coef coefSeries[i-1,j-2]+2A21Coef coefSeries[i-3,j-1] + 2A40Coef coefSeries[i-5,j] + 2A41Coef coefSeries[i-5,j-1] + 2A42Coef coefSeries[i-5,j-2]
                        +2A50Coef coefSeries[i-6,j] + 2A51Coef coefSeries[i-6,j-1] + 2A60Coef coefSeries[i-7,j] + 2A61Coef coefSeries[i-7,j-1] + 2A62Coef coefSeries[i-7,j-2]
                        +2A70Coef coefSeries[i-8,j] + 2A71Coef coefSeries[i-8,j-1] + 2A80Coef coefSeries[i-9,j] + 2A81Coef coefSeries[i-9,j-1] + 2A82Coef coefSeries[i-9,j-2]
                        +2A90Coef coefSeries[i-10,j] + 2A100Coef coefSeries[i-11,j] + 2A101Coef coefSeries[i-11,j-1] + 2A102Coef coefSeries[i-11,j-2] + 2A110Coef coefSeries[i-12,j]
                        +2A52Coef coefSeries[i-6,j-2]+2A72Coef coefSeries[i-8,j-2]+ 2A111Coef coefSeries[i-12,j-1]+ 2A112Coef coefSeries[i-12,j-2])];

 (* expanding wave function around origin *)
 P[r_]:=r^(l+1) Sum[r^i Sum[coefSeries[i,j] Log[r]^j,{j,0,i}],{i,0,15}];
 Q[r_]:=r^l Sum[r^i Sum[(coefSeries[i,j](1+i+l)+coefSeries[i,j+1](j+1))Log[r]^j,{j,0,i}],{i,0,15}];

 (* solving now the set of equations dP/dr = Q && dQ/dr = - 2(E-V-l(l+1)/r^2) for 0<r<r_turning *)
 (* dy/dt = f(y(t),t) with y=(P,Q) and f=G y with G = {{0,b(t)},{c(t),0}} *)
 (* solving on grid using M[n+1] y[n+1] = y[n] + h/D sum_{j=1}^k a[j] f[n-k+j] *)

 (* evaluating y(t) and f(t) for first k steps *)
 y[0] = {Limit[P[r],r->0,Direction->"FromAbove"],Limit[Q[r],r->0,Direction->"FromAbove"]};
 Module[{stepNumber=1},While[stepNumber<= k-1, y[stepNumber] = {P[r[stepNumber]],Q[r[stepNumber]]}; stepNumber++]];
 delta[stepNumber_Integer] := 1 - lam^2 b[stepNumber] c[stepNumber];
 (* matrix G *)
 matrix[stepNumber_Integer] := {{0,b[stepNumber]},{c[stepNumber],0}};
 (* inverse matrix for matrix M = 1 - lam G *)
 matrixInverted[stepNumber_Integer] := 1/delta[stepNumber]*{{1,lam b[stepNumber]},{lam c[stepNumber],1}};
f[stepNumber_] := If[stepNumber>0,matrix[stepNumber].y[stepNumber],If[stepNumber==0,{rO*(y[1][[2]]),0}]];

 (* remaining values of y(t) *)
 Module[{stepNumber=k,aux}, While[stepNumber <= nTurning,aux=matrixInverted[stepNumber].(y[stepNumber-1]+(h/d) Sum[ a[j] f[stepNumber-k-1+j],{j,1,k}]);y[stepNumber] = SetPrecision[aux,prec];stepNumber++]];

 (* saving the value at turning point *)
 ytp = y[nTurning];

 (* moving now to the region of r_turning<r<r_infinity *)

 (* for this region inc=-1 since we are integrating from larger r toward smaller r *)
 inc = -1;

 (* parameters for expansion of the wave function for large r *)
 alam = Sqrt[-2 energy];
 sig = z/alam;
 ax[0] = 1;
 bx[0] = -alam;
 Block[{parameter=1}, While[parameter<25, ax[parameter]=ax[parameter-1](l(l+1)-(sig-parameter+1)*(sig-parameter))/(2*parameter*alam);
                                          bx[parameter]=ax[parameter-1]((sig-parameter+1)*(sig+parameter)-l(l+1))/(2 parameter);parameter++]];


 (* expansion of P and Q for large r *)
 Pinf[r_]:=r^(sig)*Exp[-alam*r]*Sum[ax[ii]/r^ii,{ii,0,14}];
 Qinf[r_]:=r^(sig)*Exp[-alam*r]*Sum[bx[ii]/r^ii,{ii,0,14}];


 (* first k steps of expansion for P and Q *)
 Block[{stepNumber=nInfinity}, While[stepNumber>nInfinity-k,y[stepNumber] = {Pinf[r[stepNumber]],Qinf[r[stepNumber]]};stepNumber--]];

 (* remaining steps up to r_turning *)
 Block[{stepNumber=nInfinity-k,aux,$MaxExtraPrecision = 2*prec}, While[stepNumber>=nTurning,aux=matrixInverted[stepNumber].(y[stepNumber+1] + (h/d) Sum[a[j] f[stepNumber+k+1-j],{j,1,k}]);y[stepNumber]=SetPrecision[aux,prec];stepNumber--]];

 (* rescaling P for r>r_turning so that it is continuous at r_turning *)
 rat = ytp[[1]]/y[nTurning][[1]];
 Block[{num=nTurning},While[num<= nInfinity,y[num]=y[num] rat;num++]];


 (* counting the amount of nodes of the wave function *)
 nzero=0;
 sp=Sign[y[1][[1]]];
 Block[{i=2},While[i<= nInfinity, If[Sign[y[i][[1]]] != sp,sp=-sp;nzero=nzero+1];i++]];

 (* if the amount of nodes differs from nr=n-l-1 then the energy is shifted and current iteration is finished *)
 If[nzero>nint,  {eupper=energy; energy=1005/1000 *eupper; Throw[energy]},
   If[nzero<nint,{elower=energy; energy= 995/1000 *elower;Throw[energy]}]];


 (* calculating the normalization factor for the wave function with trapezoid method *)
 u[stepNumber_]:=(y[stepNumber][[1]])^2*rO Exp[t[stepNumber]];
 left=1;
 right=nInfinity;
 anorm=h*(Sum[cint[j]/dint(u[left+j-1]+u[right-j+1]),{j,1,nq}]+Sum[u[k],{k,left+nq,right-nq}]);

 (* correction to energy with the current iteration E2 = E1 + (Q1(-) - Q1(+)) P1(r_turning)/(2 norm) where indices 1 and 2 refer to current *)
 (* and next iterations and (-) and (+) means left and right limit to r_turning  *)
 de = y[nTurning][[1]]*(ytp[[2]]-y[nTurning][[2]])/(2 anorm);
 de = SetPrecision[de,prec];

 energy = energy + de;

 (* if after the correction the energy is shifted to values outside of the region with correct amount of nodes in the wave function,
    it is shifted only to 1/2(E+Eupper) or 1/2(E+Elower) and iteration ends *)
 (* if the correction to energy is larger than desired limit, the energy is shifted and iteration ends *)
 If[elower!=0 &&energy<elower,energy=1/2 (energy-de+elower);Throw[energy],
  If[eupper!=0&& energy>eupper,energy=1/2(energy-de+eupper);Throw[energy],
  If[Abs[de/energy]>del,Throw[energy]]]];

 (* if correction to energy is smaller than desired limit, the correction is dropped and energy is taken as it was *)
 energy = energy - de;
 an = 1/Sqrt[anorm];

 (* normalizing the wave function *)
 Block[{i=0},While[i<=nInfinity,y[i]=y[i]*an;i++]];
 breaker = 1;
];
If[breaker == 1, Return[]];

(* printing the energy for the current iteration *)
Print[energy],
(* maximal amount of iterations *)
25]
Print["Convergence is achieved"]
Print[""]

(* consistency check *)
check[stepNumber_]:= ( 1/2 ((y[stepNumber][[2]] - y[stepNumber][[1]] 1/r[stepNumber])^2 + l(l+1)/r[stepNumber]^2 (y[stepNumber][[1]])^2 ) +
                      V[r[stepNumber]] (y[stepNumber][[1]])^2 )*rO Exp[t[stepNumber]] ;
left=1;
right=nInfinity;
tst=h*(Sum[cint[j]/dint(check[left+j-1]+check[right-j+1]),{j,1,nq}]+Sum[check[k],{k,left+nq,right-nq}]);
Print["Consistency check of the result, by calculating (E-<H>)/E "]
Print[(energy-tst)/energy]
Print[""]

Print["Nonrelativistic energy E^(2) in eV"]
Print[NumberForm[(energy)/m*evfac, 20]]
Print[""]
Print["Out of which the vacuum polarization contribution is"]
Print[NumberForm[(energy + z^2/(2 n^2))/m*evfac, 20]]
Print[""]
Print["Estimate of three-loop correction in eV"];
E3l = (energy + z^2/(2 n^2))/m*evfac alp^2/Pi^2;
Print[NumberForm[E3l, 20]]
Print[""]
