from matplotlib import pyplot as plt
import numpy as np

param = np.array([1., 0.5, -0.2, 0.1])

data1 = np.linspace(-10., 10., 101)
design1 = np.array([data1**power for power in range(len(param))]).T
target1 = design1 @ param
plt.plot(data1, target1)

data0 = 20. * np.random.random(10) - 10.
design0 = np.array([data0**power for power in range(len(param))]).T
target0 = design0 @ param + 20. * np.random.random(10) - 10.
plt.plot(data0, target0, 'o')

param = np.zeros(4)

value0 = design0 @ param
loss = np.sum((value0 - target0)**2)
grad = 2. * (value0 - target0) @ design0

print(grad)
