import numpy as np
from sklearn import datasets
import torch

features = 64
classes = 10

source = datasets.load_digits()
data = source.data
target = source.target
design = np.insert(data, 0, 1., 1)

DESIGN = torch.tensor(design, dtype = torch.float32)
TARGET = torch.tensor(target, dtype = torch.int64)

PARAM = torch.zeros(1 + features, classes, requires_grad = True)

optimizer = torch.optim.SGD([PARAM], lr = 0.0001)
for epoch in range(1000):
    optimizer.zero_grad()
    ACTIVATION = DESIGN @ PARAM
    LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET, reduction = "sum")
    LOSS.backward()
    optimizer.step()
    print(epoch, LOSS.item(), flush = True)

ACTIVATION = DESIGN @ PARAM
VALUE = torch.argmax(ACTIVATION, 1)
HIT = (VALUE == TARGET)
ACCURACY = torch.mean(HIT.float())

print(ACCURACY.item())
